/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import oracle.dbtools.common.service.ConfigProcessor;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StreamCopy;

class Compiler {
    private final File dstFolder;
    private final File outputPath;
    private final List<File> outputPaths = new ArrayList<File>();
    private final List<Processor> processors = new ArrayList<Processor>();
    private final List<File> srcFolders = new ArrayList<File>();
    private static final Iterable<String> COMPILER_OPTIONS = Arrays.asList("-g");
    private static final Set<JavaFileObject.Kind> SOURCE_KIND = Collections.singleton(JavaFileObject.Kind.SOURCE);

    Compiler(String src, String dst) {
        String[] srcFolders;
        for (String s : srcFolders = src.split("\\s*,\\s*")) {
            this.srcFolders.add(new File(s));
        }
        this.dstFolder = new File(dst);
        this.processors.add(new ConfigProcessor());
        this.outputPath = new File(this.dstFolder.getParentFile(), "tmp-compile");
        this.outputPath.mkdirs();
        this.outputPaths.add(this.outputPath);
    }

    void compile(String ... packages) throws IOException {
        Compiler.clean(this.outputPath);
        DiagnosticCollector diags = new DiagnosticCollector();
        JavaCompiler compiler = Compiler.compiler(packages);
        if (compiler == null) {
            throw new UnsupportedOperationException("Could not find a compiler for this JVM, check this JVM is using a JDK and NOT a JRE to run");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diags, null, null);
        this.outputPath.delete();
        this.outputPath.mkdirs();
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, this.outputPaths);
        fileManager.setLocation(StandardLocation.SOURCE_PATH, this.srcFolders);
        ArrayList<JavaFileObject> srcFiles = new ArrayList<JavaFileObject>();
        for (String pkg : packages) {
            for (JavaFileObject f : fileManager.list(StandardLocation.SOURCE_PATH, pkg, SOURCE_KIND, true)) {
                srcFiles.add(f);
            }
        }
        StringWriter compilerOutput = new StringWriter();
        JavaCompiler.CompilationTask task = compiler.getTask(compilerOutput, fileManager, diags, COMPILER_OPTIONS, null, srcFiles);
        task.setProcessors(this.processors);
        compilerOutput.flush();
        if (task.call().booleanValue()) {
            this.copy(this.dstFolder, this.outputPath);
            Compiler.clean(this.dstFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File dst, File src) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            File d = new File(dst, "META-INF/oracle.dbtools.common.services");
            File s = new File(src, "META-INF/oracle.dbtools.common.services");
            if (s.exists()) {
                d.getParentFile().mkdirs();
                in = new FileInputStream(s);
                out = new FileOutputStream(d);
                StreamCopy.drain(in, out);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(in, out);
            throw throwable;
        }
        Closeables.close(in, out);
    }

    private static boolean clean(File path) {
        boolean success = true;
        if (path.isDirectory()) {
            File f;
            File[] arr$ = path.listFiles();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (success = Compiler.clean(f = arr$[i$])); ++i$) {
            }
        }
        if (success) {
            success = path.delete();
        }
        return success;
    }

    private static JavaCompiler compiler(String ... packages) {
        JavaCompiler compiler = null;
        compiler = ToolProvider.getSystemJavaCompiler();
        return compiler;
    }
}

