/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Pair;

public class ConfigurationFolder {
    private final List<Pair<String, Weight>> candidateLocations = new ArrayList<Pair<String, Weight>>();
    private final AtomicReference<File> location = new AtomicReference();
    private String mountPoint;
    private File unitTestLocation;
    public static final String HOME_PROP = "apex.home";
    public static ConfigurationFolder INSTANCE = new ConfigurationFolder();
    static final String FILE_NAME = "defaults.xml";
    private static final String DEFAULT_HOME = "${java.io.tmpdir}/apex";
    private static final Log LOG = Log.get(ConfigurationFolder.class);

    private ConfigurationFolder() {
    }

    public File getFolder() {
        return this.location.get();
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setup(String contextPath, String configFolder) {
        if (this.location.get() == null) {
            this.mountPoint = contextPath;
            String webXmlLocation = null;
            if (configFolder != null && !configFolder.trim().isEmpty()) {
                webXmlLocation = configFolder;
            }
            if (!(webXmlLocation == null || webXmlLocation.endsWith("/") && webXmlLocation.endsWith("\\"))) {
                webXmlLocation = webXmlLocation + "/";
            }
            String userHome = "${user.home}/";
            String tmpDir = "${java.io.tmpdir}/";
            if (webXmlLocation != null) {
                this.addCandidateLocation(webXmlLocation + this.mountPoint, Weight.MUST_USE);
            }
            this.addCandidateLocation("${user.home}/" + this.mountPoint, Weight.IF_FOLDER_EXISTS);
            this.addCandidateLocation("${java.io.tmpdir}/" + this.mountPoint, Weight.IF_FOLDER_EXISTS);
            this.addCandidateLocation("${user.home}/", Weight.IF_EXISTS);
            this.choose();
            String absPath = this.getFolder().getAbsolutePath();
            try {
                absPath = this.getFolder().getCanonicalPath();
            }
            catch (IOException e) {
                LOG.fine(e);
            }
            String msg = "Using configuration folder: " + absPath;
            if (LOG.isLoggable(Log.INFO)) {
                LOG.info(msg);
            } else {
                LOG.console(msg);
            }
        }
    }

    public void teardown() {
        this.location.set(null);
        this.mountPoint = null;
        this.candidateLocations.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApexConfigFile [location=");
        if (this.location.get() == null) {
            builder.append("not determined yet");
        } else {
            builder.append(this.location);
        }
        builder.append("]");
        return builder.toString();
    }

    public void unitTestLocation(File unitTestLocation) {
        this.unitTestLocation = unitTestLocation;
    }

    ConfigurationFolder addCandidateLocation(String location, Weight weighting) {
        if (location != null) {
            this.candidateLocations.add(Pair.pair(location, weighting));
        }
        return this;
    }

    synchronized void choose() {
        File location = null;
        if (this.unitTestLocation == null) {
            String systemHome = System.getProperty(HOME_PROP);
            if (systemHome != null) {
                location = Files.file(systemHome);
            } else {
                location = this.chooseExistingFile();
                if (location == null) {
                    location = this.chooseNewFileLocation();
                }
            }
        } else {
            location = this.unitTestLocation;
        }
        this.location.set(location);
    }

    boolean setup() {
        return this.location.get() != null;
    }

    private File chooseExistingFile() {
        File location = null;
        for (Pair<String, Weight> candidate : this.candidateLocations) {
            String folder = candidate.first();
            File f = Files.file(folder, FILE_NAME);
            if (!f.exists()) continue;
            location = f.getParentFile();
            break;
        }
        return location;
    }

    private File chooseNewFileLocation() {
        File location = null;
        for (Pair<String, Weight> candidate : this.candidateLocations) {
            String folder = candidate.first();
            Weight weight = candidate.second();
            File f = Files.file(folder);
            switch (weight) {
                case MUST_USE: {
                    Files.mkdirs(f);
                    location = f;
                    break;
                }
                case IF_FOLDER_EXISTS: {
                    if (!f.exists()) break;
                    location = f;
                }
            }
            if (location == null) continue;
            break;
        }
        if (location == null) {
            location = ConfigurationFolder.defaultHome();
        }
        return location;
    }

    static File defaultHome() {
        return Files.file(DEFAULT_HOME);
    }

    static enum Weight {
        IF_EXISTS,
        IF_FOLDER_EXISTS,
        MUST_USE;

    }
}

