/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.config.PropertiesConfiguration;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TransformCache;

public class ConfigurationFiles
extends AssociativeArrays.Base<String, Configuration>
implements Configurations,
ConfigurationsProvider {
    private final TransformCache<String, AssociativeArray<String, String>> confs = new TransformCache<String, AssociativeArray<String, String>>(new ReadConfiguration(), false);
    private final Map<String, List<ConfigurationEventListener>> listeners = new WeakHashMap<String, List<ConfigurationEventListener>>();
    public static final ConfigurationFiles INSTANCE = new ConfigurationFiles();
    static final String FILE_SUFFIX = ".xml";
    private static final String CONF_FOLDER = "conf";
    private static final ConfigurationName CONFIGURATION_NAME = new ConfigurationName();
    private static final IsConfigurationFile IS_CONFIGURATION_FILE = new IsConfigurationFile();
    private static final Log LOG = Log.get(ConfigurationFiles.class);

    private ConfigurationFiles() {
    }

    @Override
    public void addListener(String name, ConfigurationEventListener listener) {
        List<ConfigurationEventListener> listeners = this.listeners.get(name);
        if (listeners == null) {
            listeners = new ArrayList<ConfigurationEventListener>();
            this.listeners.put(name, listeners);
        }
        listeners.add(listener);
        this.changed(name, listener);
    }

    @Override
    public boolean exists(String name) {
        if ("defaults".equals(name)) {
            return this.defaultsLocation(name).exists();
        }
        return Files.file(this.folder(), name.toLowerCase() + FILE_SUFFIX).exists();
    }

    @Override
    public Configuration get(Object key) {
        return this.get(key.toString());
    }

    @Override
    public Configuration get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        File file = this.file(name);
        if (file.exists()) {
            return new ConfigurationFile(name);
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        File folder = this.folder();
        Iterator<String> defaults = Iterators.iterator("defaults");
        Iterator<String> confs = Iterators.transform(Iterators.iterator(folder.listFiles(IS_CONFIGURATION_FILE)), CONFIGURATION_NAME);
        return Iterators.sequence(Iterators.iterator(defaults, confs));
    }

    @Override
    public void removeListener(ConfigurationEventListener listener) {
        Collection<List<ConfigurationEventListener>> all = this.listeners.values();
        for (List<ConfigurationEventListener> listeners : all) {
            Iterator<ConfigurationEventListener> iter = listeners.iterator();
            while (iter.hasNext()) {
                if (listener != iter.next()) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void setup() {
        this.ensureDefaultsExist("defaults");
    }

    @Override
    public void teardown() {
        this.confs.clear();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Configurations newConfigurations) {
        List<String> changedConfigs = this.difference(newConfigurations);
        TransformCache<String, AssociativeArray<String, String>> transformCache = this.confs;
        synchronized (transformCache) {
            for (String name : changedConfigs) {
                File file = this.file(name);
                Configuration modified = newConfigurations.get(name);
                if (modified == null) {
                    if ("defaults".equals(name)) {
                        throw new IllegalArgumentException("Must have a default configuration");
                    }
                    Files.delete(file);
                } else {
                    ConfigurationFiles.write(file, modified);
                }
                this.confs.remove(name);
            }
        }
        if (LOG.isLoggable(Log.INFO)) {
            LOG.info("Updated configurations: " + Iterables.join(changedConfigs, ", "));
        }
        for (String name : changedConfigs) {
            this.changed(name);
        }
    }

    private void changed(String name) {
        List<ConfigurationEventListener> listeners = this.listeners.get(name);
        if (listeners != null) {
            for (ConfigurationEventListener listener : listeners) {
                this.changed(name, listener);
            }
        }
        this.checkDefaultChanged(name);
    }

    private void changed(String name, ConfigurationEventListener listener) {
        if (ConfigurationFolder.INSTANCE.setup()) {
            if (this.exists(name)) {
                listener.configurationChanged(name, new ConfigurationFile(name));
            } else {
                listener.configurationRemoved(name);
            }
        }
    }

    private void checkDefaultChanged(String name) {
        if ("defaults".equals(name)) {
            for (String confName : this.listeners.keySet()) {
                if ("defaults".equals(confName)) continue;
                this.changed(confName);
            }
        }
    }

    private File defaultsLocation(String name) {
        return Files.file(this.location().getFolder(), name + FILE_SUFFIX);
    }

    private List<String> difference(Configurations modified) {
        ArrayList removed = new ArrayList();
        Iterables.add(removed, this);
        Iterator modifiedNames = modified.iterator();
        ArrayList<String> different = new ArrayList<String>();
        while (modifiedNames.hasNext()) {
            Configuration n;
            String name = (String)modifiedNames.next();
            AssociativeArray<String, String> e = this.values(name);
            if (!AssociativeArrays.equals(e, n = modified.get(name))) {
                different.add(name);
            }
            removed.remove(name);
        }
        different.addAll(removed);
        return different;
    }

    private void ensureDefaultsExist(String name) {
        File defaults = this.defaultsLocation(name);
        if (!defaults.exists()) {
            Files.mkdirs(this.folder());
            ConfigurationFiles.write(defaults, ConfigurationFiles.shippedDefaults());
        }
    }

    private File file(String name) {
        if ("defaults".equals(name)) {
            return this.defaultsLocation("defaults");
        }
        return Files.file(this.folder(), name + FILE_SUFFIX);
    }

    private File folder() {
        return Files.file(this.location().getFolder(), CONF_FOLDER);
    }

    private ConfigurationFolder location() {
        if (!ConfigurationFolder.INSTANCE.setup()) {
            throw ConfigurationFiles.notInitialized();
        }
        return ConfigurationFolder.INSTANCE;
    }

    private AssociativeArray<String, String> values(String name) {
        return this.confs.apply(name);
    }

    public static InputStream shippedDefaultsContents() {
        return ConfigurationFiles.class.getResourceAsStream("defaults.xml");
    }

    static Configuration shippedDefaults() {
        Object shippedDefaults = null;
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(ConfigurationFiles.shippedDefaultsContents());
            return propertiesConfiguration;
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
        finally {
            Closeables.close(shippedDefaults);
        }
    }

    private static boolean checkForPasswords(Properties properties, File file) throws IOException {
        boolean modified = false;
        for (String name : Iterables.transform(properties.keySet(), Iterators.AS_STRING)) {
            String value = properties.getProperty(name);
            if (!ConfigurationFiles.isPassword(name) || !value.startsWith("!")) continue;
            value = value.substring(1);
            value = "@" + Passwords.goingOut(value);
            properties.put(name, value);
            modified = true;
        }
        if (modified) {
            ConfigFiles.save(properties, file);
        }
        return modified;
    }

    private static boolean isPassword(String name) {
        return name.endsWith(".password");
    }

    private static IllegalStateException notInitialized() {
        return new IllegalStateException("Not yet initialised");
    }

    private static AssociativeArray<String, String> read(File file) {
        if (file.exists()) {
            SortedProperties properties = new SortedProperties();
            try {
                ConfigFiles.load((Properties)properties, file);
                ConfigurationFiles.checkForPasswords(properties, file);
                PropertiesConfiguration.FromProperties values = new PropertiesConfiguration.FromProperties(properties);
                return values;
            }
            catch (IOException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return null;
    }

    private static void write(File file, AssociativeArray<String, String> values) {
        try {
            Properties properties = AssociativeArrays.asProperties(values);
            if (!ConfigurationFiles.checkForPasswords(properties, file)) {
                ConfigFiles.save(properties, file);
            }
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    private final class ReadConfiguration
    implements Transform<String, AssociativeArray<String, String>> {
        private ReadConfiguration() {
        }

        @Override
        public AssociativeArray<String, String> apply(String name) {
            File file = ConfigurationFiles.this.file(name);
            AssociativeArray values = ConfigurationFiles.read(file);
            return values;
        }
    }

    private static final class IsConfigurationFile
    implements FileFilter {
        private IsConfigurationFile() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(ConfigurationFiles.FILE_SUFFIX);
        }
    }

    private static final class ConfigurationName
    implements Transform<File, String> {
        private ConfigurationName() {
        }

        @Override
        public String apply(File x) {
            String name = x.getName();
            name = name.substring(0, name.length() - ConfigurationFiles.FILE_SUFFIX.length());
            return name;
        }
    }

    private final class ConfigurationFile
    extends ConfigurationBase
    implements AssociativeArrays.MergedArray<String, String> {
        private final String name;

        ConfigurationFile(String name) {
            this.name = name;
        }

        @Override
        protected AssociativeArray<String, String> values() {
            AssociativeArray defaultValues = null;
            if (!"defaults".equals(this.name)) {
                defaultValues = ConfigurationFiles.this.values("defaults");
            }
            return AssociativeArrays.merge(this.child(), defaultValues);
        }

        @Override
        public AssociativeArray<String, String> child() {
            AssociativeArray confValues = ConfigurationFiles.this.values(this.name);
            return confValues;
        }
    }
}

