/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class TranslatableMessage {
    public static final TranslatableMessage EMPTY_MESSAGE = new TranslatableMessage((Class)TranslatableMessage.class, "", "", new Object[0]){

        @Override
        public String toString(Locale locale) {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }
    };
    private final Class<?> bundleClass;
    private final String msgId;
    private Object[] msgArgs;
    private final String defaultMsg;

    public TranslatableMessage(String msg) {
        this(null, null, "{0}", msg);
    }

    public TranslatableMessage(Class<?> bundle, String msgId, String defaultMsg, Object ... msgArgs) {
        this.bundleClass = bundle;
        this.msgId = msgId;
        if ((msgId == null || bundle == null) && defaultMsg == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMsg = defaultMsg;
        if (msgArgs == null) {
            this.msgArgs = new Object[0];
        } else {
            this.msgArgs = new Object[msgArgs.length];
            for (int i = 0; i < msgArgs.length; ++i) {
                this.msgArgs[i] = msgArgs[i] == null ? null : msgArgs[i].toString();
            }
        }
    }

    public Class<?> getBundleClass() {
        return this.bundleClass;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public Object[] getMsgArgs() {
        return this.msgArgs;
    }

    public String getDefaultMsg() {
        return this.defaultMsg;
    }

    public static String toString(TranslatableMessage msg, Iterable<Locale> localePreference) {
        if (msg == null) {
            return null;
        }
        return msg.toString(localePreference.iterator());
    }

    public String toString(Iterator<Locale> localeIter) {
        if (localeIter != null) {
            Vector<Locale> locales = new Vector<Locale>();
            while (localeIter.hasNext()) {
                Locale locale = localeIter.next();
                try {
                    String translation;
                    if (locale == null) continue;
                    locales.add(locale);
                    PreferenceResourceBundle bundle = this.getBundleFor(locale.getLanguage(), locale.getCountry(), locale.getVariant());
                    if (bundle == null || (translation = bundle.getString(this.msgId)) == null) continue;
                    return translation;
                }
                catch (Throwable t) {
                }
            }
            for (Locale locale : locales) {
                String translation;
                if (locale == null || (translation = this.toString(locale)) == null) continue;
                return translation;
            }
        }
        return this.toString();
    }

    public String toString(Locale locale) {
        String translation = this.defaultMsg;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleClass.getName(), locale, this.bundleClass.getClassLoader(), ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            translation = bundle.getString(this.msgId);
        }
        catch (Throwable t) {
            translation = this.defaultMsg;
        }
        if (this.defaultMsg == null) {
            translation = '!' + this.msgId + '!';
        }
        if (this.msgArgs.length > 0) {
            try {
                translation = MessageFormat.format(translation, this.msgArgs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return translation;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    private PreferenceResourceBundle getBundleFor(String language, String country, String variant) {
        PropertyResourceBundle languageBundle = null;
        PropertyResourceBundle countryBundle = null;
        PropertyResourceBundle variantBundle = null;
        String bundleName = this.bundleClass.getName();
        if (language != null) {
            try {
                bundleName = bundleName + "_" + language;
                languageBundle = this.getPropertiesResourceBundel(this.bundleClass.getName() + "_" + language);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (country != null) {
            try {
                bundleName = bundleName + "_" + country;
                countryBundle = this.getPropertiesResourceBundel(bundleName);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (variant != null) {
            try {
                bundleName = bundleName + "_" + variant;
                variantBundle = this.getPropertiesResourceBundel(this.bundleClass.getName() + "_" + variant);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return new PreferenceResourceBundle(languageBundle, countryBundle, variantBundle);
    }

    public final String toResourceName(String bundleName, String suffix) {
        StringBuilder sb = new StringBuilder(bundleName.length() + 1 + suffix.length());
        sb.append(bundleName.replace('.', '/')).append('.').append(suffix);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyResourceBundle getPropertiesResourceBundel(String bundleName) throws IOException {
        final String resourceName = this.toResourceName(bundleName, "properties");
        final ClassLoader classLoader = this.bundleClass.getClassLoader();
        boolean reloadFlag = false;
        PropertyResourceBundle bundle = null;
        InputStream stream = null;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    InputStream is = null;
                    is = classLoader.getResourceAsStream(resourceName);
                    return is;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (stream != null) {
            try {
                bundle = new PropertyResourceBundle(stream);
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    private static class PreferenceResourceBundle
    extends ResourceBundle {
        PropertyResourceBundle languageBundle;
        PropertyResourceBundle countryBundle;
        PropertyResourceBundle variantBundle;
        Vector<String> keys = null;

        public PreferenceResourceBundle(PropertyResourceBundle languageBundle, PropertyResourceBundle countryBundle, PropertyResourceBundle variantBundle) {
            this.languageBundle = languageBundle;
            this.countryBundle = countryBundle;
            this.variantBundle = variantBundle;
        }

        @Override
        protected Object handleGetObject(String key) {
            Object obj;
            if (this.variantBundle != null && (obj = this.variantBundle.handleGetObject(key)) != null) {
                return obj;
            }
            if (this.countryBundle != null && (obj = this.countryBundle.handleGetObject(key)) != null) {
                return obj;
            }
            if (this.languageBundle != null && (obj = this.languageBundle.handleGetObject(key)) != null) {
                return obj;
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            if (this.keys == null) {
                Enumeration<String> keyEnum;
                this.keys = new Vector();
                if (this.languageBundle != null) {
                    keyEnum = this.languageBundle.getKeys();
                    while (keyEnum.hasMoreElements()) {
                        this.keys.add(keyEnum.nextElement());
                    }
                }
                if (this.countryBundle != null) {
                    keyEnum = this.countryBundle.getKeys();
                    while (keyEnum.hasMoreElements()) {
                        this.keys.add(keyEnum.nextElement());
                    }
                }
                if (this.variantBundle != null) {
                    keyEnum = this.variantBundle.getKeys();
                    while (keyEnum.hasMoreElements()) {
                        this.keys.add(keyEnum.nextElement());
                    }
                }
            }
            return this.keys.elements();
        }
    }
}

