/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class ProducerConsumer {
    Buffer buffer;
    boolean producerClosed;
    boolean consumerClosed;
    ProducerStream pStream;
    ConsumerStream cStream;
    Thread pThread;
    Producer producer;
    Consumer consumer;
    Object pResult;
    Object cResult;
    RuntimeException runtimeException;
    Error errorException;

    public ProducerConsumer(Producer producer, Consumer consumer) {
        this.producer = producer;
        this.consumer = consumer;
        this.buffer = new Buffer();
        this.pStream = new ProducerStream();
        this.cStream = new ConsumerStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object rEx = null;
        Object eEx = null;
        try {
            this.cResult = this.consumer.readFrom(this.cStream);
            this.cStream.close();
        }
        catch (RuntimeException ex) {
            this.consumerClosed = true;
            this.runtimeException = ex;
        }
        catch (Error ex) {
            this.consumerClosed = true;
            this.errorException = ex;
        }
        if (this.pThread != null) {
            try {
                Object ex = this.lock();
                synchronized (ex) {
                    this.lock().notify();
                }
                this.pThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (this.errorException != null) {
            throw this.errorException;
        }
    }

    public Object producerResult() {
        return this.pResult;
    }

    public Object consumerResult() {
        return this.cResult;
    }

    private Object lock() {
        return this;
    }

    public static void main(final String[] argv) {
        final Random random = new Random();
        random.setSeed(42L);
        Producer p = new Producer(){

            public Object writeTo(OutputStream out) {
                System.out.println("writeTo " + out);
                try {
                    FileInputStream in = new FileInputStream(argv[0]);
                    byte[] buffer = new byte[4000];
                    int n = ((InputStream)in).read(buffer, 0, random.nextInt(3999));
                    while (n >= 0) {
                        System.out.println("Producer writing " + n + " bytes ");
                        if (random.nextInt(10) > 0) {
                            out.write(buffer, 0, n);
                        } else {
                            for (int x = 0; x < n; ++x) {
                                out.write(buffer[x]);
                            }
                        }
                        System.out.println("Producer continuing ");
                        n = ((InputStream)in).read(buffer, 0, random.nextInt(3999));
                    }
                    System.out.println("Producer done");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Producer returning");
                return null;
            }
        };
        Consumer c = new Consumer(){

            public Object readFrom(InputStream in) {
                System.out.println("readFrom " + in);
                try {
                    FileOutputStream out = new FileOutputStream(argv[1]);
                    byte[] buffer = new byte[4000];
                    System.out.println("Consumer reading ");
                    int n = this.r(in, buffer);
                    while (n >= 0) {
                        System.out.println("Consumer continuing after reading " + n + " bytes ");
                        ((OutputStream)out).write(buffer, 0, n);
                        System.out.println("Consumer reading ");
                        n = this.r(in, buffer);
                    }
                    System.out.println("Consumer done");
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Consumer returning");
                return null;
            }

            int r(InputStream in, byte[] buffer) throws IOException {
                int n;
                if (random.nextInt(10) > 1) {
                    int want = random.nextInt(3999);
                    n = in.read(buffer, 0, want);
                } else {
                    int max = random.nextInt(20);
                    int chr = 0;
                    int x = 0;
                    while (x < max && chr >= 0) {
                        chr = in.read();
                        if (chr < 0) continue;
                        buffer[x++] = (byte)chr;
                    }
                    n = x;
                }
                return n;
            }
        };
        ProducerConsumer pc = new ProducerConsumer(p, c);
        pc.run();
    }

    static class Buffer {
        byte[] array;
        int xFirst;
        int xEnd;
        boolean oneInB;
        byte b;

        Buffer() {
        }

        void fill(byte b) {
            this.b = b;
            this.oneInB = true;
            this.array = null;
        }

        void fill(byte[] array, int xFirst, int xEnd) {
            this.array = array;
            this.xFirst = xFirst;
            this.xEnd = xEnd + xFirst <= array.length ? xEnd : array.length;
            this.oneInB = false;
        }

        boolean empty() {
            boolean arrayEmpty = this.array == null || this.xFirst >= this.xEnd;
            return arrayEmpty && !this.oneInB;
        }

        int count() {
            int a = this.oneInB ? 1 : (this.array != null && this.xFirst < this.xEnd ? this.xEnd - this.xFirst : 0);
            return a;
        }

        byte getByte() {
            byte result;
            if (this.oneInB) {
                result = this.b;
                this.oneInB = false;
            } else if (this.array != null && this.xFirst < this.xEnd) {
                result = this.array[this.xFirst++];
            } else {
                throw new RuntimeException();
            }
            return result;
        }

        void copy(byte[] to, int offset, int len) {
            if (len != 0) {
                if (len == 1) {
                    to[offset] = this.getByte();
                } else {
                    System.arraycopy(this.array, this.xFirst, to, offset, len);
                    this.xFirst += len;
                }
            }
        }

        void close() {
            this.array = null;
            this.oneInB = false;
        }
    }

    class ProducerThread
    extends Thread {
        ProducerThread() {
            super("ProducerThread");
        }

        public void run() {
            try {
                ProducerConsumer.this.pResult = ProducerConsumer.this.producer.writeTo(ProducerConsumer.this.pStream);
                ProducerConsumer.this.pStream.close();
            }
            catch (RuntimeException ex) {
                ProducerConsumer.this.producerClosed = true;
                ProducerConsumer.this.runtimeException = ex;
            }
            catch (Error ex) {
                ProducerConsumer.this.producerClosed = true;
                ProducerConsumer.this.errorException = ex;
            }
        }
    }

    class ConsumerStream
    extends InputStream {
        ConsumerStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                this.getSome();
                if (ProducerConsumer.this.buffer.empty()) {
                    return -1;
                }
                return ProducerConsumer.this.buffer.getByte();
            }
        }

        public int read(byte[] bytes) {
            return this.read(bytes, 0, bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] bytes, int offset, int length) {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                this.getSome();
                int available = ProducerConsumer.this.buffer.count();
                int use = length > available ? available : length;
                ProducerConsumer.this.buffer.copy(bytes, offset, use);
                int result = use;
                if (result == 0 && ProducerConsumer.this.producerClosed) {
                    result = -1;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                return ProducerConsumer.this.buffer.count();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                if (!ProducerConsumer.this.consumerClosed) {
                    ProducerConsumer.this.consumerClosed = true;
                    ProducerConsumer.this.buffer.close();
                }
            }
        }

        public void finalize() {
            this.close();
        }

        private void getSome() {
            while (!ProducerConsumer.this.producerClosed && ProducerConsumer.this.buffer.empty()) {
                this.runProducer();
            }
        }

        private void runProducer() {
            if (ProducerConsumer.this.pThread == null) {
                ProducerConsumer.this.pThread = new ProducerThread();
                ProducerConsumer.this.pThread.start();
            }
            if (!ProducerConsumer.this.pThread.isAlive()) {
                ProducerConsumer.this.producerClosed = true;
            }
            if (!ProducerConsumer.this.producerClosed) {
                ProducerConsumer.this.lock().notify();
                try {
                    ProducerConsumer.this.lock().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    class ProducerStream
    extends OutputStream {
        ProducerStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                if (ProducerConsumer.this.consumerClosed) {
                    throw new IOException("Producer overran consumer");
                }
                while (!ProducerConsumer.this.buffer.empty()) {
                    this.runConsumer();
                }
                ProducerConsumer.this.buffer.fill((byte)(b & 0xFF));
                this.runConsumer();
            }
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] bytes, int offset, int length) throws IOException {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                if (ProducerConsumer.this.consumerClosed) {
                    throw new IOException("Producer overran consumer");
                }
                while (!ProducerConsumer.this.buffer.empty()) {
                    this.runConsumer();
                }
                ProducerConsumer.this.buffer.fill(bytes, offset, length);
                this.runConsumer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = ProducerConsumer.this.lock();
            synchronized (object) {
                if (!ProducerConsumer.this.producerClosed) {
                    ProducerConsumer.this.producerClosed = true;
                    this.runConsumer();
                }
            }
        }

        public void finalize() {
            ProducerConsumer.this.producerClosed = true;
        }

        void runConsumer() {
            ProducerConsumer.this.lock().notify();
            if (!ProducerConsumer.this.consumerClosed) {
                try {
                    ProducerConsumer.this.lock().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static interface Consumer {
        public Object readFrom(InputStream var1);
    }

    public static interface Producer {
        public Object writeTo(OutputStream var1);
    }
}

