/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.server.tools.loadjava.ConnectionError;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.FatalError;
import oracle.aurora.server.tools.loadjava.GenMissing;
import oracle.aurora.server.tools.loadjava.GenMissingOptions;
import oracle.aurora.server.tools.loadjava.JdbcOperations;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LogOptions;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.OptionFile;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.Publish;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.msg.Msg;
import oracle.jdbc.internal.OracleResultSet;
import oracle.sql.BLOB;

class LoadJavaState {
    private Msg mkMsg = MkMsg.mkMsg;
    private Options opts;
    private Connection connection;
    private boolean connSet;
    private DatabaseOptions database;
    private LoadJavaLog log;
    private PrintWriter output;
    private JdbcOperations jdbcOperations;
    private GenMissing genMissing;
    private GenMissingOptions genMissingOpts;
    private Publish publish;
    private OptionFile optionFile;
    private Hashtable jdbcTables;
    private boolean verifierOn = true;
    private String cancelled = null;
    public static final String GetMD5FunctionName = "dbms_java.handleMd5";
    private static final int MD5TableIsObsoleteUninitialized = 0;
    private static final int MD5TableIsObsoleteTrue = 1;
    private static final int MD5TableIsObsoleteFalse = 2;
    private int MD5TableIsObsolete = 0;
    String NameForLobTable = null;
    private CallableStatement classCreationStmt;
    private CallableStatement resourceCreationStmt;
    private CallableStatement sourceCreationStmt;
    private PreparedStatement lobTableStmt;
    private static final String lobTableStmtSchemaInitializer = "no chance this is a real schema name";
    private String lobTableStmtSchema = "no chance this is a real schema name";
    private PreparedStatement MD5Stmt1;
    private PreparedStatement MD5Stmt2;
    private PreparedStatement shortFromLongnameStmt;
    private PreparedStatement reportErrorsStmt1;
    private PreparedStatement reportErrorsStmt2;
    private CallableStatement startLoadingJarStmt;
    private CallableStatement endLoadingJarStmt;
    private CallableStatement resumeLoadingJarStmt;
    private CallableStatement jarStatusStmt;
    private CallableStatement dropJarStmt;
    private PreparedStatement userStatusStmt;
    private PreparedStatement allStatusStmt;
    int ld_classes;
    int ld_resources;
    int ld_sources;
    int ld_published;
    int ld_genmissing;
    int ld_skipped;
    int ld_jar;
    int cr_syn;
    int natively_compiled;
    int errors;
    private int LoadJavaLoc = -1;
    private static Hashtable shortnameTable;
    public static final int LJSTATCLA = 1;
    public static final int LJSTATRES = 2;
    public static final int LJSTATSOU = 4;
    public static final int LJSTATPUB = 8;
    public static final int LJSTATGEN = 16;
    public static final int LJSTATSKI = 32;
    public static final int LJSTATSYN = 64;
    public static final int LJSTATERR = 128;
    public static final int LJSTATJAR = 4096;
    public static final int LJSTATCMP = 8192;
    public static final int LJSTATALL = 12543;

    LoadJavaState() {
        this(null, null, null);
    }

    LoadJavaState(Options opts) {
        this(opts, null, null);
    }

    LoadJavaState(Options opts, DatabaseOptions database, LoadJavaLog log) {
        this.opts = opts;
        this.database = database;
        this.log = log;
        this.reset();
    }

    String[] parseArgs(String[] argv) throws ToolsException {
        return this.parseArgs(argv, null);
    }

    String[] parseArgs(String[] argv, Options newOpts) throws ToolsException {
        Options.Args args = new Options.Args(argv);
        this.parseArgs(args, newOpts);
        return args.unused();
    }

    void parseArgs(Options.Args args) throws ToolsException {
        this.parseArgs(args, null);
    }

    void parseArgs(Options.Args args, Options newOpts) throws ToolsException {
        if (newOpts != null) {
            this.opts = newOpts;
        }
        if (this.opts == null) {
            this.opts = new LoadJavaOptions();
        }
        if (this.database == null && !this.connSet) {
            this.database = new DatabaseOptions();
        }
        if (this.database != null) {
            this.database.parseArgs(args);
        }
        this.opts.parseArgs(args);
        this.genMissingOpts = this.opts instanceof GenMissingOptions ? (GenMissingOptions)this.opts : new GenMissingOptions();
        this.genMissingOpts.parseArgs(args);
        if (this.log == null) {
            this.log = new LoadJavaLog();
        }
        LogOptions logOpts = this.log.getOpts();
        logOpts.parseArgs(args);
    }

    void set(String property, Object value) {
        if (this.getOpts().isProperty(property)) {
            this.getOpts().set(property, value);
            this.reset();
        }
        if (this.getLog().getOpts().isProperty(property)) {
            this.getLog().getOpts().set(property, value);
        }
    }

    void reset() {
        this.verifierOn = true;
        this.jdbcTables = new Hashtable(7);
        this.NameForLobTable = Long.toString(System.nanoTime());
        this.ld_classes = 0;
        this.ld_resources = 0;
        this.ld_sources = 0;
        this.ld_published = 0;
        this.ld_genmissing = 0;
        this.ld_skipped = 0;
        this.cr_syn = 0;
        this.natively_compiled = 0;
        this.errors = 0;
    }

    void setOpts(Options opts) {
        this.opts = opts;
        this.reset();
    }

    Options getOpts() {
        if (this.opts == null) {
            this.opts = new LoadJavaOptions();
        }
        return this.opts;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
        this.connSet = connection != null;
    }

    void setDatabase(DatabaseOptions database) {
        this.database = database;
        this.connSet = false;
    }

    GenMissing getGenMissing() {
        if (this.genMissing == null) {
            this.genMissing = new GenMissing(this.genMissingOpts, this);
        }
        return this.genMissing;
    }

    Publish getPublish() {
        if (this.publish == null) {
            this.publish = new Publish(this);
        }
        return this.publish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionFile getOptionFile() {
        if (this.optionFile == null) {
            String fileName = this.getOpts().getString("-optionfile");
            String tableName = this.getOpts().getString("-optiontable");
            if (fileName != null && tableName != null) {
                this.warn("both -optionfile and -optiontable supplied. Using -optionfile");
            }
            if (fileName != null) {
                try {
                    this.optionFile = new OptionFile(this, new FileInputStream(fileName));
                }
                catch (IOException ioex) {
                    this.err(ioex, this.mkMsg.m("reading {0}", fileName));
                }
            } else if (tableName != null) {
                Connection conn = this.getConnection();
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    String select = "SELECT pattern, option, value FROM " + tableName;
                    ResultSet rs = stmt.executeQuery(select);
                    this.optionFile = new OptionFile(this, rs);
                }
                catch (SQLException sqlex) {
                    this.err(sqlex, this.mkMsg.m("processing option table {0}", tableName));
                }
                finally {
                    this.getJdbc().closeStatement(stmt, "processing option table " + tableName);
                }
            }
        }
        return this.optionFile;
    }

    JdbcOperations getJdbc() {
        if (this.jdbcOperations == null) {
            this.jdbcOperations = new JdbcOperations(this);
        }
        return this.jdbcOperations;
    }

    DatabaseOptions getDbs() {
        if (this.database == null) {
            this.database = new DatabaseOptions();
        }
        return this.database;
    }

    synchronized void setCancelled(String msg) {
        this.cancelled = msg;
    }

    synchronized void checkCancelled() {
        if (this.cancelled != null) {
            throw new FatalError(this.cancelled);
        }
    }

    void msg(String msg) {
        this.getLog().msg(msg);
    }

    void err(Exception ex, String when) {
        this.getLog().err(ex, when);
    }

    void err(String msg) {
        this.getLog().err(msg);
    }

    void failErr(String msg) {
        this.getLog().failErr(msg);
    }

    void warn(String msg) {
        this.getLog().warn(msg);
    }

    void warn(Exception ex, String when) {
        this.getLog().warn(ex, when);
    }

    public boolean databaseSupplied() {
        boolean result = false;
        if (this.database != null) {
            result = this.database.optionsSupplied();
        }
        result = this.connection != null || result;
        return result;
    }

    public Connection getConnection() {
        if (this.connection == null || this.getLog().getConnectionFailure()) {
            try {
                String edition;
                if (this.database == null) {
                    throw new ConnectionError("no connection was supplied");
                }
                this.connection = this.database.connect();
                if (this.getOpts().getBoolean("-debug")) {
                    this.getJdbc().startJDBCLogging();
                }
                if ((edition = this.getOpts().getString("-edition")) != null) {
                    this.getJdbc().executeDDL("alter session set edition=" + edition);
                }
            }
            catch (ToolsException ex) {
                this.getLog().err(ex.getMessage());
                throw new ConnectionError("could not open connection");
            }
            catch (SQLException ex) {
                this.getLog().err(ex, this.mkMsg.m("opening connection"));
                throw new ConnectionError(this.mkMsg.m("could not open connection"));
            }
            this.getLog().setConnectionFailure(false);
        }
        return this.connection;
    }

    void setLog(LoadJavaLog log) {
        this.log = log;
    }

    public LoadJavaLog getLog() {
        if (this.log == null) {
            this.log = new LoadJavaLog();
        }
        return this.log;
    }

    private PrintWriter getOutput() {
        return this.getLog().getWriter();
    }

    void setVerifier(boolean on) {
        if (this.verifierOn != on) {
            if (on) {
                this.msg(this.mkMsg.m("verifier : on"));
            } else {
                this.msg(this.mkMsg.m("verifier : off"));
            }
            this.getJdbc().turnVerifier(on);
            this.verifierOn = on;
        }
    }

    boolean doCreateTable(String tableName) {
        return !this.jdbcTables.containsKey(tableName) && !this.tableExists(tableName);
    }

    boolean tableExists(String tableName) {
        boolean exists;
        if (this.jdbcTables.containsKey(tableName)) {
            exists = (Boolean)this.jdbcTables.get(tableName);
        } else {
            exists = this.getJdbc().tableExists(tableName);
            this.jdbcTables.put(tableName, new Boolean(exists));
        }
        return exists;
    }

    void tableCreated(String tableName) {
        this.jdbcTables.put(tableName, Boolean.TRUE);
    }

    String createTable(String tableName, String shape) {
        if (this.doCreateTable(tableName)) {
            String when = this.mkMsg.m("creating {0}", tableName);
            try {
                this.getJdbc().executeDDL("create table " + tableName + " " + shape);
                this.tableCreated(tableName);
                this.msg(this.mkMsg.m("created  : {0}", tableName));
            }
            catch (SQLException sqlex) {
                if (this.getJdbc().tableExists(tableName)) {
                    this.tableCreated(tableName);
                }
                this.err(sqlex, when);
            }
        }
        return tableName;
    }

    void createLobTable(String schema) {
        this.getJdbc();
        this.createTable(JdbcOperations.lobTable(schema), "(name varchar2(700) unique, lob blob, loadtime date)");
    }

    BLOB getLoadLOB(String schema) {
        this.getJdbc();
        String tableName = JdbcOperations.lobTable(schema);
        try {
            this.createTable(tableName, "(name varchar2(700) unique, lob blob, loadtime date)");
            if (this.lobTableStmtSchema != schema) {
                this.lobTableStmtSchema = schema;
                this.getJdbc().executeDDL("delete from " + tableName + " where name='" + this.NameForLobTable + "'");
                this.getJdbc().executeDDL("insert into " + tableName + " (name, lob, loadtime) values('" + this.NameForLobTable + "', empty_blob(), sysdate)");
                this.getJdbc().closeStatement(this.lobTableStmt, "prepareLobTable opening lobTableStmt");
                this.lobTableStmt = this.getConnection().prepareStatement("select lob from " + tableName + " where name ='" + this.NameForLobTable + "' for update");
            }
            OracleResultSet r = (OracleResultSet)this.lobTableStmt.executeQuery();
            r.next();
            BLOB blob = r.getBLOB(1);
            blob.trim(0L);
            return blob;
        }
        catch (SQLException sqlex) {
            this.err(sqlex, "getLoadLOB " + schema);
            return null;
        }
    }

    String createMD5Table(String schema) {
        this.getJdbc();
        return this.createTable(JdbcOperations.md5Table(schema), "(name varchar2(200) unique, md5 raw(16))");
    }

    boolean doDropTable(String tableName) {
        return !this.jdbcTables.containsKey(tableName) && this.tableExists(tableName);
    }

    void tableDropped(String tableName) {
        this.jdbcTables.put(tableName, Boolean.FALSE);
    }

    void dropTable(String tableName) {
        if (this.doDropTable(tableName)) {
            String when = this.mkMsg.m("dropping {0}", tableName);
            try {
                this.getJdbc().executeDDL("drop table " + tableName);
                this.tableDropped(tableName);
                this.msg(this.mkMsg.m("dropped  : {0}", tableName));
            }
            catch (SQLException sqlex) {
                if (!this.getJdbc().tableExists(tableName)) {
                    this.tableDropped(tableName);
                }
                this.err(sqlex, when);
            }
        }
    }

    void dropMD5Table(String schema) {
        this.getJdbc();
        this.dropTable(JdbcOperations.md5Table(schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean MD5TableIsObsolete() {
        block7: {
            if (this.MD5TableIsObsolete == 0) {
                this.MD5TableIsObsolete = 2;
                Connection conn = this.getConnection();
                Statement stmt = null;
                try {
                    try {
                        stmt = conn.createStatement();
                        stmt.execute("select dbms_java.handleMd5('///',29) from dual");
                        this.MD5TableIsObsolete = 1;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (SQLException sqlex) {
                    if (this.getLog().checkCode(sqlex, 904)) break block7;
                    String when = this.mkMsg.m("testing for existence of {0}", GetMD5FunctionName);
                    this.getLog().err(sqlex, when);
                }
            }
        }
        return this.MD5TableIsObsolete == 1;
    }

    public String MD5TableNameIfNotObsolete(String schema) {
        String name = null;
        if (this.MD5TableIsObsolete()) {
            this.dropMD5Table(schema);
        } else {
            name = this.createMD5Table(schema);
        }
        return name;
    }

    public byte[] getOldMD5(String classname, String schema, int type) {
        byte[] md5 = null;
        String when = this.mkMsg.m("getting old MD5 of {0}", classname);
        try {
            if (this.MD5Stmt1 == null) {
                Connection conn = this.getConnection();
                String tableName = this.MD5TableNameIfNotObsolete(schema);
                if (tableName == null) {
                    String prefix = "SELECT dbms_java.handleMd5";
                    this.MD5Stmt1 = conn.prepareStatement(prefix + "(?,?) from dual");
                    this.MD5Stmt2 = conn.prepareStatement(prefix + "(?,?,?) from dual");
                } else {
                    this.MD5Stmt1 = conn.prepareStatement("SELECT MD5 FROM " + tableName + " WHERE NAME = ?");
                }
            }
            PreparedStatement stmt = this.MD5Stmt1;
            if (this.MD5TableIsObsolete == 2) {
                stmt.setString(1, classname);
            } else if (schema == null) {
                stmt.setString(1, classname);
                stmt.setInt(2, type);
            } else {
                stmt = this.MD5Stmt2;
                stmt.setString(1, schema);
                stmt.setString(2, classname);
                stmt.setInt(3, type);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                md5 = rs.getBytes(1);
            }
        }
        catch (SQLException sql) {
            this.err(sql, when);
        }
        return md5;
    }

    public void resetStmts() {
        String what = "LoadJavaState.resetStmts";
        this.getJdbc().closeStatement(this.classCreationStmt, what);
        this.classCreationStmt = null;
        this.getJdbc().closeStatement(this.resourceCreationStmt, what);
        this.resourceCreationStmt = null;
        this.getJdbc().closeStatement(this.sourceCreationStmt, what);
        this.sourceCreationStmt = null;
        this.getJdbc().closeStatement(this.lobTableStmt, what);
        this.lobTableStmt = null;
        this.lobTableStmtSchema = lobTableStmtSchemaInitializer;
        this.getJdbc().closeStatement(this.MD5Stmt1, what);
        this.MD5Stmt1 = null;
        this.getJdbc().closeStatement(this.MD5Stmt2, what);
        this.MD5Stmt2 = null;
        this.getJdbc().closeStatement(this.shortFromLongnameStmt, what);
        this.shortFromLongnameStmt = null;
        this.getJdbc().closeStatement(this.reportErrorsStmt1, what);
        this.reportErrorsStmt1 = null;
        this.getJdbc().closeStatement(this.reportErrorsStmt2, what);
        this.reportErrorsStmt2 = null;
        this.getJdbc().closeStatement(this.startLoadingJarStmt, what);
        this.startLoadingJarStmt = null;
        this.getJdbc().closeStatement(this.endLoadingJarStmt, what);
        this.endLoadingJarStmt = null;
        this.getJdbc().closeStatement(this.resumeLoadingJarStmt, what);
        this.resumeLoadingJarStmt = null;
        this.getJdbc().closeStatement(this.jarStatusStmt, what);
        this.jarStatusStmt = null;
        this.getJdbc().closeStatement(this.dropJarStmt, what);
        this.dropJarStmt = null;
        this.getJdbc().closeStatement(this.userStatusStmt, what);
        this.userStatusStmt = null;
        this.getJdbc().closeStatement(this.allStatusStmt, what);
        this.allStatusStmt = null;
        this.getJdbc();
        String lobTableName = JdbcOperations.lobTable(null);
        Enumeration e = this.jdbcTables.keys();
        Statement s = null;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.endsWith(lobTableName)) continue;
            try {
                if (s == null) {
                    s = this.getConnection().createStatement();
                }
                s.execute("delete from " + name + " where name='" + this.NameForLobTable + "'");
                this.getConnection().commit();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (s != null) {
            this.getJdbc().closeStatement(s, what);
        }
    }

    CallableStatement getClassCreationStmt() {
        if (this.classCreationStmt == null) {
            try {
                this.classCreationStmt = this.getConnection().prepareCall("begin execute immediate   'create or replace '||?||' java class '||?||?||?||?; ? := \"NameFromLastDDL\"(0);end;");
                this.classCreationStmt.registerOutParameter(6, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getClassCreationStmt");
            }
        }
        return this.classCreationStmt;
    }

    CallableStatement getResourceCreationStmt() {
        if (this.resourceCreationStmt == null) {
            try {
                this.resourceCreationStmt = this.getConnection().prepareCall("begin execute immediate   'create or replace java resource named '||?||?; ? := \"NameFromLastDDL\"(0);end;");
                this.resourceCreationStmt.registerOutParameter(3, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getResourceCreationStmt");
            }
        }
        return this.resourceCreationStmt;
    }

    CallableStatement getSourceCreationStmt() {
        if (this.sourceCreationStmt == null) {
            try {
                this.sourceCreationStmt = this.getConnection().prepareCall("declare encoding varchar2(100) := ?;begin if encoding is not null then  dbms_java.set_compiler_option(?, 'encoding', encoding); end if; execute immediate   'create or replace '||?||' java source named '||?||?||?||?; ? := \"NameFromLastDDL\"(0);end;");
                this.sourceCreationStmt.registerOutParameter(8, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getSourceCreationStmt");
            }
        }
        return this.sourceCreationStmt;
    }

    PreparedStatement getShortFromLongnameStmt() {
        if (this.shortFromLongnameStmt == null) {
            try {
                this.shortFromLongnameStmt = this.getConnection().prepareStatement("select short from javasnm where longname = ?");
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getShortFromLongnameStmt");
            }
        }
        return this.shortFromLongnameStmt;
    }

    PreparedStatement getReportErrorsStmt1() {
        if (this.reportErrorsStmt1 == null) {
            try {
                this.reportErrorsStmt1 = this.getConnection().prepareStatement("select text from user_errors where name = ?");
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getReportErrorsStmt1");
            }
        }
        return this.reportErrorsStmt1;
    }

    PreparedStatement getReportErrorsStmt2() {
        if (this.reportErrorsStmt2 == null) {
            try {
                this.reportErrorsStmt2 = this.getConnection().prepareStatement("select text from all_errors where name = ? and owner = ?");
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getReportErrorsStmt2");
            }
        }
        return this.reportErrorsStmt2;
    }

    CallableStatement getStartLoadingJarStmt() {
        if (this.startLoadingJarStmt == null) {
            try {
                this.startLoadingJarStmt = this.getConnection().prepareCall("declare jarcontent blob; begin  execute immediate ? into jarcontent; ? := dbms_java.start_loading_jar(?,?,?,?,jarcontent,?); end;");
                this.startLoadingJarStmt.registerOutParameter(2, 4);
                this.startLoadingJarStmt.registerOutParameter(7, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getStartLoadingJarStmt");
            }
        }
        return this.startLoadingJarStmt;
    }

    CallableStatement getEndLoadingJarStmt() {
        if (this.endLoadingJarStmt == null) {
            try {
                this.endLoadingJarStmt = this.getConnection().prepareCall("begin  ? := dbms_java.finish_loading_jar(?,?); end;");
                this.endLoadingJarStmt.registerOutParameter(1, 4);
                this.endLoadingJarStmt.registerOutParameter(3, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getEndLoadingJarStmt");
            }
        }
        return this.endLoadingJarStmt;
    }

    CallableStatement getResumeLoadingJarStmt() {
        if (this.resumeLoadingJarStmt == null) {
            try {
                this.resumeLoadingJarStmt = this.getConnection().prepareCall("begin  ? := dbms_java.start_loading_jar(?,?,?,?,null,?); end;");
                this.resumeLoadingJarStmt.registerOutParameter(1, 4);
                this.resumeLoadingJarStmt.registerOutParameter(6, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getResumeLoadingJarStmt");
            }
        }
        return this.resumeLoadingJarStmt;
    }

    CallableStatement getJarStatusStmt() {
        if (this.jarStatusStmt == null) {
            try {
                this.jarStatusStmt = this.getConnection().prepareCall("begin  ? := dbms_java.jar_status(?,?,?); end;");
                this.jarStatusStmt.registerOutParameter(1, 4);
                this.jarStatusStmt.registerOutParameter(4, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getJarStatusStmt");
            }
        }
        return this.jarStatusStmt;
    }

    CallableStatement getDropJarStmt() {
        if (this.dropJarStmt == null) {
            try {
                this.dropJarStmt = this.getConnection().prepareCall("begin  ? := dbms_java.drop_jar(?,?,?); commit; end;");
                this.dropJarStmt.registerOutParameter(1, 4);
                this.dropJarStmt.registerOutParameter(4, 12);
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getDropJarStmt");
            }
        }
        return this.dropJarStmt;
    }

    PreparedStatement getUserStatusStmt() {
        if (this.userStatusStmt == null) {
            try {
                this.userStatusStmt = this.getConnection().prepareStatement("select status from user_objects where object_type = ? and object_name = ?");
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getUserStatusStmt");
            }
        }
        return this.userStatusStmt;
    }

    PreparedStatement getAllStatusStmt() {
        if (this.allStatusStmt == null) {
            try {
                this.allStatusStmt = this.getConnection().prepareStatement("select status from all_objects where object_type = ? and object_name = ? and owner = ?");
            }
            catch (SQLException sqlex) {
                this.err(sqlex, "getAllStatusStmt");
            }
        }
        return this.allStatusStmt;
    }

    void populateShortnameTable(int size) {
        if (shortnameTable == null) {
            Statement stmt = null;
            try {
                stmt = this.getConnection().createStatement();
                ResultSet rset = stmt.executeQuery("select count(*) from javasnm");
                rset.next();
                shortnameTable = new Hashtable(rset.getInt(1));
                rset = stmt.executeQuery("select short,longname from javasnm");
                while (rset.next()) {
                    shortnameTable.put(rset.getString(2), rset.getString(1));
                }
                stmt.close();
            }
            catch (SQLException e) {
                this.getJdbc().closeStatement(stmt, "populateShortnameTable");
            }
        }
    }

    void recordShortnames(SchemaObject list) {
        while (list != null) {
            String key = list.getName();
            String val = (String)shortnameTable.get(key);
            if (val == null) {
                val = key;
            }
            list.setShortname(val);
            list = list.next;
        }
    }

    void printStats(int mask) {
        while (mask != 0) {
            if ((mask & 1) != 0) {
                System.out.println("Classes Loaded: " + this.ld_classes);
                --mask;
                continue;
            }
            if ((mask & 2) != 0) {
                System.out.println("Resources Loaded: " + this.ld_resources);
                mask -= 2;
                continue;
            }
            if ((mask & 4) != 0) {
                System.out.println("Sources Loaded: " + this.ld_sources);
                mask -= 4;
                continue;
            }
            if ((mask & 0x1000) != 0) {
                if (this.ld_jar > 0) {
                    System.out.println("Jars Loaded: " + this.ld_jar);
                }
                mask -= 4096;
                continue;
            }
            if ((mask & 8) != 0) {
                System.out.println("Published Interfaces: " + this.ld_published);
                mask -= 8;
                continue;
            }
            if ((mask & 0x10) != 0) {
                System.out.println("Classes generated: " + this.ld_genmissing);
                mask -= 16;
                continue;
            }
            if ((mask & 0x20) != 0) {
                System.out.println("Classes skipped: " + this.ld_skipped);
                mask -= 32;
                continue;
            }
            if ((mask & 0x40) != 0) {
                System.out.println("Synonyms Created: " + this.cr_syn);
                mask -= 64;
                continue;
            }
            if ((mask & 0x2000) != 0) {
                if (this.natively_compiled > 0) {
                    System.out.println("Methods natively compiled: " + this.natively_compiled);
                }
                mask -= 8192;
                continue;
            }
            if ((mask & 0x80) == 0) continue;
            System.out.println("Errors: " + this.errors);
            mask -= 128;
        }
    }

    void printStats() {
        this.printStats(12543);
    }

    int getLoc() {
        if (this.LoadJavaLoc == -1) {
            this.LoadJavaLoc = System.getProperty("oracle.jserver.version") != null ? 1 : 0;
        }
        return this.LoadJavaLoc;
    }
}

