/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.sql.SQLException;
import java.util.Enumeration;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SecurityManagerImpl;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTablePermission;
import oracle.aurora.rdbms.security.PolicyTableProxy;
import oracle.aurora.rdbms.security.PolicyTableRow;
import oracle.aurora.rdbms.security.PolicyTableRows;
import oracle.aurora.rdbms.security.SchemaPermissions;
import oracle.aurora.rdbms.security.TypeDescriptor;
import oracle.aurora.vm.Id;
import oracle.aurora.vm.IdManager;
import oracle.aurora.vm.IdNotFoundException;

public class PolicyTableManager {
    static int debugLevel = 0;
    static PolicyTable cachedTable;
    static final IdManager manager;
    static final String permissionClassname = "SYS:oracle.aurora.rdbms.security.PolicyTablePermission";

    public static PolicyTable getTable() {
        PolicyTable table = null;
        SecurityManager security = System.getSecurityManager();
        if (security != null && security instanceof SecurityManagerImpl) {
            table = ((SecurityManagerImpl)security).getPolicyTable();
        }
        if (table == null) {
            table = cachedTable;
        }
        if (table == null) {
            try {
                table = cachedTable = new PolicyTable();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return table;
    }

    static void commit() {
        PolicyTableManager.getTable().commit();
    }

    private static boolean bedrock(Id updater, TypeDescriptor type, String name) {
        boolean ok = false;
        TypeDescriptor bedrockType = new TypeDescriptor(PolicyTableManager.getTable(), Schema.systemSchema, "oracle.aurora.rdbms.security.PolicyTablePermission");
        if (type.equals(bedrockType)) {
            try {
                int xHash = name.indexOf(35);
                if (xHash >= 0) {
                    TypeDescriptor onType = new TypeDescriptor(PolicyTableManager.getTable(), name.substring(0, xHash));
                    Id owner = onType.getSchema();
                    ok = updater.equals(owner);
                }
            }
            catch (IdNotFoundException ex) {
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        return ok;
    }

    private static void checkPermission(TypeDescriptor td, String type, String name) {
        PolicyTablePermission required;
        SchemaPermissions schemaPermissions = PolicyTableManager.getTable().getSchemaPermissionsFor(manager.currentId());
        if (!((PermissionCollection)schemaPermissions).implies(required = new PolicyTablePermission(td.unparse() + "#" + name)) && !PolicyTableManager.bedrock(manager.currentId(), td, name)) {
            throw new SecurityException("policy table update " + type + ", " + name);
        }
    }

    private static boolean hasAnyPolicyTablePermission() {
        SchemaPermissions schemaPermissions = PolicyTableManager.getTable().getSchemaPermissionsFor(manager.currentId());
        Enumeration<Permission> en = ((PermissionCollection)schemaPermissions).elements();
        while (en.hasMoreElements()) {
            if (!(en.nextElement() instanceof PolicyTablePermission)) continue;
            return true;
        }
        return false;
    }

    private static void checkPermission() {
        if (!PolicyTableManager.hasAnyPolicyTablePermission()) {
            throw new SecurityException("policy table access permission");
        }
    }

    public static void enable(long key) {
        block3: {
            PolicyTableManager.checkPermission();
            PolicyTableRows e = PolicyTableManager.getTable().select("key = " + key);
            if (e.hasNext()) {
                PolicyTableRow r = e.nextRow();
                String type = r.type_name;
                long type_schema = r.type_schema;
                String name = r.name;
                try {
                    TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type_schema, type);
                    PolicyTableManager.checkPermission(td, type, name);
                    PolicyTableManager.getTable().enableRow(key);
                    PolicyTableManager.commit();
                }
                catch (IdNotFoundException ex) {
                    if (!PolicyTableManager.debug()) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void disable(long key) {
        block3: {
            PolicyTableManager.checkPermission();
            PolicyTableRows e = PolicyTableManager.getTable().select("key = " + key);
            if (e.hasNext()) {
                PolicyTableRow r = e.nextRow();
                String type = r.type_name;
                long type_schema = r.type_schema;
                String name = r.name;
                try {
                    TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type_schema, type);
                    PolicyTableManager.checkPermission(td, type, name);
                    PolicyTableManager.getTable().disableRow(key);
                    PolicyTableManager.commit();
                }
                catch (IdNotFoundException ex) {
                    if (!PolicyTableManager.debug()) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void delete(long key) {
        block3: {
            PolicyTableManager.checkPermission();
            PolicyTableRows e = PolicyTableManager.getTable().select("key = " + key + " and " + "status#" + " = " + 3);
            if (e.hasNext()) {
                PolicyTableRow r = e.nextRow();
                String type = r.type_name;
                long type_schema = r.type_schema;
                String name = r.name;
                try {
                    TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type_schema, type);
                    PolicyTableManager.checkPermission(td, type, name);
                    PolicyTableManager.getTable().deleteRow(key);
                    PolicyTableManager.commit();
                }
                catch (IdNotFoundException ex) {
                    if (!PolicyTableManager.debug()) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    static String pName(String onSchema, String onClass, String name) throws IdNotFoundException {
        return manager.getId(onSchema).getNumber() + ":" + onClass + "#" + name;
    }

    public static long grantPolicyPermission(String schema, String onSchema, String onClass, String name) throws IdNotFoundException, ClassNotFoundException {
        return PolicyTableManager.grant(schema, permissionClassname, PolicyTableManager.pName(onSchema, onClass, name), null);
    }

    public static void grantPolicyPermission(String schema, String onSchema, String onClass, String name, long[] key) {
        long result;
        try {
            result = PolicyTableManager.addGrant(schema, permissionClassname, PolicyTableManager.pName(onSchema, onClass, name), null);
        }
        catch (IdNotFoundException ex) {
            result = -1L;
        }
        catch (ClassNotFoundException ex) {
            result = -1L;
        }
        key[0] = result;
    }

    public static long add(int kind, String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type);
        return PolicyTableManager.add(kind, schema, td, name, action);
    }

    private static long add(int kind, String schema, TypeDescriptor td, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        Id id = manager.getId(schema);
        PolicyTableManager.checkPermission(td, td.getName(), name);
        long result = PolicyTableManager.getTable().insertRow(kind, id, td, name, action);
        PolicyTableManager.commit();
        return result;
    }

    public static long addGrant(String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        return PolicyTableManager.add(0, schema, type, name, action);
    }

    public static long addRestrict(String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        return PolicyTableManager.add(1, schema, type, name, action);
    }

    static PolicyTableRows findAll(int kind, String schema, TypeDescriptor td, String name, String action) throws ClassNotFoundException, IdNotFoundException {
        Object found = null;
        PolicyTableRow r = new PolicyTableRow(PolicyTableManager.getTable(), kind, manager.getId(schema).getNumber(), td.getSchemaNumber(), td.getName(), name, action, 0, 0L);
        int flags = -385;
        PolicyTableRows e = PolicyTableManager.getTable().match(r, flags);
        return e;
    }

    static PolicyTableRow find(int kind, String schema, TypeDescriptor td, String name, String action) throws ClassNotFoundException, IdNotFoundException {
        PolicyTableRow found = null;
        PolicyTableRows e = PolicyTableManager.findAll(kind, schema, td, name, action);
        if (e.hasNext()) {
            found = e.nextRow();
        }
        e.close();
        return found;
    }

    static long activate(int kind, String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        long result;
        if (type == null) {
            throw new ClassNotFoundException("type specified was null");
        }
        TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type);
        PolicyTableRow existing = PolicyTableManager.find(kind, schema, td, name, action);
        PolicyTableManager.checkPermission(td, type, name);
        if (existing == null) {
            result = PolicyTableManager.add(kind, schema, type, name, action);
        } else if (existing.status == 3) {
            PolicyTableManager.enable(existing.key);
            result = existing.key;
        } else {
            result = existing.key;
        }
        PolicyTableManager.getTable().refresh();
        return result;
    }

    static void deactivate(int kind, String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type);
        PolicyTableManager.checkPermission(td, type, name);
        PolicyTableRows existing = PolicyTableManager.findAll(kind, schema, td, name, action);
        while (existing.hasNext()) {
            PolicyTableRow r = existing.nextRow();
            if (r.status != 2) continue;
            PolicyTableManager.disable(r.key);
        }
    }

    public static long grant(String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        return PolicyTableManager.activate(0, schema, type, name, action);
    }

    public static long restrict(String schema, String type, String name, String action) throws IdNotFoundException, ClassNotFoundException {
        return PolicyTableManager.activate(1, schema, type, name, action);
    }

    public static void grant(String schema, String type, String name, String action, long[] key) {
        try {
            key[0] = PolicyTableManager.add(0, schema, type, name, action);
        }
        catch (IdNotFoundException ex) {
            if (PolicyTableManager.debug()) {
                ex.printStackTrace();
            }
            key[0] = -1L;
        }
        catch (ClassNotFoundException ex) {
            if (PolicyTableManager.debug()) {
                ex.printStackTrace();
            }
            key[0] = -1L;
        }
    }

    public static void revoke(String schema, String type, String name, String action) {
        block4: {
            try {
                PolicyTableManager.deactivate(0, schema, type, name, action);
            }
            catch (IdNotFoundException ex) {
                if (PolicyTableManager.debug()) {
                    ex.printStackTrace();
                }
            }
            catch (ClassNotFoundException ex) {
                if (!PolicyTableManager.debug()) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static void restrict(String schema, String type, String name, String action, long[] key) {
        try {
            key[0] = PolicyTableManager.add(1, schema, type, name, action);
        }
        catch (IdNotFoundException ex) {
            if (PolicyTableManager.debug()) {
                ex.printStackTrace();
            }
            key[0] = -1L;
        }
        catch (ClassNotFoundException ex) {
            if (PolicyTableManager.debug()) {
                ex.printStackTrace();
            }
            key[0] = -1L;
        }
    }

    public static void setDebugLevel(int n) {
        debugLevel = n;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    private static boolean debug() {
        return debugLevel > 0;
    }

    public static boolean implies(String type, String name, String action) throws IdNotFoundException, ClassNotFoundException, InstantiationException {
        TypeDescriptor td = new TypeDescriptor(PolicyTableManager.getTable(), type);
        PolicyTableRow r = new PolicyTableRow(PolicyTableManager.getTable(), 0, 0L, td.getSchemaNumber(), td.getName(), name, action, 2, 0L);
        Permission want = r.instantiate();
        PolicyTableProxy have = PolicyTableManager.getTable().getProxy(manager.currentId());
        boolean result = have.implies(want);
        return result;
    }

    static {
        manager = Schema.systemSchema;
    }
}

