/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.lang.management.ManagementPermission;
import java.lang.reflect.Member;
import java.security.Permission;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.aurora.rdbms.OracleRuntimeMXBean;
import oracle.aurora.vm.OracleRuntime;
import oracle.jdbc.internal.OracleResultSet;
import sun.management.MXBeanSupport;

final class OracleRuntimeMXBImpl
extends MXBeanSupport
implements OracleRuntimeMXBean {
    static boolean TRACE = true;
    static String OKString = "Operation Completed Successfully";
    private JdbcOps jdbcOps = null;
    private long queryElapsedTime = 0L;
    private int queryCount = 0;
    private int samplingInterval = 3000;
    private long encacheTimestamp = System.currentTimeMillis();
    private long wholeJVM_ExecutionElapsedTime;
    private HashMap<String, Long> javaTotalsCache;
    private static Permission monitorPermission = new ManagementPermission("monitor");
    private static Permission controlPermission = new ManagementPermission("control");

    OracleRuntimeMXBImpl() {
        super(OracleRuntimeMXBean.class);
    }

    public void exitSession(int status) {
        OracleRuntime.exitSession(status);
    }

    public void exitCall(int status) {
        OracleRuntime.exitCall(status);
    }

    public boolean inEndOfCall() {
        return OracleRuntime.inEndOfCall();
    }

    public String getPlatform() {
        switch (OracleRuntime.getPlatform()) {
            case 1: {
                return "Windows Port";
            }
            case 2: {
                return "Linux Port";
            }
        }
        return "Uknown";
    }

    public boolean definePackage(String name) {
        return OracleRuntime.definePackage(name);
    }

    public void exitCallWhenMainThreadTerminates() {
        OracleRuntime.setCallExitPolicy(1);
    }

    public void exitCallWhenAllNonDaemonThreadsTerminate() {
        OracleRuntime.setCallExitPolicy(0);
    }

    public void exitCallWhenAllThreadsTerminate() {
        OracleRuntime.setCallExitPolicy(2);
    }

    public String getCallExitPolicy() {
        switch (OracleRuntime.getCallExitPolicy()) {
            case 1: {
                return "ExitCallWhenMainThreadTerminates";
            }
            case 0: {
                return "ExitCallWhenAllNonDaemonThreadsTerminate";
            }
            case 2: {
                return "ExitCallWhenAllThreadsTerminate";
            }
        }
        return "Unknown";
    }

    public boolean getForceActiveThreadTherminationAtCallEnd() {
        return OracleRuntime.getThreadTerminationPolicy(true);
    }

    public void setForceActiveThreadTherminationAtCallEnd(boolean val) {
        OracleRuntime.setThreadTerminationPolicy(val);
    }

    public long getMaxMemorySize() {
        return OracleRuntime.getMaxMemorySize();
    }

    public void setMaxMemorySize(long maxSize) {
        OracleRuntime.setMaxMemorySize(maxSize);
    }

    public long getMaxRunspaceSize() {
        return OracleRuntime.getMaxRunspaceSize();
    }

    public void setMaxRunspaceSize(long maxSize) {
        OracleRuntime.setMaxRunspaceSize(maxSize);
    }

    public long getMaxSessionSize() {
        return OracleRuntime.getMaxSessionSize();
    }

    public long getSessionSoftLimit() {
        return OracleRuntime.getSessionSoftLimit();
    }

    public long getSessionSize() {
        return OracleRuntime.getSessionSize();
    }

    public long getNewspaceSize() {
        return OracleRuntime.getNewspaceSize();
    }

    public void setNewspaceSize(long size) {
        OracleRuntime.setNewspaceSize(size);
    }

    public boolean getNewspaceEnabled() {
        return OracleRuntime.newspaceEnabled();
    }

    public void setNewspaceEnabled(boolean enable) {
        OracleRuntime.enableNewspace(enable);
    }

    public byte getNewspaceMaxGeneration() {
        return OracleRuntime.getNewspaceMaxGeneration();
    }

    public void setNewspaceMaxGeneration(byte arg) {
        OracleRuntime.setNewspaceMaxGeneration(arg);
    }

    public byte getMinNewspaceTenurePolicy() {
        return 0;
    }

    public byte getDefaultNewspaceTenurePolicy() {
        return 0;
    }

    public byte getNewspaceTenureGeneration() {
        return OracleRuntime.getNewspaceTenurePolicy();
    }

    public void setNewspaceTenureGeneration(byte arg) {
        OracleRuntime.setNewspaceTenurePolicy(arg);
    }

    public long getSessionGCThreshold() {
        return OracleRuntime.getSessionGCThreshold();
    }

    public void setSessionGCThreshold(long size) {
        OracleRuntime.setSessionGCThreshold(size);
    }

    public String getSessionGCPolicy() {
        switch (OracleRuntime.getSessionGCPolicy()) {
            case 2: {
                return "do SGC at end of call";
            }
            case -2: 
            case -1: {
                return "do not SGC at end of call";
            }
            case 0: {
                return "use SGC threshold";
            }
            case 1: {
                return "tracking SGC threshold";
            }
        }
        return "unknown: " + OracleRuntime.getSessionGCPolicy();
    }

    private static String reformat(Exception e) {
        String newtext;
        int idx;
        String text = "" + e;
        while ((idx = text.indexOf(": ")) > -1) {
            text = newtext = text.substring(0, idx) + ":\n" + text.substring(idx + 2);
        }
        while ((idx = text.indexOf(") ")) > -1) {
            text = newtext = text.substring(0, idx) + ")\n" + text.substring(idx + 2);
        }
        while ((idx = text.indexOf(". ")) > -1) {
            text = newtext = text.substring(0, idx) + ".\n" + text.substring(idx + 2);
        }
        return text;
    }

    public String doSGCEndOfCall() {
        try {
            OracleRuntime.setSessionGCPolicy(2);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String doNotSGCEndOfCall() {
        try {
            OracleRuntime.setSessionGCPolicy(-1);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String useSGCThreshold() {
        try {
            OracleRuntime.setSessionGCPolicy(0);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String trackingSGCThreshold() {
        try {
            OracleRuntime.setSessionGCPolicy(1);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public int getThreadStackSize() {
        return OracleRuntime.getThreadStackSize();
    }

    public void setThreadStackSize(int size) {
        OracleRuntime.setThreadStackSize(size);
    }

    public int getJavaStackSize() {
        return OracleRuntime.getJavaStackSize();
    }

    public String intern(String str) {
        try {
            return OracleRuntime.intern(str);
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public long getInternTableMaxSize() {
        return OracleRuntime.getInternTableMaxSize();
    }

    public void setInternTableMaxSize(long size) {
        OracleRuntime.setInternTableMaxSize(size);
    }

    public long getInternTableSize() {
        return OracleRuntime.getInternTableSize();
    }

    public long getJavaPoolSize() {
        return OracleRuntime.getJavaPoolSize();
    }

    public String dumpAllHeaps(String pathname) {
        try {
            OracleRuntime.dumpAllHeaps(pathname);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String dumpJITSymbolsForVTune(String filename) {
        try {
            OracleRuntime.dumpJITSymbolsForVTune(filename);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String dumpNativeMachineCode(String sClassName, String sMethName, String sMethSig) {
        try {
            OracleRuntime.dumpNativeMachineCode(sClassName, sMethName, sMethSig);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String getSoftRefPolicy() {
        switch (OracleRuntime.getSoftRefPolicy()) {
            case 0: {
                return "age soft ref policy";
            }
            case 1: {
                return "calls soft ref policy";
            }
        }
        return "unknown: " + OracleRuntime.getSoftRefPolicy();
    }

    public String ageSoftRefPolicy() {
        try {
            OracleRuntime.setSoftRefPolicy(0, OracleRuntime.getSoftRefPolicyValue());
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String callsSoftRefPolicy() {
        try {
            OracleRuntime.setSoftRefPolicy(1, OracleRuntime.getSoftRefPolicyValue());
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public long getSoftRefPolicyValue() {
        return OracleRuntime.getSoftRefPolicyValue();
    }

    public void setSoftRefPolicyValue(long value) {
        OracleRuntime.setSoftRefPolicy(OracleRuntime.getSoftRefPolicy(), value);
    }

    public String jitMethod(String method) {
        try {
            Member[] methods = new Member[]{};
            int ret = OracleRuntime.jitSomeMethods(methods);
            return OKString + " count: " + ret;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String unjitMethod(String method, boolean permanent) {
        try {
            Member[] methods = new Member[]{};
            boolean[] flags = new boolean[]{permanent};
            OracleRuntime.unjitSomeMethods(methods, flags);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String emitStackTrace() {
        try {
            OracleRuntime.emitStackTrace();
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    public String startGCSpy(int port) {
        try {
            OracleRuntime.startGCSpy(port);
            return OKString;
        }
        catch (Exception e) {
            return "Operation Failed with Exception " + OracleRuntimeMXBImpl.reformat(e);
        }
    }

    private static void error(Exception e) {
        if (TRACE) {
            e.printStackTrace();
        }
        OracleRuntimeMXBImpl.error("Got exception " + e);
    }

    private static void out(String msg) {
        if (TRACE) {
            System.out.println("-- OracleRuntimeMXBean: " + msg);
        }
    }

    private static void error(String msg) {
        throw new Error(msg);
    }

    private boolean cacheExpired() {
        long stamp = System.currentTimeMillis();
        return this.encacheTimestamp + (long)this.samplingInterval < stamp;
    }

    private void refreshCache() {
        this.encacheTimestamp = System.currentTimeMillis();
        try {
            if (this.jdbcOps == null) {
                this.jdbcOps = new JdbcOps();
            }
            long time = System.currentTimeMillis();
            this.wholeJVM_ExecutionElapsedTime = this.jdbcOps.javaExecutionElapsedTime();
            this.javaTotalsCache = this.jdbcOps.javaStatsAllSessions();
            time = System.currentTimeMillis() - time;
            this.queryElapsedTime += time;
            ++this.queryCount;
        }
        catch (Exception e) {
            OracleRuntimeMXBImpl.error(e);
        }
    }

    public long getWholeJVM_ExecutionElapsedTime() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        return this.wholeJVM_ExecutionElapsedTime;
    }

    public long getWholeJVM_CallHeapCollectedBytes() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap collected bytes");
        }
        return result;
    }

    public long getWholeJVM_CallHeapCollectedCount() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap collected count");
        }
        return result;
    }

    public long getWholeJVM_CallHeapGcCount() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap gc count");
        }
        return result;
    }

    public long getWholeJVM_CallHeapLiveObjectCount() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap object count");
        }
        return result;
    }

    public long getWholeJVM_CallHeapLiveObjectCountMax() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap object count max");
        }
        return result;
    }

    public long getWholeJVM_CallHeapLiveSize() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap live size");
        }
        return result;
    }

    public long getWholeJVM_CallHeapLiveSizeMax() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap live size max");
        }
        return result;
    }

    public long getWholeJVM_CallHeapObjectCount() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap object count");
        }
        return result;
    }

    public long getWholeJVM_CallHeapObjectCountMax() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap object count max");
        }
        return result;
    }

    public long getWholeJVM_CallHeapTotalSize() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap total size");
        }
        return result;
    }

    public long getWholeJVM_CallHeapTotalSizeMax() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap total size max");
        }
        return result;
    }

    public long getWholeJVM_CallHeapUsedSize() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap used size");
        }
        return result;
    }

    public long getWholeJVM_CallHeapUsedSizeMax() {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        if (this.cacheExpired()) {
            this.refreshCache();
        }
        long result = 0L;
        if (this.javaTotalsCache != null) {
            result = this.javaTotalsCache.get("java call heap used size max");
        }
        return result;
    }

    public int getQueryCacheRefreshWaitMS() {
        return this.samplingInterval;
    }

    public void setQueryCacheRefreshWaitMS(int value) {
        this.samplingInterval = value;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public long getQueryElapsedTime() {
        return this.queryElapsedTime;
    }

    public String sessionsRunningJava() {
        String result = "";
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        try {
            if (this.jdbcOps == null) {
                this.jdbcOps = new JdbcOps();
            }
            result = this.jdbcOps.sessionsRunningJava();
        }
        catch (Exception e) {
            OracleRuntimeMXBImpl.error(e);
        }
        return result;
    }

    public String sessionDetailsBySID(int sid) {
        String result = "";
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
        try {
            if (this.jdbcOps == null) {
                this.jdbcOps = new JdbcOps();
            }
            result = this.jdbcOps.sessionDetails(sid);
        }
        catch (Exception e) {
            OracleRuntimeMXBImpl.error(e);
        }
        return result;
    }

    private static void checkAccess(Permission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    private static void checkMonitorAccess() throws SecurityException {
        OracleRuntimeMXBImpl.checkAccess(monitorPermission);
    }

    private static void checkControlAccess() throws SecurityException {
        OracleRuntimeMXBImpl.checkAccess(controlPermission);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JdbcOps {
        private static final String JAVA_STATS_ALL_SESSIONS = "select n.name, st.value from v$session s, v$sesstat st, v$statname n where s.sid=st.sid and n.statistic# = st.statistic# and (n.name like 'java call%')";
        private static final String JAVA_EXECUTION_ELAPSED_TIME = "select VALUE from SYS.V$SYS_TIME_MODEL where STAT_NAME like 'Java execution%'";
        private static final String JAVA_SESSIONS = "select s.sid, s.username from v$session s, v$sesstat st,v$statname n  where s.sid=st.sid and n.statistic# = st.statistic# and (n.name = 'java call heap total size') and st.value > 0";
        private static final String JAVA_SESSION_DETAILS = "select n.name, st.value from v$session s, v$sesstat st, v$statname n where s.sid = ? and s.sid=st.sid and n.statistic# = st.statistic# and (n.name like 'java call%') order by n.name";
        private static Connection conn;

        private JdbcOps() {
        }

        private Connection getConnection() throws SQLException {
            if (conn == null) {
                conn = DriverManager.getConnection("jdbc:default:connection:");
                conn.setAutoCommit(false);
            }
            return conn;
        }

        long javaExecutionElapsedTime() throws SQLException {
            ResultSet rs = null;
            PreparedStatement st = null;
            long result = 0L;
            try {
                st = this.getConnection().prepareStatement(JAVA_EXECUTION_ELAPSED_TIME);
                rs = (OracleResultSet)st.executeQuery();
                if (rs.next()) {
                    long l = result = rs.getLong(1);
                    return l;
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e) {}
            }
            return result;
        }

        HashMap<String, Long> javaStatsAllSessions() throws SQLException {
            ResultSet rs = null;
            PreparedStatement st = null;
            HashMap<String, Long> results = new HashMap<String, Long>();
            try {
                st = this.getConnection().prepareStatement(JAVA_STATS_ALL_SESSIONS);
                rs = (OracleResultSet)st.executeQuery();
                while (rs.next()) {
                    String stat = rs.getString(1);
                    long val = rs.getLong(2);
                    Long total = results.get(stat);
                    if (total == null) {
                        results.put(stat, val);
                        continue;
                    }
                    if (val <= 0L) continue;
                    results.put(stat, total + val);
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e) {}
            }
            return results;
        }

        String sessionsRunningJava() throws SQLException {
            ResultSet rs = null;
            PreparedStatement st = null;
            String result = "\nSID USER\n-------------\n";
            try {
                st = this.getConnection().prepareStatement(JAVA_SESSIONS);
                rs = (OracleResultSet)st.executeQuery();
                while (rs.next()) {
                    result = result + rs.getLong(1) + " " + rs.getString(2) + "\n";
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e) {}
            }
            return result;
        }

        String sessionDetails(int sid) throws SQLException {
            ResultSet rs = null;
            PreparedStatement st = null;
            String result = "";
            try {
                st = this.getConnection().prepareStatement(JAVA_SESSION_DETAILS);
                st.setLong(1, sid);
                rs = (OracleResultSet)st.executeQuery();
                while (rs.next()) {
                    result = result + rs.getString(1) + ": " + rs.getLong(2) + "\n";
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e) {}
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getSchema() {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.getConnection().createStatement();
                rs = stmt.executeQuery("select user from dual");
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (SQLException e) {
                String string = null;
                return string;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
    }
}

