/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.memoryManager;

import java.util.EmptyStackException;
import java.util.Stack;
import oracle.aurora.memoryManager.Callback;
import oracle.aurora.memoryManager.ThunkEnumeration;

public class EndOfCallRegistry {
    private static final int enoughLoops = 5;

    static native void addThunk(Callback var0, Object var1);

    static native void removeThunk(Callback var0, int var1);

    static native int nextIndex(int var0);

    static native Object getThunk(int var0);

    public static void registerCallback(Callback thunk) {
        EndOfCallRegistry.addThunk(thunk, thunk);
    }

    public static void registerCallback(Callback thunk, Object value) {
        EndOfCallRegistry.addThunk(thunk, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runCallbacks() {
        boolean foundSome = false;
        int count = 0;
        do {
            Object value;
            Object thunk;
            foundSome = false;
            ThunkEnumeration thunksEnum = new ThunkEnumeration();
            Stack<Object> thunks = new Stack<Object>();
            Stack<Object> values = new Stack<Object>();
            Stack<Integer> indexes = new Stack<Integer>();
            while (thunksEnum.hasMoreElements()) {
                thunk = thunksEnum.nextElement();
                int index = thunksEnum.getCurrentIndex();
                value = thunksEnum.nextElement();
                if (thunk == null) continue;
                foundSome = true;
                thunks.push(thunk);
                values.push(value);
                indexes.push(new Integer(index));
            }
            try {
                while (!thunks.empty()) {
                    thunk = null;
                    Object obj = thunks.pop();
                    value = values.pop();
                    int index = (Integer)indexes.pop();
                    try {
                        thunk = (Callback)obj;
                    }
                    catch (Throwable e) {
                        System.err.println("lost casting an object into a Callback");
                        e.printStackTrace();
                    }
                    try {
                        if (thunk == null) continue;
                        EndOfCallRegistry.removeThunk((Callback)thunk, index);
                        thunk.act(value);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                ++count;
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        } while (foundSome && count < 5);
    }
}

