/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;

public class ExternalEntityStream
extends ExternalEntity {
    int kind;
    char[] chars;
    InputStream in;
    String encoding;
    QName name;
    boolean marked;

    public ExternalEntityStream(QName name, int kind, InputStream in, String encoding) {
        super(kind);
        this.name = name;
        this.kind = kind;
        this.encoding = encoding;
        this.marked = false;
        this.in = in;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(Integer.MAX_VALUE);
    }

    public ExternalEntityStream(QName name, int kind, InputStream in) {
        this(name, kind, in, null);
    }

    public boolean isKind(int rhs) {
        return this.kind == rhs;
    }

    public Reader getReader() throws IOException {
        InputStream in;
        Reader reader = null;
        reader = this.chars != null ? new CharArrayReader(this.chars) : ((in = this.getStream()) != null && this.encoding != null ? new InputStreamReader(in, this.encoding) : new InputStreamReader(in));
        return reader;
    }

    public InputStream getStream() {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in.mark(Integer.MAX_VALUE);
        return this.in;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public QName getQualifiedName() {
        return this.name;
    }

    public String getPath() {
        return "internal array for " + this.name;
    }

    public String getNameForClassFile() {
        return this.name.getName();
    }

    public void setPackage(String pkg) {
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExternalEntityStream)) {
            return false;
        }
        ExternalEntityStream otherEntity = (ExternalEntityStream)other;
        return this.kind == otherEntity.kind && this.in.equals(otherEntity.in) && this.name.equals(otherEntity.name) && (this.encoding == null && otherEntity.encoding == null || this.encoding.equals(otherEntity.encoding));
    }

    public int hashCode() {
        return this.in.hashCode() + this.name.hashCode();
    }
}

