/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ScrollableTabBar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogContext;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;
import oracle.javatools.util.ModelUtil;

public class TabbedPage
extends AbstractLogPage
implements LogOwner {
    protected static final String TABBED_PAGE_ID = "LogWindow";
    private TabbedPageImpl _tabbedPageImpl = new TabbedPageImpl();
    private static final int CLOSE_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"TP_CLOSE_CMD_ID");
    private static final int CLOSE_OTHER_LOGS_CMD_ID = Ide.findOrCreateCmdID((String)"TP_CLOSE_OTHER_CMD_ID");
    private static final int CLOSE_ALL_LOGS_CMD_ID = Ide.findOrCreateCmdID((String)"TP_CLOSE_ALL_CMD_ID");

    protected TabbedPage() {
        super(new ViewId(TABBED_PAGE_ID, LogArb.getString((int)3)), null, false);
        this._tabbedPageImpl.setToolTipText(IdeArb.getString((int)172));
        CustomTab tabs = this._tabbedPageImpl.getCustomTab();
        tabs.setGapBeforeTabs(-1);
        tabs.setCloseAction((Action)new TabCloseAction());
        tabs.setCtrlClickCloseEnabled(true);
        tabs.addMouseListener((MouseListener)new CustomTabMouseListener());
    }

    public void addPage(LogPage page) {
        boolean takeFocus = false;
        View view = Ide.getMainWindow().getLastActiveView();
        if (view == page.getLogPageView().owner()) {
            takeFocus = true;
        }
        this._tabbedPageImpl.addPage(page, takeFocus);
        page.setOwner((LogOwner)this);
    }

    public void removePage(LogPage page) {
        View view;
        if (page != null && (view = page.getLogPageView()) != null && view.owner() != null) {
            this._tabbedPageImpl.removePage(page);
            page.setOwner(null);
        }
    }

    public void setSelectedPage(LogPage page) {
        View view = Ide.getMainWindow().getLastActiveView();
        boolean takeFocus = false;
        if (page.getLogPageView().owner() == view) {
            takeFocus = true;
        }
        this._tabbedPageImpl.setActive(page, takeFocus);
    }

    public CustomTabPage getTabPageForLogPage(LogPage page) {
        return this._tabbedPageImpl.getTabPageForLogPage(page);
    }

    public LogPage getSelectedPage() {
        if (this.getPageCount() == 0) {
            return LogManager.getLogManager().getMsgPage();
        }
        return this._tabbedPageImpl.getActivePage();
    }

    public int getPageCount() {
        return this._tabbedPageImpl.getCustomTab().getPageCount();
    }

    public void navigateLeft() {
        int index;
        CustomTab customTab = this._tabbedPageImpl.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) - 1 >= 0) {
            customTab.setSelectedPage(index - 1);
        }
    }

    public void navigateRight() {
        int index;
        CustomTab customTab = this._tabbedPageImpl.getCustomTab();
        if (customTab != null && (index = customTab.getSelectedPage()) + 1 <= this.getPageCount() - 1) {
            customTab.setSelectedPage(index + 1);
        }
    }

    public void displayDropDownMenu() {
        this._tabbedPageImpl.displayDropdownMenu();
    }

    public LogPage[] getPages() {
        LogPage[] pages = this._tabbedPageImpl.getPages();
        return pages;
    }

    public void updateTabTitle(LogPage logPage, String title) {
        CustomTab customTab = this._tabbedPageImpl.getCustomTab();
        DefaultCustomTabPage ctPage = (DefaultCustomTabPage)this._tabbedPageImpl.getTabPageForLogPage(logPage);
        if (ctPage != null) {
            ctPage.setLabel(title);
            ctPage.setLongLabel(title);
            ctPage.setTooltip(title);
            customTab.repaint();
        }
    }

    public void clearAll() {
        LogPage page = this.getSelectedPage();
        if (page != null) {
            page.clearAll();
        }
    }

    public void log(Object msg) {
        LogPage page = this.getSelectedPage();
        if (page != null) {
            page.log(msg);
        }
    }

    public String getTitleName() {
        LogPage page = this.getSelectedPage();
        if (page != null) {
            String title = page.getTitleName();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this.getTabPageForLogPage(page);
            if (!ModelUtil.areEqual((Object)tabPage.getLabel(), (Object)title)) {
                tabPage.setLabel(title);
                this._tabbedPageImpl.getCustomTab().revalidate();
            }
            return title;
        }
        return super.getTitleName();
    }

    public void addMouseListener(MouseListener listener) {
        this._tabbedPageImpl.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this._tabbedPageImpl.removeMouseListener(listener);
    }

    public void selectPage(LogPage page) {
        LogWindow owner = (LogWindow)this.owner();
        if (owner == null) {
            owner = LogManager.getIdeLogWindow();
        }
        if (!owner.isClosed()) {
            owner.show();
        }
        this.setSelectedPage(page);
    }

    public boolean isClosed() {
        if (this.owner() == null) {
            return false;
        }
        return ((LogOwner)this.owner()).isClosed();
    }

    public void highlightPage(LogPage page) {
        CustomTab customTab = this._tabbedPageImpl.getCustomTab();
        int pageCount = customTab.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            Object userObject;
            CustomTabPage tabPage = customTab.getPage(i);
            if (!(tabPage instanceof DefaultCustomTabPage) || !((userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof LogPage) || userObject != page) continue;
            customTab.setHighlighted(i, true);
            break;
        }
    }

    public View getLogOwnerView() {
        return this;
    }

    public Component getGUI() {
        return this._tabbedPageImpl;
    }

    public Context getContext(EventObject event) {
        LogPage page = this.getSelectedPage();
        if (page != null) {
            return page.getLogPageView().getContext(event);
        }
        return super.getContext(event);
    }

    private final class TabbedPageImpl
    extends JPanel
    implements ListSelectionListener {
        private final ScrollableTabBar _tabBar;
        private boolean _removingAllPages;
        private boolean _ensureTabVisibleAfterValidate = true;
        private JScrollPane _scrollPane;
        private JScrollBar _nativeVertScrollBar;
        private Component _installedVertScrollBar;
        private JScrollBar _nativeHorzScrollBar;
        private Component _installedHorzScrollBar;
        private Component _pageComponent;
        private Component _topComponent;
        private Component _bottomComponent;
        private Map<LogPage, DefaultCustomTabPage> _pageMap = Collections.synchronizedMap(new HashMap());
        private CurrentPageComponentListener _compListener = new CurrentPageComponentListener();

        private TabbedPageImpl() {
            this.setOpaque(false);
            this._tabBar = new ScrollableTabBar();
            this._tabBar.setHideSingleTab(true);
            this._tabBar.getTabs().setPosition(3);
            this._tabBar.getTabs().addSelectionListener((ListSelectionListener)this);
            this._tabBar.getTabs().setModel(new DefaultListModel());
            this._scrollPane = new JScrollPane();
            this._pageComponent = this._scrollPane;
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._nativeVertScrollBar = this._scrollPane.getVerticalScrollBar();
            this.add(this._nativeVertScrollBar);
            this._nativeHorzScrollBar = this._scrollPane.getHorizontalScrollBar();
            this._tabBar.setCustomComponent((Component)this._nativeHorzScrollBar);
            this.add((Component)this._tabBar);
            this.add(this._pageComponent);
            if (JDK.HAS_BUG_4699831) {
                final Dimension primaryScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                final JViewport viewport = this._scrollPane.getViewport();
                viewport.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        Dimension viewportSize = viewport.getSize();
                        if (viewportSize.getWidth() > primaryScreenSize.getWidth() || viewportSize.getHeight() > primaryScreenSize.getHeight()) {
                            viewport.removeComponentListener(this);
                            viewport.setScrollMode(0);
                        }
                    }
                });
            }
        }

        public void displayDropdownMenu() {
            this._tabBar.showDropDownMenu();
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            int height = size.height;
            int width = size.width;
            Insets insets = this.getInsets();
            int topComponentHeight = this._topComponent != null && this._topComponent.isVisible() ? this._topComponent.getPreferredSize().height : 0;
            int vertScrollWidth = this._installedVertScrollBar != null && this._installedVertScrollBar.isVisible() ? this._installedVertScrollBar.getPreferredSize().width : 0;
            int bottomComponentHeight = this._bottomComponent != null && this._bottomComponent.isVisible() ? this._bottomComponent.getPreferredSize().height : 0;
            int bottomHeight = this._tabBar.getPreferredSize().height;
            int xLeft = insets.left;
            int xRight = width - insets.right;
            int yTop = insets.top;
            int yBottom = height - insets.bottom;
            int pageTop = yTop + topComponentHeight;
            int pageLeft = xLeft;
            int pageWidth = xRight - vertScrollWidth - pageLeft;
            int pageHeight = yBottom - (pageTop + bottomHeight + bottomComponentHeight);
            int pageBottom = pageTop + pageHeight;
            int tabLeft = insets.left;
            int vertScrollLeft = pageLeft + pageWidth;
            int vertScrollHeight = yBottom - yTop - (bottomHeight - 1) - topComponentHeight - bottomComponentHeight;
            if (this._topComponent != null && this._topComponent.isVisible()) {
                this._topComponent.setBounds(pageLeft, yTop, xRight - pageLeft, topComponentHeight);
            }
            if (this._bottomComponent != null && this._bottomComponent.isVisible()) {
                this._bottomComponent.setBounds(pageLeft, pageBottom, pageWidth, bottomComponentHeight);
            }
            if (this._pageComponent != null) {
                this._pageComponent.setBounds(pageLeft, pageTop, pageWidth, pageHeight);
            }
            if (this._installedVertScrollBar != null) {
                int offset = this._pageComponent instanceof JScrollPane ? 1 : 0;
                this._installedVertScrollBar.setBounds(vertScrollLeft, yTop + topComponentHeight - offset, vertScrollWidth, vertScrollHeight + offset);
            }
            this._tabBar.setBounds(tabLeft, pageBottom + bottomComponentHeight, width - (insets.left + insets.right), bottomHeight);
        }

        @Override
        public void validate() {
            super.validate();
            if (this._ensureTabVisibleAfterValidate) {
                this._ensureTabVisibleAfterValidate = false;
                this._tabBar.ensureSelectedTabVisible();
            }
        }

        public void addPage(LogPage page, boolean takeFocus) {
            DefaultCustomTabPage tabPage = new DefaultCustomTabPage(page.getTabIcon(), page.getTabName(), (Object)page);
            this._pageMap.put(page, tabPage);
            this.getModel().addElement(tabPage);
            Component gui = page.getLogPageView().getGUI();
            if (gui instanceof Container) {
                ((Container)gui).setFocusCycleRoot(true);
            }
            if (gui.getAccessibleContext() != null) {
                gui.getAccessibleContext().setAccessibleName(page.getTabName());
            }
            if (takeFocus) {
                this.getCustomTab().setSelectedPage(this.getCustomTab().searchPage((CustomTabPage)tabPage));
                this.moveToFront(page, true);
            }
        }

        public DefaultListModel getModel() {
            return (DefaultListModel)this._tabBar.getTabs().getModel();
        }

        public void removePage(LogPage page) {
            Component focusedComp;
            Component comp = page.getLogPageView().getGUI();
            boolean hadFocus = false;
            if (comp != null && (focusedComp = GraphicsUtils.getFocusedChildComponent((Component)comp)) != null) {
                hadFocus = true;
            }
            if (hadFocus) {
                GraphicsUtils.focusComponentOrChild((Component)this._scrollPane, (boolean)false);
            }
            CustomTabPage removePage = this.getTabPageForLogPage(page);
            this.getModel().removeElement(removePage);
            this._pageMap.remove(page);
            if (this.getModel().getSize() > 0 && !this._removingAllPages) {
                View view;
                CustomTabPage tabPage;
                LogPage newPage;
                int selPage = this.getCustomTab().getSelectedPage();
                Component newComp = null;
                if (selPage != -1 && (newPage = this.getLogPageForTabPage(tabPage = this.getCustomTab().getPage(selPage))) != null && (view = newPage.getLogPageView()) != null) {
                    newComp = view.getGUI();
                    newComp.setVisible(true);
                }
                if (hadFocus && newComp != null) {
                    GraphicsUtils.focusComponentOrChild(newComp, (boolean)true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllPages() {
            this._removingAllPages = true;
            Set<LogPage> keySet = this._pageMap.keySet();
            Map<LogPage, DefaultCustomTabPage> map = this._pageMap;
            synchronized (map) {
                for (LogPage page : keySet) {
                    this.removePage(page);
                }
            }
            this._removingAllPages = false;
        }

        public int getPageCount() {
            return this._pageMap.size();
        }

        public LogPage[] getPages() {
            LogPage[] pages = new LogPage[this._pageMap.size()];
            Set<LogPage> pageSet = this._pageMap.keySet();
            pages = pageSet.toArray(pages);
            return pages;
        }

        public CustomTab getCustomTab() {
            return this._tabBar.getTabs();
        }

        public void setActive(LogPage page, boolean takeFocus) {
            CustomTabPage curTabPage;
            DefaultCustomTabPage tabPage = this._pageMap.get(page);
            boolean changePage = true;
            int curPage = this.getCustomTab().getSelectedPage();
            if (curPage != -1 && (curTabPage = this.getCustomTab().getPage(curPage)) == tabPage) {
                changePage = false;
            }
            if (changePage) {
                this.getCustomTab().setSelectedPage(this.getCustomTab().searchPage((CustomTabPage)tabPage));
                this.moveToFront(page, takeFocus);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LogPage getActivePage() {
            LogPage retval = null;
            int pageNum = this.getCustomTab().getSelectedPage();
            if (pageNum == -1 && this.getCustomTab().getPageCount() != 0) {
                this.getCustomTab().setSelectedPage(0);
                pageNum = 0;
            }
            CustomTabPage tabPage = this.getCustomTab().getPage(pageNum);
            Set<LogPage> set = this._pageMap.keySet();
            Map<LogPage, DefaultCustomTabPage> map = this._pageMap;
            synchronized (map) {
                for (LogPage lPage : set) {
                    if (this._pageMap.get(lPage) != tabPage) continue;
                    retval = lPage;
                    break;
                }
            }
            return retval;
        }

        private void moveToFront(LogPage page, boolean takeFocus) {
            JComponent focusComp;
            JViewport viewport;
            LogWindow lw = (LogWindow)TabbedPage.this.owner();
            if (lw != null) {
                lw.updateTitle(null);
            }
            boolean isScrollable = false;
            Component customHorzScrollbar = null;
            Object customVertScrollbar = null;
            Component comp = null;
            if (this._topComponent != null) {
                this.remove(this._topComponent);
                this._topComponent = null;
            }
            if (this._bottomComponent != null) {
                this.remove(this._bottomComponent);
                this._bottomComponent = null;
            }
            if (this._pageComponent == this._scrollPane) {
                viewport = this._scrollPane.getViewport();
                viewport.setView(null);
            }
            if (this._pageComponent != null) {
                Component displayComp;
                this.remove(this._pageComponent);
                if (this._pageComponent instanceof JScrollPane && (displayComp = ((JScrollPane)this._pageComponent).getViewport().getView()) != null) {
                    displayComp.removeComponentListener(this._compListener);
                }
            }
            if (this._nativeHorzScrollBar != null) {
                this._tabBar.setCustomComponent(null);
            }
            if (this._nativeVertScrollBar != null) {
                this.remove(this._nativeVertScrollBar);
            }
            if (page instanceof AbstractLogPage) {
                AbstractLogPage abLogPage = (AbstractLogPage)page;
                isScrollable = abLogPage.isDisplayComponentScrollable();
                if (abLogPage.getTopComponent() != null) {
                    this._topComponent = abLogPage.getTopComponent();
                    this.add(this._topComponent);
                }
                if (abLogPage.getBottomComponent() != null) {
                    this._bottomComponent = abLogPage.getBottomComponent();
                    this.add(this._bottomComponent);
                }
            }
            if (this._topComponent == null && page.getLogPageView().getToolbar() != null) {
                this._topComponent = page.getLogPageView().getToolbar();
                this.add(this._topComponent);
                MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
                mainWindow.registerView(page.getLogPageView(), this._topComponent);
            }
            if (comp == null) {
                comp = page.getLogPageView().getGUI();
            }
            if (isScrollable || comp instanceof JScrollPane) {
                this._pageComponent = comp instanceof JScrollPane ? comp : this._scrollPane;
                this._compListener.setScrollPane((JScrollPane)this._pageComponent);
                this.add(this._pageComponent);
                this._pageComponent.setVisible(true);
                comp.setVisible(true);
                if (this._pageComponent == this._scrollPane) {
                    this._nativeHorzScrollBar = this._scrollPane.getHorizontalScrollBar();
                    this._nativeVertScrollBar = this._scrollPane.getVerticalScrollBar();
                    viewport = this._scrollPane.getViewport();
                    Dimension componentSize = comp.getSize();
                    comp.setSize(componentSize.width - 1, componentSize.height);
                    viewport.setView(comp);
                    Component displayComponent = this._scrollPane.getViewport().getView();
                    if (displayComponent != null) {
                        displayComponent.addComponentListener(this._compListener);
                        this.handleScrollbarDisplay(this._scrollPane, displayComponent);
                    }
                } else {
                    ((JScrollPane)comp).setBorder(BorderFactory.createEmptyBorder());
                    Dimension componentSize = comp.getSize();
                    comp.setSize(componentSize.width - 1, componentSize.height);
                    Component displayComponent = ((JScrollPane)comp).getViewport().getView();
                    if (displayComponent != null) {
                        displayComponent.addComponentListener(this._compListener);
                    }
                    this._nativeVertScrollBar = ((JScrollPane)comp).getVerticalScrollBar();
                    this._nativeHorzScrollBar = ((JScrollPane)comp).getHorizontalScrollBar();
                    this.handleScrollbarDisplay((JScrollPane)this._pageComponent, ((JScrollPane)this._pageComponent).getViewport().getView());
                }
            } else {
                this._scrollPane.setVisible(false);
                this.remove(this._pageComponent);
                this.getNativeHorzScrollBar().setVisible(false);
                if (customHorzScrollbar != null) {
                    this._installedHorzScrollBar = customHorzScrollbar;
                    this._tabBar.setCustomComponent(customHorzScrollbar);
                }
                this.getNativeVertScrollBar().setVisible(false);
                if (customVertScrollbar != null) {
                    this._installedVertScrollBar = customVertScrollbar;
                    this.add(this._installedVertScrollBar);
                }
                this._pageComponent = comp;
                this.add(this._pageComponent);
            }
            this._ensureTabVisibleAfterValidate = true;
            this.validate();
            this.repaint();
            if (takeFocus && (focusComp = GraphicsUtils.focusComponentOrChild((Component)comp, (boolean)true)) != null && focusComp.getAccessibleContext() != null) {
                focusComp.getAccessibleContext().setAccessibleName(comp.getAccessibleContext().getAccessibleName());
            }
        }

        private void handleScrollbarDisplay(JScrollPane scrollpane, Component displayComp) {
            int compHeight = displayComp.getBounds().height;
            int scrollPaneHeight = scrollpane.getBounds().height;
            if (compHeight > scrollPaneHeight) {
                this.add(this._nativeVertScrollBar);
                this._installedVertScrollBar = this._nativeVertScrollBar;
                this._installedVertScrollBar.setVisible(true);
            } else if (compHeight <= scrollPaneHeight) {
                this.remove(this._nativeVertScrollBar);
                if (this._installedVertScrollBar != null) {
                    this._installedVertScrollBar.setVisible(false);
                }
                this._installedVertScrollBar = null;
            }
            int compWidth = displayComp.getBounds().width - 1;
            int scrollPaneWidth = scrollpane.getBounds().width;
            if (compWidth > scrollPaneWidth) {
                this._tabBar.setCustomComponent((Component)this._nativeHorzScrollBar);
                this._installedHorzScrollBar = this._nativeHorzScrollBar;
                this._installedHorzScrollBar.setVisible(true);
            } else if (compWidth <= scrollPaneWidth) {
                this._tabBar.setCustomComponent(null);
                if (this._installedHorzScrollBar != null) {
                    this._installedHorzScrollBar.setVisible(false);
                }
                this._installedHorzScrollBar = null;
            }
            scrollpane.validate();
        }

        private JScrollBar getNativeHorzScrollBar() {
            return this._nativeHorzScrollBar;
        }

        private JScrollBar getNativeVertScrollBar() {
            return this._nativeVertScrollBar;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Component comp;
            if (e.getFirstIndex() == -1) {
                return;
            }
            CustomTabPage selectedPage = this.getCustomTab().getPage(e.getFirstIndex());
            LogPage logPage = this.getLogPageForTabPage(selectedPage);
            if (logPage != null && (comp = logPage.getLogPageView().getGUI()) != null) {
                this.moveToFront(logPage, true);
            }
        }

        public CustomTabPage getTabPageForLogPage(LogPage page) {
            return (CustomTabPage)this._pageMap.get(page);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LogPage getLogPageForTabPage(CustomTabPage tabPage) {
            LogPage retval = null;
            Set<LogPage> keySet = this._pageMap.keySet();
            Iterator<LogPage> iterator = keySet.iterator();
            Map<LogPage, DefaultCustomTabPage> map = this._pageMap;
            synchronized (map) {
                while (iterator.hasNext()) {
                    LogPage logPage = iterator.next();
                    if (this._pageMap.get(logPage) != tabPage) continue;
                    retval = logPage;
                    break;
                }
            }
            return retval;
        }

        private final class CurrentPageComponentListener
        extends ComponentAdapter {
            private JScrollPane _scrollPane;

            private CurrentPageComponentListener() {
            }

            public void setScrollPane(JScrollPane scrollPane) {
                this._scrollPane = scrollPane;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                TabbedPageImpl.this.handleScrollbarDisplay(this._scrollPane, c);
                Container comp = this._scrollPane.getParent();
                if (comp != null) {
                    ((Component)comp).validate();
                    c = comp.getParent();
                    if (c != null) {
                        c.repaint();
                    }
                }
            }
        }
    }

    private final class TabCloseAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
            LogManager.getLogManager().removePage((LogPage)tabPage.getUserObject());
        }
    }

    private final class FlatTabbedWindowController
    implements Controller {
        private FlatTabbedWindowController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == CLOSE_LOG_CMD_ID) {
                LogManager.getLogManager().removePage(LogContext.getLogPage((Context)context));
                return true;
            }
            if (cmdId == CLOSE_ALL_LOGS_CMD_ID) {
                this.closeLogPages(CLOSE_ALL_LOGS_CMD_ID, null);
                return true;
            }
            if (cmdId == CLOSE_OTHER_LOGS_CMD_ID) {
                this.closeLogPages(CLOSE_OTHER_LOGS_CMD_ID, LogContext.getLogPage((Context)context));
                return true;
            }
            return false;
        }

        private void closeLogPages(int closeType, LogPage logPage) {
            LogManager logMgr = LogManager.getLogManager();
            LogPage[] pages = logMgr.getPages();
            for (int i = 0; i < pages.length; ++i) {
                if (closeType == CLOSE_OTHER_LOGS_CMD_ID && logPage == pages[i]) continue;
                logMgr.removePage(pages[i]);
            }
        }

        public boolean update(IdeAction action, Context context) {
            return false;
        }
    }

    private final class CustomTabMouseListener
    extends MouseAdapter
    implements ContextMenuListener {
        private ContextMenu _contextMenu;
        private Controller _controller;
        private IdeAction _closeAction;
        private JMenuItem _closeMenuItem;
        private IdeAction _closeAllAction;
        private JMenuItem _closeAllMenuItem;
        private IdeAction _closeOthersAction;
        private JMenuItem _closeOthersMenuItem;

        private CustomTabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                DefaultCustomTabPage customTabPage;
                LogPage logPage;
                int pageNum = TabbedPage.this._tabbedPageImpl.getCustomTab().getPageAt(e.getPoint());
                if (pageNum == -1) {
                    return;
                }
                if (this._contextMenu == null) {
                    this._contextMenu = new ContextMenu();
                    this._contextMenu.addContextMenuListener((ContextMenuListener)this);
                    this._controller = new FlatTabbedWindowController();
                    this._closeAction = IdeAction.get((int)CLOSE_LOG_CMD_ID, null, (String)LogArb.getString((int)4), null, (Integer)LogArb.getInteger((int)5), (Icon)LogArb.getIcon((int)6), null, (boolean)true);
                    this._closeMenuItem = this._contextMenu.createMenuItem((ToggleAction)this._closeAction);
                    this._closeAction.addController(this._controller);
                    this._closeOthersAction = IdeAction.get((int)CLOSE_OTHER_LOGS_CMD_ID, null, (String)LogArb.getString((int)14), null, (Integer)LogArb.getInteger((int)15), (Icon)LogArb.getIcon((int)16), null, (boolean)true);
                    this._closeOthersMenuItem = this._contextMenu.createMenuItem((ToggleAction)this._closeOthersAction);
                    this._closeOthersAction.addController(this._controller);
                    this._closeAllAction = IdeAction.get((int)CLOSE_ALL_LOGS_CMD_ID, null, (String)LogArb.getString((int)17), null, (Integer)LogArb.getInteger((int)18), (Icon)LogArb.getIcon((int)19), null, (boolean)true);
                    this._closeAllMenuItem = this._contextMenu.createMenuItem((ToggleAction)this._closeAllAction);
                    this._closeAllAction.addController(this._controller);
                }
                boolean isMsgPage = (logPage = (LogPage)(customTabPage = (DefaultCustomTabPage)TabbedPage.this._tabbedPageImpl.getCustomTab().getPage(pageNum)).getUserObject()) == LogManager.getLogManager().getMsgPage();
                this._closeAction.setEnabled(!isMsgPage);
                int numPages = TabbedPage.this._tabbedPageImpl.getCustomTab().getPageCount();
                this._closeAllAction.setEnabled(numPages > 1);
                if (numPages == 1 || numPages == 2 && !isMsgPage) {
                    this._closeOthersAction.setEnabled(false);
                } else {
                    this._closeOthersAction.setEnabled(true);
                }
                Context selContext = Context.newIdeContext();
                LogContext.setLogPage((Context)selContext, (LogPage)logPage);
                selContext.setEvent((EventObject)e);
                this._contextMenu.show(selContext);
            }
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu popup) {
            popup.add((Component)this._closeMenuItem);
            popup.add((Component)this._closeAllMenuItem);
            popup.add((Component)this._closeOthersMenuItem);
        }

        public void menuWillHide(ContextMenu popup) {
        }
    }
}

