/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import oracle.ldap.jremtool.OidFanoutReplAgreement;
import oracle.ldap.jremtool.OidMultimasterReplAgreement;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplUtil;
import oracle.ldap.jremtool.OidReplica;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidReplNamingContext {
    private static final OidReplLogger logger = OidReplLogger.getLogger(OidReplNamingContext.class.getName());
    private long m_namingCtxId;
    private String m_namingCtxDN;
    private String m_namingCtxName;
    private String m_inclDN;
    private Set<String> m_exclDN;
    private Set<String> m_exclAttrs;
    private OidReplDirection m_direction;
    private OidReplAgreement m_agreement;
    private boolean m_isRecordChange;
    private Map<String, Object> m_modifiedItems;
    private Set<String> m_newExclAttrs;
    private Set<String> m_removedExclAttrs;
    private Set<String> m_newExclDN;
    private Set<String> m_removedExclDN;
    private OidReplContext m_replContext;

    public OidReplNamingContext(OidReplAgreement agreement, OidReplContext replContext) {
        this.m_agreement = agreement;
        this.m_exclDN = new HashSet<String>();
        this.m_exclAttrs = new HashSet<String>();
        this.m_modifiedItems = new HashMap<String, Object>();
        this.m_direction = OidReplDirection.OID_REPL_BIDIRECTION;
        this.m_isRecordChange = false;
        this.m_newExclAttrs = new HashSet<String>();
        this.m_removedExclAttrs = new HashSet<String>();
        this.m_newExclDN = new HashSet<String>();
        this.m_removedExclDN = new HashSet<String>();
        this.m_replContext = replContext;
    }

    public OidReplAgreement getAgreement() {
        return this.m_agreement;
    }

    public List<String> getAllDirections() {
        ArrayList<String> directions = new ArrayList<String>();
        directions.add("bidirectional");
        directions.add("supplier to consumer");
        directions.add("consumer to supplier");
        return directions;
    }

    public void setAgreement(OidReplAgreement agreement) {
        this.m_agreement = agreement;
    }

    public void setDirection(OidReplDirection dir) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("REPL_DIRECTION")) {
            this.m_modifiedItems.put("REPL_DIRECTION", (Object)this.m_direction);
        }
        this.m_direction = dir;
    }

    public OidReplDirection getDirection() {
        return this.m_direction;
    }

    public String getIncludedNamingCtxDN() {
        return this.m_namingCtxDN;
    }

    public void setIncludedNamingCtxDN(String dn) {
        this.m_namingCtxDN = dn;
    }

    public long getIncludedNamingCtxId() {
        return this.m_namingCtxId;
    }

    public void setIncludedNamingCtxId(long id) {
        this.m_namingCtxId = id;
    }

    public String getIncludedNamingCtxName() {
        return this.m_namingCtxName;
    }

    public void setIncludedNamingCtxName(String name) {
        this.m_namingCtxName = name;
    }

    public String getIncludedDN() {
        return this.m_inclDN;
    }

    public void setIncludedDN(String dn) {
        if (this.m_isRecordChange && !this.m_modifiedItems.containsKey("orclIncludedNamingcontexts")) {
            this.m_modifiedItems.put("orclIncludedNamingcontexts", this.m_inclDN);
        }
        this.m_inclDN = dn;
    }

    public Set<String> getExcludedDNs() {
        return this.m_exclDN;
    }

    public void setExcludedDNs(List<String> dns) throws OidReplException {
        if (this.m_isRecordChange) {
            String msg = this.m_replContext.getString(37L, new Object[0]);
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        this.m_exclDN.clear();
        for (int count = 0; dns != null && count < dns.size(); ++count) {
            this.m_exclDN.add(dns.get(count));
        }
    }

    public void addExcludedDNToList(String dn) {
        if (this.m_isRecordChange) {
            this.m_newExclDN.add(dn);
        }
        this.m_exclDN.add(dn);
    }

    public void removeExcludedDNFromList(String dn) {
        if (this.m_isRecordChange) {
            this.m_removedExclDN.add(dn);
        }
        this.m_exclDN.remove(dn);
    }

    public Set<String> getExcludedAttrs() {
        return this.m_exclAttrs;
    }

    public void setExcludedAttrs(List<String> attrs) throws OidReplException {
        if (this.m_isRecordChange) {
            String msg = this.m_replContext.getString(37L, new Object[0]);
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        this.m_exclAttrs.clear();
        for (int count = 0; attrs != null && count < attrs.size(); ++count) {
            this.m_exclAttrs.add(attrs.get(count));
        }
    }

    public void addExcludedAttrToList(String attrname) {
        if (this.m_isRecordChange) {
            this.m_newExclAttrs.add(attrname);
        }
        this.m_exclAttrs.add(attrname);
    }

    public void removeIncludedAttrFromList(String attrname) {
        if (this.m_isRecordChange) {
            this.m_removedExclAttrs.add(attrname);
        }
        this.m_exclAttrs.remove(attrname);
    }

    public Set<String> getAllAttributesFromDir() throws OidReplException {
        OidReplica replica = null;
        if (this.m_agreement.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_ONEWAY) {
            replica = ((OidFanoutReplAgreement)this.m_agreement).getSupplier();
        } else if (this.m_agreement.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_TWOWAY) {
            replica = this.m_direction == OidReplDirection.OID_REPL_CONS_TO_SUPP ? ((OidFanoutReplAgreement)this.m_agreement).getConsumer() : ((OidFanoutReplAgreement)this.m_agreement).getSupplier();
        } else if (this.m_agreement.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER) {
            replica = ((OidMultimasterReplAgreement)this.m_agreement).getPrimaryReplica();
        }
        logger.dump("Getting attributes list for Agreement Type : {0} from supplier = ldap://{1}:{2}", this.m_agreement.getAgreementType().toString(), replica == null ? "NULL" : replica.getHost(), replica == null ? "NULL" : String.valueOf(replica.getPort()));
        if (replica == null) {
            String msg = this.m_replContext.getString(5L, new Object[0]);
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        String replicaid = replica.getReplicaID();
        logger.dump("Getting list of attributes available in replica {0}", replicaid == null ? "NULL" : replicaid);
        return replica.getAllAttributes();
    }

    public Set<LdapName> getImmediateChildrenFromDir(String baseDN) throws OidReplException {
        HashSet<LdapName> dnset = new HashSet<LdapName>();
        LdapContext dirCtx = null;
        SearchControls constraints = new SearchControls();
        String[] reqAttrs = new String[]{"dn"};
        int count = 0;
        logger.dump("Getting immediate children of \"{0}\"", baseDN);
        if (this.m_agreement instanceof OidMultimasterReplAgreement) {
            OidMultimasterReplAgreement mm = (OidMultimasterReplAgreement)this.m_agreement;
            dirCtx = mm.getPrimaryReplica().getDirContext();
        } else {
            OidFanoutReplAgreement fanout = (OidFanoutReplAgreement)this.m_agreement;
            dirCtx = this.m_direction == OidReplDirection.OID_REPL_CONS_TO_SUPP ? fanout.getConsumer().getDirContext() : fanout.getSupplier().getDirContext();
        }
        try {
            constraints.setSearchScope(1);
            constraints.setReturningAttributes(reqAttrs);
            NamingEnumeration<SearchResult> res = dirCtx.search(baseDN, "(objectclass=*)", constraints);
            while (res.hasMore()) {
                SearchResult sr = res.next();
                dnset.add(new LdapName(sr.getNameInNamespace()));
                ++count;
            }
        }
        catch (NamingException ne) {
            dnset.clear();
            dnset = null;
            String msg = this.m_replContext.getString(7L, baseDN);
            logger.error(ne, msg, new Object[0]);
            throw new OidReplException(msg, ne);
        }
        logger.dump("Retrieved {0} child entry(ies) of \"{1}\"", count, baseDN);
        return dnset;
    }

    public boolean updateChanges() throws OidReplException {
        int count = 0;
        LdapContext[] ctxList = null;
        OidReplAgreement.OidReplAgreementType agrmtType = this.m_agreement.getAgreementType();
        String direction = "";
        OidReplDirection dir = null;
        String url = "";
        if (!this.m_isRecordChange) {
            logger.error("Not in Record mode. updateChanges() cannot be called.", new Object[0]);
            return false;
        }
        if (agrmtType == OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER) {
            OidMultimasterReplAgreement mm = (OidMultimasterReplAgreement)this.m_agreement;
            List<OidReplica> replicas = mm.getMultimasterReplicas();
            count = replicas.size();
            ctxList = new LdapContext[count];
            count = 0;
            for (OidReplica replica : replicas) {
                ctxList[count] = replica.getDirContext();
                ++count;
            }
        } else {
            OidFanoutReplAgreement fo = (OidFanoutReplAgreement)this.m_agreement;
            ctxList = new LdapContext[]{fo.getSupplier().getDirContext(), fo.getConsumer().getDirContext()};
            if (agrmtType == OidReplAgreement.OidReplAgreementType.OID_TWOWAY) {
                dir = (OidReplDirection)((Object)this.m_modifiedItems.get("REPL_DIRECTION"));
                if (dir == null) {
                    dir = this.m_direction;
                }
                if (dir == OidReplDirection.OID_REPL_CONS_TO_SUPP) {
                    direction = ";" + fo.getConsumer().getReplicaID() + fo.getSupplier().getReplicaID();
                } else if (dir == OidReplDirection.OID_REPL_SUPP_TO_CONS) {
                    direction = ";" + fo.getSupplier().getReplicaID() + fo.getConsumer().getReplicaID();
                }
            }
        }
        HashSet<ModificationItem> mItems = new HashSet<ModificationItem>();
        String inclDN = (String)this.m_modifiedItems.get("orclIncludedNamingcontexts");
        if (inclDN != null) {
            String attrName = "orclIncludedNamingcontexts" + direction;
            mItems.add(OidReplUtil.CreateModItem(attrName, this.m_inclDN, 2));
        }
        for (String val : this.m_newExclDN) {
            mItems.add(OidReplUtil.CreateModItem("orclExcludedNamingcontexts", val, 1));
        }
        for (String val : this.m_removedExclDN) {
            mItems.add(OidReplUtil.CreateModItem("orclExcludedNamingcontexts", val, 3));
        }
        for (String val : this.m_newExclAttrs) {
            mItems.add(OidReplUtil.CreateModItem("orclExcludedAttributes", val, 1));
        }
        for (String val : this.m_removedExclAttrs) {
            mItems.add(OidReplUtil.CreateModItem("orclExcludedAttributes", val, 3));
        }
        ModificationItem[] modItems = new ModificationItem[mItems.size()];
        modItems = mItems.toArray(modItems);
        try {
            for (count = 0; count < ctxList.length && mItems.size() > 0; ++count) {
                url = (String)ctxList[count].getEnvironment().get("java.naming.provider.url");
                if (modItems.length > 0) {
                    ctxList[count].modifyAttributes(this.m_namingCtxDN, modItems);
                }
                logger.dump("Applying naming context change at {0}", url);
            }
        }
        catch (NamingException ne) {
            String msg = this.m_replContext.getString(8L, this.m_namingCtxDN, url == null ? "NULL" : url);
            logger.error(msg, ne);
            this.clearChanges();
            throw new OidReplException(msg, ne);
        }
        this.m_isRecordChange = false;
        this.clearChanges();
        return true;
    }

    public boolean isRecordChange() {
        return this.m_isRecordChange;
    }

    public void setRecordChange(boolean recordChange, boolean clearChanges) {
        this.m_isRecordChange = recordChange;
        if (clearChanges) {
            this.clearChanges();
        }
    }

    public void clearChanges() {
        this.m_modifiedItems.clear();
        this.m_newExclAttrs.clear();
        this.m_newExclDN.clear();
        this.m_removedExclAttrs.clear();
        this.m_removedExclDN.clear();
    }

    public void cancelChanges() {
        OidReplDirection dir;
        String inclDN = (String)this.m_modifiedItems.get("orclIncludedNamingcontexts");
        if (inclDN != null) {
            this.m_inclDN = inclDN;
        }
        if ((dir = (OidReplDirection)((Object)this.m_modifiedItems.get("REPL_DIRECTION"))) != null) {
            this.m_direction = dir;
        }
        for (String val : this.m_newExclAttrs) {
            this.m_exclAttrs.remove(val);
        }
        for (String val : this.m_removedExclAttrs) {
            this.m_exclAttrs.add(val);
        }
        for (String val : this.m_newExclDN) {
            this.m_exclDN.remove(val);
        }
        for (String val : this.m_removedExclDN) {
            this.m_exclDN.add(val);
        }
        this.m_modifiedItems.clear();
        this.m_newExclAttrs.clear();
        this.m_newExclDN.clear();
        this.m_removedExclAttrs.clear();
        this.m_removedExclDN.clear();
    }

    public void close() {
        this.m_namingCtxDN = null;
        this.m_namingCtxName = null;
        this.m_inclDN = null;
        if (this.m_exclDN != null) {
            this.m_exclDN.clear();
            this.m_exclDN = null;
        }
        if (this.m_exclAttrs != null) {
            this.m_exclAttrs.clear();
            this.m_exclAttrs = null;
        }
        this.m_direction = null;
        this.m_agreement = null;
        this.clearChanges();
        this.m_newExclAttrs = null;
        this.m_newExclDN = null;
        this.m_removedExclAttrs = null;
        this.m_removedExclDN = null;
        this.m_modifiedItems = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OidReplDirection {
        OID_REPL_BIDIRECTION,
        OID_REPL_SUPP_TO_CONS,
        OID_REPL_CONS_TO_SUPP;

    }
}

