/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.logging.Level;
import oracle.core.ojdl.logging.ODLLogger;

public class OidReplLogger {
    private static final String PROP_CONFIG_CLASS = "java.util.logging.config.class";
    private static final String PROP_CONFIG_FILE = "java.util.logging.config.file";
    private static final String PROP_ODL_CONFIG_FILE = "oracle.core.ojdl.logging.config.file";
    private ODLLogger m_logger;

    private OidReplLogger(String name) {
        this.m_logger = ODLLogger.getODLLogger((String)name, (String)"oracle.ldap.jremtool.mesg.OidReplMessages");
    }

    public static void init(String configfile) {
        if (System.getProperty(PROP_CONFIG_CLASS) == null && System.getProperty(PROP_CONFIG_FILE) == null) {
            System.setProperty(PROP_CONFIG_CLASS, "oracle.core.ojdl.logging.LoggingConfiguration");
            System.setProperty(PROP_ODL_CONFIG_FILE, configfile);
        }
    }

    public static OidReplLogger getLogger(String name) {
        return new OidReplLogger(name);
    }

    public void dump(String o, Throwable t) {
        this.m_logger.log(Level.FINEST, o, t);
    }

    public void dump(String o, Object ... params) {
        this.m_logger.log(Level.FINEST, o, params);
    }

    public void dump(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.FINEST, o, params, t);
    }

    public boolean isDumpEnabled() {
        return this.m_logger.isLoggable(Level.FINEST);
    }

    public void trace(String o, Throwable t) {
        this.m_logger.log(Level.FINER, o, t);
    }

    public void trace(String o, Object ... params) {
        this.m_logger.log(Level.FINER, o, params);
    }

    public void trace(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.FINER, o, params, t);
    }

    public boolean isTraceEnabled() {
        return this.m_logger.isLoggable(Level.FINER);
    }

    public void debug(String o, Throwable t) {
        this.m_logger.log(Level.FINE, o, t);
    }

    public void debug(String o, Object ... params) {
        this.m_logger.log(Level.FINE, o, params);
    }

    public void debug(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.FINE, o, params, t);
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isLoggable(Level.FINE);
    }

    public void config(String o, Throwable t) {
        this.m_logger.log(Level.CONFIG, o, t);
    }

    public void config(String o, Object ... params) {
        this.m_logger.log(Level.CONFIG, o, params);
    }

    public void config(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.CONFIG, o, params, t);
    }

    public boolean isConfigEnabled() {
        return this.m_logger.isLoggable(Level.CONFIG);
    }

    public void info(String o, Throwable t) {
        this.m_logger.log(Level.INFO, o, t);
    }

    public void info(String o, Object ... params) {
        this.m_logger.log(Level.INFO, o, params);
    }

    public void info(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.INFO, o, params, t);
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isLoggable(Level.INFO);
    }

    public void warn(String o, Throwable t) {
        this.m_logger.log(Level.WARNING, o, t);
    }

    public void warn(String o, Object ... params) {
        this.m_logger.log(Level.WARNING, o, params);
    }

    public void warn(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.WARNING, o, params, t);
    }

    public void error(String o, Throwable t) {
        this.m_logger.log(Level.SEVERE, o, t);
    }

    public void error(String o, Object ... params) {
        this.m_logger.log(Level.SEVERE, o, params);
    }

    public void error(Throwable t, String o, Object ... params) {
        this.m_logger.log(Level.SEVERE, o, params, t);
    }

    public void error(String o, Object[] params, Throwable t) {
        this.m_logger.log(Level.SEVERE, o, params, t);
    }

    public void log(Level p, String o, Throwable t) {
        this.m_logger.log(p, o, t);
    }

    public void log(Level p, String o, Object ... params) {
        this.m_logger.log(p, o, params);
    }

    public void log(Level p, String o, Object[] params, Throwable t) {
        this.m_logger.log(p, o, params, t);
    }

    public boolean isPriority(Level p) {
        return this.m_logger.isLoggable(p);
    }
}

