/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import oracle.ldap.jremtool.OidChgNum;
import oracle.ldap.jremtool.OidFanoutReplAgreement;
import oracle.ldap.jremtool.OidMultimasterReplAgreement;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplEntry;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplNamingContext;
import oracle.ldap.jremtool.OidReplUtil;
import oracle.ldap.jremtool.OidReplica;
import oracle.ldap.jremtool.mesg.OidReplMessages;
import oracle.ldap.util.ber.BERDecoder;
import oracle.ldap.util.ber.DecodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidReplContext {
    private Map<String, OidReplAgreement> m_agreements;
    private Map<String, OidReplica> m_replicas;
    private OidReplica m_userSuppliedReplica;
    private static final OidReplLogger m_logger = OidReplLogger.getLogger(OidReplContext.class.getName());
    private OidReplMessages m_messages;

    @Deprecated
    public OidReplContext(String host, int port, String dn, String pwd, Locale locale) throws OidReplException {
        this.m_messages = (OidReplMessages)ResourceBundle.getBundle(OidReplMessages.class.getName(), locale);
        this.m_userSuppliedReplica = new OidReplica();
        this.m_userSuppliedReplica.setHost(host);
        this.m_userSuppliedReplica.setPort(port);
        this.m_userSuppliedReplica.setBindDN(dn);
        this.m_userSuppliedReplica.setBindPwd(pwd);
        this.m_userSuppliedReplica.setReplicaID(OidReplUtil.getReplicaId(host, port, dn, pwd, this));
        m_logger.dump("OidReplContext initialized with host {0} port {1}dn {2}.", host, String.valueOf(port), dn);
        this.m_replicas = this.getAllReplicas(this.m_userSuppliedReplica);
        m_logger.dump("Got all replicas", new Object[0]);
        this.m_agreements = this.getAllAgreements(this.m_userSuppliedReplica);
        m_logger.dump("Got all agreements", new Object[0]);
    }

    public OidReplContext(String host, int port, String dn, String pwd, boolean isReplBind, Locale locale) throws OidReplException {
        this.m_messages = (OidReplMessages)ResourceBundle.getBundle(OidReplMessages.class.getName(), locale);
        this.m_userSuppliedReplica = new OidReplica();
        this.m_userSuppliedReplica.setHost(host);
        this.m_userSuppliedReplica.setPort(port);
        this.m_userSuppliedReplica.setReplicaID(OidReplUtil.getReplicaId(host, port, dn, pwd, this));
        if (isReplBind) {
            this.m_userSuppliedReplica.setReplDNAsBindDN(dn);
            this.m_userSuppliedReplica.setReplPwdAsBindPwd(pwd);
            m_logger.dump("OidReplContext initialized with host {0} port {1}dn {2} in replication bind mode.", host, String.valueOf(port), dn);
        } else {
            this.m_userSuppliedReplica.setBindDN(dn);
            this.m_userSuppliedReplica.setBindPwd(pwd);
            this.m_userSuppliedReplica.setIsReplBind(false);
            m_logger.dump("OidReplContext initialized with host {0} port {1}dn {2} in normal bind mode.", host, String.valueOf(port), dn);
        }
        m_logger.dump("Scanning replication configuration entries...", new Object[0]);
        this.m_replicas = this.getAllReplicas(this.m_userSuppliedReplica);
        m_logger.dump("Got all replicas.", new Object[0]);
        m_logger.dump("Scanning all replication agreement entries...", new Object[0]);
        this.m_agreements = this.getAllAgreements(this.m_userSuppliedReplica);
        m_logger.dump("Got all agreements.", new Object[0]);
        this.m_messages = (OidReplMessages)ResourceBundle.getBundle(OidReplMessages.class.getName(), locale);
    }

    public void refreshDRGInformation() throws OidReplException {
        if (this.m_agreements != null) {
            Collection<OidReplAgreement> allAgrmts = this.m_agreements.values();
            if (allAgrmts != null) {
                for (OidReplAgreement agrmt : allAgrmts) {
                    agrmt.close();
                }
                allAgrmts.clear();
            }
            this.m_agreements = null;
        }
        if (this.m_replicas != null) {
            this.m_replicas.remove(this.m_userSuppliedReplica.getReplicaID());
            Collection<OidReplica> replicas = this.m_replicas.values();
            if (replicas != null) {
                for (OidReplica replica : replicas) {
                    replica.close();
                }
            }
            this.m_replicas.clear();
            this.m_replicas = null;
        }
        m_logger.dump("Rescanning replication configuration entries...", new Object[0]);
        this.m_replicas = this.getAllReplicas(this.m_userSuppliedReplica);
        m_logger.dump("Got all replicas.", new Object[0]);
        m_logger.dump("Rescanning all replication agreement entries...", new Object[0]);
        this.m_agreements = this.getAllAgreements(this.m_userSuppliedReplica);
        m_logger.dump("Got all agreements.", new Object[0]);
    }

    public OidReplica getReplica(String replicaid) {
        if (null == replicaid) {
            return null;
        }
        return this.m_replicas.get(replicaid);
    }

    public OidReplAgreement getAgreement(String agreementName) {
        if (agreementName == null) {
            return null;
        }
        return this.m_agreements.get(agreementName);
    }

    public OidReplAgreement getAgreement(OidReplica Supplier, OidReplica Consumer2) {
        for (Map.Entry<String, OidReplAgreement> mentry : this.m_agreements.entrySet()) {
            OidFanoutReplAgreement fanout;
            OidReplAgreement agrmt = mentry.getValue();
            if (agrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER || !(fanout = (OidFanoutReplAgreement)agrmt).getConsumer().equals(Consumer2) || !fanout.getSupplier().equals(Supplier)) continue;
            return fanout;
        }
        return null;
    }

    public List<? extends OidReplAgreement> getAgreements() {
        ArrayList<OidReplAgreement> listAgreements = new ArrayList<OidReplAgreement>(this.m_agreements.values());
        return listAgreements;
    }

    public List<OidReplica> getReplicas() {
        ArrayList<OidReplica> listReplicas = new ArrayList<OidReplica>(this.m_replicas.values());
        return listReplicas;
    }

    public void addReplicaToContext(OidReplica replica) {
        if (replica != null && replica.getReplicaID() != null) {
            this.m_replicas.put(replica.getReplicaID(), replica);
        }
    }

    public void removeReplicaFromTheList(OidReplica replica) {
        if (replica != null) {
            this.m_replicas.remove(replica.getReplicaID());
            replica.close();
        }
    }

    public void removeAgreementFromTheList(OidReplAgreement agrmt) {
        if (agrmt != null) {
            this.m_agreements.remove(agrmt);
            agrmt.close();
        }
    }

    public boolean addAgreement(OidReplAgreement agrmt) throws OidReplException {
        List<String> messages = agrmt.validate();
        if (messages != null && messages.size() > 0) {
            String msg = this.getString(13L, messages.get(0));
            m_logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        this.syncCatalog(agrmt);
        this.syncRootDSEACIs(agrmt);
        if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_ONEWAY) || 0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_TWOWAY)) {
            this.addFanoutReplAgreement((OidFanoutReplAgreement)agrmt);
        } else {
            this.addMultimasterReplAgreement((OidMultimasterReplAgreement)agrmt);
        }
        return true;
    }

    private void addFanoutReplAgreement(OidFanoutReplAgreement foagrmt) throws OidReplException {
        OidReplica supplier = foagrmt.getSupplier();
        OidReplica consumer = foagrmt.getConsumer();
        String agrmtId = this.getMaxAgrmtID();
        try {
            supplier.checkAndAddSecondaryURI();
        }
        catch (OidReplException ore) {
            m_logger.warn("Failed to add URI for ldap://{0}:{1}", (Object[])new String[]{supplier.getHost(), String.valueOf(supplier.getPort())}, ore);
        }
        try {
            consumer.checkAndAddSecondaryURI();
        }
        catch (OidReplException ore) {
            m_logger.warn("Failed to add URI for ldap://{0}:{1}", (Object[])new String[]{consumer.getHost(), String.valueOf(consumer.getPort())}, ore);
        }
        supplier.AlterReplicaState("1");
        if (consumer.getReplicaState() == null || !consumer.getReplicaState().equals("6")) {
            consumer.AlterReplicaState("7");
        }
        m_logger.debug("Configuring {0} replication between ldap://{1}:{2} {3} and ldap://{4}:{5} {6}", foagrmt.getAgreementType().toString(), supplier.getHost(), String.valueOf(supplier.getPort()), supplier.getReplicaID(), consumer.getHost(), String.valueOf(consumer.getPort()), consumer.getReplicaID());
        supplier.AlterDIPRepositoryValue(true);
        if (foagrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_ONEWAY) {
            consumer.AlterReplicaType("1");
            consumer.setReplicaRWMode(true);
        } else {
            consumer.setReplicaRWMode(false);
        }
        OidReplUtil.createFanoutReplAgreementEntry(agrmtId, foagrmt);
        foagrmt.createNamingContextEntries();
        List<OidReplEntry> entries = consumer.getEntriesSortedByParentFirst("cn=replication configuration", 2, "(objectclass=*)");
        Set<LdapName> exclDNs = OidReplUtil.getStandardExcludedDNs();
        supplier.renewLdapContext();
        OidReplUtil.copyEntries(supplier, consumer, "cn=replication configuration", 2, "(objectclass=*)", exclDNs, true, this);
        ArrayList<OidReplica> listReplicas = new ArrayList<OidReplica>(this.m_replicas.values());
        listReplicas.remove(consumer);
        OidReplUtil.copyEntries(listReplicas, entries, exclDNs, true, this);
        listReplicas.remove(supplier);
        OidReplUtil.copyEntries(supplier, listReplicas, foagrmt.getAgreementDN(), 2, "(objectclass=*)", null, true, this);
        this.m_replicas.put(supplier.getReplicaID(), supplier);
        this.m_replicas.put(consumer.getReplicaID(), consumer);
        this.m_agreements.put(foagrmt.getAgreementName(), foagrmt);
        supplier.addAgreement(foagrmt);
        consumer.addAgreement(foagrmt);
        if (entries != null) {
            entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMultimasterReplAgreement(OidMultimasterReplAgreement mmagrmt) throws OidReplException {
        OidReplica primReplica = mmagrmt.getPrimaryReplica();
        List<OidReplica> replicas = mmagrmt.getMultimasterReplicas();
        int count = 0;
        String agrmtId = this.getMaxAgrmtID();
        ArrayList<List<OidReplEntry>> cacheList = null;
        ArrayList<OidReplica> newList = null;
        Set<LdapName> exclDNs = OidReplUtil.getStandardExcludedDNs();
        try {
            OidReplica replica;
            for (count = 0; count < replicas.size(); ++count) {
                OidReplica tempReplica = replicas.get(count);
                try {
                    tempReplica.checkAndAddSecondaryURI();
                }
                catch (OidReplException ore) {
                    m_logger.warn("Failed to add URI for ldap://{0}:{1}", (Object[])new String[]{tempReplica.getHost(), String.valueOf(tempReplica.getPort())}, ore);
                }
                tempReplica.AlterDIPRepositoryValue(true);
                if (tempReplica == primReplica) {
                    tempReplica.AlterReplicaState("1");
                } else if (tempReplica.getReplicaState() == null || !tempReplica.getReplicaState().equals("6")) {
                    tempReplica.AlterReplicaState("7");
                }
                tempReplica.AlterReplicaType("0");
            }
            String agreementDN = String.format("orclagreementid=%s,orclreplicaid=%s,cn=replication configuration", agrmtId, primReplica.getReplicaID());
            mmagrmt.setAgreementDN(agreementDN);
            mmagrmt.setAgreementID(agrmtId);
            OidReplUtil.createMultimasterReplAgreementEntry(agrmtId, mmagrmt);
            mmagrmt.createNamingContextEntries();
            cacheList = new ArrayList<List<OidReplEntry>>();
            for (count = 0; count < replicas.size(); ++count) {
                replica = replicas.get(count);
                cacheList.add(count, replica.getEntriesSortedByParentFirst("cn=replication configuration", 2, "(objectclass=*)"));
            }
            newList = new ArrayList<OidReplica>();
            for (count = 0; count < replicas.size(); ++count) {
                newList.add(count, replicas.get(count));
            }
            for (count = 0; count < replicas.size(); ++count) {
                replica = (OidReplica)newList.remove(count);
                List entries = (List)cacheList.get(count);
                OidReplUtil.copyEntries(newList, entries, exclDNs, true, this);
                newList.add(count, replica);
            }
            newList.clear();
            for (count = 0; count < replicas.size(); ++count) {
                replica = replicas.get(count);
                replica.addAgreement(mmagrmt);
                this.m_replicas.put(replica.getReplicaID(), replica);
            }
            this.m_agreements.put(mmagrmt.getAgreementName(), mmagrmt);
            this.refreshQueueStatistics();
        }
        finally {
            if (newList != null) {
                newList.clear();
            }
            if (cacheList != null) {
                for (count = 0; count < cacheList.size(); ++count) {
                    List Entries = (List)cacheList.get(count);
                    Entries.clear();
                }
                cacheList.clear();
            }
        }
    }

    private String getMaxAgrmtID() {
        Iterator<Map.Entry<String, OidReplAgreement>> agrmtIterator = this.m_agreements.entrySet().iterator();
        int maxAgrmtID = 2;
        int temp = 0;
        while (agrmtIterator.hasNext()) {
            Map.Entry<String, OidReplAgreement> mentry = agrmtIterator.next();
            OidReplAgreement agrmt = mentry.getValue();
            temp = Integer.parseInt(agrmt.getAgreementID());
            if (temp <= maxAgrmtID) continue;
            maxAgrmtID = temp;
        }
        String AgrmtId = String.format("%06d", maxAgrmtID + 1);
        return AgrmtId;
    }

    public void deleteFanoutReplAgreement(OidFanoutReplAgreement fanoutAgrmt) throws OidReplException {
        OidReplica conReplica = fanoutAgrmt.getConsumer();
        OidReplica supReplica = fanoutAgrmt.getSupplier();
        String conReplicaSubEntryDN = conReplica.getReplicaSubEntryDN();
        String supReplicaSubEntryDN = supReplica.getReplicaSubEntryDN();
        String agrmtDN = fanoutAgrmt.getAgreementDN();
        conReplica.deleteEntry(agrmtDN, false);
        conReplica.deleteEntry(supReplica.getReplicaSubEntryDN(), false);
        conReplica.deleteAgreement(fanoutAgrmt);
        conReplica.AlterReplicaState("1");
        conReplica.AlterReplicaType("0");
        supReplica.deleteEntry(agrmtDN, false);
        supReplica.deleteEntry(conReplica.getReplicaSubEntryDN(), false);
        supReplica.deleteAgreement(fanoutAgrmt);
        Collection<OidReplica> replicas = this.m_replicas.values();
        for (OidReplica replica : replicas) {
            if (replica.equals(conReplica) || replica.equals(supReplica)) continue;
            boolean isConReplicaASupplier = replica.isSupplier(conReplica);
            boolean isSupReplicaASupplier = replica.isSupplier(supReplica);
            replica.deleteEntry(agrmtDN, true);
            if (!isConReplicaASupplier && !conReplica.equals(replica)) {
                replica.deleteEntry(conReplicaSubEntryDN, true);
                conReplica.deleteEntry(replica.getReplicaSubEntryDN(), true);
            }
            if (isSupReplicaASupplier || supReplica.equals(replica)) continue;
            replica.deleteEntry(supReplicaSubEntryDN, true);
            supReplica.deleteEntry(replica.getReplicaSubEntryDN(), true);
        }
        this.refreshDRGInformation();
    }

    public void deleteMultimasterAgreement(OidMultimasterReplAgreement mmAgrmt) throws OidReplException {
        String agrmtDN = mmAgrmt.getAgreementDN();
        List<OidReplica> mmReplicas = mmAgrmt.getMultimasterReplicas();
        Collection<OidReplica> allReplicas = this.m_replicas.values();
        m_logger.dump("Deleting multimaster replication agreement {0}", agrmtDN);
        for (OidReplica replica : allReplicas) {
            if (mmAgrmt.isPartOfThisAgreement(replica)) continue;
            for (OidReplica mmReplica : mmReplicas) {
                if (replica.isSupplier(mmReplica)) continue;
                mmReplica.deleteEntry(replica.getReplicaSubEntryDN(), true);
                replica.deleteEntry(mmReplica.getReplicaSubEntryDN(), true);
            }
            replica.deleteEntry(agrmtDN, true);
        }
        for (OidReplica outerReplica : mmReplicas) {
            outerReplica.deleteEntry(agrmtDN, false);
            outerReplica.deleteAgreement(mmAgrmt);
            for (OidReplica innerReplica : mmReplicas) {
                if (innerReplica.equals(outerReplica)) continue;
                outerReplica.deleteEntry(innerReplica.getReplicaSubEntryDN(), false);
            }
        }
        m_logger.dump("Deleted multimaster replication agreement {0}", agrmtDN);
        this.refreshDRGInformation();
    }

    public void deleteAgreement(String agreementName) throws OidReplException {
        this.deleteAgreement(this.getAgreement(agreementName));
    }

    public void deleteAgreement(OidReplAgreement agrmt) throws OidReplException {
        if (agrmt == null) {
            return;
        }
        if (agrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_ONEWAY || agrmt.getAgreementType() == OidReplAgreement.OidReplAgreementType.OID_TWOWAY) {
            OidFanoutReplAgreement fanoutAgrmt = (OidFanoutReplAgreement)agrmt;
            this.deleteFanoutReplAgreement(fanoutAgrmt);
        } else {
            OidMultimasterReplAgreement mmAgrmt = (OidMultimasterReplAgreement)agrmt;
            this.deleteMultimasterAgreement(mmAgrmt);
        }
    }

    private Map<String, OidReplica> getAllReplicas(OidReplica userReplica) throws OidReplException {
        LdapContext dirCtx = userReplica.getDirContext();
        SearchControls constraints = new SearchControls();
        Hashtable<String, OidReplica> hreplicas = new Hashtable<String, OidReplica>();
        try {
            constraints.setSearchScope(2);
            NamingEnumeration<SearchResult> res = dirCtx.search("cn=replication configuration", "(objectclass=orclreplicasubentry)", constraints);
            while (res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute rid = OidReplUtil.getRequiredAttribute("orclreplicaid", atrs, true);
                Attribute uri = OidReplUtil.getRequiredAttribute("orclreplicauri", atrs, true);
                Attribute suri = OidReplUtil.getRequiredAttribute("orclreplicasecondaryuri", atrs, true);
                Attribute rtype = OidReplUtil.getRequiredAttribute("orclreplicatype", atrs, true);
                Attribute rstate = OidReplUtil.getRequiredAttribute("orclreplicastate", atrs, true);
                Attribute ptime = OidReplUtil.getRequiredAttribute("pilotstarttime", atrs, true);
                Attribute pmode = OidReplUtil.getRequiredAttribute("orclpilotmode", atrs, true);
                Attribute see = OidReplUtil.getRequiredAttribute("seealso", atrs, true);
                Attribute em = OidReplUtil.getRequiredAttribute("orclemtargetname", atrs, true);
                Attribute ver = OidReplUtil.getRequiredAttribute("orclreplicaversion", atrs, true);
                OidReplica replica = null;
                if (rid != null && rid.get().toString().equalsIgnoreCase(this.m_userSuppliedReplica.getReplicaID())) {
                    replica = this.m_userSuppliedReplica;
                } else {
                    replica = new OidReplica();
                    if (uri != null) {
                        String[] hp = OidReplica.getHostPortFromURI(uri.get().toString());
                        if (hp != null) {
                            replica.setHost(hp[0]);
                            replica.setPort(Integer.valueOf(hp[1]));
                        }
                        replica.setReplicaURI(uri.get().toString());
                    }
                    if (rid != null) {
                        replica.setReplicaID(rid.get().toString());
                        replica.setReplDN("cn=replication dn," + replica.getReplicaSubEntryDN());
                    }
                    if (this.m_userSuppliedReplica.getIsReplBind()) {
                        replica.setBindDN(this.m_userSuppliedReplica.getBindDN());
                        replica.setBindPwd(this.m_userSuppliedReplica.getBindPwd());
                        replica.setIsReplBind(true);
                    }
                }
                replica.setReplicaSubEntryDN(sr.getNameInNamespace());
                if (rtype != null) {
                    replica.setReplicaType(rtype.get().toString());
                }
                if (rstate != null) {
                    replica.setReplicaState(rstate.get().toString());
                }
                if (ptime != null) {
                    replica.setPilotStartTime(ptime.get().toString());
                }
                if (pmode != null) {
                    replica.setPilotMode(pmode.get().toString());
                }
                if (see != null) {
                    replica.setSeeAlso(see.get().toString());
                }
                if (em != null) {
                    replica.setEMTargetName(em.get().toString());
                }
                if (ver != null) {
                    replica.setReplicaVersion(ver.get().toString());
                }
                if (suri != null) {
                    for (int count = 0; count < suri.size(); ++count) {
                        replica.addSecondaryURI(suri.get(count).toString());
                    }
                }
                hreplicas.put(replica.getReplicaID(), replica);
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(19L, userReplica.getHost(), String.valueOf(userReplica.getPort()), "cn=replication configuration");
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        return hreplicas;
    }

    private Map<String, OidReplAgreement> getAllAgreements(OidReplica userReplica) throws OidReplException {
        LdapContext dirCtx = userReplica.getDirContext();
        SearchControls constraints = new SearchControls();
        Hashtable<String, OidReplAgreement> halist = new Hashtable<String, OidReplAgreement>();
        try {
            constraints.setSearchScope(2);
            NamingEnumeration<SearchResult> res = dirCtx.search("cn=replication configuration", "(objectclass=orclreplagreemententry)", constraints);
            while (res.hasMore()) {
                OidReplAgreement agrmt = null;
                SearchResult sr = res.next();
                sr.setRelative(false);
                Attributes atrs = sr.getAttributes();
                Attribute atype = OidReplUtil.getRequiredAttribute("orclagreementtype", atrs, true);
                Attribute aname = OidReplUtil.getRequiredAttribute("orclagreementname", atrs, true);
                Attribute aid = OidReplUtil.getRequiredAttribute("orclagreementid", atrs, true);
                Attribute updsch = OidReplUtil.getRequiredAttribute("orclupdateschedule", atrs, true);
                Attribute hiqsch = OidReplUtil.getRequiredAttribute("orclhiqschedule", atrs, true);
                Attribute proto = OidReplUtil.getRequiredAttribute("orclreplicationprotocol", atrs, true);
                Attribute rid = OidReplUtil.getRequiredAttribute("orclreplicationid", atrs, true);
                Attribute replicas = OidReplUtil.getRequiredAttribute("orclreplicadn", atrs, true);
                Attribute ldapconn = OidReplUtil.getRequiredAttribute("orclldapconnkeepalive", atrs, true);
                if (atype == null || replicas == null) continue;
                String atypeval = atype.get().toString();
                if ((atypeval = atypeval.trim()).equals("0") || atypeval.equals("1")) {
                    OidFanoutReplAgreement fanout = new OidFanoutReplAgreement(this);
                    fanout.setAgreementDN(sr.getNameInNamespace());
                    fanout.setAgreementType(atypeval);
                    String supplierId = OidReplUtil.getReplicaIdFromDN(sr.getNameInNamespace());
                    String consumerId = OidReplUtil.getReplicaIdFromDN(replicas.get().toString());
                    OidReplica supplier = this.getReplica(supplierId);
                    OidReplica consumer = this.getReplica(consumerId);
                    fanout.setSupplier(supplier);
                    fanout.setConsumer(consumer);
                    if (supplier != null) {
                        supplier.addAgreement(fanout);
                    }
                    if (consumer != null) {
                        consumer.addAgreement(fanout);
                    }
                    agrmt = fanout;
                } else if (atypeval.equals("2")) {
                    OidMultimasterReplAgreement mm = new OidMultimasterReplAgreement(this);
                    mm.setAgreementDN(sr.getNameInNamespace());
                    mm.setAgreementType(atypeval);
                    for (int count = 0; count < replicas.size(); ++count) {
                        String id = OidReplUtil.getReplicaIdFromDN(replicas.get(count).toString());
                        OidReplica master = this.getReplica(id);
                        mm.addReplicaToMultimasterList(master, false);
                        if (master == null) continue;
                        master.addAgreement(mm);
                    }
                    String masterId = OidReplUtil.getReplicaIdFromDN(mm.getAgreementDN());
                    OidReplica primaryReplica = this.getReplica(masterId);
                    mm.setPrimaryReplica(primaryReplica);
                    primaryReplica.addAgreement(mm);
                    agrmt = mm;
                }
                if (hiqsch != null) {
                    agrmt.setHIQSchedule(hiqsch.get().toString());
                }
                if (updsch != null) {
                    agrmt.setUpdateSchedule(updsch.get().toString());
                }
                if (aid != null) {
                    agrmt.setAgreementID(aid.get().toString());
                }
                if (aname != null) {
                    agrmt.setAgreementName(aname.get().toString());
                } else {
                    agrmt.setAgreementName(aid.get().toString());
                }
                if (proto != null) {
                    agrmt.setReplProtocol(proto.get().toString());
                }
                if (rid != null) {
                    agrmt.setReplicationID(rid.get().toString());
                }
                if (ldapconn != null) {
                    String val = ldapconn.get().toString();
                    if ((val = val.trim()).equals("0")) {
                        agrmt.setConnKeepAlive(false);
                    } else {
                        agrmt.setConnKeepAlive(true);
                    }
                }
                userReplica.getNamingContextOfAgrmt(agrmt);
                halist.put(agrmt.getAgreementName(), agrmt);
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(19L, userReplica.getHost(), String.valueOf(userReplica.getPort()), "cn=replication configuration");
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        return halist;
    }

    public void refreshQueueStatistics() throws OidReplException {
        if (this.m_agreements.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, OidReplAgreement>> it = this.m_agreements.entrySet().iterator();
        while (it.hasNext()) {
            OidChgNum qStat;
            OidReplica consumer;
            OidReplica supplier;
            OidFanoutReplAgreement fanout;
            OidReplAgreement agrmt = it.next().getValue();
            agrmt.clearQueueStatistics();
            if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_ONEWAY)) {
                fanout = (OidFanoutReplAgreement)agrmt;
                supplier = fanout.getSupplier();
                consumer = fanout.getConsumer();
                qStat = null;
                if (supplier == null || consumer == null || (qStat = this.getQueueStat(supplier, consumer, agrmt)) == null) continue;
                fanout.addQueueStatistics(qStat);
                continue;
            }
            if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_TWOWAY)) {
                fanout = (OidFanoutReplAgreement)agrmt;
                supplier = fanout.getSupplier();
                consumer = fanout.getConsumer();
                qStat = null;
                if (supplier == null || consumer == null) continue;
                qStat = this.getQueueStat(supplier, consumer, agrmt);
                if (qStat != null) {
                    fanout.addQueueStatistics(qStat);
                }
                if ((qStat = this.getQueueStat(consumer, supplier, agrmt)) == null) continue;
                fanout.addQueueStatistics(qStat);
                continue;
            }
            if (0 != agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER)) continue;
            OidMultimasterReplAgreement mm = (OidMultimasterReplAgreement)agrmt;
            List<OidReplica> listReplicas = mm.getMultimasterReplicas();
            for (OidReplica outerReplica : listReplicas) {
                for (OidReplica innerReplica : listReplicas) {
                    if (outerReplica == innerReplica) continue;
                    OidChgNum qStat2 = null;
                    if (outerReplica == null || innerReplica == null || (qStat2 = this.getQueueStat(outerReplica, innerReplica, agrmt)) == null) continue;
                    mm.addQueueStatistics(qStat2);
                }
            }
        }
    }

    public OidChgNum getQueueStat(OidReplica supplier, OidReplica consumer, OidReplAgreement agrmt) throws OidReplException {
        OidChgNum qStat = null;
        long numLogs = 0L;
        LdapContext supDirContext = supplier.getDirContext();
        String filter = null;
        NamingEnumeration<SearchResult> res = null;
        if (consumer == null || supplier == null) {
            return null;
        }
        qStat = new OidChgNum();
        qStat.setConsumer(consumer);
        qStat.setSupplier(supplier);
        qStat.setReplAgreement(agrmt);
        try {
            SearchControls constraints = new SearchControls();
            String transportLACN = "orcllastappliedchangenumber;transport$" + supplier.getReplicaID() + "$" + consumer.getReplicaID();
            String applyLACN = "orcllastappliedchangenumber;apply$" + supplier.getReplicaID() + "$" + consumer.getReplicaID();
            String[] reqAttrs = new String[]{transportLACN, applyLACN};
            constraints.setReturningAttributes(reqAttrs);
            constraints.setSearchScope(0);
            res = supDirContext.search(agrmt.getAgreementDN(), "(objectclass=*)", constraints);
            if (res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute trans = OidReplUtil.getRequiredAttribute(transportLACN, atrs, false);
                Attribute apply = OidReplUtil.getRequiredAttribute(applyLACN, atrs, false);
                if (trans != null) {
                    qStat.setLastAppliedChangeNumberApply(Long.valueOf(trans.get().toString()));
                }
                if (apply != null) {
                    qStat.setLastAppliedChangeNumberTransport(Long.valueOf(apply.get().toString()));
                }
            }
            res.close();
        }
        catch (NamingException ne) {
            String msg = this.getString(19L, supplier.getHost(), String.valueOf(supplier.getPort()), agrmt.getAgreementDN());
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (NamingException ne) {}
        }
        filter = String.format("(&(objectclass=changelogentry)(servername=%s)(changenumber>=%d)(!(orclreplicationid=%s)))", supplier.getReplicaID(), qStat.getLastAppliedChangeNumberTransport() + 1L, agrmt.getReplicationID());
        numLogs = supplier.getNumLogs(filter);
        qStat.setLogsToBeTransported(numLogs);
        filter = null;
        filter = String.format("(&(objectclass=changeLogEntry)(servername=%s)(changeNumber>=%d)(orclChangeRetryCount=0))", supplier.getReplicaID(), qStat.getLastAppliedChangeNumberApply() + 1L);
        numLogs = consumer.getNumLogs(filter);
        qStat.setNew(numLogs);
        filter = null;
        filter = String.format("(&(objectclass=changeLogEntry)(servername=%s)(changeNumber<=%d)(orclChangeRetryCount>=1))", supplier.getReplicaID(), qStat.getLastAppliedChangeNumberApply());
        numLogs = consumer.getNumLogs(filter);
        qStat.setRetry(numLogs);
        filter = null;
        filter = String.format("(&(objectclass=changeLogEntry)(servername=%s)(changeNumber<=%d)(orclChangeRetryCount=-2))", supplier.getReplicaID(), qStat.getLastAppliedChangeNumberApply());
        numLogs = consumer.getNumLogs(filter);
        qStat.setPurge(numLogs);
        filter = null;
        filter = String.format("(&(objectclass=changeLogEntry)(servername=%s)(changeNumber<=%d)(orclChangeRetryCount=-1))", supplier.getReplicaID(), qStat.getLastAppliedChangeNumberApply());
        numLogs = consumer.getNumLogs(filter);
        qStat.setHiq(numLogs);
        return qStat;
    }

    public static long getCountVal(Control ctrl) {
        byte[] berVal = ctrl.getEncodedValue();
        long count = 0L;
        BERDecoder decoder = new BERDecoder(berVal, 0, berVal.length);
        try {
            if (decoder.bytesLeft() > 0 && 2 == decoder.peekByte()) {
                count = decoder.parseInt();
            }
        }
        catch (DecodeException de) {
            // empty catch block
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDecodedResponse(Control ctrl) {
        byte[] berVal = ctrl.getEncodedValue();
        BERDecoder decoder = new BERDecoder(berVal, 0, berVal.length);
        StringBuffer response = new StringBuffer();
        int[] rlen = new int[10];
        try {
            block11: while (decoder.bytesLeft() > 0) {
                switch (decoder.peekByte()) {
                    case 1: {
                        response.append(" [B] " + String.valueOf(decoder.parseBoolean()));
                        continue block11;
                    }
                    case 2: {
                        response.append(" [I] " + String.valueOf(decoder.parseInt()));
                        continue block11;
                    }
                    case 4: {
                        response.append(" [S] " + decoder.parseString(true));
                        continue block11;
                    }
                    case 5: {
                        decoder.parseByte();
                        response.append(" null ");
                        continue block11;
                    }
                    case 16: {
                        decoder.parseSeq(rlen);
                        response.append("{ ");
                        continue block11;
                    }
                    case 10: {
                        response.append(" [E] " + decoder.parseEnumeration());
                        continue block11;
                    }
                    case 48: {
                        decoder.parseSeq(rlen);
                        response.append("{");
                        continue block11;
                    }
                }
                int tag = decoder.peekByte();
                response.append("[" + tag + "]" + decoder.parseStringWithTag(tag, true, rlen));
            }
            return response.toString();
        }
        catch (DecodeException de) {
            // empty catch block
        }
        return response.toString();
    }

    public boolean checkBootstrapLimit(OidReplAgreement agrmt) throws OidReplException {
        LdapContext suppDirContext;
        OidReplica primReplica;
        List<OidReplNamingContext> namingCtxList = agrmt.getNamingContexts();
        long numEntries = 0L;
        if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER)) {
            OidMultimasterReplAgreement mmagrmt = (OidMultimasterReplAgreement)agrmt;
            primReplica = mmagrmt.getPrimaryReplica();
            suppDirContext = primReplica.getDirContext();
        } else {
            OidFanoutReplAgreement foagrmt = (OidFanoutReplAgreement)agrmt;
            primReplica = foagrmt.getSupplier();
            suppDirContext = primReplica.getDirContext();
        }
        for (OidReplNamingContext namingCtx : namingCtxList) {
            numEntries += OidReplUtil.getNumEntries(suppDirContext, namingCtx.getIncludedDN(), "(objectclass=*)", 2);
            Set<String> exclDNs = namingCtx.getExcludedDNs();
            for (String exclDN : exclDNs) {
                numEntries -= OidReplUtil.getNumEntries(suppDirContext, exclDN, "(objectclass=*)", 2);
            }
        }
        return numEntries <= 100000L;
    }

    public void startReplication(OidReplAgreement agrmt, boolean bootstrap) throws OidReplException {
        if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER)) {
            OidMultimasterReplAgreement mmagrmt = (OidMultimasterReplAgreement)agrmt;
            OidReplica primReplica = mmagrmt.getPrimaryReplica();
            for (OidReplica replica : mmagrmt.getMultimasterReplicas()) {
                if (replica.getReplicaState() != null && replica.getReplicaState().equals("6")) {
                    replica.AlterReplicaState("1");
                } else if (bootstrap && replica != primReplica) {
                    replica.AlterReplicaState("0");
                }
                replica.activateReplication();
            }
        } else {
            OidFanoutReplAgreement foagrmt = (OidFanoutReplAgreement)agrmt;
            OidReplica supplier = foagrmt.getSupplier();
            OidReplica consumer = foagrmt.getConsumer();
            if (consumer.getReplicaState() != null && consumer.getReplicaState().equals("6")) {
                consumer.AlterReplicaState("1");
            } else if (bootstrap) {
                consumer.AlterReplicaState("0");
            }
            consumer.activateReplication();
            if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_TWOWAY)) {
                supplier.activateReplication();
            }
        }
    }

    private void syncCatalog(OidReplAgreement agrmt) throws OidReplException {
        List<OidReplica> replicas;
        LdapContext suppDirContext;
        OidReplica primReplica;
        NamingEnumeration<SearchResult> res = null;
        Vector<String> indexedAttrs = new Vector<String>();
        SearchControls constraints = new SearchControls();
        String[] reqAttrs = new String[]{"orclindexedattribute"};
        String consReplicaId = "";
        constraints.setReturningAttributes(reqAttrs);
        constraints.setSearchScope(0);
        if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER)) {
            OidMultimasterReplAgreement mmagrmt = (OidMultimasterReplAgreement)agrmt;
            primReplica = mmagrmt.getPrimaryReplica();
            suppDirContext = primReplica.getDirContext();
            replicas = mmagrmt.getMultimasterReplicas();
        } else {
            OidFanoutReplAgreement foagrmt = (OidFanoutReplAgreement)agrmt;
            primReplica = foagrmt.getSupplier();
            suppDirContext = primReplica.getDirContext();
            replicas = new Vector<OidReplica>();
            replicas.add(foagrmt.getConsumer());
        }
        try {
            res = suppDirContext.search("cn=catalogs", "(objectclass=*)", constraints);
            if (res.hasMore()) {
                SearchResult sr = res.next();
                Attributes atrs = sr.getAttributes();
                Attribute attr = OidReplUtil.getRequiredAttribute("orclindexedattribute", atrs, false);
                for (int count = 0; count < attr.size(); ++count) {
                    String[] str = attr.get(count).toString().split(";");
                    indexedAttrs.add(str[0]);
                }
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(19L, primReplica.getHost(), String.valueOf(primReplica.getPort()), "cn=catalogs");
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (NamingException ne) {}
        }
        try {
            for (OidReplica consumer : replicas) {
                if (consumer == primReplica || consumer.getReplicaState() != null && consumer.getReplicaState().equals("6")) continue;
                consReplicaId = consumer.getReplicaID();
                Vector localIndexedAttrs = new Vector(indexedAttrs);
                LdapContext consDirContext = consumer.getDirContext();
                res = consDirContext.search("cn=catalogs", "(objectclass=*)", constraints);
                if (res.hasMore()) {
                    SearchResult sr = res.next();
                    Attributes atrs = sr.getAttributes();
                    Attribute attr = OidReplUtil.getRequiredAttribute("orclindexedattribute", atrs, false);
                    for (int count = 0; count < attr.size(); ++count) {
                        String[] str = attr.get(count).toString().split(";");
                        localIndexedAttrs.remove(str[0]);
                    }
                }
                if (res != null) {
                    res.close();
                    res = null;
                }
                if (localIndexedAttrs.size() > 0) {
                    BasicAttributes attrs = new BasicAttributes();
                    BasicAttribute attr = new BasicAttribute("orclindexedattribute");
                    for (String idxAttr : localIndexedAttrs) {
                        attr.add(idxAttr);
                    }
                    attrs.put(attr);
                    consDirContext.modifyAttributes("cn=catalogs", 1, (Attributes)attrs);
                }
                m_logger.dump("Synchronized the Catalog of consumer replica, {0} with primary replica, {1}", primReplica.getReplicaID(), consumer.getReplicaID());
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(29L, consReplicaId);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (NamingException ne) {}
        }
    }

    private void syncRootDSEACIs(OidReplAgreement agrmt) throws OidReplException {
        List<OidReplica> replicas;
        LdapContext suppDirContext;
        OidReplica primReplica;
        NamingEnumeration<SearchResult> res = null;
        SearchControls constraints = new SearchControls();
        String[] reqAttrs = new String[]{"orclaci", "orclentrylevelaci"};
        String consReplicaId = "";
        Attributes aciAttrs = null;
        constraints.setReturningAttributes(reqAttrs);
        constraints.setSearchScope(0);
        if (0 == agrmt.getAgreementType().compareTo(OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER)) {
            OidMultimasterReplAgreement mmagrmt = (OidMultimasterReplAgreement)agrmt;
            primReplica = mmagrmt.getPrimaryReplica();
            suppDirContext = primReplica.getDirContext();
            replicas = mmagrmt.getMultimasterReplicas();
        } else {
            OidFanoutReplAgreement foagrmt = (OidFanoutReplAgreement)agrmt;
            primReplica = foagrmt.getSupplier();
            suppDirContext = primReplica.getDirContext();
            replicas = new Vector<OidReplica>();
            replicas.add(foagrmt.getConsumer());
        }
        try {
            res = suppDirContext.search("", "(objectclass=*)", constraints);
            if (res.hasMore()) {
                SearchResult sr = res.next();
                aciAttrs = sr.getAttributes();
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(19L, primReplica.getHost(), String.valueOf(primReplica.getPort()), "cn=catalogs");
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (NamingException ne) {}
        }
        if (aciAttrs == null) {
            return;
        }
        try {
            for (OidReplica consumer : replicas) {
                if (consumer == primReplica || consumer.getReplicaState() != null && consumer.getReplicaState().equals("6")) continue;
                consReplicaId = consumer.getReplicaID();
                LdapContext consDirContext = consumer.getDirContext();
                consDirContext.modifyAttributes("", 2, aciAttrs);
                m_logger.dump("Synchronized the RootDSE ACIs of consumer replica, {0} with primary replica, {1}", primReplica.getReplicaID(), consumer.getReplicaID());
            }
        }
        catch (NamingException ne) {
            String msg = this.getString(30L, consReplicaId);
            m_logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    public String getString(long errCode, Object ... params) {
        String key = "OID-JREMTOOL-" + String.format("%05d", errCode);
        String val = this.m_messages.getString(key);
        String msg = MessageFormat.format(val, params);
        return msg;
    }

    public String getString(String key, Object ... params) {
        String val = this.m_messages.getString(key);
        String msg = MessageFormat.format(val, params);
        return msg;
    }
}

