/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.jremtool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import oracle.ldap.jremtool.OidReplAgreement;
import oracle.ldap.jremtool.OidReplContext;
import oracle.ldap.jremtool.OidReplEntry;
import oracle.ldap.jremtool.OidReplException;
import oracle.ldap.jremtool.OidReplLogger;
import oracle.ldap.jremtool.OidReplNamingContext;
import oracle.ldap.jremtool.OidReplUtil;
import oracle.ldap.jremtool.OidReplica;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidMultimasterReplAgreement
extends OidReplAgreement {
    private static final OidReplLogger logger = OidReplLogger.getLogger(OidMultimasterReplAgreement.class.getName());
    private List<OidReplica> m_multimasterReplicas;
    private OidReplica m_primary;

    public OidMultimasterReplAgreement(OidReplContext replContext) {
        super(replContext);
        this.m_agreementType = OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER;
        this.m_multimasterReplicas = new Vector<OidReplica>();
    }

    public OidMultimasterReplAgreement(String agreementName, OidReplContext replContext) {
        super(replContext);
        this.m_agreementName = agreementName;
        this.m_agreementType = OidReplAgreement.OidReplAgreementType.OID_MULTIMASTER;
        this.m_multimasterReplicas = new Vector<OidReplica>();
    }

    public OidReplica getPrimaryReplica() {
        return this.m_primary;
    }

    public void setPrimaryReplica(OidReplica supplier) {
        boolean exists = false;
        this.m_primary = supplier;
        for (OidReplica replica : this.m_multimasterReplicas) {
            if (!replica.equals(supplier)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.m_multimasterReplicas.add(supplier);
        }
    }

    public boolean isPrimaryReplica(OidReplica replica) {
        if (this.m_primary != null) {
            return this.m_primary.equals(replica);
        }
        return false;
    }

    public boolean isPartOfThisAgreement(OidReplica replica) {
        String replicaID = replica.getReplicaID();
        for (OidReplica tempReplica : this.m_multimasterReplicas) {
            if (!replicaID.equalsIgnoreCase(tempReplica.getReplicaID())) continue;
            return true;
        }
        return false;
    }

    public void addReplicaToMultimasterList(OidReplica replica, boolean ismaster) throws OidReplException {
        for (OidReplica testReplica : this.m_multimasterReplicas) {
            if (!testReplica.equals(replica)) continue;
            String msg = this.m_replContext.getString(3L, replica.getReplicaID());
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        this.m_multimasterReplicas.add(replica);
        if (ismaster) {
            this.m_primary = replica;
        }
    }

    public void deleteReplicaFromMultimasterList(OidReplica replica) throws OidReplException {
        boolean exists = false;
        for (OidReplica testReplica : this.m_multimasterReplicas) {
            if (!testReplica.equals(replica)) continue;
            this.m_multimasterReplicas.remove(testReplica);
            exists = true;
            if (!this.m_primary.equals(replica)) continue;
            this.m_primary = null;
        }
        if (!exists) {
            String msg = this.m_replContext.getString(4L, replica.getReplicaID());
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
    }

    public List<OidReplica> getMultimasterReplicas() {
        return this.m_multimasterReplicas;
    }

    public void alterPrimaryReplica(OidReplContext ctx, OidReplica newPrimaryReplica) throws OidReplException {
        String newReplicaID = newPrimaryReplica.getReplicaID();
        LdapName agreementdn = null;
        logger.dump("Changing primary replica from {0} to {1}", this.m_primary.getReplicaID(), newPrimaryReplica.getReplicaID());
        try {
            agreementdn = new LdapName(this.getAgreementDN());
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        String agrmtId = agreementdn.getRdn(2).getValue().toString();
        String newAgrmtDN = String.format("orclagreementid=%s,orclreplicaid=%s,cn=replication configuration", agrmtId, newReplicaID);
        for (OidReplica tempReplica : this.m_multimasterReplicas) {
            tempReplica.renameEntry(this.m_agreementDN, newAgrmtDN, false);
        }
        this.m_agreementDN = newAgrmtDN;
        this.m_primary = newPrimaryReplica;
        this.m_primary.getNamingContextOfAgrmt(this);
        logger.dump("Primary replica has been successfully changed to {1}", newPrimaryReplica.getReplicaID());
    }

    public void addMultimasterReplica(OidReplContext ctx, OidReplica newReplica, boolean isPrimaryReplica) throws OidReplException {
        this.validateNewMultimasterReplica(newReplica);
        Set<LdapName> exclDNs = OidReplUtil.getStandardExcludedDNs();
        OidReplica primReplica = this.getPrimaryReplica();
        newReplica.AlterReplicaState("1");
        newReplica.AlterDIPRepositoryValue(true);
        newReplica.AlterReplicaType("0");
        this.modMMAgreementToIncludeNewReplica(newReplica);
        List<OidReplEntry> newReplEntries = newReplica.getEntriesSortedByParentFirst("cn=replication configuration", 2, "(objectclass=*)");
        OidReplUtil.copyEntries(primReplica, newReplica, "cn=replication configuration", 2, "(objectclass=*)", exclDNs, true, this.m_replContext);
        OidReplUtil.copyEntries(ctx.getReplicas(), newReplEntries, exclDNs, true, this.m_replContext);
        ctx.addReplicaToContext(newReplica);
        this.addReplicaToMultimasterList(newReplica, false);
        if (isPrimaryReplica) {
            this.alterPrimaryReplica(ctx, newReplica);
        }
    }

    private void modMMAgreementToIncludeNewReplica(OidReplica newReplica) throws OidReplException {
        String newReplicaID = newReplica.getReplicaID();
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute orclreplicadn = new BasicAttribute("orclreplicadn");
        orclreplicadn.add(newReplica.getReplicaSubEntryDN());
        attrs.put(orclreplicadn);
        String newLastChgNum = newReplica.getAttrValue("", "lastchangenumber");
        for (OidReplica oReplica : this.m_multimasterReplicas) {
            String replid = oReplica.getReplicaID();
            String lastChgNum = oReplica.getAttrValue("", "lastchangenumber");
            String apply = String.format("orcllastappliedchangenumber;apply$%s$%s", replid, newReplicaID);
            String trans = String.format("orcllastappliedchangenumber;transport$%s$%s", replid, newReplicaID);
            attrs.put(new BasicAttribute(apply, lastChgNum));
            attrs.put(new BasicAttribute(trans, lastChgNum));
            apply = String.format("orcllastappliedchangenumber;apply$%s$%s", newReplicaID, replid);
            trans = String.format("orcllastappliedchangenumber;transport$%s$%s", newReplicaID, replid);
            attrs.put(new BasicAttribute(apply, newLastChgNum));
            attrs.put(new BasicAttribute(trans, newLastChgNum));
        }
        for (OidReplica mmReplica : this.m_multimasterReplicas) {
            logger.dump("Modifying multimaster replication agreement entry {0} to include new replica {1} ... ", this.m_agreementDN, newReplicaID);
            mmReplica.modifyEntry(this.m_agreementDN, 1, attrs);
            logger.dump("Modification completed successfully.", new Object[0]);
        }
    }

    public boolean isDeletePrimaryReplica(OidReplContext ctx, OidReplica delReplica, OidReplica newPrimaryReplica) throws OidReplException {
        delReplica.setReplicaID();
        int delReplPort = delReplica.getPort();
        String delReplHost = delReplica.getHost();
        String delReplID = delReplica.getReplicaID();
        LdapName agreementDN = null;
        boolean deletePrimary = false;
        String msg = null;
        if (!this.isPartOfThisAgreement(delReplica)) {
            msg = this.m_replContext.getString(26L, delReplID, delReplHost, String.valueOf(delReplPort));
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        try {
            Rdn rdn;
            String primaryId;
            agreementDN = new LdapName(this.m_agreementDN);
            if (agreementDN.size() > 1 && (primaryId = ((String)(rdn = agreementDN.getRdn(1)).getValue()).trim()).equalsIgnoreCase(delReplID)) {
                deletePrimary = true;
            }
        }
        catch (NamingException ne) {
            throw new OidReplException(ne);
        }
        if (deletePrimary) {
            if (newPrimaryReplica == null) {
                msg = this.m_replContext.getString(27L, new Object[0]);
                throw new OidReplException(msg);
            }
            newPrimaryReplica.setReplicaID();
            if (!this.isPartOfThisAgreement(newPrimaryReplica)) {
                String host = newPrimaryReplica.getHost();
                String replID = newPrimaryReplica.getReplicaID();
                msg = this.m_replContext.getString(26L, replID == null ? "NULL" : replID, host == null ? "NULL" : host, String.valueOf(newPrimaryReplica.getPort()));
                logger.error(msg, new Object[0]);
                throw new OidReplException(msg);
            }
        }
        return deletePrimary;
    }

    public void deleteMultimasterReplica(OidReplContext ctx, OidReplica delReplica, OidReplica newPrimaryReplica) throws OidReplException {
        boolean deletePrimary = this.isDeletePrimaryReplica(ctx, delReplica, newPrimaryReplica);
        int count = 0;
        String delReplID = delReplica.getReplicaID();
        String subentryDN = delReplica.getReplicaSubEntryDN();
        logger.dump("Deleting replica {0} from multimaster replication agreement {1}", delReplID, this.m_agreementDN);
        if (deletePrimary) {
            this.alterPrimaryReplica(ctx, newPrimaryReplica);
        }
        delReplica.deleteEntry(this.m_agreementDN, false);
        for (OidReplica mmReplica : this.m_multimasterReplicas) {
            if (delReplica.equals(mmReplica)) continue;
            delReplica.deleteEntry(mmReplica.getReplicaSubEntryDN(), false);
        }
        for (OidReplica replica : ctx.getReplicas()) {
            if (this.isPartOfThisAgreement(replica)) continue;
            for (OidReplica mmReplica : this.m_multimasterReplicas) {
                if (replica.isSupplier(mmReplica)) continue;
                mmReplica.deleteEntry(replica.getReplicaSubEntryDN(), true);
                replica.deleteEntry(mmReplica.getReplicaSubEntryDN(), true);
            }
            replica.deleteEntry(this.m_agreementDN, true);
        }
        BasicAttributes newAttrs = new BasicAttributes();
        newAttrs.put("orclreplicadn", delReplica.getReplicaSubEntryDN());
        for (count = 0; count < ctx.getReplicas().size(); ++count) {
            OidReplica tempReplica = ctx.getReplicas().get(count);
            if (tempReplica.equals(delReplica)) continue;
            String tempReplicaId = tempReplica.getReplicaID();
            String apply = String.format("orcllastappliedchangenumber;apply$%s$%s", tempReplicaId, delReplID);
            String trans = String.format("orcllastappliedchangenumber;transport$%s$%s", tempReplicaId, delReplID);
            newAttrs.put(new BasicAttribute(apply));
            newAttrs.put(new BasicAttribute(trans));
            apply = String.format("orcllastappliedchangenumber;apply$%s$%s", delReplID, tempReplicaId);
            trans = String.format("orcllastappliedchangenumber;transport$%s$%s", delReplID, tempReplicaId);
            newAttrs.put(new BasicAttribute(apply));
            newAttrs.put(new BasicAttribute(trans));
            tempReplica.deleteEntry(subentryDN, false);
        }
        this.m_multimasterReplicas.remove(delReplica);
        ctx.removeReplicaFromTheList(delReplica);
        for (OidReplica tempReplica : this.m_multimasterReplicas) {
            tempReplica.modifyEntry(this.m_agreementDN, 3, newAttrs);
        }
    }

    @Override
    public boolean updateChanges() throws OidReplException {
        String replID;
        String connType;
        String agrmtType;
        String agrmtName;
        String hiqSchd;
        String msg = null;
        if (!this.m_isRecordChange) {
            logger.error("Not in Record mode. updateChanges() cannot be called.", new Object[0]);
            return false;
        }
        logger.dump("Updating changes of fanout replication agreement {0}.", this.m_agreementDN);
        Vector<ModificationItem> mItems = new Vector<ModificationItem>();
        String updSchd = (String)this.m_modifiedItems.get("orclupdateschedule");
        if (updSchd != null) {
            mItems.add(OidReplUtil.CreateModItem("orclupdateschedule", this.m_updateSchedule, 2));
        }
        if ((hiqSchd = (String)this.m_modifiedItems.get("orclhiqschedule")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclhiqschedule", this.m_hiqSchedule, 2));
        }
        if ((agrmtName = (String)this.m_modifiedItems.get("orclagreementname")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclagreementname", this.m_agreementName, 2));
        }
        if ((agrmtType = (String)this.m_modifiedItems.get("orclagreementtype")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclagreementtype", this.m_agreementType.toString(), 2));
        }
        if ((connType = (String)this.m_modifiedItems.get("orclldapconnkeepalive")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclldapconnkeepalive", this.m_connKeepAlive ? "1" : "0", 2));
        }
        if ((replID = (String)this.m_modifiedItems.get("orclreplicationid")) != null) {
            mItems.add(OidReplUtil.CreateModItem("orclreplicationid", this.m_orclReplicationID, 2));
        }
        ModificationItem[] modItems = new ModificationItem[mItems.size()];
        modItems = mItems.toArray(modItems);
        String url = "";
        try {
            for (OidReplica replica : this.m_multimasterReplicas) {
                LdapContext ctx = replica.getDirContext();
                url = (String)ctx.getEnvironment().get("java.naming.provider.url");
                logger.dump("Applying naming context change at {0}", url);
                if (modItems.length > 0) {
                    ctx.modifyAttributes(this.m_agreementDN, modItems);
                }
                for (OidReplNamingContext newCtx : this.m_newNamingContexts) {
                    replica.createNamingContextEntry(this.m_agreementDN, newCtx, null);
                }
                for (OidReplNamingContext delCtx : this.m_removedNamingContexts) {
                    replica.deleteEntry(delCtx.getIncludedNamingCtxDN(), true);
                }
            }
        }
        catch (NamingException ne) {
            msg = this.m_replContext.getString(10L, this.m_agreementDN, url == null ? "NULL" : url);
            logger.error(msg, ne);
            super.clearChanges();
            throw new OidReplException(msg, ne);
        }
        this.m_modifiedItems.clear();
        this.m_isRecordChange = false;
        return true;
    }

    @Override
    public List<String> validate() throws OidReplException {
        LdapContext ctx = null;
        String msg = null;
        String replID = null;
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<LdapContext> ctxList = new ArrayList<LdapContext>();
        if (this.m_multimasterReplicas.size() < 2) {
            msg = this.m_replContext.getString(14L, new Object[0]);
            logger.error(msg, new Object[0]);
            messages.add(msg);
        }
        if (this.m_agreementName == null || this.m_agreementName.trim().equals("")) {
            msg = this.m_replContext.getString(38L, new Object[0]);
            logger.error(msg, new Object[0]);
            messages.add(msg);
        } else {
            List<? extends OidReplAgreement> agrmts = this.m_replContext.getAgreements();
            for (OidReplAgreement oidReplAgreement : agrmts) {
                if (!oidReplAgreement.getAgreementName().trim().equalsIgnoreCase(this.m_agreementName.trim())) continue;
                msg = this.m_replContext.getString(39L, this.m_agreementName, oidReplAgreement.getAgreementDN());
                logger.error(msg, new Object[0]);
                messages.add(msg);
                break;
            }
        }
        for (OidReplica replica : this.m_multimasterReplicas) {
            try {
                ctx = replica.getDirContext();
                ctxList.add(ctx);
            }
            catch (OidReplException oidReplException) {
                messages.add(oidReplException.getMessage());
            }
        }
        if (this.m_multimasterReplicas.size() > ctxList.size()) {
            return messages;
        }
        for (OidReplica replica : this.m_multimasterReplicas) {
            try {
                replica.setReplicaID();
            }
            catch (OidReplException oidReplException) {
                messages.add(oidReplException.getLocalizedMessage());
            }
            if ((replID = replica.getReplicaID()) != null) continue;
            messages.add(this.m_replContext.getString(11L, replica.getHost(), replica.getPort()));
        }
        if (messages.size() > 0) {
            return messages;
        }
        for (OidReplica replica : this.m_multimasterReplicas) {
            replID = replica.getReplicaID();
            for (OidReplica innerReplica : this.m_multimasterReplicas) {
                String iReplID;
                if (replica == innerReplica || !(iReplID = innerReplica.getReplicaID()).equalsIgnoreCase(replID)) continue;
                msg = this.m_replContext.getString(41L, iReplID);
                messages.add(msg);
                logger.error(msg, new Object[0]);
                return messages;
            }
        }
        SearchControls constraints = new SearchControls();
        for (int count = 0; count < ctxList.size(); ++count) {
            ctx = (LdapContext)ctxList.get(count);
            replID = this.m_multimasterReplicas.get(count).getReplicaID();
            try {
                constraints.setSearchScope(2);
                NamingEnumeration<SearchResult> namingEnumeration = ctx.search("cn=replication configuration", "(objectclass=orclreplagreemententry)", constraints);
                block12: while (namingEnumeration.hasMore()) {
                    NamingEnumeration<?> vals;
                    SearchResult sr = namingEnumeration.next();
                    String agrmntDN = sr.getNameInNamespace();
                    String replid = OidReplUtil.getReplicaIdFromDN(agrmntDN);
                    if (replid.equalsIgnoreCase(replID)) {
                        messages.add(this.m_replContext.getString(12L, replID, agrmntDN));
                        continue;
                    }
                    Attributes atrs = sr.getAttributes();
                    Attribute replicas = OidReplUtil.getRequiredAttribute("orclreplicadn", atrs, true);
                    if (replicas != null) {
                        vals = replicas.getAll();
                        while (vals != null & vals.hasMore()) {
                            replid = OidReplUtil.getReplicaIdFromDN((String)vals.next());
                            if (replid == null || !replid.equalsIgnoreCase(replID)) continue;
                            messages.add(this.m_replContext.getString(12L, replID, agrmntDN));
                            continue block12;
                        }
                        continue;
                    }
                    replicas = OidReplUtil.getRequiredAttribute("orcldirreplgroupdsas", atrs, true);
                    if (replicas == null) continue;
                    vals = replicas.getAll();
                    while (vals != null & vals.hasMore()) {
                        replid = (String)vals.next();
                        if (replid == null || !replid.equalsIgnoreCase(replID)) continue;
                        messages.add(this.m_replContext.getString(12L, replID, agrmntDN));
                        continue block12;
                    }
                }
                continue;
            }
            catch (NamingException namingException) {
                messages.add(namingException.getMessage());
            }
        }
        if (messages.size() > 0) {
            return messages;
        }
        return null;
    }

    public void validateNewMultimasterReplica(OidReplica newReplica) throws OidReplException {
        LdapContext ldapCtx = null;
        Vector<String> messages = new Vector<String>();
        String msg = null;
        String newReplicaID = null;
        String newReplicaHost = newReplica.getHost();
        int newReplicaPort = newReplica.getPort();
        newReplica.setReplicaID();
        newReplicaID = newReplica.getReplicaID();
        if (newReplicaID == null) {
            msg = this.m_replContext.getString(11L, newReplicaHost, String.valueOf(newReplicaPort));
            throw new OidReplException(msg);
        }
        if (this.isPartOfThisAgreement(newReplica)) {
            msg = this.m_replContext.getString(3L, newReplicaID);
            logger.error(msg, new Object[0]);
            throw new OidReplException(msg);
        }
        ldapCtx = newReplica.getDirContext();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            NamingEnumeration<SearchResult> res = ldapCtx.search("cn=replication configuration", "(objectclass=orclreplagreemententry)", constraints);
            block2: while (res.hasMore()) {
                NamingEnumeration<?> vals;
                SearchResult sr = res.next();
                String agrmntDN = sr.getNameInNamespace();
                Attributes atrs = sr.getAttributes();
                String agrmtType = OidReplUtil.getAttrValue("orclagreementtype", atrs, true);
                String replid = OidReplUtil.getReplicaIdFromDN(agrmntDN);
                if (replid.equalsIgnoreCase(newReplicaID) && agrmtType != null && agrmtType.equals("2")) {
                    messages.add(this.m_replContext.getString(12L, newReplicaID, agrmntDN));
                    throw new OidReplException(msg);
                }
                Attribute replicas = OidReplUtil.getRequiredAttribute("orclreplicadn", atrs, true);
                if (replicas != null) {
                    vals = replicas.getAll();
                    while (vals != null & vals.hasMore()) {
                        replid = OidReplUtil.getReplicaIdFromDN((String)vals.next());
                        if (replid == null || !replid.equalsIgnoreCase(newReplicaID)) continue;
                        messages.add(this.m_replContext.getString(12L, newReplicaID, agrmntDN));
                        continue block2;
                    }
                    continue;
                }
                replicas = OidReplUtil.getRequiredAttribute("orcldirreplgroupdsas", atrs, true);
                if (replicas == null) continue;
                vals = replicas.getAll();
                while (vals != null & vals.hasMore()) {
                    replid = ((String)vals.next()).trim();
                    if (replid == null || !replid.equalsIgnoreCase(newReplicaID)) continue;
                    msg = this.m_replContext.getString(12L, newReplicaID, agrmntDN);
                    logger.error(msg, new Object[0]);
                    throw new OidReplException(msg);
                }
            }
        }
        catch (NamingException ne) {
            msg = this.m_replContext.getString(19L, newReplicaHost, String.valueOf(newReplicaPort), "cn=replication configuration");
            logger.error(msg, ne);
            throw new OidReplException(msg, ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNamingContextEntries() throws OidReplException {
        int count = 0;
        Vector nctxs = new Vector(this.m_namingContexts.values());
        this.m_primary.createNamingContextContainerEntry(this.m_agreementDN);
        logger.dump("Creating naming context entries for {0} at ldap://{1}:{2}", this.m_agreementDN, this.m_primary.getHost(), this.m_primary.getPort());
        try {
            for (OidReplNamingContext ctx : nctxs) {
                ++count;
                this.m_primary.createNamingContextEntry(this.m_agreementDN, ctx, null);
            }
        }
        finally {
            nctxs.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.m_multimasterReplicas != null) {
            this.m_multimasterReplicas.clear();
        }
        this.m_multimasterReplicas = null;
        this.m_primary = null;
    }
}

