/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import oracle.jldif.util.XLIFFParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LDIF2XLIFConvertorTool
extends Task {
    private String m_property;
    private String m_ldifFile;
    private String m_XlifFile;
    private String m_TranslatablesFile;

    public void setProperty(String inProperty) {
        this.m_property = inProperty;
    }

    public void setLdifFile(String inLdifFile) {
        this.m_ldifFile = inLdifFile;
    }

    public void setXlifFile(String inXlifFile) {
        this.m_XlifFile = inXlifFile;
    }

    public void setTranslatablesFile(String inTranslatablesFile) {
        this.m_TranslatablesFile = inTranslatablesFile;
    }

    public void execute() throws BuildException {
        if (this.m_property == null) {
            throw new BuildException("Error: No property name");
        }
        if (this.m_ldifFile == null) {
            throw new BuildException("Error: No Ldif File Specified");
        }
        if (this.m_XlifFile == null) {
            throw new BuildException("Error: No Xlif File Specified");
        }
        if (this.m_TranslatablesFile == null) {
            throw new BuildException("Error: No Translatable Elements Specified");
        }
        String retVal = null;
        try {
            this.generateXlifFile(this.m_ldifFile, this.m_XlifFile, this.m_TranslatablesFile);
            retVal = "Generation Process Completed";
        }
        catch (Exception e) {
            retVal = "Error Generating the XLIFF File";
            throw new BuildException(retVal + e.getMessage());
        }
        finally {
            if (retVal != null) {
                this.getProject().setNewProperty(this.m_property, retVal);
            }
        }
    }

    private void generateXlifFile(String ldifFile, String xlifFile, String translatablesFile) throws Exception {
        XLIFFParser xlif = new XLIFFParser();
        String[] translatables = xlif.getTranslatableElems(translatablesFile);
        xlif.convertLDIF2XLF(ldifFile, xlifFile, translatables);
    }
}

