/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtil {
    public static InitialLdapContext getSSLDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        return ConnectionUtil.getSSLDirCtx(host, port, bindDN, bindPwd, "oracle.jldif.util.CustomSSLFactory");
    }

    public static InitialLdapContext getSSLDirCtx(String host, String port, String bindDN, String bindPwd, String sslSocketFactory) throws NamingException {
        Hashtable<String, String> hashtable = ConnectionUtil.createCtxHash(host, port, bindDN, bindPwd);
        hashtable.put("java.naming.ldap.factory.socket", sslSocketFactory);
        hashtable.put("java.naming.security.protocol", "ssl");
        Thread.currentThread().setContextClassLoader(ConnectionUtil.class.getClassLoader());
        int i = 0;
        while (true) {
            ++i;
            try {
                return new InitialLdapContext(hashtable, null);
            }
            catch (NamingException ne) {
                Throwable t;
                if (((t = ne.getRootCause()) instanceof SSLHandshakeException || t instanceof SSLException) && i <= 2) continue;
                throw ne;
            }
            break;
        }
    }

    public static InitialLdapContext getNonSSLDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        Hashtable<String, String> hashtable = ConnectionUtil.createCtxHash(host, port, bindDN, bindPwd);
        Thread.currentThread().setContextClassLoader(ConnectionUtil.class.getClassLoader());
        return new InitialLdapContext(hashtable, null);
    }

    private static Hashtable<String, String> createCtxHash(String host, String port, String bindDN, String bindPwd) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("java.naming.") || System.getProperty(key).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(key, System.getProperty(key));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        } else if (((String)hashtable.get("java.naming.factory.initial")).equals("weblogic.jndi.WLInitialContextFactory")) {
            hashtable.remove("java.naming.factory.initial");
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", bindDN);
        hashtable.put("java.naming.security.credentials", bindPwd);
        hashtable.put("java.naming.referral", "follow");
        return hashtable;
    }
}

