/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.tocNavigator.MergingTopicTreeNode;
import oracle.help.common.navigator.tocNavigator.TOCUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.tocNavigator.TOCItemFactory;

public class TOCNavigator
extends Navigator {
    private static String TYPE_TOCNAVIGATOR = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String DEFAULT_LABEL_ID = "navigator.tocNavigator.default_label";
    private TopicTreePane _treePane;
    private MergingTopicTreeNode _rootTopicTreeNode;

    public void initNavigator(View[] viewArray) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 1, 1, 1));
        this._rootTopicTreeNode = new MergingTopicTreeNode(viewArray);
        TopicTreeComponent topicTreeComponent = new TopicTreeComponent((TopicTreeNode)this._rootTopicTreeNode, TOCItemFactory.getInstance());
        this._treePane = new TopicTreePane(topicTreeComponent);
        this.add(this._treePane);
        this.addTopicTreeListener(this._treePane);
    }

    public String getDefaultLabel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string = resourceBundle.getString(DEFAULT_LABEL_ID);
        return string;
    }

    public Topic getCurrentSelection() {
        TopicTreeItem topicTreeItem = this._treePane.getSelectedItem();
        return topicTreeItem == null ? null : topicTreeItem.getTopic();
    }

    public TopicTreeNode getCurrentSelectionNode() {
        TopicTreeItem topicTreeItem = this._treePane.getSelectedItem();
        return topicTreeItem == null ? null : topicTreeItem.getTopicTreeNode();
    }

    public void addView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._rootTopicTreeNode.addView(view);
        }
    }

    public void removeView(View view) {
        if (view != null && view.getType().equals(TYPE_TOCNAVIGATOR)) {
            this._rootTopicTreeNode.removeView(view);
        }
    }

    public void printNavigator() {
        try {
            PrinterUtils.print((JComponent)((Object)this._treePane.getTopicTreeComponent()), null, (boolean)false, (Frame)WindowUtils.parentFrame((Component)this), (String)"OHJ Table of Contents", null, null, null, (double)1.0, (double)1.0, (double)1.0, (double)1.0);
        }
        catch (Exception exception) {
            System.err.println("Error printing Navigator");
        }
    }

    public boolean selectMatchingTopic(URL uRL) {
        TopicTreeNode topicTreeNode = this.getCurrentSelectionNode();
        List list = this._rootTopicTreeNode.getContributingViews();
        TopicTreeNode topicTreeNode2 = TOCUtils.findClosestMatchingNode((TopicTreeNode)topicTreeNode, (URL)uRL, (List)list);
        return this._treePane.selectTopicTreeNode(topicTreeNode2);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this._treePane.getTopicTreeComponent().setVisible(bl);
    }

    protected void addTopicTreeListener(TopicTreePane topicTreePane) {
        topicTreePane.addTopicTreeListener(new TreePaneListener());
    }

    protected final TopicTreePane getTopicTreePane() {
        return this._treePane;
    }

    protected final MergingTopicTreeNode getRootNode() {
        return this._rootTopicTreeNode;
    }

    private class TreePaneListener
    implements TopicTreeListener {
        private TreePaneListener() {
        }

        public void topicActivated(TopicTreeItem topicTreeItem, boolean bl) {
            int n = bl ? 2 : 1;
            TOCNavigator.this.fireTopicActivated(topicTreeItem.getTopic(), n);
        }

        public void topicSelected(TopicTreeItem topicTreeItem) {
            Topic topic = topicTreeItem == null ? null : topicTreeItem.getTopic();
            TOCNavigator.this.fireTopicSelected(topic);
        }

        public void popupDisplayed(TopicTreeItem topicTreeItem, JPopupMenu jPopupMenu) {
            Topic topic = topicTreeItem.getTopic();
            if (topic != null && topic.hasTarget()) {
                String string = MenuUtils.getDefaultMenuLabel("menu.Display_New");
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setAction(new DisplayInNewWindowAction(topicTreeItem));
                MenuUtils.setMenuAttributes(jMenuItem, string, true);
                jMenuItem.setActionCommand(string);
                jPopupMenu.add(jMenuItem);
            }
        }

        private class DisplayInNewWindowAction
        extends AbstractAction {
            private TopicTreeItem _item;

            public DisplayInNewWindowAction(TopicTreeItem topicTreeItem) {
                this._item = topicTreeItem;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TOCNavigator.this.fireTopicActivated(this._item.getTopic(), 2);
            }
        }
    }
}

