/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.searchNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.BooleanExpression;
import oracle.help.common.search.QueryStringBreaker;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;

public class SearchNavigator
extends LazyNavigator
implements ItemListener,
ActionListener {
    private static int BORDER_SIZE = 10;
    private static int SPACE_SIZE = BORDER_SIZE / 2;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String TYPE_SEARCH_NAVIGATOR = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static String DEFAULT_LABEL_ID = "navigator.searchNavigator.default_label";
    private static final int SEARCH_ALL_WORDS = 0;
    private static final int SEARCH_ANY_WORDS = 1;
    private static final int SEARCH_BOOLEAN = 2;
    private JComboBox _searchField;
    private JButton _searchButton;
    private JRadioButton _allRadio;
    private JRadioButton _anyRadio;
    private JRadioButton _booleanRadio;
    private JCheckBox _caseCheck;
    private JButton _openButton;
    private JLabel _status;
    private static String _inProgress;
    private static String _foundtopics;
    private static String _failed;
    private static String _searching;
    private static String _stopSearch;
    private SpreadTable _resultTable;
    private ResultTableSelectionListener _selectionListener;
    private SearchModel _searchModel;
    private SearchHistoryModel _searchHistory;
    private ArrayList _queryHandlers;
    private boolean _doingSearch;
    private boolean _showOpenButton = true;

    public Topic getCurrentSelection() {
        if (this._selectionListener != null) {
            return this._selectionListener.getSelectedTopic();
        }
        return null;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            // empty if block
        }
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            if (actionEvent.getSource() == this._openButton) {
                Topic topic = this._selectionListener.getSelectedTopic();
                if (topic != null) {
                    this.fireTopicActivated(topic);
                }
            } else {
                Object object = this;
                synchronized (object) {
                    if (this._doingSearch) {
                        return;
                    }
                    this._doingSearch = true;
                }
                object = null;
                Object object2 = this._searchField.getEditor().getItem();
                if (object2 != null) {
                    object = object2.toString();
                }
                int n = 0;
                if (this._anyRadio.isSelected()) {
                    n = 1;
                } else if (this._booleanRadio.isSelected()) {
                    n = 2;
                }
                if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                    UserQuery userQuery = new UserQuery((String)object, n, this._caseCheck.isSelected());
                    this._searchHistory.addQuery(userQuery);
                    this._searchField.setSelectedIndex(0);
                    WindowUtils.parentFrame((Component)this).setCursor(Cursor.getPredefinedCursor(3));
                    this._status.setText(_inProgress);
                    this._status.invalidate();
                    SearchWorker searchWorker = new SearchWorker(WindowUtils.parentFrame((Component)this), userQuery);
                    searchWorker.setVisible(true);
                    WindowUtils.parentFrame((Component)this).setCursor(Cursor.getPredefinedCursor(0));
                    int n2 = ((OHJSearchModelData)this._searchModel.getSearchModelData()).getRowCount();
                    if (n2 > 0) {
                        int n3 = _foundtopics.indexOf("%d");
                        this._status.setText(_foundtopics.substring(0, n3) + n2 + _foundtopics.substring(n3 + 2));
                        try {
                            Grid grid = this._resultTable.getGrid();
                            grid.setSelection(new TwoDSelection(0, true));
                        }
                        catch (Exception exception) {}
                    } else {
                        this._status.setText(_failed);
                    }
                    this._status.invalidate();
                }
                this._doingSearch = false;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        UserQuery userQuery;
        int n;
        if (itemEvent != null && itemEvent.getStateChange() == 1 && (n = this._searchField.getSelectedIndex()) != -1 && (userQuery = this._searchHistory.getQuery(n)) != null) {
            this._caseCheck.setSelected(userQuery.getCaseSensitive());
            this._allRadio.setSelected(userQuery.getSearchType() == 0);
            this._anyRadio.setSelected(userQuery.getSearchType() == 1);
            this._booleanRadio.setSelected(userQuery.getSearchType() == 2);
        }
    }

    public String getDefaultLabel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string = resourceBundle.getString(DEFAULT_LABEL_ID);
        return string;
    }

    public void showOpenButton(boolean bl) {
        this._showOpenButton = bl;
    }

    protected void doInitializationNow() {
        this._searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), this.getInitialViewsArray());
        ((OHJSearchModelData)this._searchModel.getSearchModelData()).addModelListener((TwoDModelListener)new ResultTableDataListener());
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(SPACE_SIZE, BORDER_SIZE));
        jPanel.setBorder(new EmptyBorder(BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        this._searchField = new JComboBox();
        this._searchHistory = new SearchHistoryModel();
        this._searchField.setModel(this._searchHistory);
        this._searchField.addItemListener(this);
        this._searchField.setEditable(true);
        this._searchField.getEditor().addActionListener(this);
        JLabel jLabel = MnemonicUtils.createLabel(resourceBundle.getString("navigator.searchNavigator.fieldlabel"), this._searchField.getEditor().getEditorComponent());
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)this._searchField, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        this._searchButton = MnemonicUtils.createButton(resourceBundle.getString("navigator.searchNavigator.search"));
        this._searchButton.addActionListener(this);
        jPanel2.add((Component)this._searchButton, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this._caseCheck = MnemonicUtils.createCheckBox(resourceBundle.getString("navigator.searchNavigator.casesensitive"));
        jPanel2.add((Component)this._caseCheck, gridBagConstraints);
        jLabel = MnemonicUtils.createLabel(resourceBundle.getString("navigator.searchNavigator.searchfor"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._allRadio = MnemonicUtils.createRadioButton(resourceBundle.getString("navigator.searchNavigator.allwords"), true);
        this._anyRadio = MnemonicUtils.createRadioButton(resourceBundle.getString("navigator.searchNavigator.anyword"), false);
        this._booleanRadio = MnemonicUtils.createRadioButton(resourceBundle.getString("navigator.searchNavigator.boolean"), false);
        buttonGroup.add(this._allRadio);
        buttonGroup.add(this._anyRadio);
        buttonGroup.add(this._booleanRadio);
        jPanel2.add((Component)this._allRadio, gridBagConstraints);
        jPanel2.add((Component)this._anyRadio, gridBagConstraints);
        jPanel2.add((Component)this._booleanRadio, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, SPACE_SIZE));
        jPanel3.add((Component)this._createResultsList(resourceBundle), "Center");
        jLabel = MnemonicUtils.createLabel(resourceBundle.getString("navigator.searchNavigator.selectinfo"), (Component)this._resultTable);
        jPanel3.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(SPACE_SIZE, 0));
        this._status = MnemonicUtils.createLabel("");
        jPanel4.add((Component)this._status, "Center");
        this._openButton = MnemonicUtils.createButton(resourceBundle.getString("navigator.searchNavigator.openbutton"));
        this._openButton.setEnabled(false);
        this._openButton.addActionListener(this);
        if (this._showOpenButton) {
            jPanel4.add((Component)this._openButton, "East");
        }
        jPanel.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "Center");
        this.validate();
        _inProgress = resourceBundle.getString("navigator.searchNavigator.inprogress");
        _failed = resourceBundle.getString("navigator.searchNavigator.searchfailed");
        _foundtopics = resourceBundle.getString("navigator.searchNavigator.foundtopics");
        _searching = resourceBundle.getString("navigator.searchNavigator.searching");
        _stopSearch = resourceBundle.getString("navigator.searchNavigator.stopsearch");
        this._doingSearch = false;
    }

    protected void addViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_SEARCH_NAVIGATOR)) {
            this._searchModel.addView(view);
        }
    }

    protected void removeViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_SEARCH_NAVIGATOR)) {
            this._searchModel.removeView(view);
            this._resultTable.getGrid().setCanvasOrigin(0, 0);
        }
    }

    private JComponent _createResultsList(ResourceBundle resourceBundle) {
        Object[] objectArray = new String[]{resourceBundle.getString("navigator.searchNavigator.rank"), resourceBundle.getString("navigator.searchNavigator.topictitle"), resourceBundle.getString("navigator.searchNavigator.source")};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        this._resultTable = new SpreadTable((TwoDModel)((OHJSearchModelData)this._searchModel.getSearchModelData()), (OneDModel)arrayOneDModel, null);
        this._resultTable.setHorizontalSeparatorsVisible(false);
        this._resultTable.setVerticalSeparatorsVisible(false);
        this._resultTable.setScrollByRow(true);
        Header header = this._resultTable.getColumnHeader();
        header.setCanMoveItems(false);
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)((OHJSearchModelData)this._searchModel.getSearchModelData()));
        Grid grid = this._resultTable.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
        grid.setPreferredRowsOnScreen(4);
        grid.setColumnPainter(0, (Painter)new ImagePainter(0));
        grid.setColumnPainter(1, (Painter)new TextPainter());
        grid.setDefaultInputHandler((CellInputHandler)new ResultTableInputHandler());
        TableResizer tableResizer = new TableResizer();
        this._resultTable.addResizeListener((TableResizeListener)tableResizer);
        this._resultTable.setColumnWidth(0, 100);
        this._resultTable.setColumnWidth(1, 150);
        this._resultTable.setColumnWidth(2, 100);
        this._selectionListener = new ResultTableSelectionListener();
        this._resultTable.addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
        JScrollPane jScrollPane = new JScrollPane((Component)this._resultTable, 22, 31);
        jScrollPane.addComponentListener(tableResizer);
        return jScrollPane;
    }

    private class SearchWorker
    extends JDialog
    implements Runnable,
    ActionListener {
        private boolean _done;
        private Thread _t;
        private Frame _parent;
        private JLabel _status;
        private JButton _stopButton;
        private Thread _thread;
        private UserQuery _query;

        public SearchWorker(Frame frame, UserQuery userQuery) {
            super(frame, _searching, true);
            this.getContentPane().setLayout(new BorderLayout());
            this._parent = frame;
            this._status = new JLabel(_inProgress, 0);
            this._query = userQuery;
            this.getContentPane().add((Component)this._status, "Center");
            DialogButtonBar dialogButtonBar = new DialogButtonBar();
            this._stopButton = MnemonicUtils.createButton(_stopSearch);
            this._stopButton.addActionListener(this);
            dialogButtonBar.add((Component)this._stopButton);
            this.getContentPane().add((Component)dialogButtonBar, "South");
            this.pack();
            Dimension dimension = this.getSize();
            dimension.width += BORDER_SIZE;
            dimension.height += BORDER_SIZE;
            this.setSize(dimension.width, dimension.height);
            Window window = WindowUtils.getWindow((Component)SearchNavigator.this);
            Point point = window.getLocationOnScreen();
            Dimension dimension2 = window.getSize();
            this.setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
            this.setResizable(false);
            this._thread = new Thread((Runnable)this, "Searching Thread");
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this._done = false;
                this._thread.start();
                if (!this._done) {
                    super.setVisible(true);
                }
            }
            super.setVisible(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block17: {
                try {
                    this.wait(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._query != null) {
                    if (this._query.getSearchType() != 2) {
                        boolean bl = this._query.getSearchType() == 0;
                        ArrayList arrayList = new ArrayList();
                        QueryStringBreaker.breakQueryString((String)this._query.getQueryText(), (Locale)StaticLocaleContext.getLocale(), arrayList, (boolean)this._query.getCaseSensitive());
                        String[] stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                        SearchNavigator.this._resultTable.freezeRepaints();
                        try {
                            SearchNavigator.this._searchModel.startSearch(stringArray, bl, this._query.getCaseSensitive());
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            SearchNavigator.this._resultTable.unfreezeRepaints();
                        }
                    } else {
                        try {
                            SearchExpression searchExpression = BooleanExpression.buildExpressionTree((String)this._query.getQueryText(), (boolean)this._query.getCaseSensitive());
                            if (searchExpression == null) break block17;
                            SearchNavigator.this._resultTable.freezeRepaints();
                            try {
                                SearchNavigator.this._searchModel.startSearch(searchExpression);
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                SearchNavigator.this._resultTable.unfreezeRepaints();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this._done = true;
            this.dispose();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent != null && actionEvent.getSource() == this._stopButton) {
                SearchNavigator.this._searchModel.stopSearch();
            }
        }
    }

    private class ResultTableInputHandler
    extends CellInputHandler {
        public void mouseClicked(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (mouseEvent.getClickCount() > 1) {
                ActionEvent actionEvent = new ActionEvent(SearchNavigator.this._openButton, 1001, "");
                SearchNavigator.this.actionPerformed(actionEvent);
            }
            super.mouseClicked(mouseEvent, grid, n, n2);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            if (keyEvent != null) {
                if (keyEvent.getKeyCode() == 10) {
                    ActionEvent actionEvent = new ActionEvent(SearchNavigator.this._openButton, 1001, "");
                    SearchNavigator.this.actionPerformed(actionEvent);
                    keyEvent.consume();
                }
                super.keyPressed(keyEvent, grid, n, n2);
            }
        }
    }

    private class ResultTableDataListener
    extends TwoDModelAdapter {
        private ResultTableDataListener() {
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            if (twoDModelEvent != null) {
                int n = SearchNavigator.this._selectionListener.getSelectedRowIndex();
                int n2 = twoDModelEvent.getRowStartIndex();
                int n3 = twoDModelEvent.getRowCount();
                if (n2 <= n && n2 + n3 > n) {
                    SearchNavigator.this._selectionListener.clearSelection();
                }
            }
        }
    }

    private class ResultTableSelectionListener
    implements PropertyChangeListener {
        private int _selectedRow = -1;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() == "selection") {
                TwoDSelection twoDSelection = SearchNavigator.this._resultTable.getSelection();
                this._selectedRow = twoDSelection != null ? twoDSelection.getSingleRow() : -1;
                if (this._selectedRow != -1) {
                    SearchNavigator.this._openButton.setEnabled(true);
                } else {
                    SearchNavigator.this._openButton.setEnabled(false);
                }
                SearchNavigator.this.fireTopicSelected(SearchNavigator.this.getCurrentSelection());
            }
        }

        public Topic getSelectedTopic() {
            if (this._selectedRow != -1) {
                return SearchNavigator.this._searchModel.getTopicForRow(this._selectedRow);
            }
            return null;
        }

        public int getSelectedRowIndex() {
            return this._selectedRow;
        }

        public void clearSelection() {
            SearchNavigator.this._openButton.setEnabled(false);
            this._selectedRow = -1;
            SearchNavigator.this.fireTopicSelected(null);
        }
    }

    private class TableResizer
    extends ComponentAdapter
    implements TableResizeListener {
        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = SearchNavigator.this._resultTable.getParent().getSize();
            int n = (int)(0.14 * (double)dimension.width);
            int n2 = (int)(0.61 * (double)dimension.width);
            int n3 = dimension.width - n - n2;
            SearchNavigator.this._resultTable.setColumnWidth(0, n);
            SearchNavigator.this._resultTable.setColumnWidth(1, n2);
            SearchNavigator.this._resultTable.setColumnWidth(2, n3);
        }

        public void columnResizing(TableEvent tableEvent) {
        }

        public void columnResized(TableEvent tableEvent) {
            if (tableEvent != null) {
                Dimension dimension = SearchNavigator.this._resultTable.getSize();
                int n = SearchNavigator.this._resultTable.getColumnWidth(0);
                int n2 = SearchNavigator.this._resultTable.getColumnWidth(1);
                int n3 = dimension.width - n - n2;
                SearchNavigator.this._resultTable.setColumnWidth(2, n3);
            }
        }

        public void rowResizing(TableEvent tableEvent) {
        }

        public void rowResized(TableEvent tableEvent) {
        }
    }

    private class SearchHistoryModel
    extends DefaultComboBoxModel {
        SearchHistoryModel() {
        }

        void addQuery(UserQuery userQuery) {
            if (userQuery != null) {
                int n = super.getIndexOf(userQuery);
                super.insertElementAt(userQuery, 0);
                if (n >= 0) {
                    super.removeElementAt(n + 1);
                }
            }
        }

        UserQuery getQuery(int n) {
            UserQuery userQuery = null;
            try {
                userQuery = (UserQuery)super.getElementAt(n);
            }
            catch (Exception exception) {
                userQuery = null;
            }
            return userQuery;
        }
    }

    private class UserQuery {
        private String _queryText;
        private int _searchType;
        private boolean _caseSensitive;

        UserQuery(String string, int n, boolean bl) {
            this._queryText = string;
            this._searchType = n;
            this._caseSensitive = bl;
        }

        String getQueryText() {
            return this._queryText;
        }

        int getSearchType() {
            return this._searchType;
        }

        boolean getCaseSensitive() {
            return this._caseSensitive;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            try {
                UserQuery userQuery = (UserQuery)object;
                if (this._queryText.equals(userQuery._queryText) && this._searchType == userQuery._searchType && this._caseSensitive == userQuery._caseSensitive) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return this._queryText;
        }
    }
}

