/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;

public class FavoritesNavigator
extends LazyNavigator {
    private static final String _DEFAULT_LABEL_ID = "addfavoriteitem.favorites";
    private static final String _DELETE_KEY = "addfavoriteitem.delete";
    private static final String _RENAME_DOT = "addfavoriteitem.renamedot";
    private static final String _NEW_FOLDER_DOT = "addfavoriteitem.newfolderdot";
    private static ResourceBundle _miscBundle;
    private FavoritesModel _favoritesModel;
    private TopicTreePane _treePane;

    public FavoritesNavigator() {
        _miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
    }

    public String getDefaultLabel() {
        String string = _miscBundle.getString(_DEFAULT_LABEL_ID);
        return string;
    }

    public void addViewNow(View view) {
    }

    public void removeViewNow(View view) {
    }

    public void setFavoritesModel(FavoritesModel favoritesModel) {
        this._favoritesModel = favoritesModel;
    }

    public TopicTreeNode getCurrentSelectionNode() {
        TopicTreeItem topicTreeItem;
        if (this._treePane != null && (topicTreeItem = this._treePane.getSelectedItem()) != null) {
            return topicTreeItem.getTopicTreeNode();
        }
        return null;
    }

    public Topic getCurrentSelection() {
        TopicTreeItem topicTreeItem;
        if (this._treePane != null && (topicTreeItem = this._treePane.getSelectedItem()) != null) {
            return topicTreeItem.getTopic();
        }
        return null;
    }

    public void addTopicTreeListener(TopicTreeListener topicTreeListener) {
        this._treePane.addTopicTreeListener(topicTreeListener);
    }

    public void removeTopicTreeListener(TopicTreeListener topicTreeListener) {
        this._treePane.removeTopicTreeListener(topicTreeListener);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this._treePane != null) {
            this._treePane.getTopicTreeComponent().setVisible(bl);
        }
    }

    protected void doInitializationNow() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 1, 1, 1));
        TopicTreeNode topicTreeNode = this.getFavoritesModel().getFavoritesRoot().getParent();
        TopicTreeComponent topicTreeComponent = new TopicTreeComponent(topicTreeNode, new FavoriteItemFactory(this.getFavoritesModel()));
        topicTreeComponent.setPreferredItemsOnScreen(10);
        this._treePane = new TopicTreePane(topicTreeComponent);
        this._treePane.addTopicTreeListener(new TreePaneListener());
        this.add(this._treePane);
    }

    protected FavoritesModel getFavoritesModel() {
        return this._favoritesModel;
    }

    private class TreePaneListener
    implements TopicTreeListener,
    ActionListener {
        private JMenuItem _deleteMenuItem;
        private JMenuItem _renameMenuItem;
        private JMenuItem _newFolderMenuItem;
        private TopicTreeNode _node;

        private TreePaneListener() {
        }

        public void topicActivated(TopicTreeItem topicTreeItem, boolean bl) {
            int n = bl ? 2 : 1;
            FavoritesNavigator.this.fireTopicActivated(topicTreeItem.getTopic(), n);
        }

        public void topicSelected(TopicTreeItem topicTreeItem) {
            Topic topic = topicTreeItem == null ? null : topicTreeItem.getTopic();
            FavoritesNavigator.this.fireTopicSelected(topic);
        }

        public void popupDisplayed(TopicTreeItem topicTreeItem, JPopupMenu jPopupMenu) {
            Object object;
            String string;
            Object object2;
            this._node = topicTreeItem.getTopicTreeNode();
            if (this._node != FavoritesNavigator.this._favoritesModel.getFavoritesRoot() && (object2 = topicTreeItem.getTopic()) != null && object2.hasTarget()) {
                string = MenuUtils.getDefaultMenuLabel("menu.Display_New");
                object = new JMenuItem(string);
                ((AbstractButton)object).setAction(new DisplayInNewWindowAction(topicTreeItem));
                MenuUtils.setMenuAttributes((JMenuItem)object, string, true);
                ((AbstractButton)object).setActionCommand(string);
                jPopupMenu.add((JMenuItem)object);
                jPopupMenu.add(new JPopupMenu.Separator());
            }
            object2 = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._NEW_FOLDER_DOT));
            this._newFolderMenuItem = new JMenuItem((String)object2);
            MenuUtils.setMenuAttributes(this._newFolderMenuItem, (String)object2, true);
            this._newFolderMenuItem.setActionCommand((String)object2);
            this._newFolderMenuItem.addActionListener(this);
            jPopupMenu.add(this._newFolderMenuItem);
            if (this._node != FavoritesNavigator.this._favoritesModel.getFavoritesRoot()) {
                string = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._RENAME_DOT));
                this._renameMenuItem = new JMenuItem(string);
                MenuUtils.setMenuAttributes(this._renameMenuItem, string, true);
                this._renameMenuItem.setActionCommand(string);
                this._renameMenuItem.addActionListener(this);
                jPopupMenu.add(this._renameMenuItem);
                object = StringUtils.stripMnemonic((String)_miscBundle.getString(FavoritesNavigator._DELETE_KEY));
                this._deleteMenuItem = new JMenuItem((String)object);
                MenuUtils.setMenuAttributes(this._deleteMenuItem, (String)object, true);
                this._deleteMenuItem.setActionCommand((String)object);
                this._deleteMenuItem.addActionListener(this);
                jPopupMenu.add(this._deleteMenuItem);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._deleteMenuItem) {
                FavoritesNavigator.this._favoritesModel.removeFavoriteItem(this._node);
            } else if (actionEvent.getSource() == this._renameMenuItem) {
                FavoritesActionUtils.renameFavoriteItem(FavoritesNavigator.this, this._node, FavoritesNavigator.this._favoritesModel);
            } else if (actionEvent.getSource() == this._newFolderMenuItem) {
                FavoritesActionUtils.createNewFolder(FavoritesNavigator.this, this._node, FavoritesNavigator.this._favoritesModel);
            }
        }

        private class DisplayInNewWindowAction
        extends AbstractAction {
            private TopicTreeItem _item;

            public DisplayInNewWindowAction(TopicTreeItem topicTreeItem) {
                this._item = topicTreeItem;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesNavigator.this.fireTopicActivated(this._item.getTopic(), 2);
            }
        }
    }
}

