/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JToolBar;
import oracle.help.common.Topic;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;

public class NavigatorToolBar
extends JToolBar
implements NavigatorListener {
    private ArrayList _selectionEnabledItems = new ArrayList();
    private boolean _currentlyEnabled = false;

    public void addItem(Component component, Component component2) {
        this.addItem(component, component2, false);
    }

    public void addItem(Component component, Component component2, boolean bl) {
        if (component != null) {
            int n;
            if (bl) {
                this._selectionEnabledItems.add(component);
                if (this._currentlyEnabled) {
                    component.setEnabled(true);
                } else {
                    component.setEnabled(false);
                }
            }
            int n2 = this.getComponentCount();
            if (component2 != null && (n = this.getComponentIndex(component2)) != -1) {
                n2 = n;
            }
            this.add(component, n2);
        }
    }

    public void enableItemBasedOnSelection(boolean bl, Component component) {
        if (component != null) {
            if (bl) {
                if (!this._selectionEnabledItems.contains(component)) {
                    this._selectionEnabledItems.add(component);
                    if (this._currentlyEnabled) {
                        component.setEnabled(true);
                    } else {
                        component.setEnabled(false);
                    }
                }
            } else if (this._selectionEnabledItems.contains(component)) {
                this._selectionEnabledItems.remove(component);
            }
        }
    }

    public void removeItem(Component component) {
        if (component != null) {
            if (this._selectionEnabledItems.contains(component)) {
                this._selectionEnabledItems.remove(component);
            }
            this.remove(component);
        }
    }

    public void topicSelected(NavigatorEvent navigatorEvent) {
        if (navigatorEvent != null && navigatorEvent.getID() == 2000) {
            Topic topic = navigatorEvent.getTopic();
            boolean bl = false;
            if (topic != null && topic.hasTarget()) {
                bl = true;
            }
            if (this._currentlyEnabled != bl) {
                int n = 0;
                for (n = 0; n < this._selectionEnabledItems.size(); ++n) {
                    Component component = (Component)this._selectionEnabledItems.get(n);
                    component.setEnabled(bl);
                }
            }
            this._currentlyEnabled = bl;
        }
    }

    public void topicActivated(NavigatorEvent navigatorEvent) {
    }
}

