/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSamplingTypeTopN;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSubPanelSamplingSizePercent;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.preferences.CachePIComponentPanelSamplingTypeRandom;
import oracle.dmt.dataminer.workflow.preferences.CachePIComponentPanelSubPanelSamplingSizeRows;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class SamplingPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private JComboBox _jCmbSize;
    private JLabel _jLblSampling;
    private JLabel _jLblSize;
    private JComboBox jCmbSampling;
    private JPanel jPanelSamplingSize;
    private JPanel jPanelSamplingType;
    private boolean _bAdjusting;
    private CardLayout _samplingTypeLayout;
    private CachePIComponentPanelSamplingTypeRandom jPanelSamplingTypeRandom;
    private CachePIComponentPanelSamplingTypeTopN jPanelSamplingTypeTopN;
    private CardLayout _samplingSizeLayout;
    private CachePIComponentPanelSubPanelSamplingSizeRows jPanelSamplingSizeRows;
    private CachePIComponentPanelSubPanelSamplingSizePercent jPanelSamplingSizePercent;
    static String _random = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_RANDOM");
    static String _topN = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_TOPN");
    static String[] _sampling_type = new String[]{_random, _topN};
    static String _num_rows = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_NUMROWS");
    static String _percent = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_PERCENT");
    static String[] _sampling_size = new String[]{_num_rows, _percent};
    private boolean _isRandom;
    private int _seed;
    private boolean _isPercent;
    private long _numberRows;
    private double _samplingPercent;

    public SamplingPanel() {
        this.initComponents();
        this.initRes();
        this.initLayout();
        this.initUI();
    }

    private void initComponents() {
        this._jLblSampling = new JLabel();
        this.jCmbSampling = new JComboBox();
        this.jPanelSamplingType = new JPanel();
        this._jLblSize = new JLabel();
        this._jCmbSize = new JComboBox();
        this.jPanelSamplingSize = new JPanel();
        this._jLblSampling.setText("Sampling Type:");
        this.jCmbSampling.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelSamplingType.setLayout(new CardLayout());
        this._jLblSize.setText("Sampling Size:");
        this._jCmbSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelSamplingSize.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this._jLblSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jCmbSize, -2, 221, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jLblSampling).addGap(18, 18, 18).addComponent(this.jCmbSampling, -2, 216, -2)))).addGroup(groupLayout.createSequentialGroup().addContainerGap(37, Short.MAX_VALUE).addComponent(this.jPanelSamplingSize, -2, 294, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSamplingType, -2, 293, -2))).addContainerGap()));
        groupLayout.linkSize(0, this._jCmbSize, this.jCmbSampling);
        groupLayout.linkSize(0, this.jPanelSamplingSize, this.jPanelSamplingType);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblSampling).addComponent(this.jCmbSampling, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSamplingType, -2, 48, -2).addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblSize).addComponent(this._jCmbSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSamplingSize, -2, 58, -2).addContainerGap(110, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jPanelSamplingSize, this.jPanelSamplingType);
    }

    public void initRes() {
        this._jLblSampling.setText(PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE"));
        this._jLblSize.setText(PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE"));
        this.setHelpID("data_miner_prefs");
    }

    public void initUI() {
        this._jCmbSize.setModel(new DefaultComboBoxModel<String>(_sampling_size));
        this._jLblSize.setLabelFor(this._jCmbSize);
        this._jCmbSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SamplingPanel.this._jCmbSize.getSelectedItem();
                if (string.equals(_num_rows)) {
                    SamplingPanel.this.showSamplingSizeCard(_num_rows);
                } else if (string.equals(_percent)) {
                    SamplingPanel.this.showSamplingSizeCard(_percent);
                }
            }
        });
        this.jCmbSampling.setModel(new DefaultComboBoxModel<String>(_sampling_type));
        this._jLblSampling.setLabelFor(this.jCmbSampling);
        this.jCmbSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SamplingPanel.this._bAdjusting) {
                    return;
                }
                String string = (String)SamplingPanel.this.jCmbSampling.getSelectedItem();
                if (string.equals(_random)) {
                    SamplingPanel.this.setRandomSampling();
                } else if (string.equals(_topN)) {
                    SamplingPanel.this.setTopN();
                }
            }
        });
    }

    private void initLayout() {
        this.jPanelSamplingType.setOpaque(false);
        this._samplingTypeLayout = (CardLayout)this.jPanelSamplingType.getLayout();
        this.jPanelSamplingTypeRandom = new CachePIComponentPanelSamplingTypeRandom(this);
        this.jPanelSamplingTypeRandom.setOpaque(false);
        this.jPanelSamplingTypeTopN = new CachePIComponentPanelSamplingTypeTopN();
        this.jPanelSamplingTypeTopN.setOpaque(false);
        this.jPanelSamplingType.add((Component)this.jPanelSamplingTypeRandom, _random);
        this.jPanelSamplingType.add((Component)this.jPanelSamplingTypeTopN, _topN);
        this.jPanelSamplingSize.setOpaque(false);
        this._samplingSizeLayout = (CardLayout)this.jPanelSamplingSize.getLayout();
        this.jPanelSamplingSizeRows = new CachePIComponentPanelSubPanelSamplingSizeRows(this);
        this.jPanelSamplingSizePercent = new CachePIComponentPanelSubPanelSamplingSizePercent(this);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizeRows, _num_rows);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizePercent, _percent);
    }

    private void setRandomSampling() {
        this._bAdjusting = true;
        this.jPanelSamplingTypeRandom.setRandomValue(BigInteger.valueOf(this._seed));
        this.showSamplingTypeCard(_random);
        this._bAdjusting = false;
    }

    private void setTopN() {
        this._bAdjusting = true;
        this.showSamplingTypeCard(_topN);
        this._bAdjusting = false;
    }

    private void showSamplingTypeCard(String string) {
        this._samplingTypeLayout.show(this.jPanelSamplingType, string);
        this.jPanelSamplingType.setVisible(string.equals(_random));
    }

    private void showSamplingSizeCard(String string) {
        this._samplingSizeLayout.show(this.jPanelSamplingSize, string);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValueIsAdjusting()) {
                return;
            }
            this._samplingPercent = jSlider.getValue();
        } else if (changeEvent.getSource() instanceof JSpinner) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            if (jSpinner.getName().equals(_num_rows)) {
                this._numberRows = ((Integer)jSpinner.getValue()).intValue();
            } else if (jSpinner.getName().equals(_random)) {
                this._seed = (Integer)jSpinner.getValue();
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        CacheSettingsPanelSettings cacheSettingsPanelSettings = SamplingPanel.getCoolFeaturePrefs(traversableContext);
        this._bAdjusting = true;
        this._isRandom = cacheSettingsPanelSettings.isRandom();
        this._seed = cacheSettingsPanelSettings.getSeed();
        if (this._isRandom) {
            this.jPanelSamplingTypeRandom.setRandomValue(BigInteger.valueOf(this._seed));
            this.jCmbSampling.setSelectedItem(_random);
            this.showSamplingTypeCard(_random);
        } else {
            this.jCmbSampling.setSelectedItem(_topN);
            this.showSamplingTypeCard(_topN);
        }
        this._isPercent = cacheSettingsPanelSettings.isPercent();
        this._numberRows = cacheSettingsPanelSettings.getNumberOfRows();
        this._samplingPercent = cacheSettingsPanelSettings.getPercentValue();
        this.jPanelSamplingSizePercent.setPercent(this._samplingPercent);
        this.jPanelSamplingSizeRows.setNumberOfRows(this._numberRows);
        if (this._isPercent) {
            this._jCmbSize.setSelectedItem(_percent);
            this.showSamplingSizeCard(_percent);
        } else {
            this._jCmbSize.setSelectedItem(_num_rows);
            this.showSamplingSizeCard(_num_rows);
        }
        this._bAdjusting = false;
    }

    public void onExit(TraversableContext traversableContext) {
        Object object;
        CacheSettingsPanelSettings cacheSettingsPanelSettings = SamplingPanel.getCoolFeaturePrefs(traversableContext);
        String string = (String)this.jCmbSampling.getSelectedItem();
        if (_random.equalsIgnoreCase(string)) {
            cacheSettingsPanelSettings.setRandom(true);
            object = this.jPanelSamplingTypeRandom.getSeed();
            cacheSettingsPanelSettings.setSeed(((Long)object).intValue());
        } else {
            cacheSettingsPanelSettings.setRandom(false);
            cacheSettingsPanelSettings.removeSeed();
        }
        object = (String)this._jCmbSize.getSelectedItem();
        if (((String)object).equals(_percent)) {
            Double d = this.jPanelSamplingSizePercent.getValue();
            cacheSettingsPanelSettings.setPercentValue(d);
            cacheSettingsPanelSettings.removeNumberOfRows();
            cacheSettingsPanelSettings.setPercent(true);
        } else {
            Long l = this.jPanelSamplingSizeRows.getNumberOfRows();
            cacheSettingsPanelSettings.setNumberOfRows(l.intValue());
            cacheSettingsPanelSettings.removePercentValue();
            cacheSettingsPanelSettings.setPercent(false);
        }
    }

    private static CacheSettingsPanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return CacheSettingsPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

