/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.controls.HistogramPreferences;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class TransformationNode
extends AbstractTransformNode
implements SampleSettingsProperties,
ApplyChainNode {
    public static final String SAMPLE_SETTINGS = "sampleSize";
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String ADD_COLUMNS = "addColumns";
    public static final String REMOVE_COLUMNS = "removeColumns";
    private static final String INPUT_COLUMNS = NodeMessagesLrb.get("TRANSFORM_TABLE_INPUT");
    public static final String ALL_TRANSFORMATION_NODE_COLUMNS = "allXfomNodeColumns";
    public static final String EDIT_COLUMN = "editColumn";
    public static final String EDIT_COLUMNS = "editColumns";
    public static final String OUTPUT_STATE = "outputState";
    public static final String DATAPROFILE_SETTINGS = NodeMessagesLrb.get("DATAPROFILE_SETTINGS");
    private static Preferences _p = Preferences.getPreferences();
    private HistogramPreferences histogramPreferences = HistogramPreferences.getInstance((PropertyStorage)_p);

    @Override
    public void refactorForApply() throws Exception {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        if (transformedAttributes == null) {
            return;
        }
        List list = transformedAttributes.getMapTransformedSourceType();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MapTransformedSource mapTransformedSource : list) {
            TransformationType.MissingValuesDate.Value value;
            Object object;
            Object object2;
            Object object3;
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            TransformationType transformationType = transformationOutputAttribute.getTransformationElementType();
            if (null != transformationType.getNormalization() && null == transformationType.getNormalization().getManual()) {
                object3 = transformationType.getNormalization();
                object2 = null;
                object = null;
                if (null != transformationType.getNormalization().getLinearScale()) {
                    object2 = transformationType.getNormalization().getLinearScale().getScale();
                    object = transformationType.getNormalization().getLinearScale().getShift();
                } else if (null != transformationType.getNormalization().getZScore()) {
                    object2 = transformationType.getNormalization().getZScore().getScale();
                    object = transformationType.getNormalization().getZScore().getShift();
                } else if (null != transformationType.getNormalization().getMinMax()) {
                    object2 = transformationType.getNormalization().getMinMax().getScale();
                    object = transformationType.getNormalization().getMinMax().getShift();
                }
                if (null == object2 || null == object) continue;
                value = new TransformationType.Normalization.Manual();
                value.setShift((Double)object);
                value.setScale((Double)object2);
                object3.setManual((TransformationType.Normalization.Manual)value);
                object3.setLinearScale(null);
                object3.setZScore(null);
                object3.setMinMax(null);
                continue;
            }
            if (null != transformationType.getOutlier() && null == transformationType.getOutlier().getValue()) {
                object3 = transformationType.getOutlier();
                object2 = null;
                object = null;
                if (null != object3.getPercent()) {
                    object2 = object3.getPercent().getLowerValue();
                    object = object3.getPercent().getUpperValue();
                } else if (null != object3.getStandardDeviation()) {
                    object2 = object3.getStandardDeviation().getLowerValue();
                    object = object3.getStandardDeviation().getUpperValue();
                }
                if (null == object2 || null == object) continue;
                value = new TransformationType.Outlier.Value();
                value.setLowerValue((Double)object2);
                value.setUpperValue((Double)object);
                object3.setValue((TransformationType.Outlier.Value)value);
                object3.setPercent(null);
                object3.setStandardDeviation(null);
                continue;
            }
            if (null != transformationType.getMissingValuesDate() && null != transformationType.getMissingValuesDate().getDateStatistic()) {
                object3 = transformationType.getMissingValuesDate();
                object2 = object3.getDateStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesDate.Value();
                value.setReplaceNullsWith((XMLGregorianCalendar)object);
                object3.setValue(value);
                object3.setDateStatistic(null);
                continue;
            }
            if (null != transformationType.getMissingValuesNumeric() && null != transformationType.getMissingValuesNumeric().getNumericStatistic()) {
                object3 = transformationType.getMissingValuesNumeric();
                object2 = object3.getNumericStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesNumeric.Value();
                value.setReplaceNullsWith((Double)object);
                object3.setValue((TransformationType.MissingValuesNumeric.Value)value);
                object3.setNumericStatistic(null);
                continue;
            }
            if (null != transformationType.getMissingValuesCategorical() && null != transformationType.getMissingValuesCategorical().getCategoricalStatistic()) {
                object3 = transformationType.getMissingValuesCategorical();
                object2 = object3.getCategoricalStatistic();
                object = object2.getValue();
                value = new TransformationType.MissingValuesCategorical.Value();
                value.setReplaceNullsWith((String)object);
                object3.setValue((TransformationType.MissingValuesCategorical.Value)value);
                object3.setCategoricalStatistic(null);
                continue;
            }
            if (null != transformationType.getBinning() && (null != transformationType.getBinning().getEqualWidth() || null != transformationType.getBinning().getQuantile())) {
                object3 = null;
                object2 = null;
                if (null != transformationType.getBinning().getEqualWidth()) {
                    object3 = transformationType.getBinning().getEqualWidth().getNumericBin();
                    object2 = transformationType.getBinning().getEqualWidth().getBinLabels();
                } else if (null != transformationType.getBinning().getQuantile()) {
                    object3 = transformationType.getBinning().getQuantile().getNumericBin();
                    object2 = transformationType.getBinning().getQuantile().getBinLabels();
                }
                object = new TransformationType.Binning.CustomNumeric();
                object.getNumericBin().addAll(object3);
                object.setBinLabels((BinLabels)object2);
                transformationType.getBinning().setCustomNumeric((TransformationType.Binning.CustomNumeric)object);
                transformationType.getBinning().setEqualWidth(null);
                transformationType.getBinning().setQuantile(null);
                continue;
            }
            if (null != transformationType.getBinning() && null != transformationType.getBinning().getTopN()) {
                object3 = transformationType.getBinning().getTopN().getCategoricalBin();
                object2 = new TransformationType.Binning.CustomCategorical();
                object2.getCategoricalBin().addAll(object3);
                transformationType.getBinning().setCustomCategorical((TransformationType.Binning.CustomCategorical)object2);
                transformationType.getBinning().setTopN(null);
                continue;
            }
            if (null != transformationType.getBinning() && null != transformationType.getBinning().getDateEqualWidth()) {
                object3 = transformationType.getBinning().getDateEqualWidth().getDateBin();
                object2 = new TransformationType.Binning.CustomDate();
                object2.getDateBin().addAll(object3);
                object2.setBinLabels(transformationType.getBinning().getDateEqualWidth().getBinLabels());
                transformationType.getBinning().setCustomDate((TransformationType.Binning.CustomDate)object2);
                transformationType.getBinning().setDateEqualWidth(null);
                continue;
            }
            if (null == transformationType.getBinning() || null == transformationType.getBinning().getTimestampEqualWidth()) continue;
            object3 = transformationType.getBinning().getTimestampEqualWidth().getTimestampTimezoneBin();
            object2 = new TransformationType.Binning.CustomTimestamp();
            object2.getTimestampTimezoneBin().addAll(object3);
            object2.setBinLabels(transformationType.getBinning().getTimestampEqualWidth().getBinLabels());
            transformationType.getBinning().setCustomTimestamp((TransformationType.Binning.CustomTimestamp)object2);
            transformationType.getBinning().setTimestampEqualWidth(null);
        }
        this.validate(false);
    }

    public TransformationNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TRANSFORMATION_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TRANSFORMATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        transformationNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        transformationNodeType.setTransformedAttributes(transformedAttributes);
        transformationNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        SampleSettings sampleSettings = new SampleSettings();
        sampleSettings.setNumberOfRows(Long.valueOf(2000L));
        SampleSettings.Method method = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(12345L));
        method.setRandom(random);
        sampleSettings.setMethod(method);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        transformationNodeType.setSampleSettings(sampleSettings);
        DataProfileSettingsType dataProfileSettingsType = new DataProfileSettingsType();
        dataProfileSettingsType.setCategoricalBins(this.histogramPreferences.getNumberOfCategoricBins());
        dataProfileSettingsType.setNumericalBins(this.histogramPreferences.getNumberOfNumericBins());
        dataProfileSettingsType.setDateBins(this.histogramPreferences.getNumberOfDateBins());
        transformationNodeType.setDataProfileSettings(dataProfileSettingsType);
        transformationNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getHelpTopic() {
        return "transform_node";
    }

    @Override
    public Attributes getAttributes() {
        AttributeType attributeType;
        Object object2;
        Attributes attributes = new Attributes();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        for (Object object2 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!object2.isIsOutput()) continue;
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, (AttributeType)object2);
            attributes.getAttribute().add(attributeType);
        }
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        object2 = transformedAttributes.getMapTransformedSourceType();
        attributeType = object2.iterator();
        while (attributeType.hasNext()) {
            MapTransformedSource mapTransformedSource = (MapTransformedSource)attributeType.next();
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            if (!transformationOutputAttribute.isIsOutput()) continue;
            AttributeType attributeType2 = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType2, (AttributeType)transformationOutputAttribute);
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        String string;
        Object object;
        AttributeType attributeType2;
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list) {
            object = attributeType2.getAlias();
            string = object != null && ((String)object).trim().length() > 0 ? object : attributeType2.getName();
            hashMap.put(string, attributeType2);
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        attributeType2 = transformationNodeType.getTransformationSourceAttributes();
        if (attributeType2 == null) {
            attributeType2 = new TransformationSourceAttributes();
            transformationNodeType.setTransformationSourceAttributes((TransformationSourceAttributes)attributeType2);
        }
        if ((object = attributeType2.getTransformationSourceAttributeType()).isEmpty()) {
            TransformationNode.copyAttributes((List<TransformationSourceAttribute>)object, list);
            this.excecuteInputColumnsTxn((TransformationSourceAttributes)attributeType2, new Helper());
        } else {
            string = new TransformationSourceAttributes();
            AttributeTypeHelper.copyTransformationSourceAttributes(string.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            Map<String, AttributeStatus> map = this.buildDependentObjectStatusMap();
            this.validateInputAttributes();
            this.excecuteInputColumnsTxn(transformationNodeType.getTransformationSourceAttributes(), new Helper((TransformationSourceAttributes)string, map));
        }
        this.validate(true);
    }

    public static void copyAttributes(List<TransformationSourceAttribute> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            TransformationSourceAttribute transformationSourceAttribute = new TransformationSourceAttribute();
            transformationSourceAttribute.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            transformationSourceAttribute.setDataType(attributeType.getDataType());
            transformationSourceAttribute.setStatus(attributeType.getStatus());
            transformationSourceAttribute.setAnnotation(attributeType.getAnnotation());
            transformationSourceAttribute.setIsOutput(true);
            list.add(transformationSourceAttribute);
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    private void excecuteInputColumnsTxn(TransformationSourceAttributes transformationSourceAttributes, Helper helper) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(INPUT_COLUMNS, new Helper(transformationSourceAttributes, this.buildDependentObjectStatusMap()));
        complexProperty.setOldData(helper);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public void setNodeReady() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("status", NodeStatusType.READY);
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public Object getProperty(String string) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        Object object = null;
        if (string.equals(INPUT_COLUMNS)) {
            object = new Helper(transformationNodeType.getTransformationSourceAttributes(), this.buildDependentObjectStatusMap());
        } else if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            object = AttributeTypeHelper.getAllColumns(transformationNodeType);
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            object = transformationNodeType.getDataProfileSettings();
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            SampleSettings sampleSettings = transformationNodeType.getSampleSettings();
            object = sampleSettings;
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(EDIT_COLUMN)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(OUTPUT_STATE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ADD_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(REMOVE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(INPUT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(DATAPROFILE_SETTINGS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        if (string.equals(INPUT_COLUMNS)) {
            Helper helper = (Helper)object;
            transformationNodeType.setTransformationSourceAttributes(helper.newAttributes);
            if (helper.dependentObjectStatusMap.isEmpty()) {
                return;
            }
            for (MapTransformedSource mapTransformedSource : transformationNodeType.getTransformedAttributes().getMapTransformedSourceType()) {
                AttributeStatus attributeStatus = helper.dependentObjectStatusMap.get(mapTransformedSource.getKey().getName());
                if (attributeStatus == null) continue;
                mapTransformedSource.getKey().setStatus(attributeStatus);
            }
        } else if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            AttributeTypeHelper.TransformationNodeColumns transformationNodeColumns = (AttributeTypeHelper.TransformationNodeColumns)object;
            AttributeTypeHelper.copyTransformedAttributes(transformationNodeType.getTransformedAttributes(), transformationNodeColumns.getXformedAttributes());
            AttributeTypeHelper.copyTransformationSourceAttributes(transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), transformationNodeColumns.getXformSourceAttributes().getTransformationSourceAttributeType());
        } else if (string.equals(EDIT_COLUMN)) {
            List list;
            MapTransformedSource mapTransformedSource = (MapTransformedSource)object;
            TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
            if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
                for (MapTransformedSource mapTransformedSource2 : list) {
                    if (!mapTransformedSource2.getKey().getName().equals(mapTransformedSource.getKey().getName())) continue;
                    AttributeTypeHelper.copyMapTransformedSource(mapTransformedSource2, mapTransformedSource);
                    break;
                }
            }
        } else if (string.equals(OUTPUT_STATE)) {
            Object object2;
            Object object3;
            Map<String, Boolean> map = ConverterHelper.objectToMapStringBoolean(object);
            TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
            if (transformedAttributes != null && (object3 = transformedAttributes.getMapTransformedSourceType()) != null && !object3.isEmpty()) {
                TransformationSourceAttribute transformationSourceAttribute = object3.iterator();
                while (transformationSourceAttribute.hasNext()) {
                    object2 = (MapTransformedSource)transformationSourceAttribute.next();
                    Boolean bl = map.get(object2.getKey().getName());
                    if (null == bl) continue;
                    object2.getKey().setIsOutput(bl.booleanValue());
                }
            }
            for (TransformationSourceAttribute transformationSourceAttribute : transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                object2 = map.get(transformationSourceAttribute.getName());
                if (null == object2) continue;
                transformationSourceAttribute.setIsOutput(((Boolean)object2).booleanValue());
            }
        } else if (string.equals(EDIT_COLUMNS)) {
            TransformedAttributes transformedAttributes = (TransformedAttributes)object;
            transformationNodeType.setTransformedAttributes(transformedAttributes);
        } else if (string.equals(REMOVE_COLUMNS) || string.equals(ADD_COLUMNS)) {
            TransformedAttributes transformedAttributes = (TransformedAttributes)object;
            transformationNodeType.setTransformedAttributes(transformedAttributes);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            DataProfileSettingsType dataProfileSettingsType = (DataProfileSettingsType)object;
            transformationNodeType.setDataProfileSettings(dataProfileSettingsType);
        } else if (string.equals("metadata")) {
            super.setProperty(string, object);
            transformationNodeType = (TransformationNodeType)this.getData();
            transformationNodeType.setInputStatisticTable(null);
        } else if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                transformationNodeType.setSampleSettings((SampleSettings)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        List list;
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n" + (TransformationNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        if (transformationSourceAttributes != null && (list = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n");
                }
                String string = null;
                string = !StringUtils.isDoubleQuotedString(((TransformationSourceAttribute)list.get(i)).getName()) ? "\"" + ((TransformationSourceAttribute)list.get(i)).getName() + "\"" : ((TransformationSourceAttribute)list.get(i)).getName();
                stringBuilder.append(string);
                String string2 = ((TransformationSourceAttribute)list.get(i)).getAlias();
                if (string2 == null || string2.isEmpty()) continue;
                if (!StringUtils.isDoubleQuotedString(string2)) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuilder.append(" AS ");
                stringBuilder.append(string2);
            }
        }
        stringBuilder.append(" FROM {INPUT_SOURCE}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        TransformationSourceAttributes transformationSourceAttributes;
        boolean bl2 = super.validate(bl);
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        if (dataProfileSettingsType.getCategoricalBins() <= 0 || dataProfileSettingsType.getNumericalBins() <= 0 || dataProfileSettingsType.getDateBins() <= 0) {
            bl2 = false;
            this.addMessage("DATAPROFILE_SETTINGS_INVALID", MessageEnumType.ERROR, new String[0]);
        }
        if (bl2 && (null == (transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes()) || null == transformationSourceAttributes.getTransformationSourceAttributeType() || transformationSourceAttributes.getTransformationSourceAttributeType().isEmpty())) {
            Attributes attributes;
            List list;
            Object object2;
            bl2 = false;
            object = transformationSourceAttributes.getTransformationSourceAttributeType();
            if (object.isEmpty() && (object2 = this.findParentNode()) != null && !(list = (attributes = ((DataProvider)object2).getAttributes()).getAttribute()).isEmpty()) {
                TransformationNode.copyAttributes((List<TransformationSourceAttribute>)object, list);
                this.excecuteInputColumnsTxn(transformationSourceAttributes, new Helper());
                bl2 = true;
            }
            if (!bl2) {
                this.addMessage("TRANSFORM_NODE_SOURCE_COLUMNS_MISSING", MessageEnumType.INCOMPLETE, new String[0]);
            }
        }
        if (bl2) {
            transformationSourceAttributes = new TransformationSourceAttributes();
            AttributeTypeHelper.copyTransformationSourceAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            object = this.buildDependentObjectStatusMap();
            this.validateInputAttributes();
            this.excecuteInputColumnsTxn(transformationNodeType.getTransformationSourceAttributes(), new Helper(transformationSourceAttributes, (Map<String, AttributeStatus>)object));
            for (Attributes attributes : transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                if (attributes.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl2 = false;
                this.addMessage("TRANSFORM_NODE_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                break;
            }
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    private Map<String, AttributeStatus> buildDependentObjectStatusMap() {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        HashMap<String, AttributeStatus> hashMap = new HashMap<String, AttributeStatus>();
        for (MapTransformedSource mapTransformedSource : transformationNodeType.getTransformedAttributes().getMapTransformedSourceType()) {
            hashMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource.getKey().getStatus());
        }
        return hashMap;
    }

    private boolean validateInputAttributes() {
        Object object;
        Object object22;
        boolean bl = true;
        AbstractNode abstractNode = this.findParentNode();
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        List list = transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        Attributes attributes = null;
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (dataProvider != null) {
            attributes = dataProvider.getAttributes();
        }
        List list2 = attributes != null ? attributes.getAttribute() : new ArrayList();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object22 : list2) {
            object = object22.getAlias();
            String string = object != null && ((String)object).trim().length() > 0 ? object : object22.getName();
            hashMap.put(string, object22);
        }
        TransformedAttributes transformedAttributes = transformationNodeType.getTransformedAttributes();
        object22 = new ArrayList();
        for (String string : list) {
            AttributeType attributeType = (AttributeType)hashMap.get(string.getName());
            if (null == attributeType) {
                if (!this.isColumnUsedForTransformations(transformedAttributes, (TransformationSourceAttribute)string)) {
                    object22.add(string);
                    continue;
                }
                string.setStatus(AttributeStatus.MISSING);
                continue;
            }
            if (!this.areCompatibleTypes(attributeType.getDataType(), string.getDataType())) {
                string.setStatus(AttributeStatus.INVALID);
                continue;
            }
            string.setStatus(attributeType.getStatus());
            this.isColumnUsedForTransformations(transformedAttributes, (TransformationSourceAttribute)string);
            hashMap.remove(string.getName());
        }
        if (!object22.isEmpty()) {
            this.removeMissingColumns((List<TransformationSourceAttribute>)object22);
        }
        object = new ArrayList<AttributeType>(hashMap.values());
        TransformationNode.copyAttributes(list, object);
        return bl;
    }

    private boolean areCompatibleTypes(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return DatabaseMetadataUtils.isANumberOracleDataType(string) && DatabaseMetadataUtils.isANumberOracleDataType(string2);
    }

    private boolean isColumnUsedForTransformations(TransformedAttributes transformedAttributes, TransformationSourceAttribute transformationSourceAttribute) {
        boolean bl = false;
        for (MapTransformedSource mapTransformedSource : transformedAttributes.getMapTransformedSourceType()) {
            if (TransformationTypes.isCustomXform(mapTransformedSource.getKey().getTransformationElementType())) {
                if (-1 == mapTransformedSource.getKey().getTransformationElementType().getCustomTransformation().getValue().indexOf(transformationSourceAttribute.getName())) continue;
                bl = true;
                mapTransformedSource.getKey().setStatus(transformationSourceAttribute.getStatus());
                continue;
            }
            StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
            for (String string : stringCollection.getValue()) {
                if (!string.equals(transformationSourceAttribute.getName())) continue;
                bl = true;
                mapTransformedSource.getKey().setStatus(transformationSourceAttribute.getStatus());
            }
        }
        return bl;
    }

    private void removeMissingColumns(List<TransformationSourceAttribute> list) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)this.getData();
        List list2 = transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>(list2.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)hashMap.get(transformationSourceAttribute.getName());
            list2.remove(transformationSourceAttribute2);
        }
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() == NodeStatusType.COMPLETE || this.getData().getStatus() == NodeStatusType.WARNING;
        return bl;
    }

    private class Helper {
        TransformationSourceAttributes newAttributes;
        Map<String, AttributeStatus> dependentObjectStatusMap;

        Helper() {
            this.newAttributes = new TransformationSourceAttributes();
            this.dependentObjectStatusMap = new HashMap<String, AttributeStatus>();
        }

        Helper(TransformationSourceAttributes transformationSourceAttributes, Map<String, AttributeStatus> map) {
            this.newAttributes = transformationSourceAttributes;
            this.dependentObjectStatusMap = map;
        }
    }
}

