/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.TestPreferencesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public final class TestNode
extends AbstractNode
implements ModelConsumer {
    public static final String TARGET_ATTRIBUTE = "TargetAttribute";
    public static final String CASE_ATTRIBUTES = "CaseAttributes";
    public static final String TEST_MODELS = "TestModels";
    public static final String AUTO_SETTING = "AutoSetting";
    public static final String TEST_RESULTS = "testResults";
    private HashMap<String, String> _nodesLookupMap = new HashMap();
    private HashMap<String, MiningResultType> _resultLookupMap = new HashMap();
    private static final String MODEL_STATUS = "modelStatus";

    public TestNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        TestPreferencesPanel.TestPreferenceSettings testPreferenceSettings = TestPreferencesPanel.TestPreferenceSettings.getInstance();
        boolean bl = testPreferenceSettings.getAutomaticSetting();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = new TestModelType();
        testModelType.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        testModelType.setArchive("No");
        testNodeType.setTestModels(testModelType);
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
        topNTargets.setValue(BigInteger.valueOf(100L));
        classificationTestSettingsType.setTopNTargets(topNTargets);
        testNodeType.setTestSettings(classificationTestSettingsType);
        CaseAttributes caseAttributes = new CaseAttributes();
        testNodeType.setCaseAttributes(caseAttributes);
        TestNodeType.Results results = new TestNodeType.Results();
        testNodeType.setResults(results);
        testNodeType.setStatus(NodeStatusType.INVALID);
    }

    private void initModelNodeLookup() {
        this._nodesLookupMap.clear();
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode : list) {
            this._nodesLookupMap.put(abstractNode.getMetadataId(), abstractNode.getData().getName());
        }
    }

    private void initResultLookup() {
        this._resultLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getClassificationResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
        for (ClassificationResultType classificationResultType : testNodeType.getResults().getRegressionResult()) {
            this._resultLookupMap.put(classificationResultType.getModelId(), (MiningResultType)classificationResultType);
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TEST_NODE_NAME");
    }

    public boolean areNodesCompatible(Node node) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl = false;
        ModelProvider modelProvider = (ModelProvider)((Object)node);
        bl = testNodeType.getTestModels().getModel().size() == 0 ? true : testNodeType.getTestModels().getMiningFunction().equals((Object)modelProvider.getMiningFunctionTypeSupported()) && testNodeType.getTargetAttribute().getName().equals(modelProvider.getTargetAttribute().getName()) && testNodeType.getTargetAttribute().getDataType().equals(modelProvider.getTargetAttribute().getDataType());
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof BuildTextNodeRef) {
            return false;
        }
        if (node instanceof DataProvider) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof DataProvider)) continue;
                bl = false;
                break;
            }
        } else {
            ModelProvider modelProvider;
            bl = node instanceof ModelProvider ? ((modelProvider = (ModelProvider)((Object)node)).getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.CLASSIFICATION) || modelProvider.getMiningFunctionTypeSupported().equals((Object)MiningFunctionType.REGRESSION) ? this.areNodesCompatible(node) : false) : false;
        }
        return bl;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        TestModelType testModelType = testNodeType.getTestModels();
        TestModelType testModelType2 = (TestModelType)MetaDataHelper.copyMetadataObject(testModelType);
        List list = testModelType2.getModel();
        for (TestModelType.Model model : list) {
            if (!map.containsKey(model.getName())) continue;
            RefModelType refModelType = map.get(model.getName());
            model.setName(refModelType.getName());
            model.setModelId(refModelType.getModelId());
            model.setTestStatus(ModelStatusType.READY);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_MODELS, testModelType2);
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        ++this.refactorInvokeCount;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, new TestNodeType.Results());
            this.setNodeReady();
            this.validate(false);
            List<AbstractNode> list2 = this.findChildNodes();
            for (AbstractNode abstractNode : list2) {
                abstractNode.refactor(this, bl);
            }
        }
    }

    @Override
    public void parentNodeNameChanged(Node node, String string) {
        this._nodesLookupMap.clear();
    }

    @Override
    public boolean validate(boolean bl) {
        MiningFunctionType miningFunctionType;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object52;
        Object object62;
        boolean bl2 = super.validate(bl);
        this._nodesLookupMap.clear();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        boolean bl3 = testNodeType.getTestModels().getAutoSpec().equals((Object)AutoSpecType.YES);
        boolean bl4 = false;
        boolean bl5 = false;
        TestModelType testModelType = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        TestNodeType.Results results = null;
        boolean bl6 = false;
        AttributeType attributeType = null;
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode model : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)model);
            object62 = modelProvider.getOutputModels();
            object52 = object62.iterator();
            while (object52.hasNext()) {
                object42 = object52.next();
                object3 = testModelType.getModel().iterator();
                while (object3.hasNext()) {
                    object2 = (TestModelType.Model)object3.next();
                    object = object2.getModelId();
                    if (object == null || !object42.getModelId().equals(object) || object2.getName().compareTo(object42.getName()) == 0) continue;
                    object2.setName(object42.getName());
                    bl5 = true;
                }
            }
        }
        if (bl3) {
            testModelType.getModel().clear();
            testModelType.setMiningFunction(null);
            miningFunctionType = testModelType.getMiningFunction();
            for (AbstractNode abstractNode : list) {
                object62 = (ModelProvider)((Object)abstractNode);
                if (attributeType == null) {
                    attributeType = object62.getTargetAttribute();
                    bl6 = true;
                }
                object52 = object62.getOutputModels();
                object42 = object52.iterator();
                while (object42.hasNext()) {
                    object3 = (RefModelType)object42.next();
                    if (!object3.isUseForOutput()) continue;
                    if (miningFunctionType == null) {
                        testModelType.setMiningFunction(object3.getMiningFunction());
                        miningFunctionType = testModelType.getMiningFunction();
                    }
                    if (!miningFunctionType.equals((Object)object3.getMiningFunction()) || !attributeType.getName().equals(object62.getTargetAttribute().getName()) || !attributeType.getDataType().equals(object62.getTargetAttribute().getDataType())) continue;
                    object2 = new TestModelType.Model();
                    object2.setMiningAlgorithm(object3.getMiningAlgorithm());
                    object2.setMiningFunction(object3.getMiningFunction());
                    object2.setModelId(object3.getModelId());
                    object2.setName(object3.getName());
                    object2.setNodeId(object3.getNodeId());
                    object2.setSchema(object3.getSchema());
                    object2.setStatus(object3.getStatus());
                    object2.setTestStatus(ModelStatusType.READY);
                    object2.setUseForOutput(object3.isUseForOutput());
                    object2.setIsModelBuilt(object3.isIsModelBuilt());
                    testModelType.getModel().add(object2);
                }
            }
            bl = true;
            bl5 = true;
            bl6 = true;
        } else {
            Object object7;
            Object object8;
            miningFunctionType = this.findTestModelNodes();
            HashMap hashMap = new HashMap();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            for (Object object52 : miningFunctionType) {
                object42 = (ModelProvider)object52;
                object3 = object42.getTargetAttribute();
                hashMap.put(((AbstractNode)object52).getMetadataId(), object52);
                object2 = object42.getOutputModels();
                object = object2.iterator();
                while (object.hasNext()) {
                    object8 = (RefModelType)object.next();
                    if (!object8.isUseForOutput()) continue;
                    object7 = ((AbstractNode)object52).getMetadataId() + "." + object8.getSchema() + "." + object8.getName() + "." + object8.getMiningAlgorithm() + "." + object3.getName() + "." + object3.getDataType();
                    hashMap2.put(object7, object8);
                }
            }
            object62 = new ArrayList();
            attributeType = testNodeType.getTargetAttribute();
            for (Object object42 : testModelType.getModel()) {
                if (object42.getStatus() != RefModelStatusType.VALID || (object2 = (RefModelType)hashMap2.get(object3 = object42.getNodeId() + "." + object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) != null) continue;
                if (hashMap.get(object42.getNodeId()) != null) {
                    object62.add(object42);
                    bl5 = true;
                    bl = true;
                    continue;
                }
                object42.setStatus(RefModelStatusType.INVALID);
                object42.setNodeId(null);
                object42.setModelId(null);
                if (!bl4) {
                    this.addMessage("TEST_INVAL_MODEL", MessageEnumType.WARNING, new String[0]);
                    bl4 = true;
                }
                bl2 = false;
                bl5 = true;
            }
            if (object62.size() > 0) {
                testModelType.getModel().removeAll((Collection<?>)object62);
                if (testModelType.getModel().size() == 0) {
                    testModelType.setMiningFunction(null);
                    attributeType = null;
                    bl5 = true;
                    bl6 = true;
                }
            }
            for (Object object42 : testModelType.getModel()) {
                if (object42.getNodeId() == null || hashMap.get(object3 = object42.getNodeId()) == null) continue;
                hashMap.remove(object3);
            }
            if (hashMap.size() > 0) {
                hashMap2.clear();
                for (Object object42 : hashMap.values()) {
                    object3 = (ModelProvider)object42;
                    object2 = object3.getTargetAttribute();
                    object = object3.getOutputModels();
                    object8 = object.iterator();
                    while (object8.hasNext()) {
                        object7 = (RefModelType)object8.next();
                        if (!object7.isUseForOutput()) continue;
                        String string = object7.getSchema() + "." + object7.getName() + "." + object7.getMiningAlgorithm() + "." + object2.getName() + "." + object2.getDataType();
                        hashMap2.put(string, object7);
                    }
                }
                for (Object object42 : testModelType.getModel()) {
                    if (object42.getStatus() != RefModelStatusType.INVALID || attributeType == null || (object2 = (RefModelType)hashMap2.get(object3 = object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm() + "." + attributeType.getName() + "." + attributeType.getDataType())) == null) continue;
                    object42.setStatus(RefModelStatusType.VALID);
                    object42.setNodeId(object2.getNodeId());
                    object42.setModelId(object2.getModelId());
                    bl5 = true;
                }
            }
        }
        results = new TestNodeType.Results();
        for (TestModelType.Model model : testModelType.getModel()) {
            if (model.getModelId() == null) continue;
            for (Object object62 : testNodeType.getResults().getClassificationResult()) {
                if (!object62.getModelId().equals(model.getModelId())) continue;
                results.getClassificationResult().add(object62);
            }
            for (Object object62 : testNodeType.getResults().getRegressionResult()) {
                if (!object62.getModelId().equals(model.getModelId())) continue;
                results.getRegressionResult().add(object62);
            }
        }
        boolean bl7 = results.getClassificationResult().size() != testNodeType.getResults().getClassificationResult().size();
        boolean bl8 = results.getRegressionResult().size() != testNodeType.getResults().getRegressionResult().size();
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        object62 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object52 = new ComplexProperty(TARGET_ATTRIBUTE, attributeType);
            ((ComplexProperty)object52).setOldData(testNodeType.getTargetAttribute());
            arrayList.add((ComplexProperty)object52);
        }
        if (bl5) {
            object52 = new ComplexProperty(TEST_MODELS, testModelType);
            ((ComplexProperty)object52).setOldData(testNodeType.getTestModels());
            arrayList.add((ComplexProperty)object52);
        }
        if (bl7 || bl8) {
            object52 = new ComplexProperty(TEST_RESULTS, results);
            ((ComplexProperty)object52).setOldData(testNodeType.getResults());
            arrayList.add((ComplexProperty)object52);
        }
        ((OdmrSDMUndoFilter)((Object)object62)).prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        AbstractNode abstractNode = this.findTestDataNode();
        if (abstractNode == null) {
            this.addMessage("TEST_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (testNodeType.getTestModels().getModel().size() == 0) {
            this.addMessage("TEST_NO_MODEL", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        List<AbstractNode> list = this.findTestModelNodes();
        for (AbstractNode abstractNode2 : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode2);
            if (modelProvider.getTargetAttribute() != null) continue;
            this.addMessage("TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public void setProperty(String string, Object object) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.setTargetAttribute(attributeType);
        } else if (string.equals(CASE_ATTRIBUTES)) {
            AttributeType attributeType = (AttributeType)object;
            testNodeType.getCaseAttributes().getAttribute().clear();
            testNodeType.getCaseAttributes().getAttribute().add(attributeType);
        } else if (string.equals(TEST_MODELS)) {
            TestModelType testModelType = (TestModelType)object;
            testNodeType.setTestModels(testModelType);
            this._nodesLookupMap.clear();
        } else if (string.equals(AUTO_SETTING)) {
            testNodeType.getTestModels().setAutoSpec((AutoSpecType)object);
        } else if (string.equals(MODEL_STATUS)) {
            this.setModelStatus(object);
        } else if (string.equals(TEST_RESULTS)) {
            testNodeType.setResults((TestNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(MODEL_STATUS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_SETTING)) {
            TestNodeType testNodeType = (TestNodeType)this.getData();
            return testNodeType.getTestModels().getAutoSpec();
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        TestNodeType testNodeType = (TestNodeType)this.getData();
        Object object = null;
        if (string.equals(TARGET_ATTRIBUTE)) {
            object = testNodeType.getTargetAttribute();
        } else if (string.equals(CASE_ATTRIBUTES)) {
            if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
                object = testNodeType.getCaseAttributes().getAttribute().get(0);
            }
        } else if (string.equals(TEST_MODELS)) {
            object = testNodeType.getTestModels();
        } else if (string.equals(AUTO_SETTING)) {
            object = testNodeType.getTestModels().getAutoSpec();
        } else if (string.equals(TEST_RESULTS)) {
            object = testNodeType.getResults();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TEST_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TEST_ICON"));
    }

    public AbstractNode findTestDataNode() {
        AbstractNode abstractNode = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode2 : list) {
            if (!(abstractNode2 instanceof DataProvider)) continue;
            abstractNode = abstractNode2;
            break;
        }
        return abstractNode;
    }

    public List<AttributeType> findCaseIds() {
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    public String getModelNodeName(String string) {
        if (this._nodesLookupMap.size() == 0) {
            this.initModelNodeLookup();
        }
        return this._nodesLookupMap.get(string);
    }

    public MiningResultType getModelResult(String string) {
        if (this._resultLookupMap.size() == 0) {
            this.initResultLookup();
        }
        return this._resultLookupMap.get(string);
    }

    public List<AbstractNode> findTestModelNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof ModelProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static void removeModel(TestModelType testModelType, List<TestModelType.Model> list) {
        if (list.size() > 0) {
            testModelType.getModel().removeAll(list);
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(null);
            }
        }
    }

    public static boolean addModels2(TestModelType testModelType, List<TestModelType.Model> list) {
        boolean bl = true;
        if (list.size() > 0) {
            if (testModelType.getModel().size() == 0) {
                testModelType.setMiningFunction(list.get(0).getMiningFunction());
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (TestModelType.Model model : testModelType.getModel()) {
                String string = model.getSchema() + "." + model.getName();
                hashMap.put(string, Boolean.TRUE);
            }
            for (TestModelType.Model model : list) {
                if (hashMap.get(model.getSchema() + "." + model.getName()) != null) {
                    model.setStatus(RefModelStatusType.INVALID);
                    bl = false;
                }
                testModelType.getModel().add(model);
            }
        }
        return bl;
    }

    public static boolean doesModelExist(TestModelType testModelType, RefModelType refModelType) {
        boolean bl = false;
        for (TestModelType.Model model : testModelType.getModel()) {
            String string;
            String string2 = model.getSchema() + "." + model.getName();
            if (!string2.equals(string = refModelType.getSchema() + "." + refModelType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        TestNodeType testNodeType = (TestNodeType)this.getData();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!subNodeProperty.getId().equals(model.getName())) continue;
            model.setTestStatus((ModelStatusType)subNodeProperty.getValue());
            break;
        }
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        TestNodeType testNodeType = (TestNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (!model.getTestStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(model.getName(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(model.getName(), model.getTestStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public String getHelpTopic() {
        return "test_node";
    }
}

