/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;

public final class RegressionBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    public static final String GLMSETTINGS = "RGLMSettings";
    public static final String TODO = "add settings here";
    public static final String TEST_RESULTS = "regrTestResults";
    private static Preferences _p = Preferences.getPreferences();
    private RegressionModelBuildPreferencesPanelSettings regrBuildPref = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public RegressionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = new RegressionBuildNodeType.Models();
        RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
        regressionBuildNodeType.setModels(models);
        regressionBuildNodeType.setResults(results);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.regrBuildPref.isSvm()) {
            arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.regrBuildPref.isGlm()) {
            arrayList.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "REGRESSION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.regrBuildPref.isSvm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addSVMModel((RSupportVectorMachineModelType)modelType);
        }
        if (this.regrBuildPref.isGlm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addGLMModel((RGeneralizedLinearModelType)modelType);
        }
        regressionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addGLMModel(RGeneralizedLinearModelType rGeneralizedLinearModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRGeneralizedLinearModel();
        list.add(rGeneralizedLinearModelType);
    }

    public void addSVMModel(RSupportVectorMachineModelType rSupportVectorMachineModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRSupportVectorMachineModel();
        list.add(rSupportVectorMachineModelType);
    }

    public ModelType createNewRegressionModel(String string, String string2, String string3) {
        RegressionModelType regressionModelType = (RegressionModelType)super.createNewModel(string, string2, "REGRESSION", string3);
        return regressionModelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_REG_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (!regressionBuildNodeType.getResults().getRegressionResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, new RegressionBuildNodeType.Results());
        }
        super.refactor(node, bl);
    }

    @Override
    public Object getProperty(String string) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("testOptionsChanged")) {
            return regressionBuildNodeType.getTestDataSource();
        }
        if (string.equals(TEST_RESULTS)) {
            return regressionBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (RegressionResultType regressionResultType : list) {
                if (null == map.get(regressionResultType.getModelId())) continue;
                hashMap.put(regressionResultType.getModelId(), regressionResultType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        if (models.getRGeneralizedLinearModel().isEmpty() && models.getRSupportVectorMachineModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getRGeneralizedLinearModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getRSupportVectorMachineModel())) {
                bl3 = false;
            }
            HashMap<String, RSupportVectorMachineModelType> hashMap = new HashMap<String, RSupportVectorMachineModelType>();
            for (Object object2 : models.getRSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            for (Object object2 : models.getRGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
            for (Object object3 : regressionBuildNodeType.getResults().getRegressionResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (RegressionResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getRegressionResult().add(object);
            }
            boolean bl5 = bl4 = results.getRegressionResult().size() != regressionBuildNodeType.getResults().getRegressionResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty(TEST_RESULTS, results);
                complexProperty.setOldData(regressionBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals(GLMSETTINGS)) {
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            List list = models.getRGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
                if (!rGeneralizedLinearModelType.getName().equals(string2)) continue;
                for (Property property : list2) {
                    if (!property.getDescription().equals("TODO")) continue;
                    rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().setGLMSCONFLEVEL(0.0);
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            RegressionBuildNodeType regressionBuildNodeType2 = (RegressionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(this);
            Map map = (Map)object;
            for (RegressionResultType regressionResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(regressionResultType.getModelId());
                if (null == modelStatusType) continue;
                regressionResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            regressionBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType3 = (RegressionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(TEST_RESULTS)) {
            regressionBuildNodeType.setResults((RegressionBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        return regressionBuildNodeType.getTargetAttribute();
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RSupportVectorMachineModelType rSupportVectorMachineModelType : list) {
            String string3 = rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string3 = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public Map<String, String> getRowDiagnosticTables() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            hashMap.put(rGeneralizedLinearModelType.getName(), string);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "regression_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_REGRESSION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_REGRESSION_ICON"));
    }
}

