/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;

public final class ModelNode
extends AbstractModelNode {
    public ModelNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        Object object;
        Object object22;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        this.setNodeReady();
        List<RefModelType> list = this.getOutputModels();
        Map<String, RefModelType> map = WorkflowUtils.refactorModels(this.getContext(), list, this.getModel(), true);
        ModelNodeType modelNodeType = (ModelNodeType)MetaDataHelper.copyMetadataObject(this.getData());
        ModelNodeType.Models models = modelNodeType.getModels();
        List list2 = models.getModel();
        for (Object object22 : list2) {
            object = map.get(object22.getName());
            if (object == null) continue;
            object22.setModelId(object.getModelId());
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "modelsGroup", models);
        List<AbstractNode> list3 = this.findChildNodes();
        object22 = list3.iterator();
        while (object22.hasNext()) {
            object = (AbstractNode)object22.next();
            if (object instanceof ModelConsumer) {
                ((ModelConsumer)object).refactorModelReferences(this, map, bl);
            }
            object.refactor((Node)this, bl);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_MODEL_NODE_NAME");
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        return false;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public String getHelpTopic() {
        return "model_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_MODEL_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_MODEL_ICON"));
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        Object object;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = "SELECT OWNER, MODEL_NAME, MINING_FUNCTION, ALGORITHM FROM ALL_MINING_MODELS WHERE MINING_FUNCTION = 'CLASSIFICATION' AND ((ALGORITHM = 'DECISION_TREE' AND COMMENTS IN ('BALANCED', 'CUSTOM')) OR COMMENTS IN ('TUNED'))";
        Connection connection = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            connection = Connections.getSharedConnection(this.getContext());
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new ModelGeneralDescription(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("MINING_FUNCTION"), sQLHelper.rs.getString("ALGORITHM"), null, null, null, null);
                hashtable.put(((ModelGeneralDescription)object).getOwner() + "." + ((ModelGeneralDescription)object).getModelName(), object);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        object = this.getOutputModels();
        Iterator<RefModelType> iterator = object.iterator();
        while (iterator.hasNext()) {
            RefModelType refModelType = iterator.next();
            String string2 = refModelType.getSchema().toUpperCase() + "." + refModelType.getName().toUpperCase();
            ModelGeneralDescription modelGeneralDescription = (ModelGeneralDescription)hashtable.get(string2);
            if (modelGeneralDescription == null || !refModelType.getMiningAlgorithm().value().equals(modelGeneralDescription.getAlgorithm())) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }
}

