/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.awt.Window;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.preferences.ColumnFilterPreferencesPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttrImportantSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterReasonEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataQualitySettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;

public final class ColumnFilterNode
extends AbstractTransformNode
implements ApplyChainNode {
    public static final String COLUMN_FILTER_SETTINGS = "ColumnFilterSettings";
    public static final String COLUMN_FILTER_ATTRIBUTES = "ColumnFilterAttributes";
    public static final String AUTO_FILTERING = "autoFiltering";
    public static final String AUTO_REMOVE = "autoRemoveAttrs";
    public static final String ATTR_FILTERING = "attrFiltering";
    public static final String ATTR_OUTPUT = "attrOutput";
    public static final String ATTR_OUTPUTS = "attrOutputs";
    public static final String NULL_PERCENT = "nullPercent";
    public static final String UNIQUE_PERCENT = "uniquePercent";
    public static final String CONSTANT_PERCENT = "constantPercent";
    public static final String TARGET = "target";
    public static final String IMPORTANCE = "importance";
    public static final String RANK = "rank";
    public static final String SAMPLE_SIZE = "sampleSize";
    public static final String AI_TABLE = "AttrImportanceTable";
    public static final String AI_TABLE_GEN = "GenImportanceTable";
    public static final String AI_TABLE_NULL = "NULL";
    private HashMap<String, String> _ouputCopyLookupMap = new HashMap();
    private HashMap<String, String> _reasonHintsLookupMap = new HashMap();
    private HashMap<String, Statistics> _statisticLookupMap = new HashMap();

    public ColumnFilterNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResults() throws Exception {
        Connection connection = null;
        try {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
            if (columnFilterResultType != null) {
                Statistics statistics;
                Double d;
                Integer n;
                String string;
                String string2;
                this._statisticLookupMap.clear();
                connection = Connections.getUniqueConnection(this.getContext());
                SQLHelper sQLHelper = new SQLHelper();
                String string3 = columnFilterResultType.getAttrImportanceOutput();
                String string4 = columnFilterResultType.getDataQualityOutput();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
                String string5 = connectionFolder.getUserAccountName();
                if (string3 != null && DatabaseMetadataUtils.datasourceExists(connection, string5, string3)) {
                    string2 = "SELECT ATTRIBUTE_NAME, IMPORTANCE_VALUE, RANK FROM " + string3 + " ORDER BY ATTRIBUTE_NAME";
                    sQLHelper.pstmt = connection.prepareStatement(string2);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    string = null;
                    n = null;
                    d = null;
                    while (sQLHelper.rs.next()) {
                        string = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                        n = sQLHelper.rs.getInt("RANK");
                        d = sQLHelper.rs.getDouble("IMPORTANCE_VALUE");
                        statistics = new Statistics();
                        statistics.setRank(n);
                        statistics.setImportance(d);
                        this._statisticLookupMap.put(string, statistics);
                    }
                    sQLHelper.close();
                }
                if (string4 != null) {
                    string2 = "SELECT ATTR, DATA_TYPE, NULL_PERCENT, CONSTANT_PERCENT, DISTINCT_PERCENT FROM " + string4 + " ORDER BY ATTR";
                    sQLHelper.pstmt = connection.prepareStatement(string2);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    string = null;
                    n = null;
                    d = null;
                    statistics = null;
                    Statistics statistics2 = null;
                    while (sQLHelper.rs.next()) {
                        string = sQLHelper.rs.getString("ATTR");
                        Object object = sQLHelper.rs.getObject("NULL_PERCENT");
                        n = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        object = sQLHelper.rs.getObject("CONSTANT_PERCENT");
                        d = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        object = sQLHelper.rs.getObject("DISTINCT_PERCENT");
                        statistics = object != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
                        statistics2 = this._statisticLookupMap.containsKey(string) ? this._statisticLookupMap.get(string) : new Statistics();
                        statistics2.setNulls((Double)((Object)n));
                        statistics2.setUnique((Double)((Object)statistics));
                        statistics2.setConstant(d);
                        this._statisticLookupMap.put(string, statistics2);
                    }
                    sQLHelper.close();
                }
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings.getInstance();
        boolean bl = false;
        boolean bl2 = true;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        ColumnFilterAttributeType columnFilterAttributeType = new ColumnFilterAttributeType();
        columnFilterAttributeType.setAutomaticFilterEnable(bl ? AutoSpecType.YES : AutoSpecType.NO);
        columnFilterAttributeType.setAutoSpec(bl2 ? AutoSpecType.YES : AutoSpecType.NO);
        columnFilterNodeType.setColumnFilterAttributes(columnFilterAttributeType);
        columnFilterNodeType.setSQLExpression("");
        ColumnFilterSettingsType columnFilterSettingsType = new ColumnFilterSettingsType();
        columnFilterSettingsType.setNumberOfRows(columnFilterPreferenceSettings.getUseSampling() ? BigInteger.valueOf(columnFilterPreferenceSettings.getSamplingNumberOfRows()) : null);
        DataQualitySettingsType dataQualitySettingsType = new DataQualitySettingsType();
        dataQualitySettingsType.setNullsPercent(columnFilterPreferenceSettings.getUseNullsPercent() ? Double.valueOf(columnFilterPreferenceSettings.getNullsPercentValue()) : null);
        dataQualitySettingsType.setUniquePercent(columnFilterPreferenceSettings.getUseUniquePercent() ? Double.valueOf(columnFilterPreferenceSettings.getUniquePercentValue()) : null);
        dataQualitySettingsType.setConstantPercent(columnFilterPreferenceSettings.getUseConstantPercent() ? Double.valueOf(columnFilterPreferenceSettings.getConstantPercentValue()) : null);
        columnFilterSettingsType.setDataQualitySettings(dataQualitySettingsType);
        AttrImportantSettingsType attrImportantSettingsType = new AttrImportantSettingsType();
        attrImportantSettingsType.setTargetAttribute(null);
        attrImportantSettingsType.setCutOff(columnFilterPreferenceSettings.getUseCuttoff() ? Double.valueOf(columnFilterPreferenceSettings.getCutOffValue()) : null);
        attrImportantSettingsType.setTopN(columnFilterPreferenceSettings.getUseTopN() ? BigInteger.valueOf(columnFilterPreferenceSettings.getTopNValue()) : null);
        columnFilterSettingsType.setAttrImportantSettings(attrImportantSettingsType);
        columnFilterNodeType.setColumnFilterSettings(columnFilterSettingsType);
        ColumnFilterResultType columnFilterResultType = new ColumnFilterResultType();
        columnFilterResultType.setGenerateImportanceOutput(false);
        columnFilterNodeType.setColumnFilterResults(columnFilterResultType);
        columnFilterNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_COLUMN_FILTER_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
            if (attribute.getOutput().compareTo("Yes") != 0) continue;
            AttributeType attributeType = new AttributeType();
            attributeType.setName(attribute.getAlias() != null && !attribute.getAlias().trim().isEmpty() ? attribute.getAlias() : attribute.getName());
            attributeType.setAlias(null);
            attributeType.setDataType(attribute.getDataType());
            attributeType.setStatus(attribute.getStatus());
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    public List<AttributeType> getTargetAttributes() {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                try {
                    if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext(), attributeType.getDataType())) continue;
                    arrayList.add(attributeType);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    return null;
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object4;
        Object object2;
        Object object32;
        boolean bl2 = super.validate(bl);
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        boolean bl3 = columnFilterNodeType.getColumnFilterAttributes().getAutomaticFilterEnable().equals((Object)AutoSpecType.YES);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        ColumnFilterAttributeType columnFilterAttributeType = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
        AttributeType attributeType = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<AbstractNode> list = this.findDataNodes();
        for (AbstractNode object52 : list) {
            if (!(object52 instanceof DataProvider)) continue;
            for (Object object32 : ((DataProvider)((Object)object52)).getAttributes().getAttribute()) {
                String string = object32.getAlias();
                object2 = (string != null && string.trim().length() > 0 ? string : object32.getName()) + "." + object32.getDataType();
                hashMap.put((String)object2, object32);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Object object4 : columnFilterAttributeType.getAttribute()) {
            object32 = object4.getName() + "." + object4.getDataType();
            AttributeType attributeType2 = (AttributeType)hashMap.get(object32);
            if (attributeType2 == null) {
                if (list.size() > 0) {
                    if (attributeType != null && attributeType.getName().compareTo(object4.getName()) == 0 && attributeType.getDataType().equals(object4.getDataType())) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl5) {
                            this.addMessage("COLUMN_FILTER_INVAL_TARGET_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl5 = true;
                        }
                        object4.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("COLUMN_FILTER_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl4 = true;
                        }
                        bl2 = false;
                    } else {
                        arrayList.add(object4);
                        bl = true;
                    }
                } else {
                    object4.setStatus(AttributeStatus.INVALID);
                    if (!bl4) {
                        this.addMessage("COLUMN_FILTER_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    if (attributeType != null && attributeType.getName().compareTo(object4.getName()) == 0 && attributeType.getDataType().equals(object4.getDataType())) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl5) {
                            this.addMessage("COLUMN_FILTER_INVAL_TARGET_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl5 = true;
                        }
                    }
                    bl2 = false;
                }
                bl6 = true;
                continue;
            }
            if (!object4.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object4.setStatus(AttributeStatus.VALID);
            bl6 = true;
            if (attributeType == null || attributeType.getName().compareTo(object4.getName()) != 0 || !attributeType.getDataType().equals(object4.getDataType()) || !attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            attributeType.setStatus(AttributeStatus.VALID);
        }
        if (arrayList.size() > 0) {
            columnFilterAttributeType.getAttribute().removeAll(arrayList);
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Object object32 : columnFilterAttributeType.getAttribute()) {
            String string = object32.getName() + "." + object32.getDataType();
            hashMap2.put(string, object32);
        }
        object4 = new ArrayList();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            for (AttributeType attributeType3 : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                String string = attributeType3.getName() + "." + attributeType3.getDataType();
                ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)hashMap2.get(string);
                if (attribute != null) continue;
                ColumnFilterAttributeType.Attribute attribute2 = new ColumnFilterAttributeType.Attribute();
                attribute2.setAlias(attributeType3.getAlias());
                attribute2.setDataType(attributeType3.getDataType());
                attribute2.setName(attributeType3.getName());
                attribute2.setStatus(attributeType3.getStatus());
                attribute2.setAutomaticFiltering(bl3);
                attribute2.setOutput(bl3 ? "System" : "Yes");
                object4.add(attribute2);
            }
        }
        if (object4.size() > 0) {
            columnFilterAttributeType.getAttribute().addAll(object4);
            bl = true;
            bl6 = true;
        }
        object32 = new ArrayList();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object2 = new ComplexProperty(COLUMN_FILTER_ATTRIBUTES, columnFilterAttributeType);
            ((ComplexProperty)object2).setOldData(columnFilterNodeType.getColumnFilterAttributes());
            object32.add(object2);
        }
        object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object2).setOldData(this.getSQLExpression());
        object32.add(object2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object32);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        List<AbstractNode> list = this.findDataNodes();
        if (list.size() < 1) {
            this.addMessage("COLUMN_FILTER_NO_DATA", MessageEnumType.ERROR, new String[0]);
            bl = false;
        }
        if (columnFilterNodeType.getColumnFilterAttributes().getAttribute().size() == 0) {
            this.addMessage("COLUMN_FILTER_NO_OUTPUT", MessageEnumType.ERROR, new String[0]);
            bl = false;
        } else {
            boolean bl2 = false;
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                if (!attribute.getOutput().equals("Yes")) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addMessage("COLUMN_FILTER_NO_OUTPUT", MessageEnumType.ERROR, new String[0]);
                bl = false;
            }
        }
        if ((columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff() != null || columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN() != null) && columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() == null) {
            this.addMessage("COLUMN_FILTER_NO_TARGET", MessageEnumType.ERROR, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
            if (attribute.getOutput().compareTo("Yes") != 0) continue;
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("\"" + attribute.getName() + "\"");
            if (attribute.getAlias() == null) {
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer2.append(" \"" + attribute.getAlias() + "\"" + "\n");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("SELECT " + (ColumnFilterNode.generateSQLInlineHint() ? "/*+ inline */" : "") + "\n");
            stringBuffer.append(stringBuffer2 + "\n");
            stringBuffer.append("FROM {INPUT_SOURCE}\n");
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    @Override
    public void setProperty(String string, Object object) {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        if (string.equals(COLUMN_FILTER_SETTINGS)) {
            ColumnFilterSettingsType columnFilterSettingsType = (ColumnFilterSettingsType)object;
            columnFilterNodeType.setColumnFilterSettings(columnFilterSettingsType);
        } else if (string.equals(COLUMN_FILTER_ATTRIBUTES)) {
            ColumnFilterAttributeType columnFilterAttributeType = (ColumnFilterAttributeType)object;
            columnFilterNodeType.setColumnFilterAttributes(columnFilterAttributeType);
        } else if (string.equals(AUTO_FILTERING)) {
            columnFilterNodeType.getColumnFilterAttributes().setAutomaticFilterEnable((AutoSpecType)object);
        } else if (string.equals(AUTO_REMOVE)) {
            columnFilterNodeType.getColumnFilterAttributes().setAutoSpec((AutoSpecType)object);
        } else if (string.equals(ATTR_FILTERING)) {
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)object;
            for (ColumnFilterAttributeType.Attribute attribute2 : list) {
                if (!attribute2.getName().equals(attribute.getName())) continue;
                attribute2.setAutomaticFiltering(attribute.isAutomaticFiltering());
                break;
            }
        } else if (string.equals(ATTR_OUTPUT)) {
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)object;
            for (ColumnFilterAttributeType.Attribute attribute3 : list) {
                if (!attribute3.getName().equals(attribute.getName())) continue;
                attribute3.setOutput(attribute.getOutput());
                break;
            }
        } else if (string.equals(ATTR_OUTPUTS)) {
            Map map = (Map)object;
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            for (ColumnFilterAttributeType.Attribute attribute : list) {
                String string2 = (String)map.get(attribute.getName());
                if (string2 == null) continue;
                attribute.setOutput(string2);
            }
        } else if (string.equals(NULL_PERCENT)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setNullsPercent((Double)object);
        } else if (string.equals(UNIQUE_PERCENT)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setUniquePercent((Double)object);
        } else if (string.equals(CONSTANT_PERCENT)) {
            columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().setConstantPercent((Double)object);
        } else if (string.equals(TARGET)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setTargetAttribute((AttributeType)object);
        } else if (string.equals(IMPORTANCE)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setCutOff((Double)object);
        } else if (string.equals(RANK)) {
            columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().setTopN((BigInteger)object);
        } else if (string.equals(SAMPLE_SIZE)) {
            columnFilterNodeType.getColumnFilterSettings().setNumberOfRows((BigInteger)object);
        } else if (string.equals(AI_TABLE)) {
            if (object != null) {
                if (object.equals(AI_TABLE_NULL)) {
                    columnFilterNodeType.getColumnFilterResults().setGenerateImportanceOutput(false);
                } else {
                    columnFilterNodeType.getColumnFilterResults().setGenerateImportanceOutput(true);
                    if (columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() == null) {
                        columnFilterNodeType.getColumnFilterResults().setAttrImportanceOutput((String)object);
                    }
                }
            }
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                columnFilterNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                columnFilterNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(COLUMN_FILTER_SETTINGS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(COLUMN_FILTER_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_FILTERING)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AI_TABLE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_REMOVE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ATTR_FILTERING) || complexProperty.getPropertyName().equals(ATTR_OUTPUT)) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)complexProperty.getOldData();
            boolean bl = false;
            List list = columnFilterNodeType.getColumnFilterAttributes().getAttribute();
            for (ColumnFilterAttributeType.Attribute attribute2 : list) {
                attribute = (ColumnFilterAttributeType.Attribute)complexProperty.getOldData();
                if (!attribute2.getName().equals(attribute.getName())) continue;
                bl = true;
                break;
            }
            return bl ? attribute : null;
        }
        if (complexProperty.getPropertyName().equals(ATTR_OUTPUTS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(NULL_PERCENT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(UNIQUE_PERCENT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(CONSTANT_PERCENT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(TARGET)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(IMPORTANCE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(RANK)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SAMPLE_SIZE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        Object object = null;
        if (string.equals(COLUMN_FILTER_SETTINGS)) {
            object = columnFilterNodeType.getColumnFilterSettings();
        } else if (string.equals(COLUMN_FILTER_ATTRIBUTES)) {
            object = columnFilterNodeType.getColumnFilterAttributes();
        } else if (string.equals(NULL_PERCENT)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getNullsPercent();
        } else if (string.equals(UNIQUE_PERCENT)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getUniquePercent();
        } else if (string.equals(CONSTANT_PERCENT)) {
            object = columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getConstantPercent();
        } else if (string.equals(TARGET)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
        } else if (string.equals(IMPORTANCE)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff();
        } else if (string.equals(RANK)) {
            object = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN();
        } else if (string.equals(SAMPLE_SIZE)) {
            object = columnFilterNodeType.getColumnFilterSettings().getNumberOfRows();
        } else if (string.equals(AI_TABLE)) {
            object = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        } else if (string.equals(AI_TABLE_GEN)) {
            object = columnFilterNodeType.getColumnFilterResults().isGenerateImportanceOutput();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public HashMap<String, String> getOuputCopyLookupMap() {
        this._ouputCopyLookupMap.clear();
        if (!this.isNew()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                this._ouputCopyLookupMap.put(attribute.getName(), attribute.getOutput());
            }
        }
        return this._ouputCopyLookupMap;
    }

    public HashMap<String, String> getReasonHintsLookupMap() {
        ColumnFilterNodeType columnFilterNodeType;
        ColumnFilterResultType columnFilterResultType;
        this._reasonHintsLookupMap.clear();
        if (!this.isNew() && (columnFilterResultType = (columnFilterNodeType = (ColumnFilterNodeType)this.getData()).getColumnFilterResults()) != null) {
            for (ColumnFilterResultType.Attribute attribute : columnFilterResultType.getAttribute()) {
                if (attribute.getReason() == null || attribute.getReason().size() <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (ColumnFilterResultType.Attribute.Reason reason : attribute.getReason()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.NULL_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_NULL_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.CONSTANT_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_CONSTANT_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.UNIQUE_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_UNIQUE_LIMIT_ERROR"));
                        continue;
                    }
                    if (reason.getType().equals((Object)ColumnFilterReasonEnumType.TOPN_LIMIT)) {
                        stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_TOPN_LIMIT_ERROR"));
                        continue;
                    }
                    if (!reason.getType().equals((Object)ColumnFilterReasonEnumType.CUTOFF_LIMIT)) continue;
                    stringBuffer.append(DialogsLrb.get("COLUMN_FILTER_CUTOFF_LIMIT_ERROR"));
                }
                this._reasonHintsLookupMap.put(attribute.getName(), stringBuffer.toString());
            }
        }
        return this._reasonHintsLookupMap;
    }

    public HashMap<String, Statistics> getStatisticLookupMap() {
        return this._statisticLookupMap;
    }

    public boolean isNew() {
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData();
        String string = columnFilterNodeType.getColumnFilterResults().getDataQualityOutput();
        String string2 = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        return string == null && string2 == null;
    }

    @Override
    public String getHelpTopic() {
        return "columnfilter_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_COLUMN_FILTER_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_ICON"));
    }

    @Override
    public void refactorForApply() throws Exception {
    }

    public class Statistics {
        Integer _rank;
        Double _importance;
        Double _nulls;
        Double _unique;
        Double _constant;

        public Statistics() {
            this(null, null, null, null, null);
        }

        public Statistics(Integer n, Double d, Double d2, Double d3, Double d4) {
            this._rank = n;
            this._importance = d;
            this._nulls = d2;
            this._unique = d3;
            this._constant = d4;
        }

        public void setRank(Integer n) {
            this._rank = n;
        }

        public Integer getRank() {
            return this._rank;
        }

        public void setImportance(Double d) {
            this._importance = d;
        }

        public Double getImportance() {
            return this._importance;
        }

        public void setNulls(Double d) {
            this._nulls = d;
        }

        public Double getNulls() {
            return this._nulls;
        }

        public void setUnique(Double d) {
            this._unique = d;
        }

        public Double getUnique() {
            return this._unique;
        }

        public void setConstant(Double d) {
            this._constant = d;
        }

        public Double getConstant() {
            return this._constant;
        }
    }
}

