/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.awt.Component;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PerformanceType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;

public final class ClassificationBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    public static final String PERFORMANCE = "BUILD_SETTING_PERFORM_OPTION";
    public static final String NBSETTINGS = "naiveBayesSettings";
    public static final String PAIRWISETHRESHOLD = "PAIRWISETHRESHOLD";
    public static final String SINGLETONTHRESHOLD = "SINGLETONTHRESHOLD";
    public static final String DTSETTINGS = "decisionTreeSettings";
    public static final String TREE_IMPURITY_METRIC = "TREE_IMPURITY_METRIC";
    public static final String TREE_TERM_MAX_DEPTH = "TREE_TERM_MAX_DEPTH";
    public static final String TREE_TERM_MINREC_NODE = "TREE_TERM_MINREC_NODE";
    public static final String TREE_TERM_MINPCT_NODE = "TREE_TERM_MINPCT_NODE";
    public static final String TREE_TERM_MINREC_SPLIT = "TREE_TERM_MINREC_SPLIT";
    public static final String TREE_TERM_MINPCT_SPLIT = "TREE_TERM_MINPCT_SPLIT";
    public static final String SVMSETTINGS = "svmSettings";
    public static final String SVMS_KERNEL_FUNCTION = "SVMS_KERNEL_FUNCTION";
    public static final String SVMS_CONV_TOLERANCE = "SVMS_CONV_TOLERANCE";
    public static final String SVMS_COMPLEXITY_FACTOR = "SVMS_COMPLEXITY_FACTOR";
    public static final String SVMS_ACTIVE_LEARNING = "SVMS_ACTIVE_LEARNING";
    public static final String SVMS_STD_DEV = "SVMS_STD_DEV";
    public static final String SVMS_KERNEL_CACHE_SIZE = "SVMS_KERNEL_CACHE_SIZE";
    public static final String GLMSETTINGS = "glmSettings";
    public static final String GLMS_CONF_LEVEL = "GLMS_CONF_LEVEL";
    public static final String GLMS_DIAGNOSTICS_TABLE_NAME = "GLMS_DIAGNOSTICS_TABLE_NAME";
    public static final String GLMS_REFERENCE_CLASS_NAME = "GLMS_REFERENCE_CLASS_NAME";
    public static final String GLMS_RIDGE_REGRESSION = "GLMS_RIDGE_REGRESSION";
    public static final String GLMS_RIDGE_VALUE = "GLMS_RIDGE_VALUE";
    public static final String GLMS_VIF_FOR_RIDGE = "GLMS_VIF_FOR_RIDGE";
    public static final String GLMS_MISSING_VALUE_TREATMENT = "GLMS_MISSING_VALUE_TREATMENT";
    public static final String GLMS_ROW_WEIGHT_COLUMN_NAME = "GLMS_ROW_WEIGHT_COLUMN_NAME";
    public static final String COST_BENEFIT = "costBenefit";
    public static final String TUNING_CHANGED = "tuningChanged";
    public static final String TEST_RESULTS = "classTestResults";
    private static Preferences _p = Preferences.getPreferences();
    private ClassificationModelBuildPreferencesPanelSettings classBuildPref = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public ClassificationBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
        topNTargets.setValue(BigInteger.valueOf(100L));
        classificationTestSettingsType.setTopNTargets(topNTargets);
        classificationBuildNodeType.setTestSettings(classificationTestSettingsType);
        ClassificationBuildNodeType.Models models = new ClassificationBuildNodeType.Models();
        ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
        classificationBuildNodeType.setModels(models);
        classificationBuildNodeType.setResults(results);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.classBuildPref.isNb()) {
            arrayList.add("ALGO_NAIVE_BAYES");
        }
        if (this.classBuildPref.isDt()) {
            arrayList.add("ALGO_DECISION_TREE");
        }
        if (this.classBuildPref.isSvm()) {
            arrayList.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.classBuildPref.isGlm()) {
            arrayList.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "CLASSIFICATION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.classBuildPref.isNb()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewNaiveBayesModel((NaiveBayesModelType)modelType);
        }
        if (this.classBuildPref.isDt()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewDecisionTreeModel((DecisionTreeModelType)modelType);
        }
        if (this.classBuildPref.isSvm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNewSVMModel((CSupportVectorMachineModelType)modelType);
        }
        if (this.classBuildPref.isGlm()) {
            modelType = this.createNewClassificationModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addNewGLMModel((CGeneralizedLinearModelType)modelType);
        }
        classificationBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addNewNaiveBayesModel(NaiveBayesModelType naiveBayesModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getNaiveBayesModel();
        list.add(naiveBayesModelType);
    }

    public void addNewDecisionTreeModel(DecisionTreeModelType decisionTreeModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getDecisionTreeModel();
        list.add(decisionTreeModelType);
    }

    public void addNewSVMModel(CSupportVectorMachineModelType cSupportVectorMachineModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCSupportVectorMachineModel();
        list.add(cSupportVectorMachineModelType);
    }

    public void addNewGLMModel(CGeneralizedLinearModelType cGeneralizedLinearModelType) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        List list = models.getCGeneralizedLinearModel();
        list.add(cGeneralizedLinearModelType);
    }

    public ModelType createNewClassificationModel(String string, String string2, String string3) {
        return this.createNewModel(string, string2, "CLASSIFICATION", string3);
    }

    @Override
    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        ClassificationModelType classificationModelType = (ClassificationModelType)super.createNewModel(string, string2, string3, string4);
        PerformanceType performanceType = new PerformanceType();
        PerformanceType.Balanced balanced = new PerformanceType.Balanced();
        performanceType.setBalanced(balanced);
        TuningType tuningType = new TuningType();
        tuningType.setNone(new TuningType.None());
        classificationModelType.setPerformance(performanceType);
        classificationModelType.setTuning(tuningType);
        return classificationModelType;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (!classificationBuildNodeType.getResults().getClassificationResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TEST_RESULTS, new ClassificationBuildNodeType.Results());
        }
        super.refactor(node, bl);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
        if (models.getNaiveBayesModel().isEmpty() && models.getDecisionTreeModel().isEmpty() && models.getCSupportVectorMachineModel().isEmpty() && models.getCGeneralizedLinearModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNaiveBayesModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getDecisionTreeModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCSupportVectorMachineModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getCGeneralizedLinearModel())) {
                bl3 = false;
            }
            HashMap<String, NaiveBayesModelType> hashMap = new HashMap<String, NaiveBayesModelType>();
            for (Object object2 : models.getNaiveBayesModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getDecisionTreeModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            for (Object object2 : models.getCGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (NaiveBayesModelType)object2);
            }
            ClassificationBuildNodeType.Results results = new ClassificationBuildNodeType.Results();
            for (Object object3 : classificationBuildNodeType.getResults().getClassificationResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (ClassificationResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getClassificationResult().add(object);
            }
            boolean bl5 = bl4 = results.getClassificationResult().size() != classificationBuildNodeType.getResults().getClassificationResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty(TEST_RESULTS, results);
                complexProperty.setOldData(classificationBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals(NBSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getNaiveBayesModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (NaiveBayesModelType naiveBayesModelType : list) {
                if (!naiveBayesModelType.getId().equals(string2)) continue;
                NaiveBayesAlgoType naiveBayesAlgoType = naiveBayesModelType.getNaiveBayesAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(PAIRWISETHRESHOLD)) {
                        naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SINGLETONTHRESHOLD)) {
                        naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    naiveBayesModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(DTSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getDecisionTreeModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list3 = (List)object;
            if (list3.isEmpty()) {
                return;
            }
            String string3 = ((Property)list3.get(0)).getId();
            for (DecisionTreeModelType decisionTreeModelType : list) {
                if (!decisionTreeModelType.getId().equals(string3)) continue;
                for (Property property : list3) {
                    BigInteger bigInteger;
                    DecisionTreeAlgoType decisionTreeAlgoType = decisionTreeModelType.getDecisionTreeAlgo();
                    if (decisionTreeAlgoType == null) continue;
                    if (property.getDescription().equals(TREE_IMPURITY_METRIC)) {
                        decisionTreeAlgoType.setTREEIMPURITYMETRIC((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MAX_DEPTH)) {
                        decisionTreeAlgoType.setTREETERMMAXDEPTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_NODE)) {
                        bigInteger = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECNODE(bigInteger);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_NODE)) {
                        decisionTreeAlgoType.setTREETERMMINPCTNODE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINREC_SPLIT)) {
                        bigInteger = new BigInteger(property.getValue().toString());
                        decisionTreeAlgoType.setTREETERMMINRECSPLIT(bigInteger);
                        continue;
                    }
                    if (property.getDescription().equals(TREE_TERM_MINPCT_SPLIT)) {
                        decisionTreeAlgoType.setTREETERMMINPCTSPLIT((double)((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    decisionTreeModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(SVMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCSupportVectorMachineModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list4 = (List)object;
            if (list4.isEmpty()) {
                return;
            }
            String string4 = ((Property)list4.get(0)).getId();
            for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
                if (!cSupportVectorMachineModelType.getId().equals(string4)) continue;
                for (Property property : list4) {
                    CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo();
                    if (property.getDescription().equals(SVMS_KERNEL_FUNCTION)) {
                        cSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_CONV_TOLERANCE)) {
                        cSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_COMPLEXITY_FACTOR)) {
                        cSupportVectorMachineAlgoType.setSVMSCOMPLEXITYFACTOR((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_ACTIVE_LEARNING)) {
                        cSupportVectorMachineAlgoType.setSVMSACTIVELEARNING((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_STD_DEV)) {
                        cSupportVectorMachineAlgoType.setSVMSSTDDEV((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(SVMS_KERNEL_CACHE_SIZE)) {
                        Object object2 = property.getValue();
                        if (object2 == null) {
                            cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
                            continue;
                        }
                        BigInteger bigInteger = new BigInteger(object2.toString());
                        cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(bigInteger);
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    cSupportVectorMachineModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals(GLMSETTINGS)) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getCGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list5 = (List)object;
            if (list5.isEmpty()) {
                return;
            }
            String string5 = ((Property)list5.get(0)).getId();
            for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
                if (!cGeneralizedLinearModelType.getId().equals(string5)) continue;
                for (Property property : list5) {
                    CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo();
                    if (property.getDescription().equals(GLMS_CONF_LEVEL)) {
                        cGeneralizedLinearAlgoType.setGLMSCONFLEVEL(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_DIAGNOSTICS_TABLE_NAME)) {
                        cGeneralizedLinearAlgoType.setGLMSDIAGNOSTICSTABLENAME((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_REFERENCE_CLASS_NAME)) {
                        cGeneralizedLinearAlgoType.setGLMSREFERENCECLASSNAME((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_RIDGE_REGRESSION)) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEREGRESSION((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_RIDGE_VALUE)) {
                        cGeneralizedLinearAlgoType.setGLMSRIDGEVALUE((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_VIF_FOR_RIDGE)) {
                        cGeneralizedLinearAlgoType.setGLMSVIFFORRIDGE((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_MISSING_VALUE_TREATMENT)) {
                        cGeneralizedLinearAlgoType.setODMSMISSINGVALUETREATMENT((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(GLMS_ROW_WEIGHT_COLUMN_NAME)) {
                        cGeneralizedLinearAlgoType.setODMSROWWEIGHTCOLUMNNAME((String)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals(PERFORMANCE)) continue;
                    cGeneralizedLinearModelType.setPerformance((PerformanceType)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list6 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (list6.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list7 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)classificationBuildNodeType, modelType);
                if (!list7.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)classificationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            classificationBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("alltestsRemoved")) {
            ClassificationBuildNodeType classificationBuildNodeType2 = (ClassificationBuildNodeType)this.getData();
            if (classificationBuildNodeType2.getResults() != null && !classificationBuildNodeType2.getResults().getClassificationResult().isEmpty()) {
                classificationBuildNodeType2.getResults().getClassificationResult().clear();
            }
        } else if (string.equals("testsRemoved")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType3 = (ClassificationBuildNodeType)this.getData();
            List list8 = classificationBuildNodeType3.getResults().getClassificationResult();
            block10: for (MiningResultType miningResultType : list) {
                for (ClassificationResultType classificationResultType : list8) {
                    if (!classificationResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list8.remove(classificationResultType);
                    continue block10;
                }
            }
        } else if (string.equals("alltestsRestored")) {
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType4 = (ClassificationBuildNodeType)this.getData();
            classificationBuildNodeType4.getResults().getClassificationResult().clear();
            classificationBuildNodeType4.getResults().getClassificationResult().addAll(list);
        } else if (string.equals("testsRestored")) {
            Object object32;
            ClassificationBuildNodeType classificationBuildNodeType5 = (ClassificationBuildNodeType)this.getData();
            List list = classificationBuildNodeType5.getResults().getClassificationResult();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object32 : list) {
                hashMap.put(object32.getModelId(), object32);
            }
            List list9 = (List)object;
            object32 = list9.iterator();
            while (object32.hasNext()) {
                ClassificationResultType classificationResultType = (ClassificationResultType)object32.next();
                if (null != hashMap.get(classificationResultType.getModelId())) continue;
                list.add(classificationResultType);
            }
        } else if (string.equals("testSettingsChanged")) {
            if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                return;
            }
            ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
            classificationBuildNodeType.setTestSettings(classificationTestSettingsType);
        } else if (string.equals(TUNING_CHANGED)) {
            if (object == null || !(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType6 = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string6 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType6, string6);
                ((ClassificationModelType)modelType).setTuning((TuningType)map.get(string6));
            }
        } else if (string.equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(this);
            Map map = (Map)object;
            for (ClassificationResultType classificationResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(classificationResultType.getModelId());
                if (null == modelStatusType) continue;
                classificationResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType7 = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType7, string7);
                modelType.setStatus((ModelStatusType)map.get(string7));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ClassificationBuildNodeType classificationBuildNodeType8 = (ClassificationBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType8, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(TEST_RESULTS)) {
            classificationBuildNodeType.setResults((ClassificationBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SVMSETTINGS) || complexProperty.getPropertyName().equals(NBSETTINGS) || complexProperty.getPropertyName().equals(GLMSETTINGS) || complexProperty.getPropertyName().equals(DTSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals(TUNING_CHANGED)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, TuningType> hashMap = new HashMap<String, TuningType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, ((ClassificationModelType)modelType).getTuning());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (ClassificationResultType classificationResultType : list) {
                if (null == map.get(classificationResultType.getModelId())) continue;
                hashMap.put(classificationResultType.getModelId(), classificationResultType.getStatus());
            }
            return hashMap;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)classificationBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)modelType).getCSupportVectorMachineAlgo();
            if (string2.equals(SVMS_KERNEL_FUNCTION)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION();
            }
            if (string2.equals(SVMS_CONV_TOLERANCE)) {
                return cSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE();
            }
            if (string2.equals(SVMS_COMPLEXITY_FACTOR)) {
                return cSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR();
            }
            if (string2.equals(SVMS_ACTIVE_LEARNING)) {
                return cSupportVectorMachineAlgoType.getSVMSACTIVELEARNING();
            }
            if (string2.equals(SVMS_STD_DEV)) {
                return cSupportVectorMachineAlgoType.getSVMSSTDDEV();
            }
            if (string2.equals(SVMS_KERNEL_CACHE_SIZE)) {
                return cSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((CSupportVectorMachineModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof NaiveBayesModelType) {
            NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)modelType).getNaiveBayesAlgo();
            if (string2.equals("NABS_PAIRWISE_THRESHOLD")) {
                return naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD();
            }
            if (string2.equals("NABS_SINGLETON_THRESHOLD")) {
                return naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((NaiveBayesModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof DecisionTreeModelType) {
            DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)modelType).getDecisionTreeAlgo();
            if (string2.equals(TREE_IMPURITY_METRIC)) {
                return decisionTreeAlgoType.getTREEIMPURITYMETRIC();
            }
            if (string2.equals(TREE_TERM_MAX_DEPTH)) {
                return decisionTreeAlgoType.getTREETERMMAXDEPTH();
            }
            if (string2.equals(TREE_TERM_MINREC_NODE)) {
                return decisionTreeAlgoType.getTREETERMMINRECNODE();
            }
            if (string2.equals(TREE_TERM_MINPCT_NODE)) {
                return decisionTreeAlgoType.getTREETERMMINPCTNODE();
            }
            if (string2.equals(TREE_TERM_MINREC_SPLIT)) {
                return decisionTreeAlgoType.getTREETERMMINRECSPLIT();
            }
            if (string2.equals(TREE_TERM_MINPCT_SPLIT)) {
                return decisionTreeAlgoType.getTREETERMMINPCTSPLIT();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((DecisionTreeModelType)modelType).getPerformance();
            }
        } else if (modelType instanceof CGeneralizedLinearModelType) {
            CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)modelType).getCGeneralizedLinearAlgo();
            if (string2.equals(GLMS_DIAGNOSTICS_TABLE_NAME)) {
                return cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME();
            }
            if (string2.equals(GLMS_CONF_LEVEL)) {
                return cGeneralizedLinearAlgoType.getGLMSCONFLEVEL();
            }
            if (string2.equals(GLMS_RIDGE_REGRESSION)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION();
            }
            if (string2.equals(GLMS_REFERENCE_CLASS_NAME)) {
                return cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME();
            }
            if (string2.equals(GLMS_RIDGE_VALUE)) {
                return cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE();
            }
            if (string2.equals(GLMS_VIF_FOR_RIDGE)) {
                return cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE();
            }
            if (string2.equals(PERFORMANCE)) {
                return ((CGeneralizedLinearModelType)modelType).getPerformance();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = classificationBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("testOptionsChanged")) {
            return classificationBuildNodeType.getTestDataSource();
        }
        if (string.equals("testSettingsChanged")) {
            return classificationBuildNodeType.getTestSettings();
        }
        if (string.equals(COST_BENEFIT)) {
            // empty if block
        }
        if (string.equals(TEST_RESULTS)) {
            return classificationBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string3 = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (CSupportVectorMachineModelType cSupportVectorMachineModelType : list) {
            String string3 = cSupportVectorMachineModelType.getCSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(cSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        RefModelType refModelType;
        Object object;
        Object object2;
        Object object32;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getDecisionTreeModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.CLASSIFICATION;
        String string = classificationBuildNodeType.getId();
        Connection connection = Connections.getSharedConnection(this.getContext());
        String string2 = Connections.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        for (Object object32 : list) {
            if (object32.getPerformance().getBalanced() != null || object32.getPerformance().getCustom() != null) {
                object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
                arrayList.add((RefModelType)object2);
                continue;
            }
            if (object32.getTuning().getBenefit() == null && object32.getTuning().getCost() == null && object32.getTuning().getCustom() == null) continue;
            object2 = MetaDataHelper.createRefModelType((ModelType)object32, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object2);
        }
        List list2 = classificationBuildNodeType.getModels().getNaiveBayesModel();
        object32 = list2.iterator();
        while (object32.hasNext()) {
            object2 = (NaiveBayesModelType)object32.next();
            if (object2.getTuning().getBenefit() == null && object2.getTuning().getCost() == null && object2.getTuning().getCustom() == null) continue;
            object = MetaDataHelper.createRefModelType((ModelType)object2, miningFunctionType, string2, string);
            arrayList.add((RefModelType)object);
        }
        object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (CSupportVectorMachineModelType)object2.next();
            if (object.getTuning().getBenefit() == null && object.getTuning().getCost() == null && object.getTuning().getCustom() == null) continue;
            refModelType = MetaDataHelper.createRefModelType((ModelType)object, miningFunctionType, string2, string);
            arrayList.add(refModelType);
        }
        object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        object = object2.iterator();
        while (object.hasNext()) {
            refModelType = (CGeneralizedLinearModelType)object.next();
            if (refModelType.getTuning().getBenefit() == null && refModelType.getTuning().getCost() == null && refModelType.getTuning().getCustom() == null) continue;
            RefModelType refModelType2 = MetaDataHelper.createRefModelType((ModelType)refModelType, miningFunctionType, string2, string);
            arrayList.add(refModelType2);
        }
        return arrayList;
    }

    @Override
    public Map<String, String> getRowDiagnosticTables() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
        for (CGeneralizedLinearModelType cGeneralizedLinearModelType : list) {
            String string = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            hashMap.put(cGeneralizedLinearModelType.getName(), string);
        }
        return hashMap;
    }

    public TuningType getModelTuning(String string) {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        try {
            if (classificationBuildNodeType != null) {
                Object object;
                Object object2;
                Object object32;
                List list = classificationBuildNodeType.getModels().getNaiveBayesModel();
                for (Object object32 : list) {
                    if (!object32.getId().equals(string)) continue;
                    return object32.getTuning();
                }
                List list2 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                object32 = list2.iterator();
                while (object32.hasNext()) {
                    object2 = (DecisionTreeModelType)object32.next();
                    if (!object2.getId().equals(string)) continue;
                    return object2.getTuning();
                }
                object32 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (CSupportVectorMachineModelType)object2.next();
                    if (!object.getId().equals(string)) continue;
                    return object.getTuning();
                }
                object2 = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                object = object2.iterator();
                while (object.hasNext()) {
                    CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object.next();
                    if (!cGeneralizedLinearModelType.getId().equals(string)) continue;
                    return cGeneralizedLinearModelType.getTuning();
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.CLASSIFICATION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this.getData();
        return classificationBuildNodeType.getTargetAttribute();
    }

    @Override
    public String getHelpTopic() {
        return "classification_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CLASSIFICATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_ICON"));
    }
}

