/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyPreferencesPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterIdType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusterSetType;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureSetType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureValueType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionBoundsType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionCostType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionSetType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;

public class ApplyNode
extends AbstractTransformNode
implements ModelConsumer {
    public static final String APPLY_SCORE_OUTPUT_COLUMNS = "applyScoreOutputColumns";
    public static final String APPLY_SUPPLEMENTAL_COLUMNS = "applySupplementalColumns";
    public static final String APPLY_COLUMN_OUTPUT_ORDER = "applyColumnOutputOrder";
    private boolean _isEnableLegacyApplyOutputTypes;
    private boolean _is12gDB;

    public ApplyNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.detectDBVersion();
    }

    private void detectDBVersion() {
        this._is12gDB = DatabaseMetadataUtils.isCompatibleDB(this.getContext(), "12.1");
        this._isEnableLegacyApplyOutputTypes = this._is12gDB ? DatabaseMetadataUtils.isEnableLegacyApplyOutputTypes(this.getContext()) : true;
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ApplyPreferencesPanel.ApplyPreferenceSettings applyPreferenceSettings = ApplyPreferencesPanel.ApplyPreferenceSettings.getInstance();
        boolean bl = applyPreferenceSettings.getAutomaticSettingModel();
        boolean bl2 = applyPreferenceSettings.getAutomaticSettingData();
        boolean bl3 = applyPreferenceSettings.getDataColumnsFirst();
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        ApplyOutputColumnsType applyOutputColumnsType = new ApplyOutputColumnsType();
        applyOutputColumnsType.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        applyNodeType.setOutputColumns(applyOutputColumnsType);
        SupplementalAttributesType supplementalAttributesType = new SupplementalAttributesType();
        supplementalAttributesType.setAutoSpec(AutoSpecType.NO);
        applyNodeType.setSupplementalAttributes(supplementalAttributesType);
        applyNodeType.setColumnOutputOrder(bl3 ? "SupplementalColumns" : "OutputColumns");
        applyNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_APPLY_NODE_NAME");
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof AbstractDataNode) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof AbstractDataNode)) continue;
                bl = false;
                break;
            }
        } else {
            ModelNodeType modelNodeType;
            bl = node instanceof SupervisedBuildNode ? true : (node instanceof ClusteringBuildNode ? true : (node instanceof AnomalyDetectionBuildNode ? true : (node instanceof FeatureExtractionBuildNode ? true : (node instanceof AbstractModelNode ? (modelNodeType = (ModelNodeType)node.getData()).getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION || modelNodeType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || modelNodeType.getMiningFunction() == MiningFunctionType.CLUSTERING || modelNodeType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION || modelNodeType.getMiningFunction() == MiningFunctionType.REGRESSION : false))));
        }
        return bl;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_APPLY_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_APPLY_ICON"));
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        Attributes attributes2 = new Attributes();
        Attributes attributes3 = new Attributes();
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        for (AttributeType attributeType : applyNodeType.getSupplementalAttributes().getAttribute()) {
            attributes2.getAttribute().add(attributeType);
        }
        for (AttributeType attributeType : applyNodeType.getOutputColumns().getOutputColumn()) {
            String string;
            TargetInfo targetInfo;
            String string2 = "UNKNOWN";
            AttributeType attributeType2 = new AttributeType();
            if (attributeType.getClusterId() != null) {
                attributeType2.setName(attributeType.getClusterId().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string2 = targetInfo.getDataType();
            } else if (attributeType.getClusterProbability() != null) {
                attributeType2.setName(attributeType.getClusterProbability().getColumn().getName());
                string2 = this._isEnableLegacyApplyOutputTypes ? "NUMBER" : "BINARY_DOUBLE";
            } else if (attributeType.getClusterSet() != null) {
                attributeType2.setName(attributeType.getClusterSet().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string = targetInfo.getMiningType();
                string2 = string.equals("Categorical") ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_CLUSTER_SET_CAT" : "ODMR_CLUSTER_SET_CATPD") : (this._isEnableLegacyApplyOutputTypes ? "ODMR_CLUSTER_SET_NUM" : "ODMR_CLUSTER_SET_NUMPD");
            } else if (attributeType.getFeatureId() != null) {
                attributeType2.setName(attributeType.getFeatureId().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string2 = targetInfo.getDataType();
            } else if (attributeType.getFeatureSet() != null) {
                attributeType2.setName(attributeType.getFeatureSet().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string = targetInfo.getMiningType();
                string2 = string.equals("Categorical") ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_FEATURE_SET_CAT" : "ODMR_FEATURE_SET_CATVD") : (this._isEnableLegacyApplyOutputTypes ? "ODMR_FEATURE_SET_NUM" : "ODMR_FEATURE_SET_NUMVD");
            } else if (attributeType.getFeatureValue() != null) {
                attributeType2.setName(attributeType.getFeatureValue().getColumn().getName());
                string2 = this._isEnableLegacyApplyOutputTypes ? "NUMBER" : "BINARY_DOUBLE";
            } else if (attributeType.getPrediction() != null) {
                attributeType2.setName(attributeType.getPrediction().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string2 = targetInfo.getDataType();
            } else if (attributeType.getPredictionCost() != null) {
                attributeType2.setName(attributeType.getPredictionCost().getColumn().getName());
                string2 = this._isEnableLegacyApplyOutputTypes ? "NUMBER" : "BINARY_DOUBLE";
            } else if (attributeType.getPredictionDetails() != null) {
                attributeType2.setName(attributeType.getPredictionDetails().getColumn().getName());
                string2 = "XMLTYPE";
            } else if (attributeType.getPredictionProbability() != null) {
                attributeType2.setName(attributeType.getPredictionProbability().getColumn().getName());
                string2 = this._isEnableLegacyApplyOutputTypes ? "NUMBER" : "BINARY_DOUBLE";
            } else if (attributeType.getPredictionSet() != null) {
                attributeType2.setName(attributeType.getPredictionSet().getColumn().getName());
                targetInfo = ApplyNode.findTargetMiningTypeFromModel(this, attributeType.getModel());
                string = targetInfo.getMiningType();
                String string3 = targetInfo.getDataType();
                boolean bl = ApplyNode.doesModelCostExist(this, attributeType.getModel());
                string2 = string.equals("Categorical") ? (bl ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_CAT_COST" : "ODMR_PREDICTION_SET_CAT_COSTPD") : (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_CAT" : "ODMR_PREDICTION_SET_CATPD")) : (bl ? (string3 == "BINARY_DOUBLE" ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTD") : (string3 == "BINARY_FLOAT" ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTF") : (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTN"))) : (string3 == "BINARY_DOUBLE" ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_D") : (string3 == "BINARY_FLOAT" ? (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_F") : (this._isEnableLegacyApplyOutputTypes ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_N"))));
            } else if (attributeType.getPredictionBounds() != null) {
                if (attributeType.getPredictionBounds().getColumn().getLowerBound() != null) {
                    attributeType2.setName(attributeType.getPredictionBounds().getColumn().getLowerBound());
                }
                if (attributeType.getPredictionBounds().getColumn().getUpperBound() != null) {
                    attributeType2.setName(attributeType.getPredictionBounds().getColumn().getUpperBound());
                }
                string2 = this._isEnableLegacyApplyOutputTypes ? "NUMBER" : "BINARY_DOUBLE";
            }
            attributeType2.setDataType(string2);
            attributeType2.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType2);
        }
        if (applyNodeType.getColumnOutputOrder().compareTo("SupplementalColumns") == 0) {
            attributes.getAttribute().addAll(attributes2.getAttribute());
            attributes.getAttribute().addAll(attributes3.getAttribute());
        } else {
            attributes.getAttribute().addAll(attributes3.getAttribute());
            attributes.getAttribute().addAll(attributes2.getAttribute());
        }
        return attributes;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        ApplyOutputColumnsType applyOutputColumnsType = applyNodeType.getOutputColumns();
        ApplyOutputColumnsType applyOutputColumnsType2 = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyOutputColumnsType);
        List list = applyOutputColumnsType2.getOutputColumn();
        for (ApplyOutputColumnsType.OutputColumn outputColumn : list) {
            RefModelType refModelType = outputColumn.getModel();
            if (!map.containsKey(refModelType.getName())) continue;
            RefModelType refModelType2 = map.get(refModelType.getName());
            outputColumn.setModel(refModelType2);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), APPLY_SCORE_OUTPUT_COLUMNS, applyOutputColumnsType2);
    }

    @Override
    public void parentNodeNameChanged(Node node, String string) {
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        String string;
        Object object22;
        Object object32;
        Object object42;
        RefModelType refModelType2;
        Object object5;
        boolean bl2 = super.validate(bl);
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        boolean bl3 = applyNodeType.getOutputColumns().getAutoSpec().equals((Object)AutoSpecType.YES);
        ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator = new ApplyOutputColumnNameGenerator(applyNodeType.getOutputColumns());
        boolean bl4 = false;
        boolean bl5 = false;
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        boolean bl6 = false;
        boolean bl7 = false;
        ApplyOutputColumnsType applyOutputColumnsType = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
        SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
        HashMap<String, AbstractNode> hashMap2 = new HashMap<String, AbstractNode>();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<AbstractNode> list = this.findApplyModelNodes();
        for (AbstractNode object62 : list) {
            object5 = (ModelProvider)((Object)object62);
            hashMap2.put(object62.getMetadataId(), object62);
            refModelType2 = null;
            try {
                refModelType2 = object5.getModelsContainingCostMatrix();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (Object object42 : refModelType2) {
                object32 = object62.getMetadataId() + "." + object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm();
                hashMap.put(object32, Boolean.TRUE);
            }
            refModelType2 = object5.getOutputModels();
            for (Object object42 : refModelType2) {
                if (object42.isUseForOutput()) {
                    object32 = object62.getMetadataId() + "." + object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm();
                    hashMap3.put(object32, object42);
                }
                for (Object object22 : applyOutputColumnsType.getOutputColumn()) {
                    string = object22.getModel().getModelId();
                    if (string == null || !object42.getModelId().equals(string) || object22.getModel().getName().compareTo(object42.getName()) == 0) continue;
                    object22.getModel().setName(object42.getName());
                    bl6 = true;
                }
            }
        }
        if (bl3) {
            applyOutputColumnsType.getOutputColumn().clear();
            applyOutputColumnNameGenerator.removeAllUniqueNames();
            ApplyNode.addModels(this, applyOutputColumnsType, applyOutputColumnNameGenerator);
            bl = true;
            bl6 = true;
        } else {
            for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
                if (outputColumn.getModel().getStatus() != RefModelStatusType.VALID) continue;
                object5 = outputColumn.getModel().getNodeId() + "." + outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName() + "." + outputColumn.getModel().getMiningAlgorithm();
                refModelType2 = (RefModelType)hashMap3.get(object5);
                if (refModelType2 == null) {
                    if (hashMap2.get(outputColumn.getModel().getNodeId()) != null) {
                        arrayList.add(outputColumn);
                        bl6 = true;
                        bl = true;
                        continue;
                    }
                    outputColumn.getModel().setStatus(RefModelStatusType.INVALID);
                    outputColumn.getModel().setNodeId(null);
                    outputColumn.getModel().setModelId(null);
                    if (!bl4) {
                        this.addMessage("APPLY_INVAL_MODEL", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    bl2 = false;
                    bl6 = true;
                    continue;
                }
                if (!hashMap.containsKey(object5)) continue;
                object = null;
                for (Object object32 : applyOutputColumnsType.getOutputColumn()) {
                    if (object32.getPredictionCost() == null || !((String)object5).equals(object22 = object32.getModel().getNodeId() + "." + object32.getModel().getSchema() + "." + object32.getModel().getName() + "." + object32.getModel().getMiningAlgorithm())) continue;
                    object = object32;
                    break;
                }
                if (hashMap.containsKey(object5) && object == null) {
                    object42 = new PredictionCostType();
                    object32 = new PredictionCostType.Column();
                    object32.setName(applyOutputColumnNameGenerator.GenerateColumnName("PCST", refModelType2.getName(), true));
                    object42.setColumn((PredictionCostType.Column)object32);
                    object22 = new PredictionCostType.CostOption();
                    object22.setModel(new PredictionCostType.CostOption.Model());
                    object42.setCostOption((PredictionCostType.CostOption)object22);
                    string = new ApplyOutputColumnsType.OutputColumn();
                    string.setPredictionCost((PredictionCostType)object42);
                    string.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType2));
                    arrayList2.add(string);
                    bl6 = true;
                    continue;
                }
                if (hashMap.containsKey(object5) || object == null) continue;
                arrayList.add(object);
                bl6 = true;
            }
            if (arrayList2.size() > 0) {
                applyOutputColumnsType.getOutputColumn().addAll(arrayList2);
            }
            if (arrayList.size() > 0) {
                applyOutputColumnsType.getOutputColumn().removeAll(arrayList);
            }
            for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
                if (outputColumn.getModel().getNodeId() == null || hashMap2.get(object5 = outputColumn.getModel().getNodeId()) == null) continue;
                hashMap2.remove(object5);
            }
            if (hashMap2.size() > 0) {
                hashMap3.clear();
                for (AbstractNode abstractNode : hashMap2.values()) {
                    object5 = (ModelProvider)((Object)abstractNode);
                    refModelType2 = object5.getOutputModels();
                    for (Object object42 : refModelType2) {
                        if (!object42.isUseForOutput()) continue;
                        object32 = object42.getSchema() + "." + object42.getName() + "." + object42.getMiningAlgorithm();
                        hashMap3.put(object32, object42);
                    }
                }
                for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
                    if (outputColumn.getModel().getStatus() != RefModelStatusType.INVALID || (refModelType2 = (RefModelType)hashMap3.get(object5 = outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName() + "." + outputColumn.getModel().getMiningAlgorithm())) == null) continue;
                    outputColumn.getModel().setStatus(RefModelStatusType.VALID);
                    outputColumn.getModel().setNodeId(refModelType2.getNodeId());
                    outputColumn.getModel().setModelId(refModelType2.getModelId());
                    bl6 = true;
                }
            }
            for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
                if (outputColumn.getModel().getStatus() != RefModelStatusType.INVALID || bl4) continue;
                this.addMessage("APPLY_INVAL_MODEL", MessageEnumType.WARNING, new String[0]);
                bl4 = true;
                bl2 = false;
            }
        }
        Iterator<Object> iterator = this.findApplyDataNode(this.getModel());
        HashMap<Object, RefModelType> hashMap4 = new HashMap<Object, RefModelType>();
        if (iterator != null && iterator instanceof DataProvider) {
            for (RefModelType refModelType2 : ((DataProvider)((Object)iterator)).getAttributes().getAttribute()) {
                object = refModelType2.getAlias();
                object42 = (String)(object != null && ((String)object).trim().length() > 0 ? object : refModelType2.getName()) + "." + refModelType2.getDataType();
                hashMap4.put(object42, refModelType2);
            }
        }
        object5 = new ArrayList();
        refModelType2 = supplementalAttributesType.getAttribute();
        for (Object object42 : refModelType2) {
            object32 = object42.getName() + "." + object42.getDataType();
            object22 = (AttributeType)hashMap4.get(object32);
            if (object22 == null) {
                if (iterator != null) {
                    object5.add(object42);
                    bl7 = true;
                    bl = true;
                    continue;
                }
                object42.setStatus(AttributeStatus.INVALID);
                if (!bl5) {
                    this.addMessage("APPLY_INVAL_DATA", MessageEnumType.WARNING, new String[0]);
                    bl5 = true;
                }
                bl2 = false;
                bl7 = true;
                continue;
            }
            object42.setStatus(AttributeStatus.VALID);
            bl7 = true;
            bl = true;
        }
        if (object5.size() > 0) {
            refModelType2.removeAll((Collection<?>)object5);
        }
        object = new ArrayList();
        object42 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            object32 = new ComplexProperty(APPLY_SCORE_OUTPUT_COLUMNS, applyOutputColumnsType);
            ((ComplexProperty)object32).setOldData(applyNodeType.getOutputColumns());
            object.add(object32);
        }
        if (bl7) {
            object32 = new ComplexProperty(APPLY_SUPPLEMENTAL_COLUMNS, supplementalAttributesType);
            ((ComplexProperty)object32).setOldData(applyNodeType.getSupplementalAttributes());
            object.add(object32);
        }
        object32 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object32).setOldData(this.getSQLExpression());
        object.add(object32);
        ((OdmrSDMUndoFilter)((Object)object42)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object);
        if (bl2) {
            bl2 = this.validateNode();
        } else {
            this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        AbstractNode abstractNode = this.findApplyDataNode(this.getModel());
        if (abstractNode == null) {
            this.addMessage("APPLY_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (applyNodeType.getOutputColumns().getOutputColumn().size() == 0) {
            this.addMessage("APPLY_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public String getHelpTopic() {
        return "apply_node";
    }

    @Override
    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        StringBuffer stringBuffer3 = new StringBuffer(1000);
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        for (ApplyOutputColumnsType.OutputColumn outputColumn : applyNodeType.getOutputColumns().getOutputColumn()) {
            Parameters parameters = ApplyNode.getPredictionFunctionParameters(outputColumn);
            String string = parameters.generateCode(this, outputColumn.getModel());
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(string + "\n");
        }
        for (ApplyOutputColumnsType.OutputColumn outputColumn : applyNodeType.getSupplementalAttributes().getAttribute()) {
            if (outputColumn.getStatus() != AttributeStatus.VALID) continue;
            if (stringBuffer3.length() > 0) {
                stringBuffer3.append(", ");
            }
            stringBuffer3.append("\"" + outputColumn.getName() + "\"");
            if (outputColumn.getAlias() != null) {
                stringBuffer3.append(" \"" + outputColumn.getAlias() + "\"");
            }
            stringBuffer3.append("\n");
        }
        if (applyNodeType.getColumnOutputOrder().compareTo("SupplementalColumns") == 0) {
            if (stringBuffer3.length() > 0) {
                stringBuffer.append(stringBuffer3);
                stringBuffer.append(", ");
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(stringBuffer2);
            }
        } else {
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3.length() > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(stringBuffer3);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "SELECT " + (ApplyNode.generateSQLInlineHint() ? "/*+ inline */" : "") + "\n");
            stringBuffer.append(" FROM {INPUT_SOURCE}");
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    @Override
    public void setProperty(String string, Object object) {
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        if (string.equals(APPLY_SCORE_OUTPUT_COLUMNS)) {
            ApplyOutputColumnsType applyOutputColumnsType = (ApplyOutputColumnsType)object;
            applyNodeType.setOutputColumns(applyOutputColumnsType);
        } else if (string.equals(APPLY_SUPPLEMENTAL_COLUMNS)) {
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)object;
            applyNodeType.setSupplementalAttributes(supplementalAttributesType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                applyNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                applyNodeType.setSQLExpression((String)object);
            }
        } else if (string.equals(APPLY_COLUMN_OUTPUT_ORDER)) {
            String string2 = (String)object;
            applyNodeType.setColumnOutputOrder(string2);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(APPLY_SCORE_OUTPUT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(APPLY_SUPPLEMENTAL_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(APPLY_COLUMN_OUTPUT_ORDER)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        Object object = null;
        if (string.equals(APPLY_SCORE_OUTPUT_COLUMNS)) {
            object = applyNodeType.getOutputColumns();
        } else if (string.equals(APPLY_SUPPLEMENTAL_COLUMNS)) {
            object = applyNodeType.getSupplementalAttributes();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = applyNodeType.getSQLExpression();
        } else if (string.equals(APPLY_COLUMN_OUTPUT_ORDER)) {
            object = applyNodeType.getColumnOutputOrder();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    public AbstractNode findApplyDataNode(WorkflowModel workflowModel) {
        AbstractNode abstractNode = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode2 : list) {
            if (!(abstractNode2 instanceof DataProvider)) continue;
            abstractNode = abstractNode2;
            break;
        }
        return abstractNode;
    }

    public List<AbstractNode> findApplyModelNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof ModelProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static boolean doesModelCostExist(ApplyNode applyNode, RefModelType refModelType) {
        boolean bl = false;
        List<AbstractNode> list = applyNode.findApplyModelNodes();
        String string = refModelType.getNodeId() + "." + refModelType.getSchema() + "." + refModelType.getName() + "." + refModelType.getMiningAlgorithm();
        block2: for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<RefModelType> list2 = null;
            try {
                list2 = modelProvider.getModelsContainingCostMatrix();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (RefModelType refModelType2 : list2) {
                String string2 = abstractNode.getMetadataId() + "." + refModelType2.getSchema() + "." + refModelType2.getName() + "." + refModelType2.getMiningAlgorithm();
                if (!string.equals(string2)) continue;
                bl = true;
                continue block2;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TargetInfo findTargetMiningTypeFromModel(ApplyNode applyNode, RefModelType refModelType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        String string2 = null;
        String string3 = null;
        if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
            string2 = "Numerical";
            string3 = "NUMBER";
        } else {
            object6 = new SQLHelper();
            string = "select FEATURE_ID from table(FEATURE_SET( " + Model.getCombinedUserNameModelName(refModelType.getSchema(), refModelType.getName(), true) + "  using)) WHERE ROWNUM = 1";
            object5 = "select CLUSTER_ID from table(CLUSTER_SET( " + Model.getCombinedUserNameModelName(refModelType.getSchema(), refModelType.getName(), true) + "  using)) WHERE ROWNUM = 1";
            object4 = "select PREDICTION from table(PREDICTION_SET( " + Model.getCombinedUserNameModelName(refModelType.getSchema(), refModelType.getName(), true) + "  using)) WHERE ROWNUM = 1";
            object3 = null;
            object2 = null;
            try {
                object3 = Connections.getSharedConnection(applyNode.getContext());
                if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                    object2 = string;
                } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                    object2 = object5;
                } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                    object2 = object4;
                }
                ((SQLHelper)object6).pstmt = object3.prepareStatement((String)object2);
                ((SQLHelper)object6).rs = ((SQLHelper)object6).pstmt.executeQuery();
                object = ((SQLHelper)object6).rs.getMetaData();
                int n = object.getColumnType(1);
                string2 = DatabaseMetadataUtils.isSQLDataTypeString(n) ? "Categorical" : "Numerical";
                string3 = object.getColumnTypeName(1);
            }
            catch (Exception exception) {
            }
            finally {
                ((SQLHelper)object6).close();
            }
        }
        if (string2 == null) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                object6 = applyNode.findParentNodes();
                string = null;
                object5 = object6.iterator();
                block5: while (object5.hasNext()) {
                    object4 = (AbstractNode)object5.next();
                    if (refModelType.getNodeId().compareTo(((AbstractNode)object4).getMetadataId()) != 0) continue;
                    object3 = (ModelProvider)object4;
                    object2 = object3.getOutputModels();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        RefModelType refModelType2 = object.next();
                        if (refModelType.getName().compareTo(refModelType2.getName()) != 0) continue;
                        string = object3.getTargetAttribute();
                        continue block5;
                    }
                }
                if (string != null) {
                    string2 = string.getDataType().indexOf("CHAR") >= 0 ? "Categorical" : "Numerical";
                    string3 = string.getDataType();
                } else {
                    string2 = "Categorical";
                    string3 = "VARCHAR2";
                }
            } else {
                string2 = "Numerical";
                string3 = "NUMBER";
            }
        }
        return new TargetInfo(string3, string2);
    }

    public static boolean doesModelExist(ApplyOutputColumnsType applyOutputColumnsType, RefModelType refModelType) {
        boolean bl = false;
        for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
            String string;
            String string2 = outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName();
            if (!string2.equals(string = refModelType.getSchema() + "." + refModelType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean addModel(ApplyNode applyNode, ApplyOutputColumnsType applyOutputColumnsType, RefModelType refModelType, ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator) {
        PredictionType predictionType;
        String string;
        String string2;
        ApplyOutputColumnsType.OutputColumn outputColumn3;
        boolean bl = true;
        ApplyOutputColumnsType.OutputColumn outputColumn2 = null;
        for (ApplyOutputColumnsType.OutputColumn outputColumn3 : applyOutputColumnsType.getOutputColumn()) {
            string2 = outputColumn3.getModel().getSchema() + "." + outputColumn3.getModel().getName();
            if (!string2.equals(string = refModelType.getSchema() + "." + refModelType.getName())) continue;
            bl = false;
            break;
        }
        if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
            predictionType = new PredictionType();
            outputColumn3 = new PredictionType.CostOption();
            outputColumn3.setNone(new PredictionType.CostOption.None());
            predictionType.setCostOption((PredictionType.CostOption)outputColumn3);
            string2 = new PredictionType.Column();
            string2.setName(applyOutputColumnNameGenerator.GenerateColumnName("PRED", refModelType.getName(), true));
            predictionType.setColumn((PredictionType.Column)string2);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setPrediction(predictionType);
            string = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            PredictionProbabilityType predictionProbabilityType = new PredictionProbabilityType();
            PredictionProbabilityType.Column column = new PredictionProbabilityType.Column();
            column.setName(applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), true));
            predictionProbabilityType.setColumn(column);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setPredictionProbability(predictionProbabilityType);
            string = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
            PredictionCostType.Column column;
            PredictionCostType predictionCostType;
            predictionType = new PredictionType();
            outputColumn3 = new PredictionType.CostOption();
            boolean bl2 = ApplyNode.doesModelCostExist(applyNode, refModelType);
            if (bl2) {
                outputColumn3.setModel(new PredictionType.CostOption.Model());
            } else {
                outputColumn3.setNone(new PredictionType.CostOption.None());
            }
            predictionType.setCostOption((PredictionType.CostOption)outputColumn3);
            string = new PredictionType.Column();
            string.setName(applyOutputColumnNameGenerator.GenerateColumnName("PRED", refModelType.getName(), true));
            predictionType.setColumn((PredictionType.Column)string);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setPrediction(predictionType);
            RefModelType refModelType2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            refModelType2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel(refModelType2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            PredictionProbabilityType predictionProbabilityType = new PredictionProbabilityType();
            PredictionProbabilityType.Column column2 = new PredictionProbabilityType.Column();
            column2.setName(applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), true));
            predictionProbabilityType.setColumn(column2);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setPredictionProbability(predictionProbabilityType);
            refModelType2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            refModelType2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel(refModelType2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            if (bl2) {
                predictionCostType = new PredictionCostType();
                column = new PredictionCostType.Column();
                column.setName(applyOutputColumnNameGenerator.GenerateColumnName("PCST", refModelType.getName(), true));
                predictionCostType.setColumn(column);
                PredictionCostType.CostOption costOption = new PredictionCostType.CostOption();
                costOption.setModel(new PredictionCostType.CostOption.Model());
                predictionCostType.setCostOption(costOption);
                outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
                outputColumn2.setPredictionCost(predictionCostType);
                refModelType2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
                refModelType2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
                outputColumn2.setModel(refModelType2);
                applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            }
            if (refModelType.getMiningAlgorithm().compareTo((Enum)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) == 0) {
                predictionCostType = new PredictionBoundsType();
                column = new PredictionBoundsType.Column();
                column.setLowerBound(applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), true));
                predictionCostType.setColumn((PredictionBoundsType.Column)column);
                outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
                outputColumn2.setPredictionBounds((PredictionBoundsType)predictionCostType);
                refModelType2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
                refModelType2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
                outputColumn2.setModel(refModelType2);
                applyOutputColumnsType.getOutputColumn().add(outputColumn2);
                predictionCostType = new PredictionBoundsType();
                column = new PredictionBoundsType.Column();
                column.setUpperBound(applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), true));
                predictionCostType.setColumn((PredictionBoundsType.Column)column);
                outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
                outputColumn2.setPredictionBounds((PredictionBoundsType)predictionCostType);
                refModelType2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
                refModelType2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
                outputColumn2.setModel(refModelType2);
                applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            }
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
            predictionType = new ClusterIdType();
            outputColumn3 = new ClusterIdType.Column();
            outputColumn3.setName(applyOutputColumnNameGenerator.GenerateColumnName("CLID", refModelType.getName(), true));
            predictionType.setColumn((ClusterIdType.Column)outputColumn3);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setClusterId((ClusterIdType)predictionType);
            string2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            string = new ClusterProbabilityType();
            ClusterProbabilityType.Column column = new ClusterProbabilityType.Column();
            column.setName(applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), true));
            string.setColumn(column);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setClusterProbability((ClusterProbabilityType)string);
            string2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
            predictionType = new FeatureIdType();
            outputColumn3 = new FeatureIdType.Column();
            outputColumn3.setName(applyOutputColumnNameGenerator.GenerateColumnName("FEID", refModelType.getName(), true));
            predictionType.setColumn((FeatureIdType.Column)outputColumn3);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setFeatureId((FeatureIdType)predictionType);
            string2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            string = new FeatureValueType();
            FeatureValueType.Column column = new FeatureValueType.Column();
            column.setName(applyOutputColumnNameGenerator.GenerateColumnName("FVAL", refModelType.getName(), true));
            string.setColumn(column);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setFeatureValue((FeatureValueType)string);
            string2 = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string2.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string2);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
            predictionType = new PredictionType();
            outputColumn3 = new PredictionType.CostOption();
            outputColumn3.setNone(new PredictionType.CostOption.None());
            predictionType.setCostOption((PredictionType.CostOption)outputColumn3);
            string2 = new PredictionType.Column();
            string2.setName(applyOutputColumnNameGenerator.GenerateColumnName("PRED", refModelType.getName(), true));
            predictionType.setColumn((PredictionType.Column)string2);
            outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
            outputColumn2.setPrediction(predictionType);
            string = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
            string.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
            outputColumn2.setModel((RefModelType)string);
            applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            if (refModelType.getMiningAlgorithm().compareTo((Enum)MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) == 0) {
                PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
                PredictionBoundsType.Column column = new PredictionBoundsType.Column();
                column.setLowerBound(applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), true));
                predictionBoundsType.setColumn(column);
                outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
                outputColumn2.setPredictionBounds(predictionBoundsType);
                string = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
                string.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
                outputColumn2.setModel((RefModelType)string);
                applyOutputColumnsType.getOutputColumn().add(outputColumn2);
                predictionBoundsType = new PredictionBoundsType();
                column = new PredictionBoundsType.Column();
                column.setUpperBound(applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), true));
                predictionBoundsType.setColumn(column);
                outputColumn2 = new ApplyOutputColumnsType.OutputColumn();
                outputColumn2.setPredictionBounds(predictionBoundsType);
                string = (RefModelType)MetaDataHelper.copyMetadataObject(refModelType);
                string.setStatus(!bl ? RefModelStatusType.INVALID : RefModelStatusType.VALID);
                outputColumn2.setModel((RefModelType)string);
                applyOutputColumnsType.getOutputColumn().add(outputColumn2);
            }
        }
        return bl;
    }

    public static boolean addModels(ApplyNode applyNode, Node node, ApplyOutputColumnsType applyOutputColumnsType, ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator) {
        boolean bl = true;
        ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator2 = null;
        applyOutputColumnNameGenerator2 = applyOutputColumnNameGenerator == null ? new ApplyOutputColumnNameGenerator(applyOutputColumnsType) : applyOutputColumnNameGenerator;
        if (node instanceof ModelProvider) {
            ModelProvider modelProvider = (ModelProvider)((Object)node);
            List<RefModelType> list = modelProvider.getOutputModels();
            List list2 = applyOutputColumnsType.getOutputColumn();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (ApplyOutputColumnsType.OutputColumn outputColumn : list2) {
                String string = outputColumn.getModel().getNodeId() + "." + outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName();
                hashMap.put(string, Boolean.TRUE);
            }
            for (RefModelType refModelType : list) {
                boolean bl2;
                if (!refModelType.isUseForOutput() || hashMap.get(refModelType.getNodeId() + "." + refModelType.getSchema() + "." + refModelType.getName()) != null || (bl2 = ApplyNode.addModel(applyNode, applyOutputColumnsType, refModelType, applyOutputColumnNameGenerator2))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean addModels(ApplyNode applyNode, ApplyOutputColumnsType applyOutputColumnsType, ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator) {
        boolean bl = true;
        ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator2 = null;
        applyOutputColumnNameGenerator2 = applyOutputColumnNameGenerator == null ? new ApplyOutputColumnNameGenerator(applyOutputColumnsType) : applyOutputColumnNameGenerator;
        List<AbstractNode> list = applyNode.findParentNodes();
        for (AbstractNode abstractNode : list) {
            boolean bl2 = ApplyNode.addModels(applyNode, abstractNode, applyOutputColumnsType, applyOutputColumnNameGenerator);
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public static int addSupplAttrs(SupplementalAttributesType supplementalAttributesType, Node node) {
        int n = 0;
        if (node instanceof DataProvider) {
            DataProvider dataProvider = (DataProvider)((Object)node);
            List list = dataProvider.getAttributes().getAttribute();
            List list2 = supplementalAttributesType.getAttribute();
            for (AttributeType attributeType : list) {
                boolean bl = false;
                for (AttributeType attributeType2 : list2) {
                    if (attributeType.getName().compareTo(attributeType2.getName()) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                supplementalAttributesType.getAttribute().add((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                ++n;
            }
        }
        return n;
    }

    public static int addSupplAttrs(SupplementalAttributesType supplementalAttributesType, ApplyNode applyNode) {
        int n = 0;
        List<AbstractNode> list = applyNode.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            int n2 = ApplyNode.addSupplAttrs(supplementalAttributesType, abstractNode);
            n += n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Object> getPredictionValues(Context context, String string, String string2) {
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<Object> vector = new Vector<Object>();
        String string3 = "select prediction from table(prediction_set( " + Model.getCombinedUserNameModelName(string, string2, true) + "  using)) order by prediction";
        try {
            connection = Connections.getSharedConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = new Integer(sQLHelper.rs.getInt("prediction"));
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString("prediction");
                } else if (DatabaseMetadataUtils.isSQLDataTypeDate(n)) {
                    object = sQLHelper.rs.getDate("prediction");
                } else {
                    throw new Exception("Unexpected target data type. Expected either a number, string or date.");
                }
                vector.add(object);
            }
        }
        catch (Exception exception) {
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Object> getClusterIds(Context context, String string, String string2) {
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<Object> vector = new Vector<Object>();
        String string3 = "select cluster_id from table(CLUSTER_SET( " + Model.getCombinedUserNameModelName(string, string2, true) + "  using)) order by cluster_id";
        try {
            connection = Connections.getSharedConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = new Integer(sQLHelper.rs.getInt("cluster_id"));
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString("cluster_id");
                } else {
                    throw new Exception("Unexpected cluster id data type. Expected either a number or string.");
                }
                vector.add(object);
            }
        }
        catch (Exception exception) {
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Object> getFeatureIds(Context context, String string, String string2) {
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<Object> vector = new Vector<Object>();
        String string3 = "select feature_id from table(FEATURE_SET( " + Model.getCombinedUserNameModelName(string, string2, true) + "  using)) order by feature_id";
        try {
            connection = Connections.getSharedConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = new Integer(sQLHelper.rs.getInt("feature_id"));
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString("feature_id");
                } else {
                    throw new Exception("Unexpected feature id data type. Expected either a number or string.");
                }
                vector.add(object);
            }
        }
        catch (Exception exception) {
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public static String getPredictionFunctionOutput(ApplyOutputColumnsType.OutputColumn outputColumn) {
        String string = null;
        if (outputColumn.getPrediction() != null) {
            string = outputColumn.getPrediction().getColumn().getName();
        } else if (outputColumn.getPredictionBounds() != null) {
            string = outputColumn.getPredictionBounds().getColumn().getName();
            if (string == null) {
                string = outputColumn.getPredictionBounds().getColumn().getLowerBound();
            }
            if (string == null) {
                string = outputColumn.getPredictionBounds().getColumn().getUpperBound();
            }
        } else if (outputColumn.getPredictionCost() != null) {
            string = outputColumn.getPredictionCost().getColumn().getName();
        } else if (outputColumn.getPredictionDetails() != null) {
            string = outputColumn.getPredictionDetails().getColumn().getName();
        } else if (outputColumn.getPredictionProbability() != null) {
            string = outputColumn.getPredictionProbability().getColumn().getName();
        } else if (outputColumn.getPredictionSet() != null) {
            string = outputColumn.getPredictionSet().getColumn().getName();
        } else if (outputColumn.getClusterId() != null) {
            string = outputColumn.getClusterId().getColumn().getName();
        } else if (outputColumn.getClusterProbability() != null) {
            string = outputColumn.getClusterProbability().getColumn().getName();
        } else if (outputColumn.getClusterSet() != null) {
            string = outputColumn.getClusterSet().getColumn().getName();
        } else if (outputColumn.getFeatureId() != null) {
            string = outputColumn.getFeatureId().getColumn().getName();
        } else if (outputColumn.getFeatureValue() != null) {
            string = outputColumn.getFeatureValue().getColumn().getName();
        } else if (outputColumn.getFeatureSet() != null) {
            string = outputColumn.getFeatureSet().getColumn().getName();
        }
        return string;
    }

    public static String getPredictionFunction(ApplyOutputColumnsType.OutputColumn outputColumn) {
        String string = null;
        if (outputColumn.getPrediction() != null) {
            string = ServerConstants.ApplyPredictionFunctions.PREDICTION;
        } else if (outputColumn.getPredictionBounds() != null) {
            if (outputColumn.getPredictionBounds().getColumn().getLowerBound() != null && outputColumn.getPredictionBounds().getColumn().getUpperBound() != null) {
                string = ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS;
            } else if (outputColumn.getPredictionBounds().getColumn().getLowerBound() != null) {
                string = ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER;
            } else if (outputColumn.getPredictionBounds().getColumn().getUpperBound() != null) {
                string = ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER;
            }
        } else if (outputColumn.getPredictionCost() != null) {
            string = ServerConstants.ApplyPredictionFunctions.PREDICTION_COST;
        } else if (outputColumn.getPredictionDetails() != null) {
            string = ServerConstants.ApplyPredictionFunctions.PREDICTION_DETAILS;
        } else if (outputColumn.getPredictionProbability() != null) {
            string = ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY;
        } else if (outputColumn.getPredictionSet() != null) {
            string = ServerConstants.ApplyPredictionFunctions.PREDICTION_SET;
        } else if (outputColumn.getClusterId() != null) {
            string = ServerConstants.ApplyPredictionFunctions.CLUSTER_ID;
        } else if (outputColumn.getClusterProbability() != null) {
            string = ServerConstants.ApplyPredictionFunctions.CLUSTER_PROBABILITY;
        } else if (outputColumn.getClusterSet() != null) {
            string = ServerConstants.ApplyPredictionFunctions.CLUSTER_SET;
        } else if (outputColumn.getFeatureId() != null) {
            string = ServerConstants.ApplyPredictionFunctions.FEATURE_ID;
        } else if (outputColumn.getFeatureValue() != null) {
            string = ServerConstants.ApplyPredictionFunctions.FEATURE_VALUE;
        } else if (outputColumn.getFeatureSet() != null) {
            string = ServerConstants.ApplyPredictionFunctions.FEATURE_SET;
        }
        return string;
    }

    public static Parameters getPredictionFunctionParameters(ApplyOutputColumnsType.OutputColumn outputColumn) {
        Parameters parameters = null;
        String string = "None";
        if (outputColumn.getPrediction() != null) {
            if (outputColumn.getPrediction().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new Prediction(outputColumn.getPrediction().getColumn().getName(), string, null);
        } else if (outputColumn.getPredictionDetails() != null) {
            parameters = new PredictionDetails(outputColumn.getPredictionDetails().getColumn().getName());
        } else if (outputColumn.getPredictionBounds() != null) {
            Double d = outputColumn.getPredictionBounds().getColumn().getConfidence();
            parameters = outputColumn.getModel().getMiningFunction() == MiningFunctionType.CLASSIFICATION ? (outputColumn.getPredictionBounds().getColumn().getUpperBound() != null ? new ClassPredictionUpperBounds(d, outputColumn.getPredictionBounds().getColumn().getTargetValue(), null, outputColumn.getPredictionBounds().getColumn().getUpperBound()) : new ClassPredictionLowerBounds(d, outputColumn.getPredictionBounds().getColumn().getTargetValue(), null, outputColumn.getPredictionBounds().getColumn().getLowerBound())) : (outputColumn.getPredictionBounds().getColumn().getUpperBound() != null ? new RegressPredictionUpperBounds(d, outputColumn.getPredictionBounds().getColumn().getUpperBound()) : new RegressPredictionLowerBounds(d, outputColumn.getPredictionBounds().getColumn().getLowerBound()));
        } else if (outputColumn.getPredictionCost() != null) {
            if (outputColumn.getPredictionCost().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new PredictionCost(outputColumn.getPredictionCost().getColumn().getTargetValue(), null, outputColumn.getPredictionCost().getColumn().getName(), string, null);
        } else if (outputColumn.getPredictionProbability() != null) {
            parameters = new PredictionProbability(outputColumn.getPredictionProbability().getColumn().getTargetValue(), null, outputColumn.getPredictionProbability().getColumn().getName());
        } else if (outputColumn.getPredictionSet() != null) {
            if (outputColumn.getPredictionSet().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new PredictionSet(outputColumn.getPredictionSet().getColumn().getTopNValue() != null, outputColumn.getPredictionSet().getColumn().getTopNValue(), 1, outputColumn.getPredictionSet().getColumn().getProbCutOff() != null, outputColumn.getPredictionSet().getColumn().getProbCutOff(), outputColumn.getPredictionSet().getColumn().getCostCutOff() != null, outputColumn.getPredictionSet().getColumn().getCostCutOff(), outputColumn.getPredictionSet().getColumn().getName(), string, null);
        } else if (outputColumn.getClusterId() != null) {
            parameters = new ClusterId(outputColumn.getClusterId().getColumn().getName());
        } else if (outputColumn.getClusterProbability() != null) {
            parameters = new ClusterProbability(outputColumn.getClusterProbability().getColumn().getClusterId(), null, outputColumn.getClusterProbability().getColumn().getName());
        } else if (outputColumn.getClusterSet() != null) {
            parameters = new ClusterSet(outputColumn.getClusterSet().getColumn().getTopNValue() != null, outputColumn.getClusterSet().getColumn().getTopNValue(), 1, outputColumn.getClusterSet().getColumn().getCutOffValue() != null, outputColumn.getClusterSet().getColumn().getCutOffValue(), outputColumn.getClusterSet().getColumn().getName());
        } else if (outputColumn.getFeatureId() != null) {
            parameters = new FeatureId(outputColumn.getFeatureId().getColumn().getName());
        } else if (outputColumn.getFeatureValue() != null) {
            parameters = new FeatureValue(outputColumn.getFeatureValue().getColumn().getFeatureId(), null, outputColumn.getFeatureValue().getColumn().getName());
        } else if (outputColumn.getFeatureSet() != null) {
            parameters = new FeatureSet(outputColumn.getFeatureSet().getColumn().getTopNValue() != null, outputColumn.getFeatureSet().getColumn().getTopNValue(), 1, outputColumn.getFeatureSet().getColumn().getCutOffValue() != null, outputColumn.getFeatureSet().getColumn().getCutOffValue(), outputColumn.getFeatureSet().getColumn().getName());
        }
        return parameters;
    }

    public static Parameters getPredictionFunctionParameters(Context context, ApplyOutputColumnsType.OutputColumn outputColumn) {
        Parameters parameters = null;
        String string = "None";
        if (outputColumn.getPrediction() != null) {
            if (outputColumn.getPrediction().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new Prediction(outputColumn.getPrediction().getColumn().getName(), string, null);
        } else if (outputColumn.getPredictionDetails() != null) {
            parameters = new PredictionDetails(outputColumn.getPredictionDetails().getColumn().getName());
        } else if (outputColumn.getPredictionBounds() != null) {
            Double d = outputColumn.getPredictionBounds().getColumn().getConfidence();
            parameters = outputColumn.getModel().getMiningFunction() == MiningFunctionType.CLASSIFICATION ? (outputColumn.getPredictionBounds().getColumn().getUpperBound() != null ? new ClassPredictionUpperBounds(d, outputColumn.getPredictionBounds().getColumn().getTargetValue(), ApplyNode.getPredictionValues(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getPredictionBounds().getColumn().getUpperBound()) : new ClassPredictionLowerBounds(d, outputColumn.getPredictionBounds().getColumn().getTargetValue(), ApplyNode.getPredictionValues(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getPredictionBounds().getColumn().getLowerBound())) : (outputColumn.getPredictionBounds().getColumn().getUpperBound() != null ? new RegressPredictionUpperBounds(d, outputColumn.getPredictionBounds().getColumn().getUpperBound()) : new RegressPredictionLowerBounds(d, outputColumn.getPredictionBounds().getColumn().getLowerBound()));
        } else if (outputColumn.getPredictionCost() != null) {
            if (outputColumn.getPredictionCost().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new PredictionCost(outputColumn.getPredictionCost().getColumn().getTargetValue(), ApplyNode.getPredictionValues(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getPredictionCost().getColumn().getName(), string, null);
        } else if (outputColumn.getPredictionProbability() != null) {
            parameters = new PredictionProbability(outputColumn.getPredictionProbability().getColumn().getTargetValue(), ApplyNode.getPredictionValues(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getPredictionProbability().getColumn().getName());
        } else if (outputColumn.getPredictionSet() != null) {
            if (outputColumn.getPredictionSet().getCostOption().getModel() != null) {
                string = "Model";
            }
            parameters = new PredictionSet(outputColumn.getPredictionSet().getColumn().getTopNValue() != null, outputColumn.getPredictionSet().getColumn().getTopNValue(), ApplyNode.getPredictionValues(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()).size(), outputColumn.getPredictionSet().getColumn().getProbCutOff() != null, outputColumn.getPredictionSet().getColumn().getProbCutOff(), outputColumn.getPredictionSet().getColumn().getCostCutOff() != null, outputColumn.getPredictionSet().getColumn().getCostCutOff(), outputColumn.getPredictionSet().getColumn().getName(), string, null);
        } else if (outputColumn.getClusterId() != null) {
            parameters = new ClusterId(outputColumn.getClusterId().getColumn().getName());
        } else if (outputColumn.getClusterProbability() != null) {
            parameters = new ClusterProbability(outputColumn.getClusterProbability().getColumn().getClusterId(), ApplyNode.getClusterIds(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getClusterProbability().getColumn().getName());
        } else if (outputColumn.getClusterSet() != null) {
            parameters = new ClusterSet(outputColumn.getClusterSet().getColumn().getTopNValue() != null, outputColumn.getClusterSet().getColumn().getTopNValue(), ApplyNode.getClusterIds(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()).size(), outputColumn.getClusterSet().getColumn().getCutOffValue() != null, outputColumn.getClusterSet().getColumn().getCutOffValue(), outputColumn.getClusterSet().getColumn().getName());
        } else if (outputColumn.getFeatureId() != null) {
            parameters = new FeatureId(outputColumn.getFeatureId().getColumn().getName());
        } else if (outputColumn.getFeatureValue() != null) {
            parameters = new FeatureValue(outputColumn.getFeatureValue().getColumn().getFeatureId(), ApplyNode.getFeatureIds(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()), outputColumn.getFeatureValue().getColumn().getName());
        } else if (outputColumn.getFeatureSet() != null) {
            parameters = new FeatureSet(outputColumn.getFeatureSet().getColumn().getTopNValue() != null, outputColumn.getFeatureSet().getColumn().getTopNValue(), ApplyNode.getFeatureIds(context, outputColumn.getModel().getSchema(), outputColumn.getModel().getName()).size(), outputColumn.getFeatureSet().getColumn().getCutOffValue() != null, outputColumn.getFeatureSet().getColumn().getCutOffValue(), outputColumn.getFeatureSet().getColumn().getName());
        }
        return parameters;
    }

    public static void setPredictionFunctionParameters(ApplyOutputColumnsType.OutputColumn outputColumn, Parameters parameters) {
        outputColumn.setClusterId(null);
        outputColumn.setClusterProbability(null);
        outputColumn.setClusterSet(null);
        outputColumn.setFeatureId(null);
        outputColumn.setFeatureSet(null);
        outputColumn.setFeatureValue(null);
        outputColumn.setPrediction(null);
        outputColumn.setPredictionBounds(null);
        outputColumn.setPredictionCost(null);
        outputColumn.setPredictionDetails(null);
        outputColumn.setPredictionProbability(null);
        outputColumn.setPredictionSet(null);
        if (parameters instanceof Prediction) {
            Prediction prediction = (Prediction)parameters;
            PredictionType predictionType = new PredictionType();
            PredictionType.CostOption costOption = new PredictionType.CostOption();
            if (prediction.getUseCostType().compareTo("Model") == 0) {
                costOption.setModel(new PredictionType.CostOption.Model());
            } else {
                costOption.setNone(new PredictionType.CostOption.None());
            }
            predictionType.setCostOption(costOption);
            PredictionType.Column column = new PredictionType.Column();
            column.setName(prediction.getColumn());
            predictionType.setColumn(column);
            outputColumn.setPrediction(predictionType);
        } else if (parameters instanceof PredictionDetails) {
            PredictionDetails predictionDetails = (PredictionDetails)parameters;
            PredictionDetailsType predictionDetailsType = new PredictionDetailsType();
            PredictionDetailsType.Column column = new PredictionDetailsType.Column();
            column.setName(predictionDetails.getColumn());
            predictionDetailsType.setColumn(column);
            outputColumn.setPredictionDetails(predictionDetailsType);
        } else if (parameters instanceof ClusterId) {
            ClusterId clusterId = (ClusterId)parameters;
            ClusterIdType clusterIdType = new ClusterIdType();
            ClusterIdType.Column column = new ClusterIdType.Column();
            column.setName(clusterId.getColumn());
            clusterIdType.setColumn(column);
            outputColumn.setClusterId(clusterIdType);
        } else if (parameters instanceof FeatureId) {
            FeatureId featureId = (FeatureId)parameters;
            FeatureIdType featureIdType = new FeatureIdType();
            FeatureIdType.Column column = new FeatureIdType.Column();
            column.setName(featureId.getColumn());
            featureIdType.setColumn(column);
            outputColumn.setFeatureId(featureIdType);
        } else if (parameters instanceof PredictionDetails) {
            PredictionDetails predictionDetails = (PredictionDetails)parameters;
            PredictionDetailsType predictionDetailsType = new PredictionDetailsType();
            PredictionDetailsType.Column column = new PredictionDetailsType.Column();
            column.setName(predictionDetails.getColumn());
            predictionDetailsType.setColumn(column);
            outputColumn.setPredictionDetails(predictionDetailsType);
        } else if (parameters instanceof ClassPredictionLowerBounds) {
            ClassPredictionLowerBounds classPredictionLowerBounds = (ClassPredictionLowerBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setLowerBound(classPredictionLowerBounds.getLowerBound());
            Object object = classPredictionLowerBounds.getSelectedTarget();
            column.setTargetValue(object == null ? null : object.toString());
            column.setConfidence(classPredictionLowerBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof ClassPredictionUpperBounds) {
            ClassPredictionUpperBounds classPredictionUpperBounds = (ClassPredictionUpperBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setUpperBound(classPredictionUpperBounds.getUpperBound());
            Object object = classPredictionUpperBounds.getSelectedTarget();
            column.setTargetValue(object == null ? null : object.toString());
            column.setConfidence(classPredictionUpperBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof RegressPredictionLowerBounds) {
            RegressPredictionLowerBounds regressPredictionLowerBounds = (RegressPredictionLowerBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setLowerBound(regressPredictionLowerBounds.getLowerBound());
            column.setConfidence(regressPredictionLowerBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof RegressPredictionUpperBounds) {
            RegressPredictionUpperBounds regressPredictionUpperBounds = (RegressPredictionUpperBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setUpperBound(regressPredictionUpperBounds.getUpperBound());
            column.setConfidence(regressPredictionUpperBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof ClassPredictionBounds) {
            ClassPredictionBounds classPredictionBounds = (ClassPredictionBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setLowerBound(classPredictionBounds.getLowerBound());
            column.setUpperBound(classPredictionBounds.getUpperBound());
            Object object = classPredictionBounds.getSelectedTarget();
            column.setTargetValue(object == null ? null : object.toString());
            column.setConfidence(classPredictionBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof RegressPredictionBounds) {
            RegressPredictionBounds regressPredictionBounds = (RegressPredictionBounds)parameters;
            PredictionBoundsType predictionBoundsType = new PredictionBoundsType();
            PredictionBoundsType.Column column = new PredictionBoundsType.Column();
            column.setLowerBound(regressPredictionBounds.getLowerBound());
            column.setUpperBound(regressPredictionBounds.getUpperBound());
            column.setConfidence(regressPredictionBounds.getConfidence());
            predictionBoundsType.setColumn(column);
            outputColumn.setPredictionBounds(predictionBoundsType);
        } else if (parameters instanceof PredictionCost) {
            PredictionCost predictionCost = (PredictionCost)parameters;
            PredictionCostType predictionCostType = new PredictionCostType();
            PredictionCostType.CostOption costOption = new PredictionCostType.CostOption();
            if (predictionCost.getUseCostType().compareTo("Model") == 0) {
                costOption.setModel(new PredictionCostType.CostOption.Model());
            } else {
                costOption.setNone(new PredictionCostType.CostOption.None());
            }
            predictionCostType.setCostOption(costOption);
            PredictionCostType.Column column = new PredictionCostType.Column();
            column.setName(predictionCost.getColumn());
            Object object = predictionCost.getSelectedTarget();
            column.setTargetValue(object == null ? null : object.toString());
            predictionCostType.setColumn(column);
            outputColumn.setPredictionCost(predictionCostType);
        } else if (parameters instanceof PredictionProbability) {
            PredictionProbability predictionProbability = (PredictionProbability)parameters;
            PredictionProbabilityType predictionProbabilityType = new PredictionProbabilityType();
            PredictionProbabilityType.Column column = new PredictionProbabilityType.Column();
            column.setName(predictionProbability.getColumn());
            Object object = predictionProbability.getSelectedTarget();
            column.setTargetValue(object == null ? null : object.toString());
            predictionProbabilityType.setColumn(column);
            outputColumn.setPredictionProbability(predictionProbabilityType);
        } else if (parameters instanceof PredictionSet) {
            PredictionSet predictionSet = (PredictionSet)parameters;
            PredictionSetType predictionSetType = new PredictionSetType();
            PredictionSetType.CostOption costOption = new PredictionSetType.CostOption();
            if (predictionSet.getUseCostType().compareTo("Model") == 0) {
                costOption.setModel(new PredictionSetType.CostOption.Model());
            } else {
                costOption.setNone(new PredictionSetType.CostOption.None());
            }
            predictionSetType.setCostOption(costOption);
            PredictionSetType.Column column = new PredictionSetType.Column();
            column.setName(predictionSet.getColumn());
            column.setTopNValue(predictionSet.getTopN());
            column.setProbCutOff(predictionSet.getCutOff());
            column.setCostCutOff(predictionSet.getCostCutOff());
            predictionSetType.setColumn(column);
            outputColumn.setPredictionSet(predictionSetType);
        } else if (parameters instanceof ClusterProbability) {
            ClusterProbability clusterProbability = (ClusterProbability)parameters;
            ClusterProbabilityType clusterProbabilityType = new ClusterProbabilityType();
            ClusterProbabilityType.Column column = new ClusterProbabilityType.Column();
            column.setName(clusterProbability.getColumn());
            column.setClusterId(clusterProbability.getClusterId() == null ? null : clusterProbability.getClusterId().toString());
            clusterProbabilityType.setColumn(column);
            outputColumn.setClusterProbability(clusterProbabilityType);
        } else if (parameters instanceof ClusterSet) {
            ClusterSet clusterSet = (ClusterSet)parameters;
            ClusterSetType clusterSetType = new ClusterSetType();
            ClusterSetType.Column column = new ClusterSetType.Column();
            column.setName(clusterSet.getColumn());
            column.setTopNValue(clusterSet.getTopN());
            column.setCutOffValue(clusterSet.getCutOff());
            clusterSetType.setColumn(column);
            outputColumn.setClusterSet(clusterSetType);
        } else if (parameters instanceof FeatureValue) {
            FeatureValue featureValue = (FeatureValue)parameters;
            FeatureValueType featureValueType = new FeatureValueType();
            FeatureValueType.Column column = new FeatureValueType.Column();
            column.setName(featureValue.getColumn());
            column.setFeatureId(featureValue.getFeatureId() == null ? null : featureValue.getFeatureId().toString());
            featureValueType.setColumn(column);
            outputColumn.setFeatureValue(featureValueType);
        } else if (parameters instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)parameters;
            FeatureSetType featureSetType = new FeatureSetType();
            FeatureSetType.Column column = new FeatureSetType.Column();
            column.setName(featureSet.getColumn());
            column.setTopNValue(featureSet.getTopN());
            column.setCutOffValue(featureSet.getCutOff());
            featureSetType.setColumn(column);
            outputColumn.setFeatureSet(featureSetType);
        }
    }

    @Override
    public ArrayList<SourceDefinition> getLineageSources() {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        ApplyNodeType applyNodeType = (ApplyNodeType)this.getData();
        List list = applyNodeType.getOutputColumns().getOutputColumn();
        for (ApplyOutputColumnsType.OutputColumn outputColumn : list) {
            RefModelType refModelType = outputColumn.getModel();
            SourceDefinition sourceDefinition = new SourceDefinition(this, refModelType.getSchema(), refModelType.getName(), DatabaseObjectType.MODEL);
            if (this.isSourceContained(arrayList, sourceDefinition)) continue;
            arrayList.add(sourceDefinition);
        }
        return arrayList;
    }

    public boolean isEnableLegacyApplyOutputTypes() {
        return this._isEnableLegacyApplyOutputTypes;
    }

    public boolean is12gDB() {
        return this._is12gDB;
    }

    public static class FeatureSet
    extends DefaultPredictionSet {
        public FeatureSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            super(bl, bigInteger, n, bl2, d, string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this._useTopN) {
                stringBuffer.append(", " + this._topN.toString());
                if (this._useCutOff) {
                    stringBuffer.append(", " + this._cutOff.toString());
                }
            } else if (this._useCutOff) {
                stringBuffer.append(", NULL, " + this._cutOff.toString());
            }
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = null;
            string2 = string.equals("Categorical") ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_FEATURE_SET_CAT" : "ODMR_FEATURE_SET_CATVD") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_FEATURE_SET_NUM" : "ODMR_FEATURE_SET_NUMVD");
            return "CAST(FEATURE_SET(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + stringBuffer.toString() + " USING *) AS " + string2 + ") \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = null;
            string2 = string.equals("Categorical") ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_FEATURE_SET_CAT" : "ODMR_FEATURE_SET_CATVD") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_FEATURE_SET_NUM" : "ODMR_FEATURE_SET_NUMVD");
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string2);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class FeatureValue
    implements Parameters {
        private Object _featureId;
        private Vector<Object> _featureIds;
        private String _column;

        public FeatureValue(Object object, Vector<Object> vector, String string) {
            this._featureId = object;
            this._featureIds = vector;
            this._column = string;
        }

        public Vector<Object> getFeatureIds() {
            return this._featureIds;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._featureId != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID") + " " + this._featureId.toString());
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setFeatureId(Object object) {
            this._featureId = object;
        }

        public Object getFeatureId() {
            return this._featureId;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            String string = "";
            if (this._featureId != null) {
                string = ", '" + this._featureId.toString() + "'";
            }
            return "FEATURE_VALUE(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + string + " USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class ClusterSet
    extends DefaultPredictionSet {
        public ClusterSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            super(bl, bigInteger, n, bl2, d, string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this._useTopN) {
                stringBuffer.append(", " + this._topN.toString());
                if (this._useCutOff) {
                    stringBuffer.append(", " + this._cutOff.toString());
                }
            } else if (this._useCutOff) {
                stringBuffer.append(", NULL, " + this._cutOff.toString());
            }
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = null;
            string2 = string.equals("Categorical") ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_CLUSTER_SET_CAT" : "ODMR_CLUSTER_SET_CATPD") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_CLUSTER_SET_NUM" : "ODMR_CLUSTER_SET_NUMPD");
            return "CAST(CLUSTER_SET(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + stringBuffer.toString() + " USING *) AS " + string2 + ") \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = null;
            string2 = string.equals("Categorical") ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_CLUSTER_SET_CAT" : "ODMR_CLUSTER_SET_CATPD") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_CLUSTER_SET_NUM" : "ODMR_CLUSTER_SET_NUMPD");
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string2);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class ClusterProbability
    implements Parameters {
        private Object _clusterId;
        private Vector<Object> _clusterIds;
        private String _column;

        public ClusterProbability(Object object, Vector<Object> vector, String string) {
            this._clusterId = object;
            this._clusterIds = vector;
            this._column = string;
        }

        public Vector<Object> getClusterIds() {
            return this._clusterIds;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._clusterId != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID") + " " + this._clusterId.toString());
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setClusterId(Object object) {
            this._clusterId = object;
        }

        public Object getClusterId() {
            return this._clusterId;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            String string = "";
            if (this._clusterId != null) {
                string = ", '" + this._clusterId.toString() + "'";
            }
            return "CLUSTER_PROBABILITY(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + string + " USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class PredictionCost
    extends DefaultPredictionProbability {
        protected String _useCostType;
        protected CostMatrixType _costMatrix;

        public PredictionCost(Object object, Vector<Object> vector, String string, String string2, CostMatrixType costMatrixType) {
            super(object, vector, string);
            this._useCostType = string2;
            this._costMatrix = costMatrixType;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            String string = "";
            if (this._selectedTarget != null) {
                TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
                String string2 = targetInfo.getMiningType();
                string = string2.equals("Categorical") ? ", '" + this._selectedTarget + "'" : ", " + this._selectedTarget.toString();
            }
            return "PREDICTION_COST(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + string + " COST MODEL USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }

        public void setUseCostType(String string) {
            this._useCostType = string;
        }

        public String getUseCostType() {
            return this._useCostType;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }
    }

    public static class PredictionProbability
    extends DefaultPredictionProbability {
        public PredictionProbability(Object object, Vector<Object> vector, String string) {
            super(object, vector, string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            String string = "";
            if (this._selectedTarget != null) {
                TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
                String string2 = targetInfo.getMiningType();
                string = string2.equals("Categorical") ? ", '" + this._selectedTarget + "'" : ", " + this._selectedTarget.toString();
            }
            return "PREDICTION_PROBABILITY(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + string + " USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class DefaultPredictionProbability
    implements Parameters {
        protected Object _selectedTarget;
        protected Vector<Object> _targetValues;
        protected String _column;

        public DefaultPredictionProbability(Object object, Vector<Object> vector, String string) {
            this._selectedTarget = object;
            this._targetValues = vector;
            this._column = string;
        }

        public Vector<Object> getTargetValues() {
            return this._targetValues;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._selectedTarget != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET") + " " + this._selectedTarget);
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setSelectedTarget(Object object) {
            this._selectedTarget = object;
        }

        public Object getSelectedTarget() {
            return this._selectedTarget;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }
    }

    public static class PredictionSet
    extends DefaultPredictionSet {
        protected String _useCostType;
        protected CostMatrixType _costMatrix;
        protected Double _costCutOff;
        protected boolean _useCostCutOff;

        public PredictionSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, boolean bl3, Double d2, String string, String string2, CostMatrixType costMatrixType) {
            super(bl, bigInteger, n, bl2, d, string);
            this._useCostType = string2;
            this._costMatrix = costMatrixType;
            this._costCutOff = d2;
            this._useCostCutOff = bl3;
        }

        @Override
        public void validate() throws ValidationException {
            if (!(this._useTopN || this._useCutOff || this._useCostCutOff)) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_TOPN_CUTOFF_NULL_ERROR"));
            }
            if (this._useCostType.compareTo("Model") == 0) {
                if (this._useCostCutOff) {
                    if (this._costCutOff == null) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_COST_CUTOFF_ERROR"));
                    }
                    if (this._costCutOff <= 0.0) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_COST_CUTOFF_ERROR"));
                    }
                }
            } else if (this._useCutOff) {
                if (this._cutOff == null) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
                if (this._cutOff <= 0.0 || this._cutOff > 1.0) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topN != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + this._topN.toString());
            }
            if (this._useCostType.compareTo("Model") == 0) {
                if (this._useCostCutOff && this._costCutOff != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_COST_CUTOFF") + " " + this._costCutOff.toString());
                }
            } else if (this._useCutOff && this._cutOff != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_PROB_CUTOFF") + " " + this._cutOff.toString());
            }
            return stringBuffer.toString();
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this._useTopN) {
                stringBuffer.append(", " + this._topN.toString());
                if (this._useCostType.compareTo("Model") == 0) {
                    if (this._useCostCutOff) {
                        stringBuffer.append(", " + this._costCutOff.toString());
                    }
                } else if (this._useCutOff) {
                    stringBuffer.append(", " + this._cutOff.toString());
                }
            } else if (this._useCostType.compareTo("Model") == 0) {
                if (this._useCostCutOff) {
                    stringBuffer.append(", NULL, " + this._costCutOff.toString());
                }
            } else if (this._useCutOff) {
                stringBuffer.append(", NULL, " + this._cutOff.toString());
            }
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = targetInfo.getDataType();
            String string3 = null;
            String string4 = "";
            if (string.equals("Categorical")) {
                if (this._useCostType.compareTo("Model") == 0) {
                    string3 = applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_CAT_COST" : "ODMR_PREDICTION_SET_CAT_COSTPD";
                    string4 = " COST MODEL ";
                } else {
                    string3 = applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_CAT" : "ODMR_PREDICTION_SET_CATPD";
                }
            } else if (this._useCostType.compareTo("Model") == 0) {
                string3 = string2 == "BINARY_DOUBLE" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTD") : (string2 == "BINARY_FLOAT" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTF") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTN"));
                string4 = " COST MODEL ";
            } else {
                string3 = string2 == "BINARY_DOUBLE" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_D") : (string2 == "BINARY_FLOAT" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_F") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_N"));
            }
            return "CAST(PREDICTION_SET(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + stringBuffer.toString() + string4 + " USING *) AS " + string3 + ") \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getMiningType();
            String string2 = targetInfo.getDataType();
            String string3 = null;
            string3 = string.equals("Categorical") ? (this._useCostType.compareTo("Model") == 0 ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_CAT_COST" : "ODMR_PREDICTION_SET_CAT_COSTPD") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_CAT" : "ODMR_PREDICTION_SET_CATPD")) : (this._useCostType.compareTo("Model") == 0 ? (string2 == "BINARY_DOUBLE" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTD") : (string2 == "BINARY_FLOAT" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTF") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM_COST" : "ODMR_PREDICTION_SET_NUM_COSTN"))) : (string2 == "BINARY_DOUBLE" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_D") : (string2 == "BINARY_FLOAT" ? (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_F") : (applyNode.isEnableLegacyApplyOutputTypes() ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_N"))));
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string3);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }

        public void setCostCutOff(Double d) {
            this._costCutOff = d;
        }

        public Double getCostCutOff() {
            return this._costCutOff;
        }

        public void setUseCostCutOff(boolean bl) {
            this._useCostCutOff = bl;
        }

        public boolean isUseCostCutOff() {
            return this._useCostCutOff;
        }

        public void setUseCostType(String string) {
            this._useCostType = string;
        }

        public String getUseCostType() {
            return this._useCostType;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }
    }

    public static class DefaultPredictionSet
    implements Parameters {
        protected BigInteger _topN;
        protected int _maxN;
        protected Double _cutOff;
        protected String _column;
        protected boolean _useTopN;
        protected boolean _useCutOff;

        public DefaultPredictionSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            this._topN = bigInteger;
            this._maxN = n;
            this._cutOff = d;
            this._column = string;
            this._useTopN = bl;
            this._useCutOff = bl2;
        }

        @Override
        public void validate() throws ValidationException {
            if (!this._useTopN && !this._useCutOff) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_TOPN_CUTOFF_NULL_ERROR"));
            }
            if (this._useCutOff) {
                if (this._cutOff == null) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
                if (this._cutOff <= 0.0 || this._cutOff > 1.0) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topN != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + this._topN.toString());
            }
            if (this._cutOff != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_PROB_CUTOFF") + " " + this._cutOff.toString());
            }
            return stringBuffer.toString();
        }

        public BigInteger getTopN() {
            return this._topN;
        }

        public void setTopN(BigInteger bigInteger) {
            this._topN = bigInteger;
        }

        public Double getCutOff() {
            return this._cutOff;
        }

        public void setCutOff(Double d) {
            this._cutOff = d;
        }

        public int getMaxN() {
            return this._maxN;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        public void setUseTopN(boolean bl) {
            this._useTopN = bl;
        }

        public boolean isUseTopN() {
            return this._useTopN;
        }

        public void setUseCutOff(boolean bl) {
            this._useCutOff = bl;
        }

        public boolean isUseCutOff() {
            return this._useCutOff;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }
    }

    public static class ClassPredictionUpperBounds
    extends ClassPredictionBounds {
        public ClassPredictionUpperBounds(Double d, Object object, Vector<Object> vector, String string) {
            super(d, object, vector, null, string);
        }

        @Override
        public String getColumn() {
            return this._upperBound;
        }

        @Override
        public void setColumn(String string) {
            this._upperBound = string;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._upperBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class ClassPredictionLowerBounds
    extends ClassPredictionBounds {
        public ClassPredictionLowerBounds(Double d, Object object, Vector<Object> vector, String string) {
            super(d, object, vector, string, null);
        }

        @Override
        public String getColumn() {
            return this._lowerBound;
        }

        @Override
        public void setColumn(String string) {
            this._lowerBound = string;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._lowerBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class ClassPredictionBounds
    extends DefaultPredictionBounds {
        private Object _selectedTarget;
        private Vector<Object> _targetValues;

        public ClassPredictionBounds(Double d, Object object, Vector<Object> vector, String string, String string2) {
            super(d, string, string2);
            this._selectedTarget = object;
            this._targetValues = vector;
        }

        public Vector<Object> getTargetValues() {
            return this._targetValues;
        }

        public Object getSelectedTarget() {
            return this._selectedTarget;
        }

        public void setSelectedTarget(Object object) {
            this._selectedTarget = object;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CONFIDENCE_PERC") + " " + this.getConfidence() * 100.0);
            if (this._selectedTarget != null) {
                stringBuffer.append(", " + NodeMessagesLrb.get("APPLY_PREDICTION_TARGET_MOST_LIKELY") + " " + this._selectedTarget);
            } else {
                stringBuffer.append(", " + NodeMessagesLrb.get("APPLY_PREDICTION_TARGET_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            CharSequence charSequence;
            Object object;
            String string = null;
            if (this._selectedTarget != null) {
                object = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
                charSequence = ((TargetInfo)object).getMiningType();
                string = ((String)charSequence).equals("Categorical") ? "'" + this._selectedTarget + "'" : this._selectedTarget.toString();
            }
            object = new StringBuffer("");
            if (this._confidence != null) {
                ((StringBuffer)object).append(", " + this._confidence);
                if (this._selectedTarget != null) {
                    ((StringBuffer)object).append(", " + string);
                }
            } else if (this._selectedTarget != null) {
                ((StringBuffer)object).append(", NULL, " + string);
            }
            charSequence = new StringBuffer();
            if (this._lowerBound != null) {
                ((StringBuffer)charSequence).append("PREDICTION_BOUNDS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + object + " USING *).LOWER \"" + this._lowerBound + "\"");
            }
            if (this._upperBound != null) {
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append("PREDICTION_BOUNDS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + object + " USING *).UPPER \"" + this._upperBound + "\"");
            }
            return ((StringBuffer)charSequence).toString();
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._lowerBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            attributeType = new AttributeType();
            attributeType.setName(this._upperBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class RegressPredictionUpperBounds
    extends RegressPredictionBounds {
        public RegressPredictionUpperBounds(Double d, String string) {
            super(d, null, string);
        }

        @Override
        public String getColumn() {
            return this._upperBound;
        }

        @Override
        public void setColumn(String string) {
            this._upperBound = string;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._upperBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class RegressPredictionLowerBounds
    extends RegressPredictionBounds {
        public RegressPredictionLowerBounds(Double d, String string) {
            super(d, string, null);
        }

        @Override
        public String getColumn() {
            return this._lowerBound;
        }

        @Override
        public void setColumn(String string) {
            this._lowerBound = string;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._lowerBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class RegressPredictionBounds
    extends DefaultPredictionBounds {
        public RegressPredictionBounds(Double d, String string, String string2) {
            super(d, string, string2);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this._confidence != null) {
                stringBuffer.append(", " + this._confidence);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            if (this._lowerBound != null) {
                stringBuffer2.append("PREDICTION_BOUNDS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + stringBuffer + " USING *).LOWER \"" + this._lowerBound + "\"");
            }
            if (this._upperBound != null) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append("PREDICTION_BOUNDS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"" + stringBuffer + " USING *).UPPER \"" + this._upperBound + "\"");
            }
            return stringBuffer2.toString();
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._lowerBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            attributeType = new AttributeType();
            attributeType.setName(this._upperBound);
            attributeType.setDataType(applyNode.isEnableLegacyApplyOutputTypes() ? "NUMBER" : "BINARY_DOUBLE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class DefaultPredictionBounds
    implements Parameters {
        protected Double _confidence = new Double(0.95);
        protected String _lowerBound;
        protected String _upperBound;

        public DefaultPredictionBounds(Double d, String string, String string2) {
            if (d != null) {
                this._confidence = d;
            }
            this._lowerBound = string;
            this._upperBound = string2;
        }

        @Override
        public void validate() throws ValidationException {
            if (this._confidence <= 0.0 || this._confidence * 100.0 > 100.0) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CONFIDENCE_ERROR"));
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CONFIDENCE_PERC") + " " + this.getConfidence() * 100.0);
            return stringBuffer.toString();
        }

        public void setLowerBound(String string) {
            this._lowerBound = string;
        }

        public String getLowerBound() {
            return this._lowerBound;
        }

        public void setUpperBound(String string) {
            this._upperBound = string;
        }

        public String getUpperBound() {
            return this._upperBound;
        }

        public void setConfidence(Double d) {
            this._confidence = d;
        }

        public Double getConfidence() {
            return this._confidence;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public void setColumn(String string) {
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }
    }

    public static class FeatureId
    extends DefaultParameters {
        public FeatureId(String string) {
            super(string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return "FEATURE_ID(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getDataType();
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class ClusterId
    extends DefaultParameters {
        public ClusterId(String string) {
            super(string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return "CLUSTER_ID(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" USING *) \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getDataType();
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class PredictionDetails
    extends DefaultParameters {
        public PredictionDetails(String string) {
            super(string);
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            if (applyNode.is12gDB()) {
                return "extractValue(PREDICTION_DETAILS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" USING *), '/Details/@node') \"" + this._column + "\"";
            }
            return "extractValue(PREDICTION_DETAILS(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" USING *), '/Node/@id') \"" + this._column + "\"";
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType("XMLTYPE");
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class Prediction
    extends DefaultParameters {
        protected String _useCostType;
        protected CostMatrixType _costMatrix;

        public Prediction(String string, String string2, CostMatrixType costMatrixType) {
            super(string);
            this._useCostType = string2;
            this._costMatrix = costMatrixType;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            if (this._useCostType.compareTo("Model") == 0) {
                return "PREDICTION(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" COST MODEL USING *) \"" + this._column + "\"";
            }
            return "PREDICTION(\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\" USING *) \"" + this._column + "\"";
        }

        public void setUseCostType(String string) {
            this._useCostType = string;
        }

        public String getUseCostType() {
            return this._useCostType;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            TargetInfo targetInfo = ApplyNode.findTargetMiningTypeFromModel(applyNode, refModelType);
            String string = targetInfo.getDataType();
            Attributes attributes = new Attributes();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(this._column);
            attributeType.setDataType(string);
            attributeType.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(attributeType);
            return attributes;
        }
    }

    public static class DefaultParameters
    implements Parameters {
        protected String _column;

        public DefaultParameters(String string) {
            this._column = string;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }

        @Override
        public Attributes getAttributes(ApplyNode applyNode, RefModelType refModelType) {
            return null;
        }
    }

    public static interface Parameters {
        public void validate() throws ValidationException;

        public String toString();

        public String getColumn();

        public void setColumn(String var1);

        public String generateCode(ApplyNode var1, RefModelType var2);

        public Attributes getAttributes(ApplyNode var1, RefModelType var2);
    }

    public static class ApplyOutputColumnNameGenerator {
        public static final String OUTPUT_CLUSTER_ID = "CLID";
        public static final String OUTPUT_CLUSTER_PROB = "PROB";
        public static final String OUTPUT_CLUSTER_SET = "CSET";
        public static final String OUTPUT_FEATURE_ID = "FEID";
        public static final String OUTPUT_FEATURE_SET = "FSET";
        public static final String OUTPUT_FEATURE_VALUE = "FVAL";
        public static final String OUTPUT_PREDICTION = "PRED";
        public static final String OUTPUT_PREDICTION_BOUNDS = "PBND";
        public static final String OUTPUT_PREDICTION_BOUNDS_UPPER = "PBUP";
        public static final String OUTPUT_PREDICTION_BOUNDS_LOWER = "PBLW";
        public static final String OUTPUT_PREDICTION_COSTS = "PCST";
        public static final String OUTPUT_PREDICTION_DETAILS = "PDET";
        public static final String OUTPUT_PREDICTION_PROB = "PROB";
        public static final String OUTPUT_PREDICTION_SET = "PSET";
        private HashMap<String, Boolean> _columnNames = new HashMap();
        private int MAX_COLUMN_LEN = 30;

        public ApplyOutputColumnNameGenerator(ApplyOutputColumnsType applyOutputColumnsType) {
            if (applyOutputColumnsType != null) {
                for (ApplyOutputColumnsType.OutputColumn outputColumn : applyOutputColumnsType.getOutputColumn()) {
                    FeatureSetType featureSetType;
                    FeatureValueType featureValueType;
                    FeatureIdType featureIdType;
                    ClusterSetType clusterSetType;
                    ClusterProbabilityType clusterProbabilityType;
                    ClusterIdType clusterIdType;
                    Object object;
                    PredictionProbabilityType predictionProbabilityType;
                    Object object2;
                    Object object3;
                    PredictionBoundsType predictionBoundsType;
                    PredictionType predictionType = outputColumn.getPrediction();
                    if (predictionType != null) {
                        this._columnNames.put(predictionType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((predictionBoundsType = outputColumn.getPredictionBounds()) != null) {
                        object3 = predictionBoundsType.getColumn().getUpperBound();
                        if (object3 != null) {
                            this._columnNames.put((String)object3, Boolean.TRUE);
                        }
                        if ((object2 = predictionBoundsType.getColumn().getLowerBound()) != null) {
                            this._columnNames.put((String)object2, Boolean.TRUE);
                        }
                    }
                    if ((object3 = outputColumn.getPredictionCost()) != null && (object2 = object3.getColumn().getName()) != null) {
                        this._columnNames.put((String)object2, Boolean.TRUE);
                    }
                    if ((object2 = outputColumn.getPredictionDetails()) != null) {
                        this._columnNames.put(object2.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((predictionProbabilityType = outputColumn.getPredictionProbability()) != null && (object = predictionProbabilityType.getColumn().getName()) != null) {
                        this._columnNames.put((String)object, Boolean.TRUE);
                    }
                    if ((object = outputColumn.getPredictionSet()) != null) {
                        this._columnNames.put(object.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((clusterIdType = outputColumn.getClusterId()) != null) {
                        this._columnNames.put(clusterIdType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((clusterProbabilityType = outputColumn.getClusterProbability()) != null) {
                        this._columnNames.put(clusterProbabilityType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((clusterSetType = outputColumn.getClusterSet()) != null) {
                        this._columnNames.put(clusterSetType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((featureIdType = outputColumn.getFeatureId()) != null) {
                        this._columnNames.put(featureIdType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((featureValueType = outputColumn.getFeatureValue()) != null) {
                        this._columnNames.put(featureValueType.getColumn().getName(), Boolean.TRUE);
                    }
                    if ((featureSetType = outputColumn.getFeatureSet()) == null) continue;
                    this._columnNames.put(featureSetType.getColumn().getName(), Boolean.TRUE);
                }
            }
        }

        public boolean doesNameExist(String string) {
            Boolean bl = this._columnNames.get(string);
            return bl != null;
        }

        public void addUniqueName(String string) {
            this._columnNames.put(string, Boolean.TRUE);
        }

        public void removeUniqueName(String string) {
            this._columnNames.remove(string);
        }

        public void removeUniqueName(ApplyOutputColumnsType.OutputColumn outputColumn) {
            String string = null;
            if (outputColumn.getPrediction() != null) {
                string = outputColumn.getPrediction().getColumn().getName();
            } else if (outputColumn.getPredictionBounds() != null) {
                String string2;
                PredictionBoundsType predictionBoundsType = outputColumn.getPredictionBounds();
                String string3 = predictionBoundsType.getColumn().getUpperBound();
                if (string3 != null) {
                    string = string3;
                }
                if ((string2 = predictionBoundsType.getColumn().getLowerBound()) != null) {
                    string = string2;
                }
            } else if (outputColumn.getPredictionCost() != null) {
                string = outputColumn.getPredictionCost().getColumn().getName();
            } else if (outputColumn.getPredictionDetails() != null) {
                string = outputColumn.getPredictionDetails().getColumn().getName();
            } else if (outputColumn.getPredictionProbability() != null) {
                string = outputColumn.getPredictionProbability().getColumn().getName();
            } else if (outputColumn.getPredictionSet() != null) {
                string = outputColumn.getPredictionSet().getColumn().getName();
            } else if (outputColumn.getClusterId() != null) {
                string = outputColumn.getClusterId().getColumn().getName();
            } else if (outputColumn.getClusterProbability() != null) {
                string = outputColumn.getClusterProbability().getColumn().getName();
            } else if (outputColumn.getClusterSet() != null) {
                string = outputColumn.getClusterSet().getColumn().getName();
            } else if (outputColumn.getFeatureId() != null) {
                string = outputColumn.getFeatureId().getColumn().getName();
            } else if (outputColumn.getFeatureValue() != null) {
                string = outputColumn.getFeatureValue().getColumn().getName();
            } else if (outputColumn.getFeatureSet() != null) {
                string = outputColumn.getFeatureSet().getColumn().getName();
            }
            if (string != null) {
                this.removeUniqueName(string);
            }
        }

        public void removeAllUniqueNames() {
            this._columnNames.clear();
        }

        private String getUniqueName(String string, String string2) {
            int n;
            String string3 = null;
            string3 = string2 + "_" + string;
            int n2 = string3.length();
            if (n2 > this.MAX_COLUMN_LEN) {
                n = n2 - this.MAX_COLUMN_LEN;
                string3 = string2.substring(0, string2.length() - n) + "_" + string;
            }
            n = 0;
            while (this._columnNames.containsKey(string3)) {
                string3 = string2 + "_" + string + ++n;
                n2 = string3.length();
                if (n2 <= this.MAX_COLUMN_LEN) continue;
                int n3 = n2 - this.MAX_COLUMN_LEN;
                string3 = string2.substring(0, string2.length() - n3) + "_" + string + n;
            }
            return string3;
        }

        private String getUniqueName(String string, String string2, String string3) {
            int n;
            if (string3 == null) {
                return this.getUniqueName(string, string2);
            }
            String string4 = null;
            string4 = string2 + "_" + string + "_" + string3;
            int n2 = string4.length();
            int n3 = 0;
            if (n2 > this.MAX_COLUMN_LEN && (n2 = (string4 = string2 + "_T" + ++n3).length()) > this.MAX_COLUMN_LEN) {
                n = n2 - this.MAX_COLUMN_LEN;
                string4 = string2.substring(0, string2.length() - n) + "_T" + n3;
            }
            while (this._columnNames.containsKey(string4)) {
                string4 = string2 + "_T" + ++n3;
                n2 = string4.length();
                if (n2 <= this.MAX_COLUMN_LEN) continue;
                n = n2 - this.MAX_COLUMN_LEN;
                string4 = string2.substring(0, string2.length() - n) + "_T" + n3;
            }
            return string4;
        }

        public String GenerateColumnName(String string, String string2, boolean bl) {
            return this.GenerateColumnName(string, string2, null, bl);
        }

        public String GenerateColumnName(String string, String string2, String string3, boolean bl) {
            String string4 = null;
            if (string.compareTo(OUTPUT_PREDICTION) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION, string2);
            } else if (string.compareTo(OUTPUT_PREDICTION_BOUNDS_UPPER) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_BOUNDS_UPPER, string2, string3);
            } else if (string.compareTo(OUTPUT_PREDICTION_BOUNDS_LOWER) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_BOUNDS_LOWER, string2, string3);
            } else if (string.compareTo(OUTPUT_PREDICTION_BOUNDS) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_BOUNDS, string2, string3);
            } else if (string.compareTo(OUTPUT_PREDICTION_COSTS) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_COSTS, string2, string3);
            } else if (string.compareTo(OUTPUT_PREDICTION_DETAILS) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_DETAILS, string2);
            } else if (string.compareTo("PROB") == 0) {
                string4 = this.getUniqueName("PROB", string2, string3);
            } else if (string.compareTo(OUTPUT_PREDICTION_SET) == 0) {
                string4 = this.getUniqueName(OUTPUT_PREDICTION_SET, string2);
            } else if (string.compareTo(OUTPUT_CLUSTER_ID) == 0) {
                string4 = this.getUniqueName(OUTPUT_CLUSTER_ID, string2);
            } else if (string.compareTo("PROB") == 0) {
                string4 = this.getUniqueName("PROB", string2, string3);
            } else if (string.compareTo(OUTPUT_CLUSTER_SET) == 0) {
                string4 = this.getUniqueName(OUTPUT_CLUSTER_SET, string2);
            } else if (string.compareTo(OUTPUT_FEATURE_ID) == 0) {
                string4 = this.getUniqueName(OUTPUT_FEATURE_ID, string2);
            } else if (string.compareTo(OUTPUT_FEATURE_SET) == 0) {
                string4 = this.getUniqueName(OUTPUT_FEATURE_SET, string2);
            } else if (string.compareTo(OUTPUT_FEATURE_VALUE) == 0) {
                string4 = this.getUniqueName(OUTPUT_FEATURE_VALUE, string2, string3);
            }
            if (bl) {
                this._columnNames.put(string4, Boolean.TRUE);
            }
            return string4;
        }
    }

    private static class TargetInfo {
        String _dataType;
        String _miningType;

        public TargetInfo(String string, String string2) {
            this._dataType = string;
            this._miningType = string2;
        }

        public String getDataType() {
            return this._dataType;
        }

        public String getMiningType() {
            return this._miningType;
        }
    }
}

