/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;

public final class AggregationNode
extends AbstractTransformNode
implements ApplyChainNode {
    public static final String AUTO_SPEC = "autoSpec";
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String SUB_GROUP_BY = "subGroupBy";
    public static final String ALL_AGGREGATE_NODE_PROPERTIES = "allAggregateNodeProperies";
    public static final String MAIN_GROUP_BY = "mainGroupBy";

    public AggregationNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_AGGREGATION_NODE_NAME");
    }

    public static boolean isAutoSpec(AggregationNodeType aggregationNodeType) {
        AutoSpecType autoSpecType = aggregationNodeType.getAutoSpec();
        if (autoSpecType == null) {
            return false;
        }
        return 0 == autoSpecType.value().compareTo("Yes");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_AGGREGATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_AGGREGATION_ICON"));
    }

    @Override
    public Attributes getAttributes() {
        String string;
        AbstractNode abstractNode;
        Object object;
        Attributes attributes = new Attributes();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        if (null != groupingElementType.getExpression()) {
            object = new AttributeType();
            Object object2 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
            String string2 = AttributeTypeHelper.createNonQuotedAlias((String)object2);
            object.setName(string2);
            try {
                abstractNode = this.findParentNode();
                string = AttributeTypeHelper.getMainGroupByElementValidationSQL(groupingElementType, ((DataProvider)((Object)abstractNode)).getInputSQL());
                String string3 = DatabaseMetadataUtils.getColumnType(this.getContext(), string);
                object.setDataType(string3);
            }
            catch (Exception exception) {
                object.setDataType("VARCHAR2");
            }
            object.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(object);
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
            for (Object object2 : groupingElementType.getAttributes().getAttribute()) {
                attributes.getAttribute().add(object2);
            }
        }
        object = aggregationNodeType.getAggregationElements();
        for (String string2 : object.getAggregationElement()) {
            abstractNode = string2.getOutput();
            string = new AttributeType();
            string.setName(abstractNode.getName());
            string.setAlias(abstractNode.getAlias());
            string.setDataType(abstractNode.getDataType());
            string.setStatus(abstractNode.getStatus());
            attributes.getAttribute().add(string);
        }
        return attributes;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        AggregationElements aggregationElements = new AggregationElements();
        aggregationElements.getAggregationElement();
        aggregationNodeType.setAggregationElements(aggregationElements);
        GroupingElementType groupingElementType = new GroupingElementType();
        Attributes attributes = new Attributes();
        attributes.getAttribute();
        groupingElementType.setAttributes(attributes);
        aggregationNodeType.setGroupingElement(groupingElementType);
        aggregationNodeType.setAutoSpec(AutoSpecType.YES);
        aggregationNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        aggregationNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public boolean validate(boolean bl) {
        AbstractNode abstractNode;
        boolean bl2 = super.validate(bl);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        GroupingElementType groupingElementType = null;
        boolean bl3 = false;
        if (bl2) {
            groupingElementType = aggregationNodeType.getGroupingElement();
            if (groupingElementType == null) {
                bl2 = false;
            }
            boolean bl4 = bl3 = null == groupingElementType.getExpression() && (null == groupingElementType.getAttributes() || null == groupingElementType.getAttributes().getAttribute() || groupingElementType.getAttributes().getAttribute().isEmpty());
        }
        if (null == aggregationNodeType.getAggregationElements() || null == aggregationNodeType.getAggregationElements().getAggregationElement()) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        } else if (aggregationNodeType.getAggregationElements().getAggregationElement().isEmpty() && bl3) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2 && (abstractNode = this.findParentNode()) == null) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_SRC_DATA", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2) {
            bl2 = this.validateInputAttributes();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        if (bl2) {
            this.excecuteInputColumnsTxn();
        }
        return bl2;
    }

    @Override
    public Object getProperty(String string) {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        Object object = null;
        if (string.equals(SOURCE_COLUMNS)) {
            object = aggregationNodeType.getAggregationElements();
        } else if (string.equals(AUTO_SPEC)) {
            object = aggregationNodeType;
        } else if (string.equals(MAIN_GROUP_BY)) {
            object = aggregationNodeType.getGroupingElement();
        } else if (string.equals(ALL_AGGREGATE_NODE_PROPERTIES)) {
            AggregationNodeType aggregationNodeType2 = new AggregationNodeType();
            AggregationElements aggregationElements = new AggregationElements();
            aggregationElements.getAggregationElement();
            aggregationNodeType2.setAggregationElements(aggregationElements);
            GroupingElementType groupingElementType = new GroupingElementType();
            Attributes attributes = new Attributes();
            attributes.getAttribute();
            groupingElementType.setAttributes(attributes);
            aggregationNodeType2.setGroupingElement(groupingElementType);
            if (aggregationNodeType.getAggregationElements() != null && aggregationNodeType.getAggregationElements().getAggregationElement() != null) {
                AttributeTypeHelper.copyAttributes(aggregationNodeType2.getAggregationElements().getAggregationElement(), aggregationNodeType.getAggregationElements().getAggregationElement());
            }
            if (aggregationNodeType.getGroupingElement() != null) {
                AttributeTypeHelper.copyGroupingElementType(aggregationNodeType2.getGroupingElement(), aggregationNodeType.getGroupingElement());
            }
            aggregationNodeType2.setAutoSpec(aggregationNodeType.getAutoSpec());
            object = aggregationNodeType2;
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SOURCE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AUTO_SPEC)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MAIN_GROUP_BY)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        if (string.equals(SOURCE_COLUMNS)) {
            assert (object instanceof AggregationElements);
            aggregationNodeType.setAggregationElements((AggregationElements)object);
        } else if (string.equals(AUTO_SPEC)) {
            AggregationNodeType aggregationNodeType2 = (AggregationNodeType)object;
            aggregationNodeType.setAutoSpec(aggregationNodeType2.getAutoSpec());
            aggregationNodeType.setGroupingElement(aggregationNodeType2.getGroupingElement());
            aggregationNodeType.setAggregationElements(aggregationNodeType2.getAggregationElements());
        } else if (string.equals(MAIN_GROUP_BY)) {
            aggregationNodeType.setGroupingElement((GroupingElementType)object);
        } else if (string.equals(ALL_AGGREGATE_NODE_PROPERTIES)) {
            AggregationNodeType aggregationNodeType3 = (AggregationNodeType)object;
            aggregationNodeType.setAggregationElements(aggregationNodeType3.getAggregationElements());
            aggregationNodeType.setAutoSpec(aggregationNodeType3.getAutoSpec());
            aggregationNodeType.setGroupingElement(aggregationNodeType3.getGroupingElement());
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        return this.wrapExpressionInWithClause(AttributeTypeHelper.generateSQLExpression(this.getContext(), aggregationNodeType.getAggregationElements(), aggregationNodeType.getGroupingElement(), null, false));
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    private void excecuteInputColumnsTxn() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    private boolean validateInputAttributes() {
        String string;
        boolean bl = true;
        AbstractNode abstractNode = this.findParentNode();
        assert (abstractNode instanceof DataProvider);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (Object object : list2) {
            String string2 = object.getAlias();
            string = string2 != null && string2.trim().length() > 0 ? string2 : object.getName();
            hashMap.put(string, (AttributeType)object);
        }
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        bl = AggregationNode.validateGroupingElementType(hashMap, groupingElementType);
        if (bl) {
            for (String string2 : list) {
                string = string2.getSource();
                bl = AggregationNode.validateGroupingElementType(hashMap, (GroupingElementType)string);
                if (!bl) {
                    this.addMessage("AGGREGATION_MISSING_COLUMN", MessageEnumType.INCOMPLETE, new String[0]);
                } else {
                    GroupingElementType groupingElementType2 = string2.getSubGroupBy();
                    bl = AggregationNode.validateGroupingElementType(hashMap, groupingElementType2);
                    if (bl) continue;
                    this.addMessage("AGGREGATION_MISSING_COLUMN", MessageEnumType.INCOMPLETE, new String[0]);
                }
                break;
            }
        } else {
            this.addMessage("AGGREGATION_INCOMPLETE_SRC_DATA", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    private static boolean validateGroupingElementType(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        List list;
        boolean bl = true;
        if (null != groupingElementType.getAttributes() && null == groupingElementType.getExpression() && null != (list = groupingElementType.getAttributes().getAttribute()) && !list.isEmpty()) {
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = map.get(attributeType.getName());
                if (null == attributeType2) {
                    attributeType.setStatus(AttributeStatus.MISSING);
                    bl = false;
                    continue;
                }
                attributeType.setStatus(attributeType2.getStatus());
                attributeType.setStatus(attributeType2.getStatus().equals((Object)AttributeStatus.VALID) ? AttributeStatus.VALID : AttributeStatus.INVALID);
            }
        }
        return bl;
    }

    private static boolean isGroupingElementInvalid(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        boolean bl = false;
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            for (AttributeType attributeType : groupingElementType.getAttributes().getAttribute()) {
                AttributeType attributeType2 = map.get(attributeType.getName());
                if (null == attributeType2) {
                    bl = true;
                    break;
                }
                if (attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static Map<String, AggregationElementType> getInvalidAggregationElements(DataProvider dataProvider, AggregationNodeType aggregationNodeType) {
        String string;
        HashMap<String, AggregationElementType> hashMap = new HashMap<String, AggregationElementType>();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list.isEmpty()) {
            return hashMap;
        }
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap2 = new HashMap<String, AttributeType>();
        for (Object object : list2) {
            String string2 = object.getAlias();
            string = string2 != null && string2.trim().length() > 0 ? string2 : object.getName();
            hashMap2.put(string, (AttributeType)object);
        }
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        if (AggregationNode.isGroupingElementInvalid(hashMap2, groupingElementType)) {
            for (String string2 : list) {
                hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
            }
            return hashMap;
        }
        for (String string2 : list) {
            GroupingElementType groupingElementType2;
            string = string2.getSource();
            if (AggregationNode.isGroupingElementInvalid(hashMap2, (GroupingElementType)string)) {
                hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
            }
            if (!AggregationNode.isGroupingElementInvalid(hashMap2, groupingElementType2 = string2.getSubGroupBy())) continue;
            hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "aggregation_node";
    }

    public static void autoRemoveAttributes(DataProvider dataProvider, AggregationNodeType aggregationNodeType) {
        String string2;
        Object object;
        AttributeType attributeType2;
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list.isEmpty()) {
            return;
        }
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list2) {
            object = attributeType2.getAlias();
            string2 = object != null && ((String)object).trim().length() > 0 ? object : attributeType2.getName();
            hashMap.put(string2, attributeType2);
        }
        ArrayList arrayList = new ArrayList();
        attributeType2 = aggregationNodeType.getGroupingElement();
        if (AggregationNode.isGroupingElementInvalid(hashMap, (GroupingElementType)attributeType2)) {
            for (String string2 : list) {
                arrayList.add(string2);
            }
        } else {
            for (String string2 : list) {
                GroupingElementType groupingElementType;
                GroupingElementType groupingElementType2 = string2.getSource();
                if (AggregationNode.isGroupingElementInvalid(hashMap, groupingElementType2)) {
                    arrayList.add(string2);
                }
                if (!AggregationNode.isGroupingElementInvalid(hashMap, groupingElementType = string2.getSource())) continue;
                arrayList.add(string2);
            }
        }
        object = arrayList.iterator();
        block3: while (object.hasNext()) {
            string2 = (AggregationElementType)object.next();
            for (GroupingElementType groupingElementType : list) {
                if (!groupingElementType.getOutput().getName().equals(string2.getOutput().getName())) continue;
                list.remove(groupingElementType);
                continue block3;
            }
        }
    }

    @Override
    public void refactorForApply() throws Exception {
    }
}

