/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public abstract class AbstractBuildNode
extends AbstractNode
implements ModelProvider {
    public static final String MODEL_NAME = "modelName";
    public static final String MODEL_ADDED_REMOVED = "modelAddedorRemoved";
    public static final String MODEL_ADDED = "modelAdded";
    public static final String MODEL_REMOVED = "modelRemoved";
    public static final String MODELS_RERUN = "modelsRerun";
    public static final String TESTS_RERUN = "testsRerun";
    public static final String MODEL_ANNOTATION = "modelAnnotation";
    public static final String ALL_TESTS_REMOVED = "alltestsRemoved";
    public static final String ALL_TESTS_RESTORED = "alltestsRestored";
    public static final String TESTS_REMOVED = "testsRemoved";
    public static final String TESTS_RESTORED = "testsRestored";
    public static final String MODEL_USE_FOR_OUTPUT = "modelUseForOutput";
    public static final String ALG_SETTINGS = "algTreeSettings";
    public static final String TEST_OPTIONS_CHANGED = "testOptionsChanged";
    public static final String TEST_SETTINGS_CHANGED = "testSettingsChanged";
    public static final String SPLIT_VALUE_CHANGED = "splitValueChanged";
    public static final String MINING_ATTRIBUTE_SETTINGS = "miningAttributeSettings";
    private Long lastBuildNodeId = 1L;
    public static final String CASE_ATTRIBUTES = "caseAttributes";
    public static final String BUILD_DATA_SOURCE = "buildDataSource";
    private static final String ALL_ATTRIBUTES = "allAttributes";
    private static final String NODE_ATTRIBUTES = "nodeAttributes";
    private static final String MODELS_ATTRIBUTES = "modelsAttributes";
    private static final String MODEL_ATTRIBUTES = "modelAttributes";
    private static final String REFACTOR_MODELS = "refactorModels";
    private static final String MODEL_STATUS = "modelStatus";
    private static final String CASE_ID_ATTRIBUTES = "caseAttributesInternal";

    public AbstractBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.initMaxModelId();
    }

    private void initMaxModelId() {
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData());
        for (ModelType modelType : list) {
            Long l = new Long(modelType.getId());
            if (this.lastBuildNodeId == null) {
                this.lastBuildNodeId = l;
                continue;
            }
            if (this.lastBuildNodeId.compareTo(l) >= 0) continue;
            this.lastBuildNodeId = l;
        }
    }

    public String getNextModelId() {
        this.lastBuildNodeId = new Long(this.lastBuildNodeId + 1L);
        return this.lastBuildNodeId.toString();
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        try {
            this.initMiningAttributesInstance();
            this.initCaseAttributesInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public abstract String getDefaultName();

    public ModelType createNewModel(String string, String string2, String string3, String string4) {
        NaiveBayesModelType naiveBayesModelType = null;
        String string5 = null;
        try {
            string5 = this.getModel().getNextNewIdString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        InputMiningData inputMiningData = new InputMiningData();
        MiningAttributes miningAttributes = new MiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        inputMiningData.setMiningAttributes(miningAttributes);
        if (string3.equals("ASSOCIATION")) {
            inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
            inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
        } else {
            inputMiningData.setDataUsage(InputMiningDataType.AUTO);
            inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
        }
        List list2 = ((BuildNodeType)this.getData()).getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list2) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list.add(miningAttributeType2);
        }
        if (string4.equals("ALGO_NAIVE_BAYES")) {
            naiveBayesModelType = MetaDataHelper.createNaiveBayesModel();
        } else if (string4.equals("ALGO_DECISION_TREE")) {
            naiveBayesModelType = MetaDataHelper.createDecisionTreeModel();
        } else if (string4.equals("ALGO_SUPPORT_VECTOR_MACHINES")) {
            if (string3.equals("CLASSIFICATION")) {
                naiveBayesModelType = MetaDataHelper.createSVMClassificationModel();
            } else if (string3.equals("REGRESSION")) {
                naiveBayesModelType = MetaDataHelper.createSVMRegressionModel();
            } else if (string3.equals("ANOMALY_DETECTION")) {
                naiveBayesModelType = MetaDataHelper.createSVMAnomalyModel();
            }
        } else if (string4.equals("ALGO_GENERALIZED_LINEAR_MODEL")) {
            if (string3.equals("CLASSIFICATION")) {
                naiveBayesModelType = MetaDataHelper.createGLMClassificationModel();
            } else if (string3.equals("REGRESSION")) {
                naiveBayesModelType = MetaDataHelper.createGLMRegressionModel();
            }
        } else if (string4.equals("ALGO_KMEANS")) {
            naiveBayesModelType = MetaDataHelper.createKMeansModel();
        } else if (string4.equals("ALGO_O_CLUSTER")) {
            naiveBayesModelType = MetaDataHelper.createOClusterModel();
        } else if (string4.equals("ALGO_APRIORI_ASSOCIATION_RULES")) {
            naiveBayesModelType = MetaDataHelper.createAprioriModel();
        } else if (string4.equals("ALGO_NONNEGATIVE_MATRIX_FACTOR")) {
            naiveBayesModelType = MetaDataHelper.createNMFModel();
        }
        naiveBayesModelType.setName(string);
        naiveBayesModelType.setAnnotation(string2);
        naiveBayesModelType.setInputMiningData(inputMiningData);
        naiveBayesModelType.setStatus(ModelStatusType.READY);
        naiveBayesModelType.setId(string5);
        return naiveBayesModelType;
    }

    public abstract MiningFunctionType getMiningFunctionType();

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    public AbstractDataNode findBuildDataNode(WorkflowModel workflowModel) {
        AbstractDataNode abstractDataNode = null;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            return null;
        }
        List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)this);
        for (GeneralLink generalLink : list) {
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)generalLink.getFrom();
            if (!abstractDataNode2.getMetadataId().equals(buildDataSource.getSourceId())) continue;
            abstractDataNode = abstractDataNode2;
            break;
        }
        return abstractDataNode;
    }

    @Override
    public List<RefModelType> getOutputModels() {
        List<RefModelType> list = new ArrayList<RefModelType>();
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        Context context = this.getContext();
        try {
            if (buildNodeType != null) {
                list = MetaDataHelper.getModelsCollection(buildNodeType, context);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)NodeMessagesLrb.get("ERROR_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            exception.printStackTrace();
        }
        return list;
    }

    @Override
    public Object getProperty(String string) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        try {
            if (string.equals(CASE_ATTRIBUTES)) {
                return buildNodeType.getCaseAttributes();
            }
            if (string.equals(BUILD_DATA_SOURCE)) {
                return buildNodeType.getBuildDataSource();
            }
            if (string.equals(NODE_ATTRIBUTES)) {
                return buildNodeType.getMiningAttributes();
            }
            if (string.equals(REFACTOR_MODELS)) {
                HashMap<String, RefModelType> hashMap = new HashMap<String, RefModelType>();
                List<RefModelType> list = MetaDataHelper.getModelsCollection(buildNodeType, this.getContext());
                for (RefModelType refModelType : list) {
                    hashMap.put(refModelType.getName(), refModelType);
                }
                return hashMap;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(ALL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(CASE_ID_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODELS_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_STATUS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(MODEL_ANNOTATION)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getAnnotation());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MODEL_NAME)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                hashMap.put(string, modelType.getName());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals(MINING_ATTRIBUTE_SETTINGS)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, Pair> hashMap = new HashMap<String, Pair>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById(buildNodeType, string);
                Pair pair = (Pair)map.get(string);
                MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute((String)pair.getFirst(), modelType);
                MiningAttributeType miningAttributeType2 = MetaDataHelper.createMiningAttributeFrom((AttributeType)miningAttributeType);
                hashMap.put(string, new Pair((Object)miningAttributeType2.getName(), (Object)miningAttributeType2));
            }
            return hashMap;
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public void setProperty(String string, Object object) {
        try {
            BuildNodeType buildNodeType = (BuildNodeType)this.getData();
            if (string.equals(CASE_ATTRIBUTES)) {
                buildNodeType.setCaseAttributes((CaseAttributes)object);
            } else if (string.equals(ALL_ATTRIBUTES)) {
                List list = (List)object;
                BuildNodeType buildNodeType2 = (BuildNodeType)this.getData();
                MiningAttributes miningAttributes = buildNodeType2.getMiningAttributes();
                List list2 = miningAttributes.getMiningAttribute();
                list2.clear();
                list2.addAll(list);
            } else if (string.equals(BUILD_DATA_SOURCE)) {
                buildNodeType.setBuildDataSource((BuildDataSource)object);
            } else if (string.equals(NODE_ATTRIBUTES)) {
                buildNodeType.setMiningAttributes((MiningAttributes)object);
            } else if (string.equals(MODELS_ATTRIBUTES)) {
                if (object == null || !(object instanceof HashMap)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                Set set = hashMap.keySet();
                for (ModelType modelType : set) {
                    List list = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
                    list.clear();
                    list.addAll((Collection)hashMap.get(modelType));
                }
            } else if (string.equals(CASE_ID_ATTRIBUTES)) {
                List list = (List)object;
                BuildNodeType buildNodeType3 = (BuildNodeType)this.getData();
                CaseAttributes caseAttributes = buildNodeType3.getCaseAttributes();
                List list3 = caseAttributes.getAttribute();
                list3.clear();
                list3.addAll(list);
            } else if (string.equals(MODEL_STATUS)) {
                this.setModelStatus(object);
            } else if (string.equals(REFACTOR_MODELS)) {
                Map map = (Map)object;
                AbstractBuildNode.applyRefactoredModels(map, MetaDataHelper.getModelsCollection(buildNodeType));
            } else if (string.equals(MODEL_ATTRIBUTES)) {
                this.setModelAttributes(object);
            } else if (string.equals(MODEL_ANNOTATION)) {
                if (object == null || !(object instanceof HashMap)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                BuildNodeType buildNodeType4 = (BuildNodeType)this.getData();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType4, string2);
                    if (modelType == null) continue;
                    modelType.setAnnotation((String)hashMap.get(string2));
                }
            } else if (string.equals(MODEL_NAME)) {
                if (object == null || !(object instanceof HashMap)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                BuildNodeType buildNodeType5 = (BuildNodeType)this.getData();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType5, string3);
                    if (modelType == null) continue;
                    modelType.setName((String)hashMap.get(string3));
                }
            } else if (string.equals(MINING_ATTRIBUTE_SETTINGS)) {
                if (object == null || !(object instanceof HashMap)) {
                    return;
                }
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    return;
                }
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                BuildNodeType buildNodeType6 = (BuildNodeType)this.getData();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    ModelType modelType = MetaDataHelper.findModelById(buildNodeType6, string4);
                    Pair pair = (Pair)hashMap.get(string4);
                    MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(((MiningAttributeType)pair.getSecond()).getName(), modelType);
                    miningAttributeType.setAutoPrep(((MiningAttributeType)pair.getSecond()).getAutoPrep());
                    miningAttributeType.setInput(((MiningAttributeType)pair.getSecond()).getInput());
                }
            } else {
                super.setProperty(string, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void applyRefactoredModels(Map<String, RefModelType> map, List<ModelType> list) {
        for (ModelType modelType : list) {
            RefModelType refModelType = map.get(modelType.getName());
            if (refModelType == null) continue;
            modelType.setName(refModelType.getName());
            modelType.setId(refModelType.getModelId());
            modelType.setCreationDate(null);
            modelType.setStatus(ModelStatusType.READY);
        }
    }

    private void setModelAttributes(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)this.getData(), subNodeProperty.getId());
        InputMiningData inputMiningData = modelType.getInputMiningData();
        inputMiningData.setMiningAttributes((MiningAttributes)subNodeProperty.getValue());
    }

    private void setModelStatus(Object object) {
        SubNodeProperty subNodeProperty = (SubNodeProperty)object;
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)this.getData(), subNodeProperty.getId());
        modelType.setStatus((ModelStatusType)subNodeProperty.getValue());
    }

    private void initMiningAttributesInstance() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = new MiningAttributes();
        buildNodeType.setMiningAttributes(miningAttributes);
    }

    private void initCaseAttributesInstance() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        CaseAttributes caseAttributes = new CaseAttributes();
        buildNodeType.setCaseAttributes(caseAttributes);
    }

    private MiningAttributes createMiningAttributesFrom(List<? extends AttributeType> list) {
        MiningAttributes miningAttributes = new MiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        for (AttributeType attributeType : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
            list2.add(miningAttributeType);
        }
        return miningAttributes;
    }

    private void initMiningAttributeInputs(MiningAttributes miningAttributes, ModelType modelType) {
        List list = miningAttributes.getMiningAttribute();
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, version).booleanValue()) continue;
            miningAttributeType.setInput("No");
        }
    }

    public static Boolean isInputAllowed(MiningAttributeType miningAttributeType, ModelType modelType, Version version) {
        String string = miningAttributeType.getDataType();
        if (string.equals("NCHAR") || string.equals("NVARCHAR2")) {
            return false;
        }
        if (string.equals("VARCHAR2") || string.equals("CHAR") || string.equals("NUMBER") || string.equals("FLOAT")) {
            return true;
        }
        if ((string.equals("BINARY_DOUBLE") || string.equals("BINARY_FLOAT")) && version != null && version.toCanonicalString().startsWith("12")) {
            return true;
        }
        if (!(modelType instanceof OClusterModelType) && !(modelType instanceof DecisionTreeModelType) && AttributeTypeHelper.isNestedType((AttributeType)miningAttributeType)) {
            return true;
        }
        return false;
    }

    private boolean validateCaseAttributes(List<AttributeType> list) {
        AttributeType attributeType;
        boolean bl = true;
        CaseAttributes caseAttributes = ((BuildNodeType)this.getData()).getCaseAttributes();
        List list2 = caseAttributes.getAttribute();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list2.size());
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>(list2.size());
        for (Object object2 : list2) {
            AttributeType object3 = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList.add(object3);
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            arrayList2.add(attributeType);
        }
        boolean bl2 = false;
        for (AttributeType attributeType2 : arrayList) {
            if (list == null) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                bl = false;
                continue;
            }
            attributeType = this.findCompatibleAttribute(attributeType2, list);
            if (null == attributeType) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_CASEIDS", MessageEnumType.INCOMPLETE, new String[0]);
                bl = false;
                continue;
            }
            if (!bl2) {
                bl2 = attributeType2.getStatus().equals((Object)AttributeStatus.INVALID);
            }
            attributeType2.setStatus(AttributeStatus.VALID);
        }
        if (!bl || bl2) {
            Object object2;
            object2 = new ComplexProperty(CASE_ID_ATTRIBUTES, arrayList);
            ((ComplexProperty)object2).setOldData(arrayList2);
            ((ComplexProperty)object2).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object2);
        }
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (!(node instanceof AbstractDataNode) || node instanceof BuildTextNodeRef) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.handleBuildDataSourceConnected(node);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        List<GeneralLink> list;
        super.handleRemoveConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource != null && buildDataSource.getSourceId().equals(node.getMetadataId()) && node.getMetadataId().equals(buildDataSource.getSourceId())) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
        }
        if ((list = this.getModel().findLinksToNode((IlvSDMNode)this)).size() == 1) {
            Node node2 = (Node)list.get(0).getFrom();
            this.handleBuildDataSourceConnected(node2);
        }
    }

    private void handleBuildDataSourceConnected(Node node) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list2 = attributes.getAttribute();
        BuildDataSource buildDataSource = buildNodeType.getBuildDataSource();
        if (buildDataSource == null) {
            buildDataSource = new BuildDataSource();
            buildDataSource.setSourceId(node.getMetadataId());
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, buildDataSource);
            if (list.size() == 0) {
                MiningAttributes miningAttributes2 = this.createMiningAttributesFrom(list2);
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes2);
                List<ModelType> list3 = MetaDataHelper.getModelsCollection(buildNodeType);
                for (ModelType modelType : list3) {
                    MiningAttributes miningAttributes3 = modelType.getInputMiningData().getMiningAttributes();
                    MiningAttributes miningAttributes4 = this.createMiningAttributesFrom(miningAttributes2.getMiningAttribute());
                    this.initMiningAttributeInputs(miningAttributes4, modelType);
                    ComplexProperty complexProperty = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes4));
                    complexProperty.setOldData(new SubNodeProperty(modelType.getId(), miningAttributes3));
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
                }
            }
        }
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        Object object;
        Object object2;
        ++this.refactorInvokeCount;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            String string;
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
            object2 = null;
            object = buildNodeType.getBuildDataSource();
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object2 = ((SuperviseBuildNodeType)buildNodeType).getTestDataSource();
            }
            if ((string = ((AbstractNode)node).getOldId()).equals(object.getSourceId())) {
                BuildDataSource buildDataSource = MetaDataHelper.copyBuildDataSource(object);
                buildDataSource.setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, buildDataSource);
                if (list.size() == 1 && object2 != null) {
                    TestDataSource testDataSource = new TestDataSource();
                    TestDataSource.SplitData splitData = new TestDataSource.SplitData();
                    splitData.setTestPercent(50.0);
                    testDataSource.setSplitData(splitData);
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", testDataSource);
                }
            } else if (object2 != null && string.equals(object2.getTestData().getSourceId())) {
                TestDataSource testDataSource = MetaDataHelper.copyTestDataSource((TestDataSource)object2);
                testDataSource.getTestData().setSourceId(node.getMetadataId());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", testDataSource);
                if (list.size() == 1 && object2 != null) {
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
                }
            }
        } else {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), BUILD_DATA_SOURCE, null);
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                object2 = (SuperviseBuildNodeType)buildNodeType;
                object = object2.getTestDataSource();
                TestDataSource testDataSource = MetaDataHelper.copyTestDataSource((TestDataSource)object);
                testDataSource.setTestData(null);
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testData", testDataSource);
            }
        }
        if (this.refactorInvokeCount == list.size() || list.size() == 0) {
            object2 = this.getOutputModels();
            object = WorkflowUtils.refactorModels(this.getContext(), (List<RefModelType>)object2, this.getModel(), bl);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_MODELS, object);
            this.refactorChildModelReferences((Map<String, RefModelType>)object, bl);
        }
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map) throws Exception {
        this.refactorChildModelReferences(map, false);
    }

    public void refactorChildModelReferences(Map<String, RefModelType> map, boolean bl) throws Exception {
        List<AbstractNode> list = this.findChildNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode instanceof ModelConsumer) {
                ((ModelConsumer)((Object)abstractNode)).refactorModelReferences(this, map, bl);
            }
            abstractNode.refactor(this, bl);
        }
    }

    protected abstract boolean validateImpl(boolean var1, boolean var2);

    public boolean validateAfterEdit() {
        return this.validateImpl(true, false);
    }

    @Override
    public boolean validate(boolean bl) {
        AttributeType attributeType;
        Object object;
        Object object2;
        MiningAttributeType miningAttributeType2;
        Object object32;
        boolean bl2 = super.validate(bl);
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>(list.size());
        ArrayList<MiningAttributeType> arrayList2 = new ArrayList<MiningAttributeType>(list.size());
        for (Object object32 : list) {
            miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
            arrayList.add(miningAttributeType2);
            object2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
            arrayList2.add((MiningAttributeType)object2);
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType2 : arrayList) {
            hashMap.put(miningAttributeType2.getName(), miningAttributeType2);
        }
        object32 = this.findBuildDataNode(this.getModel());
        if (object32 == null) {
            this.validateDisconnectedNode(arrayList);
            return false;
        }
        miningAttributeType2 = ((DataProvider)object32).getAttributes();
        object2 = miningAttributeType2.getAttribute();
        boolean bl3 = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (MiningAttributeType)iterator.next();
            attributeType = this.findCompatibleAttribute((AttributeType)object, (List<? extends AttributeType>)object2);
            if (null == attributeType) {
                iterator.remove();
                hashMap.remove(object.getName());
                bl3 = true;
                continue;
            }
            if (!object.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object.setStatus(AttributeStatus.VALID);
            bl3 = true;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            attributeType = (AttributeType)object.next();
            MiningAttributeType miningAttributeType3 = (MiningAttributeType)hashMap.get(attributeType.getName());
            if (miningAttributeType3 != null) continue;
            arrayList.add(MetaDataHelper.createMiningAttributeFrom(attributeType));
        }
        if (!bl2 || bl3 || arrayList2.size() != arrayList.size()) {
            object = (OdmrSDMUndoFilter)this.getUndoFilter();
            attributeType = new MiningAttributes();
            attributeType.getMiningAttribute().addAll(arrayList);
            ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, attributeType);
        }
        if (!this.validateCaseAttributes((List<AttributeType>)object2)) {
            bl2 = false;
        }
        return bl2;
    }

    private void validateDisconnectedNode(List<MiningAttributeType> list) {
        this.addMessage("BUILD_NO_BUILD_DATA", MessageEnumType.WARNING, new String[0]);
        for (MiningAttributeType object2 : list) {
            object2.setStatus(AttributeStatus.INVALID);
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        MiningAttributes miningAttributes = new MiningAttributes();
        miningAttributes.getMiningAttribute().addAll(list);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), NODE_ATTRIBUTES, miningAttributes);
        this.validateCaseAttributes(null);
    }

    public boolean validateModels(List<? extends ModelType> list) {
        boolean bl = true;
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (ModelType modelType : list) {
            Object object;
            Object object2;
            Object object32;
            boolean bl2 = false;
            boolean bl3 = false;
            MiningAttributes miningAttributes2 = modelType.getInputMiningData().getMiningAttributes();
            if (miningAttributes2 == null) {
                bl = false;
                continue;
            }
            MiningAttributes miningAttributes3 = MetaDataHelper.copyMiningAttributes(miningAttributes2);
            List list3 = miningAttributes3.getMiningAttribute();
            HashMap<String, MiningAttributeType> hashMap2 = new HashMap<String, MiningAttributeType>();
            for (Object object32 : list3) {
                hashMap2.put(object32.getName(), (MiningAttributeType)object32);
            }
            for (Object object32 : list2) {
                object2 = (MiningAttributeType)hashMap2.get(object32.getName());
                if (null == object2) {
                    object = (MiningAttributeType)MetaDataHelper.copyMetadataObject(object32);
                    object.setInput("No");
                    list3.add(object);
                    bl3 = true;
                    continue;
                }
                if (!object32.getDataType().equals(object2.getDataType()) || object32.getStatus().equals((Object)AttributeStatus.INVALID)) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    object2.setStatus(AttributeStatus.INVALID);
                    bl2 = true;
                    bl3 = true;
                    continue;
                }
                if (object32.getAlias() == null || !object32.getAlias().equals(object2.getAlias())) continue;
                object2.setAlias(object32.getAlias());
                bl3 = true;
            }
            Iterator iterator = list3.iterator();
            object32 = this.findBuildDataNode(this.getModel());
            while (iterator.hasNext()) {
                object2 = (MiningAttributeType)iterator.next();
                if (object32 == null) {
                    object2.setStatus(AttributeStatus.INVALID);
                    bl3 = true;
                    continue;
                }
                object = (MiningAttributeType)hashMap.get(object2.getName());
                if (null == object) {
                    iterator.remove();
                    bl3 = true;
                    continue;
                }
                if (!object2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                object2.setStatus(AttributeStatus.VALID);
                bl3 = true;
            }
            if (bl2) {
                bl = false;
                this.addMessage("BUILD_INVALID_MODEL", MessageEnumType.WARNING, modelType.getName());
            }
            if (!bl3) continue;
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            object = new ComplexProperty(MODEL_ATTRIBUTES, new SubNodeProperty(modelType.getId(), miningAttributes3));
            ((ComplexProperty)object).setOldData(new SubNodeProperty(modelType.getId(), miningAttributes2));
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.getData());
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (ModelType modelType : list) {
            if (!modelType.getStatus().equals((Object)ModelStatusType.COMPLETE)) continue;
            ComplexProperty complexProperty = new ComplexProperty(MODEL_STATUS, new SubNodeProperty(modelType.getId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(modelType.getId(), modelType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }
}

