/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.transformations;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TransformationNodeHistogramPIComponentPanel
extends PIComponentPanel
implements FocusListener {
    private AbstractDataNode _targetNode;
    private JLabel jLabelCatBins;
    private JLabel jLabelDateBins;
    private JLabel jLabelNumBins;
    private JTextField jTextFieldDateBins;
    private JTextField jTextFieldNunBins;
    private JTextField jTextFieldcatBins;

    public TransformationNodeHistogramPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelNumBins = new JLabel();
        this.jTextFieldNunBins = new NumberTextField();
        this.jLabelCatBins = new JLabel();
        this.jTextFieldcatBins = new NumberTextField();
        this.jLabelDateBins = new JLabel();
        this.jTextFieldDateBins = new NumberTextField();
        this.jLabelNumBins.setText("Numerical Bins:");
        this.jTextFieldNunBins.setText("10");
        this.jLabelCatBins.setText("Categoricla Bins:");
        this.jTextFieldcatBins.setText("10");
        this.jLabelDateBins.setText("Date Bins:");
        this.jTextFieldDateBins.setText("10");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelCatBins, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldcatBins)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelNumBins, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNunBins, -2, 52, -2))).addContainerGap(219, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelDateBins, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDateBins, -1, 52, Short.MAX_VALUE).addGap(244, 244, 244)))));
        groupLayout.linkSize(0, this.jLabelCatBins, this.jLabelDateBins, this.jLabelNumBins);
        groupLayout.linkSize(0, this.jTextFieldDateBins, this.jTextFieldNunBins, this.jTextFieldcatBins);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBins).addComponent(this.jTextFieldNunBins, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCatBins).addComponent(this.jTextFieldcatBins, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDateBins).addComponent(this.jTextFieldDateBins, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLabelCatBins, this.jLabelDateBins, this.jLabelNumBins);
        groupLayout.linkSize(1, this.jTextFieldDateBins, this.jTextFieldNunBins, this.jTextFieldcatBins);
    }

    public void initRes() {
        this.jLabelCatBins.setText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_CAT_BINS"));
        this.jLabelDateBins.setText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_DATE_BINS"));
        this.jLabelNumBins.setText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NUM_BINS"));
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof TransformationNodeType)) {
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        this.setupTextField(this.jTextFieldNunBins, dataProfileSettingsType.getNumericalBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_NUM_BINS_TOOLTIP"));
        this.setupTextField(this.jTextFieldDateBins, dataProfileSettingsType.getDateBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_DATE_BINS_TOOLTIP"));
        this.setupTextField(this.jTextFieldcatBins, dataProfileSettingsType.getCategoricalBins(), ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_SETTINGS_GROUP_CAT_BINS_TOOLTIP"));
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        this.jTextFieldNunBins.setEnabled(bl);
        this.jTextFieldDateBins.setEnabled(bl);
        this.jTextFieldcatBins.setEnabled(bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowTransformNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowTransformNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof TransformationNodeType)) {
            return;
        }
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        this.setNumber(this.jTextFieldNunBins, dataProfileSettingsType.getNumericalBins());
        this.setNumber(this.jTextFieldDateBins, dataProfileSettingsType.getDateBins());
        this.setNumber(this.jTextFieldcatBins, dataProfileSettingsType.getCategoricalBins());
        this.setWritableControls();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!(focusEvent.getSource() instanceof JTextField)) {
            return;
        }
        NodeType nodeType = this._targetNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        DataProfileSettingsType dataProfileSettingsType = transformationNodeType.getDataProfileSettings();
        DataProfileSettingsType dataProfileSettingsType2 = new DataProfileSettingsType();
        JTextField jTextField = (JTextField)focusEvent.getSource();
        Number number = this.getNumber(jTextField);
        if (number == null) {
            String string = ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_SETTINGS_ERROR_NULL_VALUE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_SETTINGS_ERROR_TITLE"), null);
            return;
        }
        int n = number.intValue();
        int n2 = dataProfileSettingsType.getNumericalBins();
        int n3 = dataProfileSettingsType.getCategoricalBins();
        int n4 = dataProfileSettingsType.getDateBins();
        if (jTextField.equals(this.jTextFieldNunBins)) {
            if (n == n2) {
                return;
            }
            n2 = n;
        } else if (jTextField.equals(this.jTextFieldDateBins)) {
            if (n == n4) {
                return;
            }
            n4 = n;
        } else if (jTextField.equals(this.jTextFieldcatBins)) {
            if (n == n3) {
                return;
            }
            n3 = n;
        }
        dataProfileSettingsType2.setNumericalBins(n2);
        dataProfileSettingsType2.setCategoricalBins(n3);
        dataProfileSettingsType2.setDateBins(n4);
        this.updateProfileSettings(dataProfileSettingsType2, dataProfileSettingsType, TransformationNode.DATAPROFILE_SETTINGS);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    private void updateProfileSettings(Object object, Object object2, String string) {
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        if (this._model instanceof WorkflowTransformNodePropertyProxyModel) {
            WorkflowTransformNodePropertyProxyModel workflowTransformNodePropertyProxyModel = (WorkflowTransformNodePropertyProxyModel)this._model;
            workflowTransformNodePropertyProxyModel.setValueAt(string, this._targetNode, complexProperty, TransformNodePropertyModel.RowIndex.DATAPROFILE_SETTINGS);
        }
    }

    private void setupTextField(JTextField jTextField, int n, String string) {
        this.setDataType(jTextField, Integer.class);
        this.setSigned(jTextField, false);
        this.setLocale(jTextField, Locale.getDefault());
        this.setNumber(jTextField, n);
        jTextField.setToolTipText(string);
        jTextField.addFocusListener(this);
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        ((NumberTextField)jTextField).setLocale(locale);
    }

    private Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }
}

