/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.table.CreateTableNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.table.WorkflowCreateTableNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.status.Issue;

public class CreateTableNodeSpecGroupPIComponentPanel
extends PIComponentPanel
implements ActionListener {
    private AbstractDataNode _targetNode;
    private ButtonGroup buttonGroup1;
    private JLabel jLabelName;
    private JLabel jLabelType;
    private JRadioButton jRadioButtonTable;
    private JRadioButton jRadioButtonView;
    private JTextField jTextFieldName;

    public CreateTableNodeSpecGroupPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jRadioButtonTable = new JRadioButton();
        this.jRadioButtonView = new JRadioButton();
        this.jLabelType = new JLabel();
        this.jLabelName.setText("Name:");
        this.jRadioButtonTable.setText("Table");
        this.jRadioButtonView.setText("View");
        this.jLabelType.setText("Type:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelType, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelName, GroupLayout.Alignment.TRAILING, -1, 39, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioButtonTable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonView)).addComponent(this.jTextFieldName, -2, 185, -2)).addContainerGap(136, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jRadioButtonTable, this.jRadioButtonView);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName, -2, 14, -2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelType).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonTable).addComponent(this.jRadioButtonView))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jLabelName.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        this.jLabelType.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TYPE"));
        this.jRadioButtonTable.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE"));
        this.jRadioButtonView.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_VIEW"));
        this.jRadioButtonTable.setOpaque(false);
        this.jRadioButtonView.setOpaque(false);
        this.buttonGroup1.add(this.jRadioButtonTable);
        this.buttonGroup1.add(this.jRadioButtonView);
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowCreateTableNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof CreateTableNodeType)) {
            return;
        }
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)nodeType;
        boolean bl = createTableNodeType.isTable();
        this.jRadioButtonTable.setSelected(bl);
        this.jRadioButtonView.setSelected(!bl);
        String string = createTableNodeType.getTableName();
        this.jTextFieldName.setDocument(new TextFieldLimit(32));
        TableNameInputVerifier tableNameInputVerifier = new TableNameInputVerifier(this.jTextFieldName, this.getContext((PropertyModel)this._model));
        this.jTextFieldName.setInputVerifier(tableNameInputVerifier);
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        this.setControlsWritable();
        this.jRadioButtonTable.addActionListener(this);
        this.jRadioButtonView.addActionListener(this);
        CustomTableNameValidator customTableNameValidator = new CustomTableNameValidator(tableNameInputVerifier);
        this.jTextFieldName.addFocusListener(customTableNameValidator);
        this.jTextFieldName.addKeyListener(customTableNameValidator);
        this.validateTableName(string);
    }

    private void setControlsWritable() {
        boolean bl = this.isWritable();
        this.jRadioButtonTable.setEnabled(bl);
        this.jRadioButtonView.setEnabled(bl);
        this.jTextFieldName.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableName(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        CreateTableNode createTableNode = (CreateTableNode)this.getTargetNode((PropertyModel)this._model, CreateTableNodeType.class);
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
        String string2 = createTableNodeType.getTableName();
        if (string2 != null && string2.trim().length() > 0 && string2.equals(StringUtils.trimDoubleQuotes(string))) {
            return;
        }
        string = StringUtils.trimDoubleQuotes(string);
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ComplexProperty complexProperty = new ComplexProperty("tableName", string);
        CommandProcessor.getInstance().beginTrans(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME_TXN"));
        try {
            this._model.setValueAt(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME"), createTableNode, complexProperty, CreateTableNodePropertyModel.RowIndex.TABLE_NAME);
            workflowNodeInspectorElement.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        ComplexProperty complexProperty = null;
        String string = null;
        if (actionEvent.getSource().equals(this.jRadioButtonTable)) {
            bl = this.jRadioButtonTable.isSelected();
            complexProperty = new ComplexProperty("isTable", bl);
            string = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE");
        } else if (actionEvent.getSource().equals(this.jRadioButtonView)) {
            bl = this.jRadioButtonTable.isSelected();
            complexProperty = new ComplexProperty("isTable", bl);
            string = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_VIEW");
        }
        if (complexProperty != null) {
            List list;
            CreateTableNodeType createTableNodeType;
            DBAttributes dBAttributes;
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(CreateTableNodePropertyModel.RowIndex.IS_TABLE), null, complexProperty, null, null));
            CreateTableNode createTableNode = (CreateTableNode)this.getTargetNode((PropertyModel)this._model, CreateTableNodeType.class);
            if (complexProperty.getData() != null && complexProperty.getData() instanceof Boolean && !((Boolean)complexProperty.getData()).booleanValue() && (dBAttributes = (createTableNodeType = (CreateTableNodeType)createTableNode.getData()).getDBAttributes()) != null && (list = dBAttributes.getDBAttribute()) != null && !list.isEmpty()) {
                Object object;
                DBAttributes dBAttributes2 = new DBAttributes();
                List list2 = dBAttributes2.getDBAttribute();
                DBAttributes dBAttributes3 = new DBAttributes();
                List list3 = dBAttributes3.getDBAttribute();
                for (int i = 0; i < list.size(); ++i) {
                    object = new DBColumnType();
                    object.setAlias(((DBColumnType)list.get(i)).getAlias());
                    object.setAnnotation(((DBColumnType)list.get(i)).getAnnotation());
                    object.setDataType(((DBColumnType)list.get(i)).getDataType());
                    object.setName(((DBColumnType)list.get(i)).getName());
                    object.setStatus(((DBColumnType)list.get(i)).getStatus());
                    object.setKey("No");
                    object.setIndex("No");
                    list2.add(object);
                    DBColumnType dBColumnType = new DBColumnType();
                    dBColumnType.setAlias(((DBColumnType)list.get(i)).getAlias());
                    dBColumnType.setAnnotation(((DBColumnType)list.get(i)).getAnnotation());
                    dBColumnType.setDataType(((DBColumnType)list.get(i)).getDataType());
                    dBColumnType.setName(((DBColumnType)list.get(i)).getName());
                    dBColumnType.setStatus(((DBColumnType)list.get(i)).getStatus());
                    dBColumnType.setKey(((DBColumnType)list.get(i)).getKey());
                    dBColumnType.setIndex(((DBColumnType)list.get(i)).getIndex());
                    list3.add(dBColumnType);
                }
                ComplexProperty complexProperty2 = new ComplexProperty(CreateTableNode.INPUT_COLUMNS, dBAttributes2);
                complexProperty2.setOldData(dBAttributes3);
                arrayList.add(new Property(String.valueOf(CreateTableNodePropertyModel.RowIndex.INPUT_COLUMNS), null, complexProperty2, null, null));
                object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                ((ComplexProperty)object).setOldData(createTableNode.getSQLExpression());
                arrayList.add(new Property(String.valueOf(CreateTableNodePropertyModel.RowIndex.SQL_EXPRESSION), null, object, null, null));
            }
            this._model.setValueAt(string, createTableNode, arrayList);
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowCreateTableNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowCreateTableNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof CreateTableNodeType)) {
            return;
        }
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)nodeType;
        boolean bl = createTableNodeType.isTable();
        this.jRadioButtonTable.setSelected(bl);
        this.jRadioButtonView.setSelected(!bl);
        String string = createTableNodeType.getTableName();
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        this.validateTableName(string);
        this.setControlsWritable();
    }

    private void validateTableName(String string) {
        String string2 = null;
        if ((string = StringUtils.trimDoubleQuotes(string)).length() > 30) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR");
        } else if (!StringUtils.isDoubleQuotedString(string) && !StringUtils.containsNoDot(string)) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_TABLE_NAME_ERROR");
        }
        if (string2 != null) {
            List<Issue> list = this.openIssue(string2);
            this.addWarningBorderAndTooltip(this.jTextFieldName, list);
        } else {
            this.restoreBorder(this.jTextFieldName);
        }
    }

    private boolean isDuplicateName(String string) {
        boolean bl = false;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    class TableNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public TableNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                CreateTableNode createTableNode = (CreateTableNode)CreateTableNodeSpecGroupPIComponentPanel.this.getTargetNode((PropertyModel)CreateTableNodeSpecGroupPIComponentPanel.this._model, CreateTableNodeType.class);
                CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
                this._currentValue = createTableNodeType.getTableName();
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (StringUtils.isDoubleQuotedString(string)) {
                    this._currentValue = StringUtils.addDoubleQuotes(this._currentValue);
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0) {
                        if (bl && CreateTableNodeSpecGroupPIComponentPanel.this.isDuplicateName(StringUtils.trimDoubleQuotes(string))) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NOT_UNIQUE_MSG"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), null);
                            bl = false;
                        }
                        if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                            bl = false;
                        }
                        if (bl && !TableNameValidator.isTableNameUnique(this._context, string)) {
                            String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_DUPLICATE"), string);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null);
                            bl = false;
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableNameInputVerifier.this._textField.setText(TableNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    CreateTableNodeSpecGroupPIComponentPanel.this.setTableName(string);
                }
            }
            return bl;
        }
    }

    class CustomTableNameValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        TableNameInputVerifier _verifier;

        public CustomTableNameValidator(TableNameInputVerifier tableNameInputVerifier) {
            this._verifier = tableNameInputVerifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(CreateTableNodeSpecGroupPIComponentPanel.this.jTextFieldName);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }
}

