/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class DataProfileNodeProfileGroupPIComponentPanel
extends PIComponentPanel {
    private static final int COLUMN_COUNT = 2;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private String[] _columnNames = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")};
    private GenericTable _jAttributesTable = new GenericTableTooltip();
    private Vector<AttributeType> _profiledAttributes = new Vector();
    private Vector<AttributeType> _allAttributes = new Vector();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private List<String> _allowedAttributes = new ArrayList<String>();
    private JButton _editBtn;
    private JButton _removeBtn;
    private SearchField _searchField;
    private Component _findPane;
    private static Icon _editIcon;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    public static final int FILTER_ATTRIBUTE_NAME = 0;
    public static final int FILTER_ATTRIBUTE_TYPE = 1;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"));
    private static String _defaultGroupByValue;
    private AbstractDataNode _targetNode;
    private ComponentWithTitlebar jAttributesComponent;
    private JCheckBox jChkBoxAuto;
    private JComboBox jComboBoxGroupby;
    private JLabel jLabelGroupby;

    public DataProfileNodeProfileGroupPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelGroupby = new JLabel();
        this.jComboBoxGroupby = new JComboBox();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jChkBoxAuto = new JCheckBox();
        this.jLabelGroupby.setText("Group  By:");
        this.jComboBoxGroupby.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jAttributesComponent.setMinimumSize(new Dimension(500, 1000));
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkBoxAuto, -2, 289, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelGroupby, -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxGroupby, 0, 268, Short.MAX_VALUE))).addContainerGap(63, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -2, 447, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGroupby).addComponent(this.jComboBoxGroupby, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jChkBoxAuto).addContainerGap(348, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(80, 80, 80).addComponent((Component)this.jAttributesComponent, -2, 333, Short.MAX_VALUE).addContainerGap())));
    }

    public void initRes() {
        this.jLabelGroupby.setText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_GROUP_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        if (_editIcon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        DataProfileInputType dataProfileInputType;
        Object object3;
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof DataProfileNodeType)) {
            return;
        }
        List<AttributeType> list = this.getDatasourceAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            object3 = list.iterator();
            while (object3.hasNext()) {
                dataProfileInputType = (AttributeType)object3.next();
                this._allAttributesMap.put(dataProfileInputType.getName(), (AttributeType)dataProfileInputType);
                try {
                    if (DatabaseMetadataUtils.isACustomDataType(this.getContext((PropertyModel)this._model), dataProfileInputType.getDataType())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    return;
                }
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileInputType.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileInputType.getName());
            }
        }
        if ((object2 = (dataProfileInputType = (object3 = (DataProfileNodeType)nodeType).getDataProfileInput()).getAttributes()) != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new Vector<String>(this._allowedAttributes));
        defaultComboBoxModel.addElement(_defaultGroupByValue);
        String string = _defaultGroupByValue;
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != attributeType && (string = attributeType.getName()) != null && -1 == this._allowedAttributes.indexOf(string)) {
            defaultComboBoxModel.addElement(string);
        }
        this.jComboBoxGroupby.setModel(defaultComboBoxModel);
        this.jComboBoxGroupby.setSelectedItem(string);
        if (attributeType != null) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLabelGroupby.setIcon(_invalid_attribue_icon);
            } else {
                this.jLabelGroupby.setIcon(null);
            }
        } else {
            this.jLabelGroupby.setIcon(null);
        }
        this.jComboBoxGroupby.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                String string = (String)object;
                NodeType nodeType = DataProfileNodeProfileGroupPIComponentPanel.this._targetNode.getData();
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
                DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
                DataProfileInputType dataProfileInputType2 = new DataProfileInputType();
                dataProfileInputType2.setGroupByAttribute((AttributeType)DataProfileNodeProfileGroupPIComponentPanel.this._allAttributesMap.get(string));
                Attributes attributes = new Attributes();
                attributes.getAttribute().addAll(dataProfileInputType.getAttributes().getAttribute());
                dataProfileInputType2.setAttributes(attributes);
                DataProfileNodeProfileGroupPIComponentPanel.this.updateProfile(dataProfileInputType2, dataProfileInputType, DataProfileNode.DATAPROFILE_INPUT);
            }
        });
        AttributesTableModel attributesTableModel = new AttributesTableModel(this._profiledAttributes);
        this.setupItemsTable(attributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)this._jAttributesTable);
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        boolean bl = 0 == object3.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.isSelected();
                if (bl && !MessageDialog.confirm((Component)DataProfileNodeProfileGroupPIComponentPanel.this, (Object)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED"), (String)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED_CONFIRM"), null)) {
                    DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.setSelected(false);
                    return;
                }
                DataProfileNodeProfileGroupPIComponentPanel.this._editBtn.setEnabled(!bl);
                DataProfileNodeProfileGroupPIComponentPanel.this._removeBtn.setEnabled(!bl);
                DataProfileNodeProfileGroupPIComponentPanel.this.updateAutoSpec("autoSpec", bl);
            }
        });
        this.setWritableControls();
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        AttributesTableModel attributesTableModel;
        if (!(propertyModel instanceof WorkflowDataProfileNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (nArray != null && nArray.length > 0) {
            attributesTableModel = (AttributesTableModel)((Object)this._jAttributesTable.getModel());
            for (int n : nArray) {
                object = attributesTableModel.getDataVector().get(n);
                arrayList.add(object.getName());
            }
        }
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        attributesTableModel = this._targetNode.getData();
        this._allAttributes.clear();
        this._allAttributesMap.clear();
        this._allowedAttributes.clear();
        Object object2 = this.getDatasourceAttributes();
        if (object2 != null) {
            this._allAttributes.addAll((Collection<AttributeType>)object2);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                AttributeType attributeType = (AttributeType)iterator.next();
                this._allAttributesMap.put(attributeType.getName(), attributeType);
                try {
                    if (DatabaseMetadataUtils.isACustomDataType(this.getContext((PropertyModel)this._model), attributeType.getDataType())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    return;
                }
                String string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
                if (!string.equals("Numerical") && !string.equals("Categorical")) continue;
                this._allowedAttributes.add(attributeType.getName());
            }
        }
        this._profiledAttributes.clear();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)attributesTableModel;
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        Attributes attributes = dataProfileInputType.getAttributes();
        if (attributes != null && (object = attributes.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new Vector<String>(this._allowedAttributes));
        defaultComboBoxModel.addElement(_defaultGroupByValue);
        String string = _defaultGroupByValue;
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != dataProfileInputType && null != attributeType && (string = attributeType.getName()) != null && -1 == this._allowedAttributes.indexOf(string)) {
            defaultComboBoxModel.addElement(string);
        }
        this.jComboBoxGroupby.setModel(defaultComboBoxModel);
        this.jComboBoxGroupby.setSelectedItem(string);
        if (attributeType != null) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLabelGroupby.setIcon(_invalid_attribue_icon);
            } else {
                this.jLabelGroupby.setIcon(null);
            }
        } else {
            this.jLabelGroupby.setIcon(null);
        }
        AttributesTableModel attributesTableModel2 = null;
        try {
            attributesTableModel2 = this.getFilteredAttributesTableModel(this._profiledAttributes, this._searchField.getText(), this._currentSearchCategory);
        }
        catch (Exception exception) {
            attributesTableModel2 = new AttributesTableModel(this._profiledAttributes);
        }
        this.setupItemsTable(attributesTableModel2);
        boolean bl = 0 == dataProfileNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        if (!arrayList.isEmpty()) {
            nArray = new int[arrayList.size()];
            int n = 0;
            int n2 = -1;
            for (AttributeType attributeType2 : attributesTableModel2.getDataVector()) {
                ++n2;
                int n3 = arrayList.indexOf(attributeType2.getName());
                if (-1 == n3) continue;
                nArray[n++] = n2;
            }
            this._jAttributesTable.setSelectedRowsInModel(nArray);
        }
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        this.jChkBoxAuto.setEnabled(bl);
        this.jComboBoxGroupby.setEnabled(bl);
        if (!bl) {
            this._removeBtn.setEnabled(false);
            this._editBtn.setEnabled(false);
        }
        ((AttributesTableModel)((Object)this._jAttributesTable.getModel())).setWritable(bl);
    }

    private void setupItemsTable(AttributesTableModel attributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)attributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl;
                    Context context = DataProfileNodeProfileGroupPIComponentPanel.this.getContext((PropertyModel)DataProfileNodeProfileGroupPIComponentPanel.this._model);
                    DataProfileAttributesDialog dataProfileAttributesDialog = new DataProfileAttributesDialog();
                    AbstractNode abstractNode = DataProfileNodeProfileGroupPIComponentPanel.this._targetNode.findParentNode();
                    if (abstractNode != null && abstractNode instanceof AbstractDataNode && (bl = dataProfileAttributesDialog.invoke(context, (DataProfileNode)DataProfileNodeProfileGroupPIComponentPanel.this._targetNode, (AbstractDataNode)abstractNode))) {
                        DataProfileNodeProfileGroupPIComponentPanel.this.updateWorkFlow();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeType nodeType = DataProfileNodeProfileGroupPIComponentPanel.this._targetNode.getData();
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
                DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
                int[] nArray = DataProfileNodeProfileGroupPIComponentPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    AttributeType attributeType;
                    AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)DataProfileNodeProfileGroupPIComponentPanel.this._jAttributesTable.getModel());
                    HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        attributeType = attributesTableModel.getDataVector().get(nArray[i]);
                        hashMap.put(attributeType.getName(), attributeType);
                    }
                    DataProfileInputType dataProfileInputType2 = new DataProfileInputType();
                    attributeType = new Attributes();
                    List list = attributeType.getAttribute();
                    for (AttributeType attributeType2 : DataProfileNodeProfileGroupPIComponentPanel.this._profiledAttributes) {
                        if (null != hashMap.get(attributeType2.getName())) continue;
                        list.add(attributeType2);
                    }
                    dataProfileInputType2.setAttributes((Attributes)attributeType);
                    dataProfileInputType2.setGroupByAttribute(dataProfileInputType.getGroupByAttribute());
                    DataProfileNodeProfileGroupPIComponentPanel.this.updateProfile(dataProfileInputType2, dataProfileInputType, DataProfileNode.DATAPROFILE_INPUT);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        ListSelectionModel listSelectionModel = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !this.jChkBoxAuto.isSelected());
        this._removeBtn.setToolTipText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_COLUMNS_REMOVE_TOOLTIP"));
        this._findPane = this.createFindPane();
        controlBar.addSeparator();
        controlBar.add(this._findPane);
    }

    private void updateProfile(Object object, Object object2, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.DATAPROFILE_INPUT), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    private void updateProfileAndSpec(Object object, Object object2, String string, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        ComplexProperty complexProperty2 = new ComplexProperty("autoSpec", bl ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.AUTO_SPEC), null, complexProperty2, null, null));
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.DATAPROFILE_INPUT), null, complexProperty, null, null));
        ComplexProperty complexProperty3 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty3.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty3, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    private void updateAutoSpec(String string, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty("autoSpec", bl ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.AUTO_SPEC), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.RowIndex.SQL_EXPRESSION), null, complexProperty2, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                DataProfileNodeProfileGroupPIComponentPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                DataProfileNodeProfileGroupPIComponentPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                DataProfileNodeProfileGroupPIComponentPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                DataProfileNodeProfileGroupPIComponentPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private void processFilter(String string) {
        try {
            AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)this._jAttributesTable.getModel());
            if (attributesTableModel != null) {
                AttributesTableModel attributesTableModel2 = this.getFilteredAttributesTableModel(this._profiledAttributes, string, this._currentSearchCategory);
                this.setupItemsTable(attributesTableModel2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_TITLE"), (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_MESSAGE"), null);
        }
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
    }

    public AttributesTableModel getFilteredAttributesTableModel(Vector<AttributeType> vector, String string, int n) throws Exception {
        Vector<AttributeType> vector2 = new Vector<AttributeType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = vector.iterator();
        AttributeType attributeType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (object.hasNext()) {
            attributeType = object.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = attributeType.getName();
                        break;
                    }
                    case 1: {
                        string2 = attributeType.getDataType();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector2.add(attributeType);
        }
        object = new AttributesTableModel(vector2);
        ((AttributesTableModel)((Object)object)).setWritable(this.isWritable());
        return object;
    }

    protected List<AttributeType> getDatasourceAttributes() {
        List list = null;
        Attributes attributes = null;
        AbstractDataNode abstractDataNode = this.getNode((PropertyModel)this._model);
        if (abstractDataNode != null) {
            if (abstractDataNode instanceof DataProfileNode) {
                attributes = ((DataProfileNode)abstractDataNode).getSourceAttributes();
            } else {
                AbstractNode abstractNode = abstractDataNode.findParentNode();
                if (abstractNode instanceof DataProvider) {
                    attributes = ((DataProvider)((Object)abstractNode)).getAttributes();
                }
            }
        }
        if (attributes != null) {
            list = attributes.getAttribute();
        }
        return list;
    }

    private AbstractDataNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof AbstractDataNode)) {
            return null;
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)node;
        return abstractDataNode;
    }

    static {
        _defaultGroupByValue = ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_GROUP_GROUP_BY_DEFAULT");
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            for (AttributeType attributeType : DataProfileNodeProfileGroupPIComponentPanel.this._profiledAttributes) {
                if (!attributeType.getName().equals(object.toString()) || 0 != attributeType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl3 = true;
                break;
            }
            this.setIcon(bl3 ? _valid_attribue_icon : _invalid_attribue_icon);
            return component;
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            DataProfileNodeProfileGroupPIComponentPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.isSelected());
        }
    }

    class AttributesTableModel
    extends GenericBaseTableModel {
        private Vector<AttributeType> _srcData;
        private boolean _writable = true;

        AttributesTableModel(Vector<AttributeType> vector) {
            this._srcData = new Vector(vector.size());
            this._srcData.addAll(vector);
            this.setColumnIdentifiers(DataProfileNodeProfileGroupPIComponentPanel.this._columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector<AttributeType> getDataVector() {
            return this._srcData;
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string != null ? string : "";
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<AttributeType> vector = new Vector<AttributeType>();
            AttributeType attributeType = null;
            for (int i = 0; i < nArray.length; ++i) {
                attributeType = this._srcData.elementAt(nArray[i]);
                vector.add(attributeType);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

