/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.anomaly;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CommentTextFieldEditor;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.OutputCellRenderer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponent;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.anomaly.AnomalyBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.anomaly.AnomalyBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.anomaly.AnomalyBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.anomaly.WorkflowAnomalyBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.Pair;

public class AnomalyBuildPIComponentBuildPanel
extends GeneralBuildPIPanel
implements AnomalyBuildPIComponentGUI {
    private final int MODEL_NAME = 0;
    private final int OUTPUT = 1;
    private final int BUILD = 2;
    private final int ALGORITHM = 3;
    private final int COMMENT = 4;
    private final int COLUMN_COUNT = 5;
    private static String[] _columnNames = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
    private List<ModelType> _models;
    public static final int FILTER_MODEL_NAME = 0;
    public static final int FILTER_MODEL_ALGORITHM = 1;
    public static final int FILTER_MODEL_BUILD = 2;
    public static final int FILTER_MODEL_TEST = 3;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(_columnNames[0]);
    private static String _NOT_BUILT = BuildEditorLrb.get("BUILD_MODEL_NOT_BUILT");
    private boolean _clearSearchState = true;
    private SearchField _searchField;
    private Component _findPane;
    private static Icon _ready_icon;
    private static Icon _built_icon;
    private static Icon _error_icon;
    private static Icon _invalid_icon;
    private static Icon _viewIconEna;
    private static Icon _viewIconDis;
    private JButton _viewModelBtn;
    private JButton _removeBtn;
    private JButton _addBtn;
    private ComponentWithTitlebar<JComponent> _jComponentModelSettings;

    public AnomalyBuildPIComponentBuildPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return AnomalyBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return AnomalyBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this._jComponentModelSettings = new ComponentWithTitlebar();
        this._jComponentModelSettings.setMinimumSize(new Dimension(500, 500));
        this._jComponentModelSettings.setName("_jComponentModelSettings");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentModelSettings, -1, 509, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentModelSettings, -1, 500, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        Class<PIComponent> clazz = PIComponent.class;
        if (_ready_icon == null) {
            _ready_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_READY_ICON"));
            _built_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
            _error_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_ERROR_ICON"));
            _invalid_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
            Class<WorkflowUtils> clazz2 = WorkflowUtils.class;
            _viewIconEna = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_ENA"));
            _viewIconDis = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_DIS"));
        }
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        ModelsTableModel modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        JScrollPane jScrollPane = new JScrollPane((Component)this._jModelsTable);
        this._jComponentModelSettings.setComponent((JComponent)jScrollPane);
        this._jComponentModelSettings.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        this._jModelsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XMLGregorianCalendar xMLGregorianCalendar;
                    boolean bl = false;
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)AnomalyBuildPIComponentBuildPanel.this._jModelsTable.getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    int[] nArray = AnomalyBuildPIComponentBuildPanel.this._jModelsTable.getSelectedRowsInModel();
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
                    if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                        bl = true;
                    } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                        bl = true;
                    }
                    if (bl) {
                        AnomalyBuildPIComponentBuildPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewModelBtn = new JButton(_viewIconEna);
        this._viewModelBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewModelBtn.setDisabledIcon(_viewIconDis);
        this._viewModelBtn.setEnabled(false);
        this._viewModelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnomalyBuildPIComponentBuildPanel.this.viewModel();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)"Delete selected models and associated results?", (String)"Delete Models", null, (boolean)true)) {
                    return;
                }
                int[] nArray = AnomalyBuildPIComponentBuildPanel.this._jModelsTable.getSelectedRowsInModel();
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)AnomalyBuildPIComponentBuildPanel.this._jModelsTable.getModel());
                ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                for (int i = 0; i < nArray.length; ++i) {
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[i]);
                    arrayList.add(modelType);
                }
                AnomalyBuildPIComponentBuildPanel.this.setValue(arrayList, "modelRemoved", "modelAdded");
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewModelDialog newModelDialog;
                AbstractBuildNode abstractBuildNode = AnomalyBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)AnomalyBuildPIComponentBuildPanel.this._model);
                if (abstractBuildNode instanceof AnomalyDetectionBuildNode && (newModelDialog = new NewModelDialog()).invoke(AnomalyBuildPIComponentBuildPanel.this.getContext((PropertyModel)AnomalyBuildPIComponentBuildPanel.this._model), abstractBuildNode)) {
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    ModelType modelType = newModelDialog.getNewModel();
                    arrayList.add(modelType);
                    AnomalyBuildPIComponentBuildPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
            }
        });
        this._addBtn.setEnabled(this.isWritable());
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        controlBar.add((Component)this._duplicateBtn);
        controlBar.add((Component)this._viewModelBtn);
        controlBar.addSeparator();
        controlBar.add(this._findPane);
        this._jComponentModelSettings.setControlBar(controlBar);
        this._jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AnomalyBuildPIComponentBuildPanel.this.handleModelSelectionChanged();
            }
        });
        this._jModelsTable.setFillsViewportHeight(true);
    }

    public void reloadUI(PropertyModel propertyModel) {
        ModelType modelType;
        ModelsTableModel modelsTableModel;
        this._model = (WorkflowAnomalyBuildNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        int[] nArray = this._jModelsTable.getSelectedRowsInModel();
        ArrayList<ModelType> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            arrayList = new ArrayList<ModelType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                modelType = modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add(modelType);
            }
        }
        modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        if (arrayList != null) {
            Object object;
            Vector<Integer> vector = new Vector<Integer>();
            modelType = modelsTableModel.getDataVector();
            for (int i = 0; i < modelType.size(); ++i) {
                object = (ModelType)modelType.get(i);
                if (!arrayList.contains(object)) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (ModelType)integerArray[i];
                }
                this._jModelsTable.setSelectedRowsInModel((int[])object);
            }
        }
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this._jModelsTable.setModel((TableModel)((Object)modelsTableModel));
        this._jModelsTable.setSorted(true);
        this._jModelsTable.setUpdateSelectionOnSort(true);
        this._jModelsTable.getTableHeader().setReorderingAllowed(false);
        this._jModelsTable.sizeTableToContents();
        this._jModelsTable.setAutoResizeMode(4);
        if (modelsTableModel.getRowCount() == 0) {
            return;
        }
        TableColumn tableColumn = this._jModelsTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new CustomCellRendererModel());
        TableColumn tableColumn2 = this._jModelsTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new OutputCellEditor());
        tableColumn2.setCellRenderer(new OutputCellRenderer());
        TableColumn tableColumn3 = this._jModelsTable.getColumnModel().getColumn(4);
        tableColumn3.setCellEditor(new CommentTextFieldEditor(this.getContext((PropertyModel)this._model)));
        tableColumn3.setMaxWidth(200);
        TableColumn tableColumn4 = this._jModelsTable.getColumnModel().getColumn(0);
        tableColumn4.setMinWidth(100);
        tableColumn4.setCellEditor(new ModelNameCellEditor(this.getContext((PropertyModel)this._model), this.getWorkflowModel(), (BuildNodeType)this.getTargetNode((PropertyModel)this._model).getData()));
    }

    @Override
    protected ModelType getModelType(int n) {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(this._jModelsTable.convertRowIndexToModel(n));
        return modelType;
    }

    @Override
    public boolean isWritable() {
        return AnomalyBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    private void setEnabled(AbstractButton[] abstractButtonArray, boolean[] blArray) {
        boolean bl = this.isWritable();
        AbstractButtonState abstractButtonState = new AbstractButtonState(abstractButtonArray, blArray);
        abstractButtonState.setState(bl);
    }

    private void setValue(ModelType modelType, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (object != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), (String)object);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(AnomalyBuildNodePropertyModel.RowIndex.MODEL_ANNOTATION), null, new ComplexProperty("modelAnnotation", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(List<Pair<String, Boolean>> list) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(AnomalyBuildNodePropertyModel.RowIndex.MODEL_USEFOROUTPUT), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    @Override
    protected void setValue(List<ModelType> list, String string, String string2) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADDED_REMOVED"), this.getTargetNode((PropertyModel)this._model), new ComplexProperty(string, string2, list), AnomalyBuildNodePropertyModel.RowIndex.MODEL_ADDED_REMOVED);
            this.updateWorkFlow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnomalyBuildPIComponentBuildPanel.this.resetModelSettingsTable((PropertyModel)AnomalyBuildPIComponentBuildPanel.this._model);
                }
            });
        }
    }

    protected void updateWorkFlow() {
        this.updateWorkFlowInternal();
    }

    @Override
    public void updateCell(int n, int n2) {
        GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)this._jModelsTable.getModel();
        genericBaseTableModel.fireTableCellUpdated(n, n2);
    }

    @Override
    protected int getModelNameIdFromPropertyModel() {
        return AnomalyBuildNodePropertyModel.RowIndex.MODEL_NAME;
    }

    @Override
    protected int getModelsRerunIdFromPropertyModel() {
        return AnomalyBuildNodePropertyModel.RowIndex.MODELS_RERUN;
    }

    @Override
    protected int getTestsRerunIdFromPropertyModel() {
        return -1;
    }

    private void handleModelSelectionChanged() {
        Object[] objectArray;
        AbstractButton[] abstractButtonArray;
        boolean bl;
        boolean bl2 = false;
        int n = this._jModelsTable.getSelectedRowCount();
        boolean bl3 = bl = n == 1;
        if (n > 0) {
            XMLGregorianCalendar xMLGregorianCalendar;
            abstractButtonArray = (AbstractButton[])this._jModelsTable.getModel();
            objectArray = this._jModelsTable.getSelectedRowsInModel();
            if (objectArray.length == 0) {
                return;
            }
            ModelType modelType = abstractButtonArray.getDataVector().get(objectArray[0]);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                bl2 = true;
            } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                bl2 = true;
            }
        }
        this._viewModelBtn.setEnabled(bl2 && bl);
        abstractButtonArray = new AbstractButton[]{this._removeBtn, this._addBtn, this._duplicateBtn};
        objectArray = new boolean[]{n > 0, n != -1, true};
        this.setEnabled(abstractButtonArray, (boolean[])objectArray);
    }

    private void viewModel() {
        int[] nArray = this._jModelsTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
        Context context = this.getContext((PropertyModel)this._model);
        String string = modelType.getName();
        String string2 = this.getTargetNode((PropertyModel)this._model).getData().getName();
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
        EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
    }

    public ModelsTableModel getFilteredAttributesTableModel(List<ModelType> list, String string, int n) throws Exception {
        Vector<ModelType> vector = new Vector<ModelType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = list.iterator();
        ModelType modelType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (object.hasNext()) {
            modelType = object.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = modelType.getName();
                        break;
                    }
                    case 1: {
                        string2 = MetaDataHelper.getAlgorithmName(modelType);
                        break;
                    }
                    case 2: {
                        XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                        if (xMLGregorianCalendar != null) break;
                        string2 = _NOT_BUILT;
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(modelType);
        }
        object = new ModelsTableModel(vector);
        ((ModelsTableModel)object).setWritable(this.isWritable());
        return object;
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.reloadUI(propertyModel);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                AnomalyBuildPIComponentBuildPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                AnomalyBuildPIComponentBuildPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                AnomalyBuildPIComponentBuildPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                AnomalyBuildPIComponentBuildPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(_columnNames[3]));
        this._searchField.addCategory(new SearchCategory(_columnNames[2]));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private void processFilter(String string) {
        try {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            if (modelsTableModel != null) {
                ModelsTableModel modelsTableModel2 = this.getFilteredAttributesTableModel(this._models, string, this._currentSearchCategory);
                this.setupModelsTable(modelsTableModel2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_TITLE"), (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_FAILURE_MESSAGE"), null);
        }
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(_columnNames[0])) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(_columnNames[3])) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(_columnNames[2])) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
    }

    private class AbstractButtonState {
        AbstractButton[] btns;
        boolean[] bstates;

        AbstractButtonState(AbstractButton[] abstractButtonArray, boolean[] blArray) {
            assert (abstractButtonArray.length == blArray.length);
            this.btns = abstractButtonArray;
            this.bstates = blArray;
        }

        void setState(boolean bl) {
            for (int i = 0; i < this.btns.length; ++i) {
                this.btns[i].setEnabled(bl && this.bstates[i]);
            }
        }
    }

    class NewModelDialog {
        protected JEWTDialog _dlg;
        protected String wizName = "addModel";
        private ModelType newModel;

        public ModelType getNewModel() {
            return this.newModel;
        }

        protected JEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode) {
            NewModelPanel newModelPanel = new NewModelPanel(context, abstractBuildNode, AnomalyBuildPIComponentBuildPanel.this.getInMemoryModelNames(abstractBuildNode));
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)newModelPanel);
            jEWTDialog.setTitle(BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE"));
            return jEWTDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke(Context context, AbstractBuildNode abstractBuildNode) {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog(context, abstractBuildNode);
                jEWTDialog.setResizable(true);
                final NewModelPanel newModelPanel = (NewModelPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                            if (!newModelPanel.doWork()) {
                                throw new PropertyVetoException("panel", propertyChangeEvent);
                            }
                            NewModelDialog.this.newModel = newModelPanel.getNewModel();
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }

    private class CustomCellRendererModel
    extends DefaultTableCellRenderer {
        private CustomCellRendererModel() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)AnomalyBuildPIComponentBuildPanel.this._jModelsTable.getModel());
            int n3 = AnomalyBuildPIComponentBuildPanel.this._jModelsTable.convertRowIndexToModel(n);
            ModelType modelType = modelsTableModel.getDataVector().get(n3);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                this.setIcon(_built_icon);
            } else if (modelType.getStatus() == ModelStatusType.READY) {
                this.setIcon(_ready_icon);
            } else if (modelType.getStatus() == ModelStatusType.FAILURE) {
                this.setIcon(_error_icon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private Vector<ModelType> _srcData;
        private Map<String, ModelType> _srcMap;
        private boolean _writable = true;

        public ModelsTableModel(List<ModelType> list) {
            this._srcData = new Vector(list.size());
            this._srcData.addAll(list);
            this._srcMap = new HashMap<String, ModelType>();
            for (ModelType modelType : list) {
                this._srcMap.put(modelType.getName(), modelType);
            }
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(5);
        }

        public Comparator getColumnSortComparator(int n) {
            if (n == 2) {
                return new ModelsTableDateComparator();
            }
            return super.getColumnSortComparator(n);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector<ModelType> getDataVector() {
            return this._srcData;
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this._srcData.get(n);
            string = modelType.getName();
            return string;
        }

        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Pair<String, Boolean> getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ModelType modelType = this._srcData.get(n);
            Pair pair = new Pair((Object)modelType.getName(), (Object)modelType.isUseForOutput());
            return pair;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return null;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = modelType.getName();
                    break;
                }
                case 3: {
                    object = MetaDataHelper.getAlgorithmName(modelType);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = _NOT_BUILT;
                    break;
                }
                case 4: {
                    String string = modelType.getAnnotation();
                    object = string != null ? string : "";
                    break;
                }
                case 1: {
                    if (modelType.isUseForOutput()) {
                        object = Boolean.TRUE;
                        break;
                    }
                    object = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4 || n2 == 0 || n2 == 1) {
                return this._writable;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 4) {
                ModelType modelType = this._srcData.get(n);
                AnomalyBuildPIComponentBuildPanel.this.setValue(modelType, object);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 0) {
                if (object instanceof String) {
                    AnomalyBuildPIComponentBuildPanel.this.renameModel(this._srcData, object, n, n2);
                }
            } else if (n2 == 1) {
                ModelType modelType = this._srcData.get(n);
                Boolean bl = (Boolean)object;
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                arrayList.add(new Pair((Object)modelType.getId(), (Object)bl));
                AnomalyBuildPIComponentBuildPanel.this.setValue(arrayList);
            } else {
                return;
            }
        }
    }

    private class ModelsTableDateComparator
    implements Comparator {
        private ModelsTableDateComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Date && object2 instanceof Date && object instanceof Comparable && object2 instanceof Comparable) {
                Date date = (Date)object;
                Date date2 = (Date)object2;
                return date.compareTo(date2);
            }
            return object.toString().compareTo(object2.toString());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ModelsTableDateComparator;
        }
    }
}

