/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Connection;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDocumentInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDocumentPropertyProxyModel;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class WorkflowPIComponentPanel
extends PIComponentPanel {
    private PropertyModel _model;
    private boolean _listenersAdded = false;
    private int MAXIMUM_COMMENT_LENGTH = 4000;
    private PropertyLabel _jCommentLabel;
    private JTextArea _jCommentValue;
    private JScrollPane jScrollPane1;

    public WorkflowPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jCommentLabel = new PropertyLabel();
        this.jScrollPane1 = new JScrollPane();
        this._jCommentValue = new JTextArea();
        this._jCommentLabel.setText("Comment:");
        this._jCommentValue.setColumns(20);
        this._jCommentValue.setRows(5);
        this.jScrollPane1.setViewportView(this._jCommentValue);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jCommentLabel, -2, 90, -2).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 472, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jCommentLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 652, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jCommentLabel, (Component)this._jCommentValue, (String)(PropertyLrb.get("PI_WORKFLOW_COMMENT") + ":"));
        this._jCommentLabel.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_WORKFLOW_COMMENT_ADA"));
        this._jCommentValue.setText("");
        this._jCommentValue.setLineWrap(true);
        this._jCommentValue.setWrapStyleWord(true);
        this._jCommentValue.setDocument(new TextFieldLimit(this.MAXIMUM_COMMENT_LENGTH));
    }

    public void reloadUI(PropertyModel propertyModel) {
        this.initUI(propertyModel);
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = propertyModel;
        WorkflowProcess workflowProcess = this.getWorkflowProcess(propertyModel);
        if (workflowProcess == null) {
            this._jCommentValue.setText("");
            return;
        }
        String string = workflowProcess.getComment();
        if (string != null) {
            this._jCommentValue.setText(string);
            this._jCommentValue.setCaretPosition(this._jCommentValue.getDocument().getLength());
            this._jCommentValue.moveCaretPosition(0);
        } else {
            this._jCommentValue.setText("");
        }
        this._jCommentValue.setEnabled(this.isWritable());
        if (!this._listenersAdded) {
            this._jCommentValue.addFocusListener(new FocusListener(){
                Context _context;
                String origComment;
                {
                    this._context = WorkflowPIComponentPanel.this.getContext(WorkflowPIComponentPanel.this._model);
                    this.origComment = "";
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    this.origComment = WorkflowPIComponentPanel.this._jCommentValue.getText();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = WorkflowPIComponentPanel.this._jCommentValue.getText();
                    boolean bl = true;
                    if (this.origComment.compareTo(string) != 0) {
                        Connection connection = null;
                        try {
                            connection = Connections.getSharedConnection(this._context);
                            if (!Workflow.validateWorkflowComment(connection, string)) {
                                bl = false;
                                WorkflowPIComponentPanel.this._jCommentValue.setText(this.origComment);
                            }
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Workflow Document Edit Error", (String)"Unable to update comment.", null);
                        }
                        if (bl) {
                            CommandProcessor.getInstance().beginTrans("Edit Workflow Comment");
                            try {
                                WorkflowPIComponentPanel.this._model.setValueAt((Object)WorkflowPIComponentPanel.this._jCommentValue.getText().trim(), 0, 0);
                            }
                            catch (Exception exception) {
                                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Workflow Document Edit Error", (String)"Unable to update comment.", null);
                            }
                            finally {
                                CommandProcessor.getInstance().endTrans();
                            }
                        }
                    }
                }
            });
            this._listenersAdded = true;
        }
    }

    protected WorkflowProcess getWorkflowProcess(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowDocumentPropertyProxyModel)) {
            return null;
        }
        WorkflowDocumentPropertyProxyModel workflowDocumentPropertyProxyModel = (WorkflowDocumentPropertyProxyModel)propertyModel;
        Context context = workflowDocumentPropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowDocumentInspectorElement workflowDocumentInspectorElement = (WorkflowDocumentInspectorElement)((Object)elementArray[0].getData());
        return workflowDocumentInspectorElement.getWorkflowProcess();
    }
}

