/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.OutputCellRenderer;
import oracle.dmt.dataminer.controls.TextIcon;
import oracle.dmt.dataminer.mviewer.coefficients.LoadSVMModelViewer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodeDialog;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelTableModel;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesDialog;
import oracle.dmt.dataminer.workflow.inspect.ModelNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowExistingModelNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.Pair;

public class ModelPIComponentPanel
extends PIComponentPanel {
    private WorkflowNodePropertyProxyModel _model;
    private boolean _bLoading = false;
    private SearchField _searchField;
    private Component _findPane;
    private Connection _dbConn;
    private String _ownerName;
    private static Icon _invalid_icon;
    private static Icon _viewIconEna;
    private static Icon _viewIconDis;
    private static Icon _out_icon;
    private static Icon _ignore_icon;
    private static NullIcon _nullIcon;
    private static Icon _refreshIcon;
    private JButton _viewBtn;
    private JButton _removeBtn;
    private JButton _refreshBtn;
    private JButton _addBtn;
    public static final int FILTER_FULL_NAME = 0;
    public static final int FILTER_MODEL_NAME = 1;
    public static final int FILTER_SCHEMA_NAME = 2;
    public static final int FILTER_MODEL_ALGORITHM = 3;
    private static String[] _columnNames;
    private final int MODEL_NAME = 0;
    private final int ALGORITHM = 1;
    private final int OUTPUT = 2;
    private final int COLUMN_COUNT = 3;
    private int _currentSearchCategory = 1;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_NAME"));
    private GenericTable _jModelsTable = new GenericTable();
    private ModelsTableModel _modelsTblModel;
    private TargetValues _targetValues;
    private MiningFunctionType _mft = null;
    private AttributeType _at = null;
    private List<ModelNodeType.Models.Model> _models = null;
    private ModelNodeType.Models _nodeTypeModels = null;
    private ModelNodeType _nodeData = null;
    private MiningFunctions _miningFunction = null;
    private ComponentWithTitlebar<JComponent> _jComponentModels;
    private PropertyLabel _jMiningFunctionLabel;
    private JTextField _jMiningFunctionValue;
    private PropertyLabel _jTargetAttributeLabel;
    private JTextField _jTargetAttributeValue;
    private PropertyLabel _jTargetDataTypeLabel;
    private JTextField _jTargetDataTypeValue;
    private JButton _jTargetValuesButton;

    public ModelPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        assert (propertyModel != null) : "PropertyModel for model node is null.";
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        assert (abstractModelNode != null) : "Model node is null.";
        if (abstractModelNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((ModelNodeType)abstractModelNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jMiningFunctionValue = new JTextField();
        this._jTargetAttributeValue = new JTextField();
        this._jTargetDataTypeValue = new JTextField();
        this._jMiningFunctionLabel = new PropertyLabel();
        this._jTargetAttributeLabel = new PropertyLabel();
        this._jTargetDataTypeLabel = new PropertyLabel();
        this._jComponentModels = new ComponentWithTitlebar();
        this._jTargetValuesButton = new JButton();
        this._jMiningFunctionValue.setEditable(false);
        this._jMiningFunctionValue.setText("Classification");
        this._jMiningFunctionValue.setBorder(null);
        this._jTargetAttributeValue.setEditable(false);
        this._jTargetAttributeValue.setText("123456789012345678901234567890");
        this._jTargetAttributeValue.setBorder(null);
        this._jTargetDataTypeValue.setEditable(false);
        this._jTargetDataTypeValue.setText("Varchar");
        this._jTargetDataTypeValue.setBorder(null);
        this._jMiningFunctionLabel.setText("Function:");
        this._jTargetAttributeLabel.setText("Target Attribute:");
        this._jTargetDataTypeLabel.setText("Data Type:");
        this._jComponentModels.setMinimumSize(new Dimension(500, 500));
        this._jComponentModels.setPreferredSize(new Dimension(500, 500));
        this._jTargetValuesButton.setText("Values...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jComponentModels, -1, 628, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this._jTargetAttributeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionValue, -1, 187, Short.MAX_VALUE).addComponent(this._jTargetAttributeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValuesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jTargetDataTypeLabel, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetDataTypeValue, -2, 77, -2))).addContainerGap()));
        groupLayout.linkSize(0, this._jMiningFunctionValue, this._jTargetAttributeValue);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jTargetAttributeLabel, -1, 14, Short.MAX_VALUE).addComponent(this._jTargetAttributeValue, -2, -1, -2).addComponent(this._jTargetValuesButton).addComponent((Component)this._jTargetDataTypeLabel, -1, 14, Short.MAX_VALUE).addComponent(this._jTargetDataTypeValue, -2, 14, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jMiningFunctionLabel, -1, 14, Short.MAX_VALUE).addComponent(this._jMiningFunctionValue, -2, -1, -2)).addGap(20, 20, 20))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jComponentModels, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        Class<WorkflowUtils> clazz = WorkflowUtils.class;
        ResourceUtils.resLabel((JLabel)this._jMiningFunctionLabel, (Component)this._jMiningFunctionValue, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_FUNCTION") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetAttributeLabel, (Component)this._jTargetAttributeValue, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_ATTRIBUTE") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetDataTypeLabel, (Component)this._jTargetDataTypeLabel, (String)(PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_DATA_TYPE") + ":"));
        ResourceUtils.resButton((AbstractButton)this._jTargetValuesButton, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_TARGET_VALUES_BUTTON"));
        if (_invalid_icon == null) {
            _invalid_icon = UIResourceHelper.getImageIcon(this.getClass(), PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
        }
        if (_viewIconEna == null) {
            _viewIconEna = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_ENA"));
        }
        if (_viewIconDis == null) {
            _viewIconDis = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_DIS"));
        }
        if (_out_icon == null) {
            _out_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("FILTER_ATTR_OUTPUT_ICON"));
        }
        if (_ignore_icon == null) {
            _ignore_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("FILTER_ATTR_IGNORE_ICON"));
        }
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(_ignore_icon.getIconWidth(), _ignore_icon.getIconHeight());
        }
        if (_refreshIcon == null) {
            _refreshIcon = OracleIcons.getIcon((String)"refresh.png");
        }
        this._jTargetAttributeValue.setText("");
        this._jTargetAttributeValue.setFocusable(false);
        this._jTargetAttributeValue.setOpaque(false);
        this._jTargetDataTypeValue.setText("");
        this._jTargetDataTypeValue.setFocusable(false);
        this._jTargetDataTypeValue.setOpaque(false);
        this._jMiningFunctionValue.setText("");
        this._jMiningFunctionValue.setFocusable(false);
        this._jMiningFunctionValue.setOpaque(false);
        this._jTargetValuesButton.setEnabled(false);
        this._jTargetValuesButton.setVisible(false);
    }

    public void loadData(ModelNodeType modelNodeType) {
        this._nodeData = modelNodeType;
        this._mft = modelNodeType.getMiningFunction();
        this._at = modelNodeType.getTargetAttribute();
        this._nodeTypeModels = modelNodeType.getModels();
        this._models = modelNodeType.getModels().getModel();
        if (this._mft != null) {
            String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
            this._miningFunction = MiningFunctions.fromString(string);
            this._jMiningFunctionValue.setText(this._miningFunction.toString());
            if (this._mft == MiningFunctionType.CLASSIFICATION || this._mft == MiningFunctionType.REGRESSION) {
                this.showTarget(true);
                this._targetValues = modelNodeType.getTargetValues();
                if (this._mft == MiningFunctionType.CLASSIFICATION) {
                    this._jTargetValuesButton.setEnabled(true);
                    this._jTargetValuesButton.setVisible(true);
                } else {
                    this._jTargetValuesButton.setEnabled(false);
                    this._jTargetValuesButton.setVisible(false);
                }
            } else {
                this.showTarget(false);
                this._jTargetValuesButton.setEnabled(false);
                this._jTargetValuesButton.setVisible(false);
            }
        } else {
            this.showTarget(false);
            this._jMiningFunctionValue.setText("");
            this._jTargetAttributeValue.setText("");
            this._jTargetDataTypeValue.setText("");
            this._miningFunction = null;
        }
        if (this._at != null) {
            this._jTargetAttributeValue.setText(this._at.getName());
            this._jTargetDataTypeValue.setText(this._at.getDataType());
        }
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._bLoading = true;
        try {
            this._dbConn = Connections.getSharedConnection(this.getContext((PropertyModel)this._model));
            this._ownerName = Connections.getUserAccountName(this.getContext((PropertyModel)this._model));
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_PI_ERROR_MESG"), null);
            return;
        }
        boolean bl = this.isWritable();
        ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
        this.loadData(modelNodeType);
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName);
        this.setupModelsTable(this._modelsTblModel);
        this._modelsTblModel.setWritable(bl);
        JScrollPane jScrollPane = new JScrollPane((Component)this._jModelsTable);
        this._jComponentModels.setComponent((JComponent)jScrollPane);
        this._jComponentModels.setLabel(new JLabel(PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODELS")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        this._jModelsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this._jModelsTable.getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    ModelNodeType.Models.Model model = modelsTableModel.getDataVector().get(ModelPIComponentPanel.this._jModelsTable.getSelectedRow());
                    if (model.getStatus() == RefModelStatusType.VALID) {
                        ModelPIComponentPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewBtn = new JButton(_viewIconEna);
        this._viewBtn.setDisabledIcon(_viewIconDis);
        this._viewBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewBtn.setEnabled(false);
        this._viewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPIComponentPanel.this.viewModel();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL"));
        this._removeBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelNodeType.Models models;
                AttributeType attributeType;
                MiningFunctionType miningFunctionType;
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL_WARNING_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_REMOVE_MODEL_WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = ModelPIComponentPanel.this._jModelsTable.getSelectedRowsInModel();
                if (nArray.length == 0) {
                    return;
                }
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this._jModelsTable.getModel());
                boolean bl = false;
                if (nArray.length == modelsTableModel.getRowCount()) {
                    bl = true;
                }
                modelsTableModel.removeSelectedRows(nArray);
                if (bl) {
                    ModelPIComponentPanel.this._miningFunction = null;
                    miningFunctionType = null;
                    attributeType = null;
                    models = new ModelNodeType.Models();
                } else {
                    miningFunctionType = MiningFunctions.translateToODMServerMiningFunction(ModelPIComponentPanel.this._miningFunction);
                    attributeType = ModelPIComponentPanel.this.createAttributeType(ModelPIComponentPanel.this._jTargetAttributeValue.getText(), ModelPIComponentPanel.this._jTargetDataTypeValue.getText());
                    models = ModelPIComponentPanel.this.createModelsCollection();
                }
                CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
                try {
                    ModelPIComponentPanel.this._model.setValueAt(miningFunctionType, ModelNodePropertyModel.RowIndex.MINING_FUNCTION, 0);
                    ModelPIComponentPanel.this._model.setValueAt(attributeType, ModelNodePropertyModel.RowIndex.TARGET_ATTRIBUTE, 0);
                    ModelPIComponentPanel.this._model.setValueAt(models, ModelNodePropertyModel.RowIndex.MODELS, 0);
                    Element[] elementArray = ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model).getSelection();
                    WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                    workflowNodeInspectorElement.validate(true);
                    ModelPIComponentPanel.this.updateWorkFlow();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_ADD_MODEL"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodeDialog editModelNodeDialog = new EditModelNodeDialog();
                if (editModelNodeDialog.invoke(ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model), (PropertyModel)ModelPIComponentPanel.this._model)) {
                    ModelPIComponentPanel.this.updateWorkFlow();
                }
            }
        });
        this._addBtn.setEnabled(bl);
        this._refreshBtn = new JButton(_refreshIcon);
        this._refreshBtn.setToolTipText(PropertyLrb.get("PI_MODEL_GROUP_MODEL_ADD_REFRESH_MODEL"));
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadUI loadUI = new LoadUI();
                loadUI.start();
            }
        });
        controlBar.add((Component)this._refreshBtn);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        controlBar.add((Component)this._viewBtn);
        controlBar.addSeparator();
        controlBar.add(this._findPane);
        this._jComponentModels.setControlBar(controlBar);
        this._jTargetValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetValuesDialog targetValuesDialog = new TargetValuesDialog();
                targetValuesDialog.invoke(ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this._at.getName(), ModelPIComponentPanel.this._at.getDataType(), ModelPIComponentPanel.this._targetValues);
            }
        });
        this._jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ModelPIComponentPanel.this.handleModelSelectionChanged();
            }
        });
        this._bLoading = false;
    }

    private AttributeType createAttributeType(String string, String string2) {
        AttributeType attributeType = null;
        if (string.length() > 0) {
            attributeType = new AttributeType();
            attributeType.setDataType(string2);
            attributeType.setName(string);
            attributeType.setStatus(AttributeStatus.VALID);
        }
        return attributeType;
    }

    private ModelNodeType.Models createModelsCollection() {
        ModelNodeType.Models models = new ModelNodeType.Models();
        List list = models.getModel();
        ModelNodeType.Models.Model model = null;
        for (ModelNodeType.Models.Model model2 : this._modelsTblModel.getDataVector()) {
            model = new ModelNodeType.Models.Model();
            model.setName(model2.getName());
            model.setSchema(model2.getSchema());
            model.setMiningAlgorithm(model2.getMiningAlgorithm());
            model.setMiningFunction(model2.getMiningFunction());
            model.setStatus(model2.getStatus());
            model.setUseForOutput(model2.isUseForOutput());
            model.setModelId(model2.getModelId());
            model.setModelSettingsODM(model2.getModelSettingsODM());
            list.add(model);
        }
        return models;
    }

    private void handleModelSelectionChanged() {
        boolean bl = false;
        int n = this._jModelsTable.getSelectedRowCount();
        if (n == 1) {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            int n2 = this._jModelsTable.getSelectedRow();
            if (n2 == -1) {
                return;
            }
            ModelNodeType.Models.Model model = modelsTableModel.getDataVector().get(n2);
            if (model.getStatus() == RefModelStatusType.VALID) {
                bl = true;
            }
        }
        this._viewBtn.setEnabled(bl);
        if (this.isWritable()) {
            this._removeBtn.setEnabled(n != 0);
        }
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ModelPIComponentPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                ModelPIComponentPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ModelPIComponentPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ModelPIComponentPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            ModelsTableModel modelsTableModel = this._modelsTblModel.getfilteredCopy(string, this._currentSearchCategory);
            this.setupModelsTable(modelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_NAME"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_ALGORITHM"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_FULL_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_SCHEMA"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 1;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_FULL_NAME")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_SCHEMA")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_ALGORITHM")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    public void resetModelsTable(PropertyModel propertyModel) {
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((ModelNodeType)abstractModelNode.getData());
        this.reloadUI(propertyModel);
    }

    public void reloadUI(PropertyModel propertyModel) {
        Object object;
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractModelNode abstractModelNode = this.getTargetNode(propertyModel);
        if (abstractModelNode == null) {
            return;
        }
        this._bLoading = true;
        try {
            this._dbConn = Connections.getSharedConnection(this.getContext((PropertyModel)this._model));
            this._ownerName = Connections.getUserAccountName(this.getContext((PropertyModel)this._model));
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_PI_ERROR_MESG"), null);
            return;
        }
        ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
        this.loadData(modelNodeType);
        int[] nArray = this._jModelsTable.getSelectedRowsInModel();
        ArrayList<ModelNodeType.Models.Model> arrayList = null;
        if (nArray != null && nArray.length > 0) {
            object = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            arrayList = new ArrayList<ModelNodeType.Models.Model>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                ModelNodeType.Models.Model model = ((ModelsTableModel)((Object)object)).getDataVector().get(nArray[i]);
                arrayList.add(model);
            }
        }
        this._modelsTblModel = new ModelsTableModel(this._models, this._ownerName);
        this.setupModelsTable(this._modelsTblModel);
        if (arrayList != null) {
            Object object2;
            object = new Vector();
            Vector<ModelNodeType.Models.Model> vector = this._modelsTblModel.getDataVector();
            for (int i = 0; i < vector.size(); ++i) {
                object2 = vector.get(i);
                if (!arrayList.contains(object2)) continue;
                ((Vector)object).add(i);
            }
            if (!((Vector)object).isEmpty()) {
                Integer[] integerArray = ((Vector)object).toArray(new Integer[((Vector)object).size()]);
                object2 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object2[i] = (ModelNodeType.Models.Model)integerArray[i];
                }
                this._jModelsTable.setSelectedRowsInModel((int[])object2);
            }
        }
        this._bLoading = false;
    }

    public boolean isLoading() {
        return this._bLoading;
    }

    private void viewModel() {
        try {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._jModelsTable.getModel());
            int n = this._jModelsTable.convertRowIndexToModel(this._jModelsTable.getSelectedRow());
            ModelNodeType.Models.Model model = modelsTableModel.getDataVector().get(n);
            MiningAlgorithmType miningAlgorithmType = model.getMiningAlgorithm();
            String string = this.getTargetNode((PropertyModel)this._model).getData().getName();
            if (miningAlgorithmType != MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
                String string2 = model.getName();
                Context context = this.getContext((PropertyModel)this._model);
                WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                if (workflowNode == null) {
                    return;
                }
                BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string, string2);
                if (baseTreeNode != null) {
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                } else {
                    MessageDialog.error((Component)this, (Object)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_NODE_ERROR_MESG"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), null);
                }
                return;
            }
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer((ModelInfoType)model, this.getContext((PropertyModel)this._model), string);
            loadSVMModelViewer.start();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
        }
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this._jModelsTable.setModel((TableModel)((Object)modelsTableModel));
        this._jModelsTable.setSorted(true);
        this._jModelsTable.setSortColumn(0, true);
        this._jModelsTable.setUpdateSelectionOnSort(true);
        this._jModelsTable.getTableHeader().setReorderingAllowed(false);
        this._jModelsTable.setShowToolTips(true);
        TableColumn tableColumn = this._jModelsTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        tableColumn = this._jModelsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this._jModelsTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(100);
    }

    private void showTarget(boolean bl) {
        this._jTargetAttributeValue.setVisible(bl);
        this._jTargetAttributeLabel.setVisible(bl);
        this._jTargetDataTypeValue.setVisible(bl);
        this._jTargetDataTypeLabel.setVisible(bl);
    }

    @Override
    protected AbstractModelNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowExistingModelNodePropertyProxyModel)) {
            return null;
        }
        WorkflowExistingModelNodePropertyProxyModel workflowExistingModelNodePropertyProxyModel = (WorkflowExistingModelNodePropertyProxyModel)propertyModel;
        Context context = workflowExistingModelNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelNodeType) {
            return (AbstractModelNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void setValue(List<Pair<String, Boolean>> list) {
        AbstractModelNode abstractModelNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractModelNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(ModelNodePropertyModel.RowIndex.MODEL_USEFOROUTPUT), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt("modelUseForOutput", abstractModelNode, arrayList);
        this.updateWorkFlow();
    }

    static {
        _columnNames = new String[]{PropertyLrb.get("PI_MODEL_GROUP_MODEL_NAME"), PropertyLrb.get("PI_MODEL_GROUP_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT")};
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        private EditModelTableModel _selectedModelsTableModel;
        private EditModelTableModel _availModelsTableModel;
        private Context _context;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
        }

        public Object construct() {
            Connection connection = null;
            try {
                Vector<EditModelTableModel.TableRow> vector = this.loadSelectedModelsFromNode();
                this._context = ((WorkflowExistingModelNodePropertyProxyModel)ModelPIComponentPanel.this._model).getSelectionContext();
                this._selectedModelsTableModel = new EditModelTableModel(ModelPIComponentPanel.this._ownerName, vector, this._context);
                connection = Connections.getSharedConnection(this._context);
                this._availModelsTableModel = new EditModelTableModel(this._context);
                Vector<EditModelTableModel.TableRow> vector2 = this._availModelsTableModel.createMissingRowsBasedOnMatch(this._selectedModelsTableModel.getDataVector());
                this._selectedModelsTableModel.refreshModelStatus(vector2);
                this._success = this._selectedModelsTableModel.areModelsValid();
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateModels() {
            ModelNodeType modelNodeType = (ModelNodeType)MetaDataHelper.copyMetadataObject(ModelPIComponentPanel.this._nodeData);
            List list = modelNodeType.getModels().getModel();
            Vector<EditModelTableModel.TableRow> vector = this._selectedModelsTableModel.getDataVector();
            block5: for (EditModelTableModel.TableRow object : vector) {
                for (ModelNodeType.Models.Model model : list) {
                    if (object.getModelName().compareTo(model.getName()) != 0) continue;
                    model.setStatus(object.getStatus());
                    continue block5;
                }
            }
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
            try {
                AbstractModelNode abstractModelNode = ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model);
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)abstractModelNode.getUndoFilter();
                odmrSDMUndoFilter.prepareUndo(abstractModelNode, this._context, "modelsGroup", modelNodeType.getModels());
                abstractModelNode.validate(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }

        private Vector<EditModelTableModel.TableRow> loadSelectedModelsFromNode() {
            AbstractModelNode abstractModelNode = ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model);
            ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
            List list = modelNodeType.getModels().getModel();
            if (list != null) {
                if (list.size() == 0) {
                    return new Vector<EditModelTableModel.TableRow>();
                }
            } else {
                return new Vector<EditModelTableModel.TableRow>();
            }
            Vector<EditModelTableModel.TableRow> vector = new Vector<EditModelTableModel.TableRow>();
            String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
            String string2 = null;
            String string3 = null;
            if (modelNodeType.getTargetAttribute() != null) {
                string2 = modelNodeType.getTargetAttribute().getName();
                string3 = modelNodeType.getTargetAttribute().getDataType();
            }
            String string4 = "";
            for (ModelNodeType.Models.Model model : list) {
                string4 = MiningAlgorithms.translateFromODMServerAlgorithm(model.getMiningAlgorithm().value());
                EditModelTableModel.TableRow tableRow = new EditModelTableModel.TableRow(model.getSchema(), model.getName(), string, string4, string2, string3, null, null, model.getStatus(), model.getModelId(), new ModelSettingsODM(), model.isUseForOutput());
                vector.add(tableRow);
            }
            return vector;
        }

        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    this.updateModels();
                } else if (!this._success && this._ex == null) {
                    if (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_REFRESH_MESG"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE")) == 1) {
                        EditModelNodeDialog editModelNodeDialog = new EditModelNodeDialog();
                        if (editModelNodeDialog.invoke(ModelPIComponentPanel.this.getContext((PropertyModel)ModelPIComponentPanel.this._model), ModelPIComponentPanel.this.getTargetNode((PropertyModel)ModelPIComponentPanel.this._model), (PropertyModel)ModelPIComponentPanel.this._model)) {
                            ModelPIComponentPanel.this.updateWorkFlow();
                        }
                    } else {
                        this.updateModels();
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
            }
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = ModelPIComponentPanel.this._jModelsTable.convertRowIndexToModel(n);
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ModelPIComponentPanel.this._jModelsTable.getModel());
            if (((ModelNodeType.Models.Model)modelsTableModel._srcData.get(n3)).getStatus() == RefModelStatusType.VALID) {
                this.setIcon(null);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel {
        private Vector<ModelNodeType.Models.Model> _srcData;
        private Map<String, ModelNodeType.Models.Model> _srcMapSchemaAndName;
        private Map<String, ModelNodeType.Models.Model> _srcMapName;
        private boolean _ownerOnly = true;
        private String _ownerName;
        private boolean _writable = true;

        public ModelsTableModel(List<ModelNodeType.Models.Model> list, String string) {
            this._srcData = new Vector(list.size());
            this._srcData.addAll(list);
            this._ownerName = string;
            this._srcMapSchemaAndName = new HashMap<String, ModelNodeType.Models.Model>();
            this._srcMapName = new HashMap<String, ModelNodeType.Models.Model>();
            for (ModelNodeType.Models.Model model : list) {
                this._srcMapSchemaAndName.put(model.getSchema() + "." + model.getName(), model);
                this._srcMapName.put(model.getName(), model);
            }
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(3);
            this.areModelsInOwnerSchema();
        }

        private void areModelsInOwnerSchema() {
            boolean bl = true;
            for (ModelNodeType.Models.Model model : this._srcData) {
                if (model.getSchema().compareTo(this._ownerName) == 0) continue;
                bl = false;
                break;
            }
            this._ownerOnly = bl;
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<ModelNodeType.Models.Model> getDataVector() {
            return this._srcData;
        }

        public Class<?> getColumnClass(int n) {
            if (this.getRowCount() == 0) {
                return String.class;
            }
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Pair<TextIcon, Boolean> getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            Icon icon = null;
            ModelNodeType.Models.Model model = this._srcData.get(n);
            String string = this._ownerOnly ? model.getName() : model.getSchema() + "." + model.getName();
            icon = model.getStatus() == RefModelStatusType.VALID ? null : _invalid_icon;
            Pair pair = new Pair((Object)new TextIcon(string, icon), (Object)model.isUseForOutput());
            return pair;
        }

        public Comparator getColumnSortComparator(int n) {
            return super.getColumnSortComparator(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelNodeType.Models.Model model = this._srcData.get(n);
            if (n2 != 2) {
                return;
            }
            Boolean bl = (Boolean)object;
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            String string = model.getSchema() + "." + model.getName();
            arrayList.add(new Pair((Object)string, (Object)bl));
            ModelPIComponentPanel.this.setValue(arrayList);
            this.fireTableCellUpdated(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds: " + n + ", RowCount: " + this.getRowCount();
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelNodeType.Models.Model model = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    String string = this._ownerName.equals(model.getSchema()) ? model.getName() : model.getSchema() + "." + model.getName();
                    object = string;
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(model.getMiningAlgorithm());
                    break;
                }
                case 2: {
                    if (model.isUseForOutput()) {
                        object = Boolean.TRUE;
                        break;
                    }
                    object = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public ModelsTableModel getfilteredCopy(String string, int n) throws Exception {
            Vector<ModelNodeType.Models.Model> vector = null;
            assert (string != null) : "name filter must be non null";
            SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            Object object = this.getDataVector();
            vector = new Vector<ModelNodeType.Models.Model>(1000, 500);
            Iterator<ModelNodeType.Models.Model> iterator = ((Vector)object).iterator();
            ModelNodeType.Models.Model model = null;
            boolean bl = string.length() <= 0;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                model = iterator.next();
                if (bl) {
                    bl2 = true;
                } else {
                    String string2;
                    switch (n) {
                        case 1: {
                            string2 = model.getName();
                            break;
                        }
                        case 0: {
                            string2 = model.getSchema() + "." + model.getName();
                            break;
                        }
                        case 2: {
                            string2 = model.getSchema();
                            break;
                        }
                        case 3: {
                            string2 = MetaDataHelper.getAlgorithmName(model.getMiningAlgorithm());
                            break;
                        }
                        default: {
                            string2 = model.getName();
                        }
                    }
                    bl2 = searchMatcher.matches((CharSequence)string2);
                }
                if (!bl2) continue;
                vector.add(model);
            }
            object = new ModelsTableModel(vector, this._ownerName);
            ((ModelsTableModel)((Object)object)).setWritable(this._writable);
            return object;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return this._writable;
            }
            return false;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<ModelNodeType.Models.Model> vector = new Vector<ModelNodeType.Models.Model>();
            ModelNodeType.Models.Model model = null;
            for (int i = 0; i < nArray.length; ++i) {
                model = this._srcData.elementAt(nArray[i]);
                vector.add(model);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }
    }
}

