/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public abstract class GeneralBuildPIPanel
extends JPanel {
    protected JButton _duplicateBtn;
    protected WorkflowNodePropertyProxyModel _model;
    protected GenericTable _jModelsTable = new GenericTable();

    public GeneralBuildPIPanel() {
    }

    public GeneralBuildPIPanel(PropertyModel propertyModel) {
    }

    public GeneralBuildPIPanel(boolean bl) {
        super(bl);
    }

    public GeneralBuildPIPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public GeneralBuildPIPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public abstract Context getContext(PropertyModel var1);

    protected abstract ModelType getModelType(int var1);

    protected abstract void setValue(List<ModelType> var1, String var2, String var3);

    public void initUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this._duplicateBtn = new JButton(OracleIcons.getIcon((String)"duplicate.png"));
        this._duplicateBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_DUPLICATE"));
        this._duplicateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    Context context = GeneralBuildPIPanel.this.getContext((PropertyModel)GeneralBuildPIPanel.this._model);
                    Element[] elementArray = context.getSelection();
                    WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                    BuildNodeType buildNodeType = (BuildNodeType)workflowNodeInspectorElement.getNode().getData();
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)context.getNode());
                    int[] nArray = GeneralBuildPIPanel.this._jModelsTable.getSelectedRows();
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        object2 = GeneralBuildPIPanel.this.getModelType(nArray[i]);
                        object = (ModelType)MetaDataHelper.copyMetadataObject(object2);
                        object.setUseForOutput(true);
                        arrayList.add((ModelType)object);
                    }
                    List<RefModelType> list = MetaDataHelper.getModelsCollection(buildNodeType, arrayList, context);
                    object2 = MetaDataHelper.getModelsCollection(buildNodeType);
                    object = WorkflowUtils.refactorModels(context, list, (List<ModelType>)object2, workflowModel, false);
                    AbstractBuildNode.applyRefactoredModels((Map<String, RefModelType>)object, arrayList);
                    GeneralBuildPIPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this._duplicateBtn.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameModel(Vector<ModelType> vector, Object object, int n, int n2) {
        CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_MODEL_RENAME_TXN"));
        try {
            ModelType modelType = vector.get(n);
            String string = modelType.getName();
            String string2 = (String)object;
            this.setNameValue(modelType, string2);
            this.updateCell(n, n2);
            AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
            Context context = this.getContext((PropertyModel)this._model);
            RefModelType refModelType = MetaDataHelper.getModelRefFromId((BuildNodeType)abstractBuildNode.getData(), modelType.getId(), context);
            HashMap<String, RefModelType> hashMap = new HashMap<String, RefModelType>();
            if (refModelType != null) {
                refModelType.setName(string2);
                hashMap.put(string, refModelType);
            }
            abstractBuildNode.refactorChildModelReferences(hashMap);
            List<AbstractNode> list = abstractBuildNode.findAllChildNodes();
            for (AbstractNode abstractNode : list) {
                abstractNode.validate(true);
            }
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            exception.printStackTrace();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    public abstract AbstractBuildNode getTargetNode(PropertyModel var1);

    public abstract void updateCell(int var1, int var2);

    protected abstract int getModelNameIdFromPropertyModel();

    protected abstract int getModelsRerunIdFromPropertyModel();

    protected abstract int getTestsRerunIdFromPropertyModel();

    protected WorkflowModel getWorkflowModel() {
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext((PropertyModel)this._model).getNode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return workflowModel;
    }

    protected Collection<String> getInMemoryModelNames(AbstractBuildNode abstractBuildNode) {
        return WorkflowUtils.getInMemoryModelNames(this.getWorkflowModel(), (BuildNodeType)abstractBuildNode.getData());
    }

    private void setNameValue(ModelType modelType, String string) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), string);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(this.getModelNameIdFromPropertyModel()), null, new ComplexProperty("modelName", hashMap), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.add(modelType);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), abstractBuildNode, arrayList);
            this.updateWorkFlowInternal();
        }
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType modelType : list) {
            hashMap.put(modelType.getId(), ModelStatusType.READY);
        }
        ArrayList arrayList = new ArrayList();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(this.getModelsRerunIdFromPropertyModel()), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (-1 != this.getTestsRerunIdFromPropertyModel()) {
                arrayList.add(new Property(String.valueOf(this.getTestsRerunIdFromPropertyModel()), null, new ComplexProperty("testsRerun", hashMap), null, null));
            }
        }
        return arrayList;
    }

    protected void updateWorkFlowInternal() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            try {
                Node node = workflowEditor.getSelectedDiagramNode();
                if (node != null) {
                    workflowEditor.setSelected(workflowNode.getEngine(), node);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

