/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class EditCaseAttributesDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "Edit profile node";
    private CaseEditRecord caseEdits;

    public EditCaseAttributesDialog(CaseEditRecord caseEditRecord) {
        this.caseEdits = caseEditRecord;
    }

    protected JEWTDialog buildDialog(Context context, AbstractDataNode abstractDataNode) {
        SelectCaseAttributesPanel selectCaseAttributesPanel = new SelectCaseAttributesPanel(context, abstractDataNode, this.getAvailableAttributes(abstractDataNode));
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)((Object)selectCaseAttributesPanel));
        jEWTDialog.setTitle(DataDialogsLrb.get("DIALOG_TITLE"));
        return jEWTDialog;
    }

    private List<AttributeType> getAvailableAttributes(AbstractDataNode abstractDataNode) {
        if (abstractDataNode == null || !(abstractDataNode instanceof DataProvider)) {
            return new ArrayList<AttributeType>();
        }
        AbstractDataNode abstractDataNode2 = abstractDataNode;
        List list = abstractDataNode2.getAttributes().getAttribute();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            arrayList.add(attributeType2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, AbstractDataNode abstractDataNode) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, abstractDataNode);
            jEWTDialog.setResizable(true);
            final DataSourceAttributesPanel dataSourceAttributesPanel = (DataSourceAttributesPanel)((Object)jEWTDialog.getContent());
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !dataSourceAttributesPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DIALOG_FAIL_TITLE"), (String)DataDialogsLrb.get("DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    class SelectCaseAttributesPanel
    extends DataSourceAttributesPanel {
        SelectCaseAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
            super(context, abstractNode, list);
        }

        @Override
        protected List<AttributeType> getSelectedAttributes() {
            return EditCaseAttributesDialog.this.caseEdits.getCaseAttributes().getAttribute();
        }

        @Override
        public boolean doWork() {
            boolean bl = true;
            List list = EditCaseAttributesDialog.this.caseEdits.getCaseAttributes().getAttribute();
            list.clear();
            list.addAll(this.selectedAttrsCache);
            return bl;
        }
    }
}

