/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestLiftProfitDialogPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class ClassificationBuildPIComponentTestPanel
extends JPanel
implements ClassificationBuildPIComponentGUI,
ActionListener {
    private List<ModelType> _models;
    private WorkflowNodePropertyProxyModel _model;
    private boolean _clearSearchState = true;
    private ButtonGroup buttonGroupTest;
    private JCheckBox jChkPerformTest;
    private JLabel jLblSplit;
    private JPanel jPanelTestData;
    private JRadioButton jRadioAllData;
    private JRadioButton jRadioSplit;
    private JRadioButton jRadioTest;
    private JSpinner jSpinnerSplit;
    private static double _SLIDER_INITIAL_VALUE = 40.0;
    private static double _SLIDER_MIN_VALUE = 5.0;
    private static double _SLIDER_MAX_VALUE = 100.0;
    private static double _SLIDER_STEP_VALUE = 1.0;

    public ClassificationBuildPIComponentTestPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.buttonGroupTest = new ButtonGroup();
        this.jChkPerformTest = new JCheckBox();
        this.jPanelTestData = new JPanel();
        this.jLblSplit = new JLabel();
        this.jRadioAllData = new JRadioButton();
        this.jRadioSplit = new JRadioButton();
        this.jRadioTest = new JRadioButton();
        this.jSpinnerSplit = new JSpinner();
        this.jChkPerformTest.setText("Perform Test");
        this.jChkPerformTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkPerformTest.setMargin(new Insets(0, 0, 0, 0));
        this.jLblSplit.setText("Split:");
        this.jRadioAllData.setText("Use All Mining Build Data for Testing");
        this.jRadioAllData.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAllData.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioSplit.setText("Use Split Build Data for Testing");
        this.jRadioSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioSplit.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioTest.setText("Use Test Data Source for Testing");
        this.jRadioTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioTest.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this.jPanelTestData);
        this.jPanelTestData.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioAllData, -1, 372, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLblSplit, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSplit, -2, 47, -2)).addComponent(this.jRadioSplit, -1, 372, Short.MAX_VALUE).addComponent(this.jRadioTest, -1, 372, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioAllData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioSplit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSplit).addComponent(this.jSpinnerSplit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioTest).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelTestData, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jChkPerformTest, -1, 409, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jChkPerformTest).addGap(1, 1, 1).addComponent(this.jPanelTestData, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jChkPerformTest.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORM_TEST"));
        this.jChkPerformTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassificationBuildPIComponentTestPanel.this.updateTestOption(ClassificationBuildPIComponentTestPanel.this.jChkPerformTest.isSelected());
            }
        });
        this.jChkPerformTest.setOpaque(false);
        this.jLblSplit.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_LABEL"));
        this.jSpinnerSplit.setModel(new SpinnerNumberModel(_SLIDER_INITIAL_VALUE, _SLIDER_MIN_VALUE, _SLIDER_MAX_VALUE, _SLIDER_STEP_VALUE));
        this.jPanelTestData.setOpaque(false);
        this.jRadioAllData.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ALL_BUILD_DATA"));
        this.jRadioAllData.setOpaque(false);
        this.jRadioAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestDataSource testDataSource = new TestDataSource();
                testDataSource.setBuildData(new TestDataSource.BuildData());
                ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
            }
        });
        this.jRadioSplit.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_BUILD_DATA"));
        this.jRadioSplit.setOpaque(false);
        this.jRadioSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestDataSource testDataSource = new TestDataSource();
                Double d = (Double)ClassificationBuildPIComponentTestPanel.this.jSpinnerSplit.getValue();
                TestDataSource.SplitData splitData = new TestDataSource.SplitData();
                splitData.setTestPercent(d.doubleValue());
                testDataSource.setSplitData(splitData);
                ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
            }
        });
        this.jRadioTest.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TEST_DATA"));
        this.jRadioTest.setOpaque(false);
        this.jRadioTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractBuildNode abstractBuildNode = ClassificationBuildPIComponentTestPanel.this.getTargetNode((PropertyModel)ClassificationBuildPIComponentTestPanel.this._model);
                if (abstractBuildNode instanceof SupervisedBuildNode) {
                    WorkflowModel workflowModel = abstractBuildNode.getModel();
                    AbstractDataNode abstractDataNode = null;
                    List<AbstractNode> list = abstractBuildNode.findParentNodes();
                    AbstractDataNode abstractDataNode2 = abstractBuildNode.findBuildDataNode(workflowModel);
                    abstractDataNode = list.get(0).equals(abstractDataNode2) ? (AbstractDataNode)list.get(1) : (AbstractDataNode)list.get(0);
                    if (abstractDataNode != null) {
                        NodeType nodeType = abstractDataNode.getData();
                        TestDataSource testDataSource = new TestDataSource();
                        TestDataSource.TestData testData = new TestDataSource.TestData();
                        testData.setSourceId(nodeType.getId());
                        testDataSource.setTestData(testData);
                        ClassificationBuildPIComponentTestPanel.this.setValue(testDataSource);
                    }
                }
            }
        });
        this.jRadioAllData.addActionListener(this);
        this.jRadioSplit.addActionListener(this);
        this.jRadioTest.addActionListener(this);
        this.buttonGroupTest.add(this.jRadioAllData);
        this.buttonGroupTest.add(this.jRadioSplit);
        this.buttonGroupTest.add(this.jRadioTest);
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        boolean bl = this.isPerformTest(this.getTestDataSettings());
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption(bl);
        this.jSpinnerSplit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TestDataSource testDataSource = ClassificationBuildPIComponentTestPanel.this.getTestDataSettings();
                Double d = (Double)ClassificationBuildPIComponentTestPanel.this.jSpinnerSplit.getValue();
                double d2 = testDataSource.getSplitData().getTestPercent();
                if (d2 != d) {
                    ClassificationBuildPIComponentTestPanel.this.adjustSplitValue(d);
                }
            }
        });
        this.jChkPerformTest.setEnabled(this.isWritable());
    }

    private boolean isPerformTest(TestDataSource testDataSource) {
        return testDataSource != null && null == testDataSource.getNone();
    }

    private TestDataSource getTestDataSettings() {
        TestDataSource testDataSource = null;
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            testDataSource = classificationBuildNodeType.getTestDataSource();
        }
        return testDataSource;
    }

    private void initTestOption(boolean bl) {
        TestDataSource testDataSource;
        boolean bl2 = this.isWritable();
        this.jRadioAllData.setEnabled(bl && bl2);
        this.jRadioSplit.setEnabled(bl && bl2);
        boolean bl3 = false;
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode instanceof SupervisedBuildNode) {
            testDataSource = abstractBuildNode.findParentNodes();
            bl3 = testDataSource != null && !testDataSource.isEmpty() && testDataSource.size() == 2;
        }
        this.jRadioTest.setEnabled(bl && bl3 && bl2);
        testDataSource = this.getTestDataSettings();
        if (testDataSource != null && bl) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
                this.enableSplitControls(false);
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
                this.enableSplitControls(false);
            } else {
                this.enableSplitControls(bl2);
                this.jRadioSplit.setSelected(true);
                this.jSpinnerSplit.setValue(testDataSource.getSplitData().getTestPercent());
            }
        }
    }

    private void enableSplitControls(boolean bl) {
        this.jSpinnerSplit.setEnabled(bl);
    }

    private void updateTestOption(boolean bl) {
        boolean bl2 = this.isWritable();
        this.jRadioAllData.setEnabled(bl && bl2);
        this.jRadioSplit.setEnabled(bl && bl2);
        this.jRadioTest.setEnabled(bl && bl2);
        TestDataSource testDataSource = new TestDataSource();
        if (bl) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
                testDataSource.setBuildData(new TestDataSource.BuildData());
                this.jSpinnerSplit.setEnabled(false);
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
                testDataSource.setTestData(new TestDataSource.TestData());
                this.jSpinnerSplit.setEnabled(false);
            } else {
                this.jSpinnerSplit.setEnabled(bl2);
                this.jRadioSplit.setSelected(true);
                Double d = (Double)this.jSpinnerSplit.getValue();
                TestDataSource.SplitData splitData = new TestDataSource.SplitData();
                splitData.setTestPercent(d.doubleValue());
                testDataSource.setSplitData(splitData);
            }
        } else {
            testDataSource.setNone(new TestDataSource.None());
            this.jSpinnerSplit.setEnabled(false);
            this.jLblSplit.setEnabled(false);
        }
        this.setValue(testDataSource);
    }

    private void updateWorkFlow() {
        Context context = this.getContext((PropertyModel)this._model);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            try {
                Node node = workflowEditor.getSelectedDiagramNode();
                WorkflowNode workflowNode2 = (WorkflowNode)context.getNode();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode2);
                if (node != null) {
                    workflowEditor.setSelected(workflowNode.getEngine(), node);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void adjustSplitValue(double d) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.SPLIT_VALUE), null, new ComplexProperty("splitValueChanged", d), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            this._model.setValueAt("splitValueChanged", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(TestDataSource testDataSource) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        ClassificationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TEST_OPTIONS_CHANGED), null, new ComplexProperty("testOptionsChanged", testDataSource), null, null));
            arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (this.isPerformTest(testDataSource)) {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            } else {
                arrayList.add(new Property(String.valueOf(ModelBuildNodePropertyModel.RowIndex.TESTS_ADDED_REMOVED), null, new ComplexProperty("alltestsRemoved", "alltestsRestored", MetaDataHelper.getClassResultsCollection(abstractBuildNode)), null, null));
            }
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            this.enableSplitControls(this.jRadioSplit.equals(actionEvent.getSource()) && this.isWritable());
        }
    }

    public void upadteUI(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        TestDataSource testDataSource = this.getTestDataSettings();
        boolean bl = this.isPerformTest(testDataSource);
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption(bl);
        this.jChkPerformTest.setEnabled(this.isWritable());
    }

    @Override
    public boolean isWritable() {
        return ClassificationBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    class LiftProfitClassDialog {
        protected String wizName = "Lift / Profit Settings";
        private TestLiftProfitDialogPanel _content;

        protected JEWTDialog buildDialog() {
            this._content = new TestLiftProfitDialogPanel((PropertyModel)ClassificationBuildPIComponentTestPanel.this._model);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)this._content);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFITSETTINGS_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final TestLiftProfitDialogPanel testLiftProfitDialogPanel = (TestLiftProfitDialogPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !testLiftProfitDialogPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFITSETTINGS_DIALOG_FAIL_TITLE"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFITSETTINGS_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }

        public ClassificationTestSettingsType collectData() {
            return this._content.collectData();
        }
    }
}

