/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Color;
import java.awt.Window;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConverterHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.transformations.ExtendedTransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.TIMESTAMPTZ;

public class TransformationStatisticsState
implements GraphModelProvider {
    public static String NULLS = "Nulls";
    public static String EDGES = "EdgeValues";
    public static int DEFAULT_BIN_COUNT = 10;
    private boolean _loaded;
    private Context _context;
    private TransformationNode _transformationNode;
    private TransformedAttributes _transformedAttributes;
    private Vector<TransformationSourceAttribute> _transformationSourceAttributes;
    private TransformationSettingsTableModel _tableModel;
    public static String RANGE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_RANGE");
    public static String SEQUENCE = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_LABELS_NUMBER");
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    static String _NONE_ATTRIBUTE = DataProfileStatisticsLrb.get("ATTRIBUTE_NONE");
    private static Color[] _RESERVED_COLORS = new Color[]{Color.yellow, Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.black, Color.gray};
    private static Color[][] _EXTRA_COLORS = new Color[][]{{new Color(255, 226, 122), new Color(255, 122, 122), new Color(122, 255, 122), new Color(122, 122, 255), new Color(122, 255, 255), new Color(255, 122, 255), new Color(255, 226, 122), new Color(255, 51, 51), new Color(51, 26, 0), Color.lightGray}, {new Color(255, 213, 61), new Color(255, 61, 61), new Color(61, 255, 61), new Color(61, 61, 255), new Color(61, 255, 255), new Color(255, 61, 255), new Color(255, 213, 61), new Color(255, 112, 112), new Color(112, 112, 0), Color.darkGray}};
    private static String ATTR = "ATTR";
    private static String DATA_TYPE = "DATA_TYPE";
    private static String NULL_PERCENT = "NULL_PERCENT";
    private static String DISTINCT_CNT = "DISTINCT_CNT";
    private static String DISTINCT_PERCENT = "DISTINCT_PERCENT";
    private static String MODE_VALUE = "MODE_VALUE";
    private static String AVG = "AVG";
    private static String AVG_DATE = "AVG_DATE";
    private static String AVG_TS_TZ = "AVG_TS_TZ";
    private static String MEDIAN_VAL = "MEDIAN_VAL";
    private static String MEDIAN_DATE = "MEDIAN_DATE";
    private static String MEDIAN_TS_TZ = "MEDIAN_TS_TZ";
    private static String MIN = "MIN";
    private static String MAX = "MAX";
    private static String STD = "STD";
    private static String VAR = "VAR";
    private static String SKEWNESS = "SKEWNESS";
    private static String KURTOSIS = "KURTOSIS";
    private static String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static String ATTRIBUTE_PERCENT = "ATTRIBUTE_PERCENT";
    private static String _comma = ", ";
    private static StringBuffer _listBuffer = new StringBuffer();
    private static String _where_clause;
    private static String _where_clause_template;
    private static String _attr_list_token;
    private static String _table_name_token;
    private static String _QUERY;
    private HashMap<String, AttributeHistogramArray> _serverHistograms = new HashMap();
    private Map<String, Boolean> _mapModified = new HashMap<String, Boolean>();
    private HashMap<String, DataProfileStatisticsData> _refreshDataPoints;
    private HashMap<String, AttributeHistogramArray> _refreshHistograms = new HashMap();
    private String _refreshStatsTable;
    private String _refreshSingleColumnStatsTable;
    private HashMap<String, DataProfileStatisticsData> _serverDataPoints;
    static String LIST_OF_DISTINCT_VALUES;
    private Map<String, List<String>> distinctValues = new HashMap<String, List<String>>();
    private static String EQWIDTH;
    private static String QTILE;
    private static String TOPN;
    static String UNBOUNDED;
    static String NO_LOWER_BOUND;
    private static final String ODMR_OBJECT_NAMES = "ODMR_OBJECT_NAMES";
    private static final String ODMR_OBJECT_IDS = "ODMR_OBJECT_IDS";
    private static final String ODMR_OBJECT_VALUES = "ODMR_OBJECT_VALUES";
    private static String xformToSql;
    static String sql_distincts;
    private static String queryDateTemplate_no_with;
    private static String queryDateTemplate;

    boolean isUpToDate() {
        boolean bl = true;
        Collection<Boolean> collection = this._mapModified.values();
        for (Boolean bl2 : collection) {
            if (!bl2.booleanValue()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void addToModifiedList(MapTransformedSource mapTransformedSource) {
        this._mapModified.put(mapTransformedSource.getKey().getName(), Boolean.TRUE);
    }

    public boolean isModified(String string) {
        return null != this._mapModified.get(string);
    }

    public boolean needsRefresh(String string) {
        Boolean bl = this._mapModified.get(string);
        if (null == bl) {
            return false;
        }
        return bl;
    }

    private void resetModifiedList() {
        Set<String> set = this._mapModified.keySet();
        for (String string : set) {
            this._mapModified.put(string, Boolean.FALSE);
        }
    }

    private void resetModifiedState(String string) {
        this._mapModified.put(string, Boolean.FALSE);
    }

    public void setTransformationSourceAttributes(Vector<TransformationSourceAttribute> vector) {
        this._transformationSourceAttributes = vector;
    }

    public TransformationSourceAttribute findTransformationSourceColumn(String string) {
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            if (!transformationSourceAttribute.getName().equals(string)) continue;
            return transformationSourceAttribute;
        }
        return null;
    }

    public TransformationOutputAttribute findTransformedColumn(String string) {
        List list = this._transformedAttributes.getMapTransformedSourceType();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (MapTransformedSource mapTransformedSource : list) {
            if (!mapTransformedSource.getKey().getName().equals(string)) continue;
            return mapTransformedSource.getKey();
        }
        return null;
    }

    public Context getContext() {
        return this._context;
    }

    public void setRefreshSingleColumnStatsTable(String string) {
        this._refreshSingleColumnStatsTable = string;
    }

    public String getRefreshSingleColumnStatsTable() {
        return this._refreshSingleColumnStatsTable;
    }

    public void setTransformationNode(TransformationNode transformationNode) {
        this._transformationNode = transformationNode;
    }

    public TransformationNode getTransformationNode() {
        return this._transformationNode;
    }

    public TransformedAttributes getTransformedAttributes() {
        return this._transformedAttributes;
    }

    public TransformationStatisticsState(Context context, GraphicalPreferencesSettings graphicalPreferencesSettings, TransformationNode transformationNode, TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this.styleSelection = graphicalPreferencesSettings.getGraphStyle();
        this.depthRadius = graphicalPreferencesSettings.getRadiusDepthValue();
        this._transformationNode = transformationNode;
        this._transformedAttributes = transformedAttributes;
        this._transformationSourceAttributes = vector;
    }

    GraphDataModel initGraphModel() {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        defaultGraphDataModel.setX1(DataProfileStatisticsLrb.get("HISTOGRAM_X_AXIS"), null);
        defaultGraphDataModel.setY1(DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS"), 100.0);
        return defaultGraphDataModel;
    }

    public String getServerStatisticalTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null ? resultType.getName() : null;
    }

    public boolean hasInputStatisticTable() {
        ResultType resultType = ((TransformationNodeType)this._transformationNode.getData()).getInputStatisticTable();
        return resultType != null;
    }

    public static String getTransformationSourceAttributeDataType(TransformationNode transformationNode, String string) {
        String string2 = null;
        TransformationSourceAttributes transformationSourceAttributes = ((TransformationNodeType)transformationNode.getData()).getTransformationSourceAttributes();
        for (TransformationSourceAttribute transformationSourceAttribute : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!transformationSourceAttribute.getName().equals(string)) continue;
            string2 = transformationSourceAttribute.getDataType();
            break;
        }
        return string2;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void close() {
    }

    public void setTableModel(TransformationSettingsTableModel transformationSettingsTableModel) {
        this._tableModel = transformationSettingsTableModel;
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void loadExtendedModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new ExtendedTransformationSettingsTableModel(this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public void loadBaseModel(String string, int n) throws Exception {
        String string2 = this.getServerStatisticalTable();
        if (string2 == null) {
            this._loaded = false;
            return;
        }
        this._tableModel = new TransformationSettingsTableModel(this._transformedAttributes, this._transformationSourceAttributes, this.loadAllStatistics(string2), string, n);
        this.createAllGraphDataModelsTotalPopulation();
        this._loaded = true;
    }

    public List<DataProfileStatisticsData> loadAllStatistics(String string) throws Exception {
        List<DataProfileStatisticsData> list;
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        List<DataProfileStatisticsData> list2 = this.loadServerStatistics(string);
        if (list2 != null && !list2.isEmpty()) {
            arrayList.addAll(list2);
        }
        if (this._refreshStatsTable != null && (list = this.loadRefreshedStatistics(this._refreshStatsTable)) != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<DataProfileStatisticsData> loadRefreshedStatistics(String string) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this.resetModifiedList();
            return TransformationStatisticsState.loadStatistics(this._context, string, null, this._refreshDataPoints, this._refreshHistograms, null);
        }
        return TransformationStatisticsState.getDataPoints(this._refreshDataPoints);
    }

    public List<DataProfileStatisticsData> loadColumnRefreshedStatistics(HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, List<String> list) throws Exception {
        return TransformationStatisticsState.loadStatistics(this._context, this._refreshSingleColumnStatsTable, list, hashMap, hashMap2, null);
    }

    private List<DataProfileStatisticsData> loadServerStatistics(String string) throws Exception {
        if (this._serverDataPoints == null) {
            this._serverDataPoints = new HashMap();
            return TransformationStatisticsState.loadStatistics(this._context, string, null, this._serverDataPoints, this._serverHistograms, this._mapModified);
        }
        return TransformationStatisticsState.getDataPoints(this._serverDataPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DataProfileStatisticsData> loadStatistics(Context context, String string, List<String> list, HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, Map<String, Boolean> map) throws Exception {
        List<DataProfileStatisticsData> list2 = null;
        String string2 = null;
        Connection connection = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        try {
            Object object;
            Object object2;
            CharSequence charSequence;
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            string2 = StringUtils.getReplacedString(_QUERY, _attr_list_token, _listBuffer.toString());
            if (list == null || list.isEmpty()) {
                string2 = StringUtils.getReplacedString(string2, _where_clause, "");
            } else {
                charSequence = new StringBuilder();
                for (String string3 : list) {
                    if (charSequence.length() > 0) {
                        charSequence.append(",");
                    }
                    object2 = StringUtils.addSingleQuotes(TransformationStatisticsState.getQuotedName(StringUtils.escapeSingleQuotesForSQL(string3)));
                    charSequence.append((String)object2);
                }
                charSequence.append(")");
                object = new StringBuilder(_where_clause_template);
                ((StringBuilder)object).append(charSequence.toString());
                string2 = StringUtils.getReplacedString(string2, _where_clause, ((StringBuilder)object).toString());
            }
            string2 = StringUtils.getReplacedString(string2, _table_name_token, string);
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string2);
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            while (oracleResultSet.next()) {
                Object object3;
                Comparable<Calendar> comparable;
                Serializable serializable;
                Object object4;
                Comparable<Calendar> comparable2;
                java.util.Date date;
                Object object5;
                String string3;
                charSequence = oracleResultSet.getString(ATTR);
                object = StringUtils.trimDoubleQuotes((String)charSequence);
                if (map != null && null != map.get(object)) continue;
                string3 = oracleResultSet.getString(DATA_TYPE);
                object2 = oracleResultSet.getObject(NULL_PERCENT);
                Object object6 = oracleResultSet.getObject(DISTINCT_CNT);
                Object object7 = oracleResultSet.getObject(DISTINCT_PERCENT);
                String string4 = oracleResultSet.getString(MODE_VALUE);
                Object object8 = oracleResultSet.getObject(AVG);
                Date date2 = oracleResultSet.getDate(AVG_DATE);
                TIMESTAMPTZ tIMESTAMPTZ = oracleResultSet.getTIMESTAMPTZ(AVG_TS_TZ);
                Object object9 = oracleResultSet.getObject(MEDIAN_VAL);
                Date date3 = oracleResultSet.getDate(MEDIAN_DATE);
                TIMESTAMPTZ tIMESTAMPTZ2 = oracleResultSet.getTIMESTAMPTZ(MEDIAN_TS_TZ);
                String string5 = oracleResultSet.getString(MIN);
                String string6 = oracleResultSet.getString(MAX);
                Object object10 = oracleResultSet.getObject(STD);
                Object object11 = oracleResultSet.getObject(VAR);
                Object object12 = oracleResultSet.getObject(SKEWNESS);
                Object object13 = oracleResultSet.getObject(KURTOSIS);
                Object object14 = oracleResultSet.getObject(ATTRIBUTE_VALUE);
                Double d = oracleResultSet.getDouble(ATTRIBUTE_PERCENT);
                Double d2 = object2 == null ? null : new Double(((BigDecimal)object2).doubleValue());
                Integer n = object6 == null ? null : new Integer(((BigDecimal)object6).intValue());
                Double d3 = object7 == null ? null : new Double(((BigDecimal)object7).doubleValue());
                Double d4 = object8 == null ? null : new Double(((BigDecimal)object8).doubleValue());
                java.util.Date date4 = date2 == null ? null : new java.util.Date(date2.getTime());
                Object object15 = null;
                if (d4 != null) {
                    object15 = d4;
                } else if (date4 != null) {
                    object15 = date4;
                } else if (tIMESTAMPTZ != null) {
                    object5 = tIMESTAMPTZ.toBytes();
                    date = tIMESTAMPTZ.timestampValue(connection);
                    comparable2 = new GregorianCalendar();
                    ((Calendar)comparable2).setTime(date);
                    object4 = TimeUtils.GMT + TimeUtils.getRegionName(object5);
                    serializable = TimeUtils.toTimeZoneFromZoneId((String)object4);
                    ((GregorianCalendar)comparable2).setTimeZone((TimeZone)serializable);
                    object15 = comparable2;
                }
                object5 = object9 == null ? null : new Double(((BigDecimal)object9).doubleValue());
                date = date3 == null ? null : new java.util.Date(date3.getTime());
                comparable2 = null;
                if (object5 != null) {
                    comparable2 = (Comparable<Calendar>)object5;
                } else if (date != null) {
                    comparable2 = date;
                } else if (tIMESTAMPTZ2 != null) {
                    object4 = tIMESTAMPTZ2.toBytes();
                    serializable = tIMESTAMPTZ2.timestampValue(connection);
                    comparable = new GregorianCalendar();
                    ((Calendar)comparable).setTime((java.util.Date)serializable);
                    object3 = TimeUtils.GMT + TimeUtils.getRegionName(object4);
                    TimeZone timeZone = TimeUtils.toTimeZoneFromZoneId((String)object3);
                    ((GregorianCalendar)comparable).setTimeZone(timeZone);
                    comparable2 = comparable;
                }
                object4 = object10 == null ? null : new Double(((BigDecimal)object10).doubleValue());
                serializable = object11 == null ? null : new Double(((BigDecimal)object11).doubleValue());
                comparable = object12 == null ? null : new Double(((BigDecimal)object12).doubleValue());
                object3 = object13 == null ? null : new Double(((BigDecimal)object13).doubleValue());
                TransformationStatisticsState.addPoint(hashMap, hashMap2, (String)charSequence, string3, d2, n, d3, string4, object15, comparable2, string5, string6, (Double)object4, (Double)serializable, comparable, (Double)object3, object14, null, d);
            }
            list2 = TransformationStatisticsState.getDataPoints(hashMap);
        }
        finally {
            try {
                oracleResultSet.close();
            }
            catch (Exception exception) {}
            try {
                oraclePreparedStatement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return list2;
    }

    public TransformationSettingsTableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableModel == null) {
            return null;
        }
        DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(n);
        if (dataProfileStatisticsData == null) {
            return null;
        }
        GraphDataModel graphDataModel = dataProfileStatisticsData.getGraphDataModel();
        return graphDataModel;
    }

    public DataProfileStatisticsData getDataProfileStatisticsData(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getDataProfileStatisticsData(string);
    }

    public void setDataProfileStatisticsData(DataProfileStatisticsData dataProfileStatisticsData) {
        if (this._tableModel == null) {
            return;
        }
        this._tableModel.addDataItem(dataProfileStatisticsData);
        String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
        int n = this._tableModel.getRow(string);
        this._tableModel.fireTableRowsUpdated(n, n);
    }

    public void setDataProfileStatisticsData(List<DataProfileStatisticsData> list) {
        if (this._tableModel == null) {
            return;
        }
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this._tableModel.addDataItem(dataProfileStatisticsData);
            String string = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
            int n = this._tableModel.getRow(string);
            this._tableModel.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public String getStyleSelection() {
        return this.styleSelection;
    }

    public boolean isValidAttribute(String string) {
        return true;
    }

    public int getDepthRadius() {
        return this.depthRadius;
    }

    public GraphDataModel createDetailedGraphModel(String string) {
        GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulation(string);
        return graphDataModel;
    }

    private void createAllGraphDataModelsTotalPopulation() {
        Vector<TransformationSourceAttribute> vector = this._tableModel.getDataVector();
        for (TransformationSourceAttribute transformationSourceAttribute : vector) {
            String string = transformationSourceAttribute.getName();
            GraphDataModel graphDataModel = this.createGraphDataModelTotalPopulationGeneric(string);
            if (graphDataModel == null) {
                return;
            }
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            DataProfileStatisticsData dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(string);
            if (dataProfileStatisticsData == null) continue;
            dataProfileStatisticsData.setGraphDataModel(graphDataModel);
        }
    }

    GraphDataModel createGraphDataModelTotalPopulation(String string) {
        return this.createGraphDataModelTotalPopulationGeneric(string);
    }

    GraphDataModel createGraphDataModelTotalPopulationGeneric(String string) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        AttributeHistogramArray attributeHistogramArray = this.getHistogram(string);
        if (attributeHistogramArray == null || attributeHistogramArray.isEmpty()) {
            return graphDataModel;
        }
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createDetailedRefreshedGraphModel(String string, AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        if (bl) {
            graphDataModel.setTitle(string);
            graphDataModel.setDepthRadius(this.depthRadius);
        }
        graphDataModel.setLegendVisible(false);
        return graphDataModel;
    }

    GraphDataModel createBriefRefreshedGraphModel(String string, AttributeHistogramArray attributeHistogramArray) {
        boolean bl = true;
        GraphDataModel graphDataModel = this.initGraphModel();
        ArrayList<String> arrayList = attributeHistogramArray.getBarTitles();
        if (arrayList == null || arrayList.isEmpty()) {
            return graphDataModel;
        }
        int n = arrayList.size();
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = bl ? DataProfileStatisticsLrb.get("HISTOGRAM_Y_AXIS") : "";
            for (int j = 0; j < n; ++j) {
                String string2 = arrayList.get(j);
                ArrayList<NameValuePair> arrayList2 = attributeHistogramArray.getBarArray(string2.toString());
                NameValuePair nameValuePair = arrayList2.get(0);
                Object object = nameValuePair.getValue();
                assert (object instanceof Double) : "Wrong data for this graph";
                objectArray[j][i] = nameValuePair.getValue();
                objectArray2[j] = bl ? string2 : "";
            }
        }
        graphDataModel.addColumnLabels(objectArray2);
        graphDataModel.addRowLabels(objectArray3);
        graphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        graphDataModel.addGraphData(objectArray);
        graphDataModel.setTitle(null);
        graphDataModel.setLegendVisible(false);
        graphDataModel.setDepthRadius(0);
        graphDataModel.setLineDataLineDisplayed(false);
        return graphDataModel;
    }

    private void clearServerResults() {
        if (this._serverHistograms != null) {
            this._serverHistograms.clear();
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.clear();
        }
    }

    private void clearRefreshedResults() {
        if (this._refreshHistograms != null) {
            this._refreshHistograms.clear();
            if (this._refreshDataPoints != null) {
                this._refreshDataPoints.clear();
                this._refreshDataPoints = null;
            }
        }
    }

    private static List<DataProfileStatisticsData> getDataPoints(HashMap<String, DataProfileStatisticsData> hashMap) {
        ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    private static void addPoint(HashMap<String, DataProfileStatisticsData> hashMap, HashMap<String, AttributeHistogramArray> hashMap2, String string, String string2, Double d, Integer n, Double d2, String string3, Object object, Object object2, String string4, String string5, Double d3, Double d4, Double d5, Double d6, Object object3, String string6, Double d7) {
        AttributeHistogramArray attributeHistogramArray;
        if (null == hashMap.get(string)) {
            hashMap.put(string, new DataProfileStatisticsData(string, string2, d, n, d2, string3, object, object2, string4, string5, d3, d4, d5, d6));
        }
        if ((attributeHistogramArray = hashMap2.get(string)) == null) {
            attributeHistogramArray = new AttributeHistogramArray();
            hashMap2.put(string, attributeHistogramArray);
        }
        attributeHistogramArray.addPoint(object3, string6, d7);
    }

    public void updateRefreshedData(String string, AttributeHistogramArray attributeHistogramArray, DataProfileStatisticsData dataProfileStatisticsData) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        String string2 = TransformationStatisticsState.getQuotedName(string);
        this._refreshHistograms.put(string2, attributeHistogramArray);
        this._refreshDataPoints.put(string2, dataProfileStatisticsData);
        this.resetModifiedState(string);
    }

    public void updateRefreshedDataWiz(List<String> list, HashMap<String, AttributeHistogramArray> hashMap, Map<String, DataProfileStatisticsData> map) throws Exception {
        if (this._refreshDataPoints == null) {
            this._refreshDataPoints = new HashMap();
            this._refreshStatsTable = this._refreshSingleColumnStatsTable;
            this._refreshSingleColumnStatsTable = null;
        }
        for (String string : list) {
            String string2 = TransformationStatisticsState.getQuotedName(string);
            this._refreshHistograms.put(string2, hashMap.get(string2));
            this._refreshDataPoints.put(string2, map.get(string2));
        }
        for (String string : list) {
            this.resetModifiedState(string);
        }
    }

    private AttributeHistogramArray getHistogram(String string) {
        AttributeHistogramArray attributeHistogramArray = null;
        if (!this.isModified(string)) {
            if (this._serverHistograms != null) {
                attributeHistogramArray = this._serverHistograms.get(TransformationStatisticsState.getQuotedName(string));
            }
        } else if (!this.needsRefresh(string) && this._refreshHistograms != null) {
            attributeHistogramArray = this._refreshHistograms.get(TransformationStatisticsState.getQuotedName(string));
        }
        return attributeHistogramArray;
    }

    void removeAllData(String string) {
        if (this._serverHistograms != null) {
            this._serverHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._serverDataPoints != null) {
            this._serverDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshHistograms != null) {
            this._refreshHistograms.remove(TransformationStatisticsState.getQuotedName(string));
        }
        if (this._refreshDataPoints != null) {
            this._refreshDataPoints.remove(TransformationStatisticsState.getQuotedName(string));
        }
    }

    public static String getQuotedName(String string) {
        if (StringUtils.isDoubleQuotedString(string)) {
            return string;
        }
        return StringUtils.addDoubleQuotes(string);
    }

    public Object getMissingValuesDefaultReplacementValue(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMissingValuesReplacementValue(transformationSourceAttribute);
    }

    public Double getStd(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getStd(transformationSourceAttribute);
    }

    public Object getAvg(TransformationSourceAttribute transformationSourceAttribute) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getAvg(transformationSourceAttribute);
    }

    public Double getMin(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMin(string);
    }

    public Double getMax(String string) {
        if (this._tableModel == null) {
            return null;
        }
        return this._tableModel.getMax(string);
    }

    private Color[] generateColors(int n) {
        int n2 = _RESERVED_COLORS.length + _EXTRA_COLORS[0].length * 2;
        if (n > n2) {
            return this.generateRandomColors(n);
        }
        Color[] colorArray = new Color[n];
        if (n <= _RESERVED_COLORS.length) {
            System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, n);
            return colorArray;
        }
        System.arraycopy(_RESERVED_COLORS, 0, colorArray, 0, _RESERVED_COLORS.length);
        int n3 = _RESERVED_COLORS.length;
        int n4 = n - n3;
        if (n4 < _EXTRA_COLORS[0].length) {
            System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, n4);
            return colorArray;
        }
        System.arraycopy(_EXTRA_COLORS[0], 0, colorArray, n3, _EXTRA_COLORS[0].length);
        n4 = n - (n3 += _EXTRA_COLORS[0].length);
        System.arraycopy(_EXTRA_COLORS[1], 0, colorArray, n3, n4);
        return colorArray;
    }

    private Color[] generateRandomColors(int n) {
        Color[] colorArray = new Color[n];
        int n2 = 2;
        while (!(Math.pow(++n2, 3.0) >= (double)n)) {
        }
        int n3 = 255 / n2;
        int n4 = 0;
        block1: for (int i = 255; i >= 0; i -= n3) {
            for (int j = 0; j <= 255; j += n3) {
                for (int k = 255; k >= 0; k -= n3) {
                    colorArray[n4++] = new Color(i, j, k);
                    if (n4 == n - 1) break block1;
                }
            }
        }
        return colorArray;
    }

    private static String getStackedSQL(TransformationNode transformationNode) {
        AbstractNode abstractNode = transformationNode.findParentNode();
        assert (abstractNode instanceof DataProvider);
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        return dataProvider.getInputSQL();
    }

    public void setDistinctValues(String string, List<String> list) {
        this.distinctValues.remove(string);
        this.distinctValues.put(string, new ArrayList<String>(list));
    }

    public List<String> getDistinctValues(String string) {
        if (this.distinctValues.isEmpty()) {
            List<String> list = this.getDistinctValuesFromDB(string);
            this.distinctValues.put(string, list);
            return list;
        }
        return this.distinctValues.get(string);
    }

    public Vector<NameValuePair> generateDefaultBins(String string, String string2, TransformationType.Binning binning) throws Exception {
        if (string2.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string2) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string2)) {
            return TransformationStatisticsState._generateDefaultDateBins(this._context, this._transformationNode, string, binning, false);
        }
        if (DatabaseMetadataUtils.isTimestampWithTimeZone(string2)) {
            return TransformationStatisticsState._generateDefaultDateBins(this._context, this._transformationNode, string, binning, true);
        }
        return TransformationStatisticsState._generateDefaultBins(this._context, this._transformationNode, string, string2, binning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultBins(Context context, TransformationNode transformationNode, String string, String string2, TransformationType.Binning binning) throws Exception {
        int n;
        String string3;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        String string4 = TransformationStatisticsState.getStackedSQL(transformationNode);
        if (string4 == null) {
            return vector;
        }
        int n2 = 0;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl = false;
        if (null != binning.getEqualWidth()) {
            string3 = EQWIDTH;
            n2 = null != binning.getEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getEqualWidth().getBinCount();
            binLabels = binning.getEqualWidth().getBinLabels();
        } else if (null != binning.getDateEqualWidth()) {
            string3 = EQWIDTH;
            n2 = null != binning.getDateEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getDateEqualWidth().getBinCount();
            binLabels = binning.getDateEqualWidth().getBinLabels();
        } else if (null != binning.getTimestampEqualWidth()) {
            string3 = EQWIDTH;
            n2 = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getTimestampEqualWidth().getBinCount();
            binLabels = binning.getTimestampEqualWidth().getBinLabels();
        } else if (null != binning.getQuantile()) {
            string3 = QTILE;
            n2 = null != binning.getQuantile().getBinGeneration().getAuto() ? 1 : 0;
            bigInteger = binning.getQuantile().getBinCount();
            binLabels = binning.getQuantile().getBinLabels();
        } else {
            string3 = TOPN;
            bigInteger = binning.getTopN().getBinCount();
        }
        int n3 = bigInteger != null ? (string3 != TOPN ? bigInteger.intValue() - 2 : bigInteger.intValue()) : (n = 0);
        if (binLabels != null) {
            bl = null != binLabels.getNumberSequence();
        }
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n4;
            String[] stringArray;
            int n5;
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)connection);
            ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)connection);
            ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor2, connection, (Object)new String[0]);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            ARRAY aRRAY5 = new ARRAY(arrayDescriptor3, connection, (Object)new String[0]);
            String string5 = StringUtils.isDoubleQuotedString(string) ? string : StringUtils.addDoubleQuotes(string);
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_UTIL.GENERATE_DEFAULT_BINS(?,?,?,?,?,?,?,?,?,?,?)}");
            int n6 = 1;
            oracleCallableStatement.setCharacterStream(n6++, (Reader)new StringReader(string4), string4.length());
            oracleCallableStatement.setArray(n6++, (Array)aRRAY);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY2);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY3);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY4);
            oracleCallableStatement.setArray(n6++, (Array)aRRAY5);
            oracleCallableStatement.setString(n6++, string5);
            oracleCallableStatement.setString(n6++, string2);
            oracleCallableStatement.setString(n6++, string3);
            oracleCallableStatement.setInt(n6++, n2);
            oracleCallableStatement.setInt(n6++, n);
            n6 = 2;
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_NAMES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_IDS);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.registerOutParameter(n6++, 2003, ODMR_OBJECT_VALUES);
            oracleCallableStatement.execute();
            n6 = 2;
            ARRAY aRRAY6 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray2 = (String[])aRRAY6.getArray();
            ARRAY aRRAY7 = oracleCallableStatement.getARRAY(n6++);
            BigDecimal[] bigDecimalArray = (BigDecimal[])aRRAY7.getArray();
            ARRAY aRRAY8 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray3 = (String[])aRRAY8.getArray();
            ARRAY aRRAY9 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray4 = (String[])aRRAY9.getArray();
            ARRAY aRRAY10 = oracleCallableStatement.getARRAY(n6++);
            String[] stringArray5 = (String[])aRRAY10.getArray();
            if (stringArray4 != null && stringArray4.length > 0 && stringArray4[0] == null) {
                n5 = 0;
                stringArray = new String[stringArray4.length + 1];
                stringArray[n5] = "1";
                for (n4 = 1; n4 < stringArray4.length; ++n4) {
                    ++n5;
                    try {
                        stringArray[n5] = String.valueOf(Integer.valueOf(stringArray4[n4]) + 1);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringArray[n5] = stringArray4[n4];
                    }
                }
                stringArray[n5 + 1] = String.valueOf(Integer.valueOf(stringArray[n5]) + 1);
            } else {
                stringArray = stringArray4;
            }
            if (string3.equals(TOPN)) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (n4 = 0; n4 < stringArray3.length; ++n4) {
                    object4 = stringArray3[n4];
                    object3 = stringArray3[n4];
                    if (object3 == null || ((String)object3).isEmpty()) {
                        object3 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                        object4 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    } else {
                        object3 = stringArray3[n4].trim();
                        if (object3 == null || ((String)object3).isEmpty()) {
                            object3 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                            object4 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                        }
                    }
                    if (null != hashMap.get(object3)) continue;
                    object2 = new ArrayList();
                    object2.add(object4);
                    object = new NameValuePair((String)object3, object2, n4);
                    vector.add((NameValuePair)object);
                    hashMap.put(object3, object);
                }
            } else {
                n5 = 0;
                for (n4 = 0; n4 < bigDecimalArray.length - 1; ++n4) {
                    object4 = null;
                    object3 = bigDecimalArray[n4];
                    Object object5 = object2 = object3 != null ? ((BigDecimal)object3).toString() : "0";
                    if (n4 == 0) {
                        object4 = !bl ? new NameValuePair(UNBOUNDED + " - " + (String)object2, (Object)NO_LOWER_BOUND, n5) : new NameValuePair(stringArray[n5], (Object)NO_LOWER_BOUND, n5);
                        ++n5;
                        vector.add((NameValuePair)object4);
                    }
                    if (!bl) {
                        object = bigDecimalArray[n4] + " - " + bigDecimalArray[n4 + 1];
                        object4 = new NameValuePair((String)object, (Object)bigDecimalArray[n4].toString(), n5);
                    } else {
                        object4 = new NameValuePair(stringArray[n5], (Object)bigDecimalArray[n4].toString(), n5);
                    }
                    ++n5;
                    vector.add((NameValuePair)object4);
                }
                NameValuePair nameValuePair = null;
                if (bigDecimalArray != null && bigDecimalArray.length > 0) {
                    object4 = bigDecimalArray[bigDecimalArray.length - 1] + "";
                    nameValuePair = !bl ? new NameValuePair((String)object4 + " - " + UNBOUNDED, object4, n5) : new NameValuePair(stringArray[n5], object4, n5);
                    vector.add(nameValuePair);
                }
            }
            if (string3.equals(TOPN) && !vector.isEmpty()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < stringArray5.length; ++i) {
                    object4 = stringArray5[i];
                    if (object4 == null || ((String)object4).isEmpty()) {
                        object4 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                    } else {
                        object4 = stringArray5[i];
                        if (object4 == null || ((String)object4).isEmpty()) {
                            object4 = XformDialogsLrb.get("TRANSFORM_NULL_VALUE");
                        }
                    }
                    arrayList.add(object4);
                }
                vector.add(new NameValuePair(LIST_OF_DISTINCT_VALUES, arrayList));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"));
            vector.clear();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return vector;
    }

    private static String removeWithClause(String string, String string2, int n) {
        int n2 = string.indexOf("WITH");
        if (n2 == -1) {
            String string3 = queryDateTemplate;
            string3 = StringUtils.getReplacedString(string3, "<column>", string2);
            string3 = StringUtils.getReplacedString(string3, "<bin_number>", String.valueOf(n));
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string);
            return string3;
        }
        int n3 = string.indexOf("*/");
        int n4 = string.indexOf(" as ");
        if (n4 == -1) {
            n4 = string.indexOf(" AS ");
        }
        String string4 = string.substring(n3 + 2, n4);
        n4 = string.indexOf("/* END OF SQL FOR NODE:");
        String string5 = string.substring(0, n4);
        String string6 = queryDateTemplate_no_with;
        string6 = StringUtils.getReplacedString(string6, "<column>", string2);
        string6 = StringUtils.getReplacedString(string6, "<bin_number>", String.valueOf(n));
        string6 = StringUtils.getReplacedString(string6, "<stacked_sql_view>", string5);
        string6 = StringUtils.getReplacedString(string6, "<table_name>", string4);
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultDateBins(Context context, TransformationNode transformationNode, String string, TransformationType.Binning binning, boolean bl) throws Exception {
        int n;
        if (bl) {
            return TransformationStatisticsState._generateDefaultTZBins(context, transformationNode, string, binning);
        }
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        String string2 = TransformationStatisticsState.getStackedSQL(transformationNode);
        if (string2 == null) {
            return vector;
        }
        boolean bl2 = false;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl3 = false;
        if (null == binning.getDateEqualWidth()) {
            return vector;
        }
        bl2 = null != binning.getDateEqualWidth().getBinGeneration().getAuto();
        bigInteger = binning.getDateEqualWidth().getBinCount();
        binLabels = binning.getDateEqualWidth().getBinLabels();
        int n2 = n = bigInteger != null ? bigInteger.intValue() - 2 : 0;
        if (binLabels != null) {
            bl3 = null != binLabels.getNumberSequence();
        }
        Connection connection = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            Comparable<Integer> comparable;
            Comparable<StringBuffer> comparable2;
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string3 = StringUtils.isDoubleQuotedString(string) ? string : StringUtils.addDoubleQuotes(string);
            String string4 = TransformationStatisticsState.removeWithClause(string2, string3, n);
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string4);
            OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            String string5 = NO_LOWER_BOUND;
            SimpleDateFormat simpleDateFormat = null;
            Timestamp timestamp = null;
            long l = 0L;
            if (oracleResultSet.next()) {
                timestamp = oracleResultSet.getTimestamp("min_value");
                comparable2 = oracleResultSet.getTimestamp("max_value");
                l = (((java.util.Date)comparable2).getTime() - ((java.util.Date)timestamp).getTime()) / (long)n;
                simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
            }
            comparable2 = new StringBuffer();
            StringBuffer stringBuffer = simpleDateFormat.format((java.util.Date)timestamp, (StringBuffer)comparable2, new FieldPosition(0));
            NameValuePair nameValuePair = null;
            Integer n3 = 1;
            String string6 = n3.toString();
            nameValuePair = !bl3 ? new NameValuePair(UNBOUNDED + " - " + stringBuffer.toString(), (Object)NO_LOWER_BOUND, (int)n3) : new NameValuePair(string6, (Object)NO_LOWER_BOUND, (int)n3);
            string5 = stringBuffer.toString();
            vector.add(nameValuePair);
            for (int i = 0; i < n; ++i) {
                comparable = n3;
                n3 = n3 + 1;
                Comparable<Integer> comparable3 = n3;
                string6 = n3.toString();
                comparable = new java.util.Date(((java.util.Date)timestamp).getTime() + l * (long)(i + 1));
                comparable2 = new StringBuffer();
                comparable3 = simpleDateFormat.format((java.util.Date)comparable, (StringBuffer)comparable2, new FieldPosition(0));
                if (!bl3) {
                    String string7 = string5 + " - " + ((StringBuffer)comparable3).toString();
                    nameValuePair = new NameValuePair(string7, (Object)string5, (int)n3);
                } else {
                    nameValuePair = new NameValuePair(string6, (Object)string5, (int)n3);
                }
                string5 = ((StringBuffer)comparable3).toString();
                vector.add(nameValuePair);
            }
            if (!vector.isEmpty()) {
                if (!bl3) {
                    nameValuePair = new NameValuePair(string5 + " - " + UNBOUNDED, (Object)string5, vector.size() + 1);
                    vector.add(nameValuePair);
                } else {
                    Integer n4 = n3;
                    comparable = n3 = Integer.valueOf(n3 + 1);
                    string6 = n3.toString();
                    nameValuePair = new NameValuePair(string6, (Object)string5, (int)n3);
                    vector.add(nameValuePair);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vector.clear();
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<NameValuePair> _generateDefaultTZBins(Context context, TransformationNode transformationNode, String string, TransformationType.Binning binning) throws Exception {
        int n;
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        String string2 = TransformationStatisticsState.getStackedSQL(transformationNode);
        if (string2 == null) {
            return vector;
        }
        boolean bl = false;
        BigInteger bigInteger = null;
        BinLabels binLabels = null;
        boolean bl2 = false;
        if (null == binning.getTimestampEqualWidth()) {
            return vector;
        }
        bl = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto();
        bigInteger = binning.getTimestampEqualWidth().getBinCount();
        binLabels = binning.getTimestampEqualWidth().getBinLabels();
        int n2 = n = bigInteger != null ? bigInteger.intValue() - 2 : 0;
        if (binLabels != null) {
            bl2 = null != binLabels.getNumberSequence();
        }
        Connection connection = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        Statement statement = null;
        try {
            Object object;
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string3 = StringUtils.isDoubleQuotedString(string) ? string : StringUtils.addDoubleQuotes(string);
            statement = connection.prepareCall("{ ? = call ODMR_UTIL.GENERATE_DEFAULT_TS_TZ_BINS(?,?,?)}");
            int n3 = 1;
            statement.registerOutParameter(n3++, 12);
            statement.setCharacterStream(n3++, new StringReader(string2), string2.length());
            statement.setString(n3++, string3);
            statement.setInt(n3++, n);
            statement.execute();
            n3 = 1;
            String string4 = statement.getString(n3);
            if (statement != null) {
                statement.close();
                statement = null;
            }
            String string5 = "select to_char(to_timestamp_tz(lower_bound,'dd.mm.yyyy hh24:mi:ss tzh:tzm'),'YYYY-MM-DD HH24:MI:SS TZH:TZM') lower_bound,to_char(to_timestamp_tz(lower_bound,'dd.mm.yyyy hh24:mi:ss tzh:tzm'),'YYYY-MM-DD HH24:MI:SS TZH:TZM') upper_bound from " + string4;
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string5);
            OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            Object var19_20 = null;
            Integer n4 = 1;
            String string6 = null;
            while (oracleResultSet.next()) {
                Integer n5;
                Integer n6;
                object = oracleResultSet.getString("lower_bound");
                String string7 = oracleResultSet.getString("upper_bound");
                NameValuePair nameValuePair = null;
                if (!bl2) {
                    if (n4 == 1) {
                        n6 = n4;
                        n5 = n4 = Integer.valueOf(n4 + 1);
                        nameValuePair = new NameValuePair(UNBOUNDED + " - " + (String)object, (Object)NO_LOWER_BOUND, (int)n6);
                        vector.add(nameValuePair);
                    }
                    n6 = n4;
                    n5 = n4 = Integer.valueOf(n4 + 1);
                    nameValuePair = new NameValuePair((String)object + " - " + string7, object, (int)n6);
                } else {
                    if (n4 == 1) {
                        String string8 = n4.toString();
                        n6 = n4;
                        n5 = n4 = Integer.valueOf(n4 + 1);
                        nameValuePair = new NameValuePair(string8, (Object)NO_LOWER_BOUND, (int)n6);
                        vector.add(nameValuePair);
                    }
                    String string9 = n4.toString();
                    n6 = n4;
                    n5 = n4 = Integer.valueOf(n4 + 1);
                    nameValuePair = new NameValuePair(string9, object, (int)n6);
                }
                string6 = string7;
                vector.add(nameValuePair);
            }
            object = null;
            if (!vector.isEmpty()) {
                object = !bl2 ? new NameValuePair(string6 + " - " + UNBOUNDED, string6, (int)n4) : new NameValuePair(n4.toString(), string6, (int)n4);
                vector.add((NameValuePair)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vector.clear();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshAllStatistics() throws Exception {
        if (this.isUpToDate()) {
            return false;
        }
        try {
            ArrayList<String> arrayList = null;
            ArrayList<String> arrayList2 = null;
            for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
                DataProfileStatisticsData dataProfileStatisticsData;
                if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList2 = new ArrayList<String>();
                }
                arrayList.add(transformationSourceAttribute.getName());
                arrayList2.add(transformationSourceAttribute.getDataType());
            }
            this._refreshStatsTable = TransformationStatisticsState.refreshStatistics(this._context, arrayList, arrayList2, this._transformedAttributes, this._transformationNode, this._refreshStatsTable, null);
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearRefreshedResults();
        }
    }

    public void refreshSingleColumnStatistics(String string) throws Exception {
        Object object;
        Object object22;
        if (!this.isModified(string)) {
            return;
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object22 : this._transformedAttributes.getMapTransformedSourceType()) {
                object = object22.getKey();
                if (!object.getName().equals(string)) continue;
                list.add(object22);
                break;
            }
        }
        Object object3 = null;
        object22 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || DatabaseMetadataUtils.isACustomDataType(this._context, transformationSourceAttribute.getDataType()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object22 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object22.add(transformationSourceAttribute.getDataType());
        }
        object = this.getServerStatisticalTable();
        if (object != null) {
            this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object22, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, (String)object);
        }
    }

    public void refreshSelectedColumnsStatistics(List<String> list) throws Exception {
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object22 : list) {
            if (!this.isModified(object22)) continue;
            hashMap.put(object22, object22);
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        List list2 = transformedAttributes.getMapTransformedSourceType();
        if (null != this._transformedAttributes && !this._transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (Object object2 : this._transformedAttributes.getMapTransformedSourceType()) {
                TransformationOutputAttribute transformationOutputAttribute = object2.getKey();
                if (null == hashMap.get(transformationOutputAttribute.getName())) continue;
                list2.add(object2);
            }
        }
        Object object3 = null;
        object2 = null;
        for (TransformationSourceAttribute transformationSourceAttribute : this._transformationSourceAttributes) {
            DataProfileStatisticsData dataProfileStatisticsData;
            if (null != this.findTransformedColumn(transformationSourceAttribute.getName()) || (dataProfileStatisticsData = this._tableModel.getDataProfileStatisticsData(transformationSourceAttribute.getName())) != null) continue;
            if (object3 == null) {
                object3 = new ArrayList();
                object2 = new ArrayList();
            }
            object3.add((String)transformationSourceAttribute.getName());
            object2.add(transformationSourceAttribute.getDataType());
        }
        this._refreshSingleColumnStatsTable = TransformationStatisticsState.refreshStatistics(this._context, object3, (List<String>)object2, transformedAttributes, this._transformationNode, this._refreshSingleColumnStatsTable, this.getServerStatisticalTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String refreshStatistics(Context context, List<String> list, List<String> list2, TransformedAttributes transformedAttributes, TransformationNode transformationNode, String string, String string2) throws Exception {
        StringBuffer stringBuffer;
        Comparable<StringBuffer> comparable;
        Comparable<StringBuffer> comparable2;
        CharSequence charSequence;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        StringBuilder stringBuilder;
        StringCollection stringCollection;
        TransformationOutputAttribute transformationOutputAttribute;
        MapTransformedSource mapTransformedSource;
        Object object62;
        Object object7;
        Object object8;
        ResultType resultType = ((TransformationNodeType)transformationNode.getData()).getSampleSettings().getOutputTable();
        String string3 = resultType.getName();
        assert (string3 != null);
        if (list != null && !list.isEmpty() && !TransformationStatisticsState.areColumnsPresentInSampleTable(context, string3, list) && (object8 = transformationNode.findParentNode()) != null && object8 instanceof DataProvider && null != (object7 = (DataProvider)object8).getInputSQL()) {
            string3 = "(" + object7.getInputSQL() + ")";
        }
        object8 = new ArrayList();
        object7 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<Double> arrayList8 = new ArrayList<Double>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        ArrayList<String> arrayList10 = new ArrayList<String>();
        ArrayList<Integer> arrayList11 = new ArrayList<Integer>();
        ArrayList<String> arrayList12 = new ArrayList<String>();
        ArrayList<String> arrayList13 = new ArrayList<String>();
        ArrayList<String> arrayList14 = new ArrayList<String>();
        ArrayList<String> arrayList15 = new ArrayList<String>();
        ArrayList<Integer> arrayList16 = new ArrayList<Integer>();
        ArrayList<String> arrayList17 = new ArrayList<String>();
        ArrayList<String> arrayList18 = new ArrayList<String>();
        ArrayList<String> arrayList19 = new ArrayList<String>();
        ArrayList<String> arrayList20 = new ArrayList<String>();
        ArrayList<String> arrayList21 = new ArrayList<String>();
        ArrayList<Integer> arrayList22 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList23 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList24 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList25 = new ArrayList<Integer>();
        ArrayList<String> arrayList26 = new ArrayList<String>();
        ArrayList<String> arrayList27 = new ArrayList<String>();
        ArrayList<Integer> arrayList28 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList29 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList30 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList31 = new ArrayList<Integer>();
        ArrayList<String> arrayList32 = new ArrayList<String>();
        ArrayList<String> arrayList33 = new ArrayList<String>();
        ArrayList<Integer> arrayList34 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList35 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList36 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList37 = new ArrayList<Integer>();
        ArrayList<String> arrayList38 = new ArrayList<String>();
        ArrayList<String> arrayList39 = new ArrayList<String>();
        ArrayList<Integer> arrayList40 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList41 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList42 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList43 = new ArrayList<Integer>();
        ArrayList<String> arrayList44 = new ArrayList<String>();
        ArrayList<String> arrayList45 = new ArrayList<String>();
        ArrayList<Integer> arrayList46 = new ArrayList<Integer>();
        ArrayList<String> arrayList47 = new ArrayList<String>();
        ArrayList<String> arrayList48 = new ArrayList<String>();
        ArrayList<String> arrayList49 = new ArrayList<String>();
        ArrayList<Integer> arrayList50 = new ArrayList<Integer>();
        ArrayList<String> arrayList51 = new ArrayList<String>();
        ArrayList<String> arrayList52 = new ArrayList<String>();
        ArrayList<String> arrayList53 = new ArrayList<String>();
        ArrayList<String> arrayList54 = new ArrayList<String>();
        ArrayList<String> arrayList55 = new ArrayList<String>();
        ArrayList<String> arrayList56 = new ArrayList<String>();
        ArrayList<String> arrayList57 = new ArrayList<String>();
        ArrayList<String> arrayList58 = new ArrayList<String>();
        ArrayList<String> arrayList59 = new ArrayList<String>();
        ArrayList<Double> arrayList60 = new ArrayList<Double>();
        ArrayList<String> arrayList61 = new ArrayList<String>();
        ArrayList<String> arrayList62 = new ArrayList<String>();
        ArrayList<String> arrayList63 = new ArrayList<String>();
        ArrayList<String> arrayList64 = new ArrayList<String>();
        ArrayList<String> arrayList65 = new ArrayList<String>();
        ArrayList<String> arrayList66 = new ArrayList<String>();
        ArrayList<String> arrayList67 = new ArrayList<String>();
        ArrayList<String> arrayList68 = new ArrayList<String>();
        ArrayList<String> arrayList69 = new ArrayList<String>();
        ArrayList<String> arrayList70 = new ArrayList<String>();
        ArrayList<String> arrayList71 = new ArrayList<String>();
        ArrayList<String> arrayList72 = new ArrayList<String>();
        ArrayList<Double> arrayList73 = new ArrayList<Double>();
        ArrayList<Double> arrayList74 = new ArrayList<Double>();
        ArrayList<Double> arrayList75 = new ArrayList<Double>();
        ArrayList<Double> arrayList76 = new ArrayList<Double>();
        ArrayList<Double> arrayList77 = new ArrayList<Double>();
        ArrayList<String> arrayList78 = new ArrayList<String>();
        ArrayList<String> arrayList79 = new ArrayList<String>();
        ArrayList<String> arrayList80 = new ArrayList<String>();
        ArrayList<Double> arrayList81 = new ArrayList<Double>();
        ArrayList<Double> arrayList82 = new ArrayList<Double>();
        ArrayList<String> arrayList83 = new ArrayList<String>();
        ArrayList<String> arrayList84 = new ArrayList<String>();
        ArrayList<String> arrayList85 = new ArrayList<String>();
        TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
        TransformationSourceAttributes transformationSourceAttributes = transformationNodeType.getTransformationSourceAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object62 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            hashMap.put(object62.getName(), object62);
        }
        List list3 = transformedAttributes.getMapTransformedSourceType();
        object62 = list3.iterator();
        while (object62.hasNext()) {
            TransformationType.Binning.CustomCategorical customCategorical;
            String string42;
            mapTransformedSource = (MapTransformedSource)object62.next();
            transformationOutputAttribute = mapTransformedSource.getKey();
            stringCollection = mapTransformedSource.getStringCollectionNames();
            stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string42 : stringCollection.getValue()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                    stringBuilder2.append(", ");
                }
                stringBuilder.append(string42);
                stringBuilder2.append(((TransformationSourceAttribute)hashMap.get(string42)).getDataType());
            }
            if (!transformationOutputAttribute.isModified()) continue;
            TransformationType transformationType = transformationOutputAttribute.getTransformationElementType();
            string42 = transformationType.getBinning();
            if (null != string42) {
                if (null != string42.getCustomCategorical()) {
                    customCategorical = string42.getCustomCategorical();
                    object5 = customCategorical.getCategoricalBin();
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (CategoricalBin)object4.next();
                        object2 = object3.getStringCollectionValues().getValue();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            charSequence = (String)object.next();
                            object8.add(transformationOutputAttribute.getName());
                            object7.add(stringBuilder.toString());
                            arrayList.add(object3.getName());
                            arrayList2.add(object3.isIsOther() ? 1 : 0);
                            arrayList3.add((String)charSequence);
                        }
                    }
                    continue;
                }
                if (null != string42.getCustomDate()) {
                    customCategorical = string42.getCustomDate();
                    object5 = customCategorical.getBinLabels();
                    object4 = customCategorical.getDateBin();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (DateBin)object3.next();
                        arrayList9.add(transformationOutputAttribute.getName());
                        arrayList10.add(stringBuilder.toString());
                        arrayList11.add(null != object5.getNumberSequence() ? 1 : 0);
                        arrayList12.add(object2.getName());
                        object = TimeUtils.getShortSimpleDateFormat();
                        charSequence = new StringBuffer();
                        if (null != object2.getLowerBound().getValue()) {
                            comparable2 = object2.getLowerBound().getValue().toGregorianCalendar().getTime();
                            comparable = ((SimpleDateFormat)object).format((java.util.Date)comparable2, (StringBuffer)charSequence, new FieldPosition(0));
                            arrayList13.add(comparable.toString());
                            continue;
                        }
                        arrayList13.add(null);
                    }
                    continue;
                }
                if (null != string42.getCustomTimestamp()) {
                    customCategorical = string42.getCustomTimestamp();
                    object5 = customCategorical.getBinLabels();
                    object4 = customCategorical.getTimestampTimezoneBin();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (TimestampTimezoneBin)object3.next();
                        arrayList14.add(transformationOutputAttribute.getName());
                        arrayList15.add(stringBuilder.toString());
                        arrayList16.add(null != object5.getNumberSequence() ? 1 : 0);
                        arrayList17.add(object2.getName());
                        object = TimeUtils.getShortSimpleDateFormatZoneRFC();
                        charSequence = new StringBuffer();
                        if (null != object2.getLowerBound().getValue()) {
                            comparable2 = object2.getLowerBound().getValue().toGregorianCalendar();
                            ((DateFormat)object).setTimeZone(((GregorianCalendar)comparable2).getTimeZone());
                            comparable = object2.getLowerBound().getValue().toGregorianCalendar().getTime();
                            stringBuffer = ((SimpleDateFormat)object).format((java.util.Date)comparable, (StringBuffer)charSequence, new FieldPosition(0));
                            arrayList18.add(stringBuffer.toString());
                            continue;
                        }
                        arrayList18.add(null);
                    }
                    continue;
                }
                if (null != string42.getCustomNumeric()) {
                    customCategorical = string42.getCustomNumeric();
                    object5 = customCategorical.getBinLabels();
                    object4 = customCategorical.getNumericBin();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (NumericBin)object3.next();
                        arrayList4.add(transformationOutputAttribute.getName());
                        arrayList5.add(stringBuilder.toString());
                        arrayList6.add(null != object5.getNumberSequence() ? 1 : 0);
                        arrayList7.add(object2.getBinName());
                        arrayList8.add(object2.getLowerBound());
                    }
                    continue;
                }
                if (null != string42.getEqualWidth()) {
                    customCategorical = string42.getEqualWidth();
                    arrayList19.add(transformationOutputAttribute.getName());
                    arrayList20.add(stringBuilder.toString());
                    arrayList21.add(stringBuilder2.toString());
                    arrayList22.add(customCategorical.getBinCount().intValue());
                    object5 = customCategorical.getBinGeneration();
                    arrayList23.add(null != object5.getAuto() ? 1 : 0);
                    arrayList24.add(null != object5.getManual() ? 1 : 0);
                    object4 = customCategorical.getBinLabels();
                    arrayList25.add(null != object4.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null != string42.getDateEqualWidth()) {
                    customCategorical = string42.getDateEqualWidth();
                    object5 = customCategorical.getBinGeneration();
                    object4 = customCategorical.getBinLabels();
                    object3 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, stringBuilder.toString());
                    if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object3)) {
                        arrayList26.add(transformationOutputAttribute.getName());
                        arrayList27.add(stringBuilder.toString());
                        arrayList28.add(customCategorical.getBinCount().intValue());
                        arrayList29.add(null != object5.getAuto() ? 1 : 0);
                        arrayList30.add(null != object5.getManual() ? 1 : 0);
                        arrayList31.add(null != object4.getNumberSequence() ? 1 : 0);
                        continue;
                    }
                    arrayList32.add(transformationOutputAttribute.getName());
                    arrayList33.add(stringBuilder.toString());
                    arrayList34.add(customCategorical.getBinCount().intValue());
                    arrayList35.add(null != object5.getAuto() ? 1 : 0);
                    arrayList36.add(null != object5.getManual() ? 1 : 0);
                    arrayList37.add(null != object4.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null != string42.getQuantile()) {
                    customCategorical = string42.getQuantile();
                    arrayList38.add(transformationOutputAttribute.getName());
                    arrayList39.add(stringBuilder.toString());
                    arrayList40.add(customCategorical.getBinCount().intValue());
                    object5 = customCategorical.getBinGeneration();
                    arrayList41.add(null != object5.getAuto() ? 1 : 0);
                    arrayList42.add(null != object5.getManual() ? 1 : 0);
                    object4 = customCategorical.getBinLabels();
                    arrayList43.add(null != object4.getNumberSequence() ? 1 : 0);
                    continue;
                }
                if (null == string42.getTopN()) continue;
                customCategorical = string42.getTopN();
                object5 = stringBuilder2.toString();
                if (((String)object5).equals("NVARCHAR2") || ((String)object5).equals("NCHAR")) {
                    arrayList48.add(transformationOutputAttribute.getName());
                    arrayList49.add(stringBuilder.toString());
                    arrayList50.add(customCategorical.getBinCount().intValue());
                    arrayList51.add(customCategorical.getOther());
                    continue;
                }
                arrayList44.add(transformationOutputAttribute.getName());
                arrayList45.add(stringBuilder.toString());
                arrayList46.add(customCategorical.getBinCount().intValue());
                arrayList47.add(customCategorical.getOther());
                continue;
            }
            if (null != transformationType.getMissingValuesCategorical()) {
                customCategorical = transformationType.getMissingValuesCategorical();
                arrayList52.add(transformationOutputAttribute.getName());
                arrayList53.add(stringBuilder.toString());
                arrayList54.add(stringBuilder2.toString());
                object5 = customCategorical.getCategoricalStatistic();
                object4 = customCategorical.getValue();
                if (object5 != null) {
                    arrayList55.add(object5.getReplaceNullsWith());
                    arrayList56.add("");
                    continue;
                }
                if (object4 == null) continue;
                arrayList55.add("");
                arrayList56.add(object4.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesNumeric()) {
                customCategorical = transformationType.getMissingValuesNumeric();
                arrayList57.add(transformationOutputAttribute.getName());
                arrayList58.add(stringBuilder.toString());
                object5 = customCategorical.getNumericStatistic();
                object4 = customCategorical.getValue();
                if (object5 != null) {
                    arrayList59.add(object5.getReplaceNullsWith());
                    arrayList60.add(0.0);
                    continue;
                }
                if (object4 == null) continue;
                arrayList59.add("");
                arrayList60.add(object4.getReplaceNullsWith());
                continue;
            }
            if (null != transformationType.getMissingValuesDate()) {
                customCategorical = transformationType.getMissingValuesDate();
                object5 = TransformationStatisticsState.getTransformationSourceAttributeDataType(transformationNode, stringBuilder.toString());
                if (!DatabaseMetadataUtils.isTimestampWithTimeZone((String)object5)) {
                    arrayList61.add(transformationOutputAttribute.getName());
                    arrayList62.add(stringBuilder.toString());
                    object4 = customCategorical.getDateStatistic();
                    object3 = customCategorical.getValue();
                    if (object4 != null) {
                        arrayList63.add(object4.getReplaceNullsWith());
                        arrayList64.add("");
                        continue;
                    }
                    if (object3 == null) continue;
                    arrayList63.add("");
                    object2 = object3.getReplaceNullsWith().toGregorianCalendar().getTime();
                    object = TimeUtils.getShortSimpleDateFormatZone();
                    charSequence = new StringBuffer();
                    comparable2 = ((SimpleDateFormat)object).format((java.util.Date)object2, (StringBuffer)charSequence, new FieldPosition(0));
                    arrayList64.add(((StringBuffer)comparable2).toString());
                    continue;
                }
                arrayList65.add(transformationOutputAttribute.getName());
                arrayList66.add(stringBuilder.toString());
                object4 = customCategorical.getDateStatistic();
                object3 = customCategorical.getValue();
                if (object4 != null) {
                    arrayList67.add(object4.getReplaceNullsWith());
                    arrayList68.add("");
                    continue;
                }
                if (object3 == null) continue;
                arrayList67.add("");
                object2 = object3.getReplaceNullsWith().toGregorianCalendar().getTime();
                object = TimeUtils.getShortSimpleDateFormatZone();
                charSequence = new StringBuffer();
                comparable2 = ((SimpleDateFormat)object).format((java.util.Date)object2, (StringBuffer)charSequence, new FieldPosition(0));
                arrayList68.add(((StringBuffer)comparable2).toString());
                continue;
            }
            if (null != transformationType.getNormalization()) {
                customCategorical = transformationType.getNormalization();
                arrayList78.add(transformationOutputAttribute.getName());
                arrayList79.add(stringBuilder.toString());
                if (null != customCategorical.getMinMax()) {
                    arrayList80.add("MinMax");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                if (null != customCategorical.getZScore()) {
                    arrayList80.add("ZScore");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                if (null != customCategorical.getLinearScale()) {
                    arrayList80.add("LinearScale");
                    arrayList81.add(null);
                    arrayList82.add(null);
                    continue;
                }
                arrayList80.add("Manual");
                arrayList81.add(customCategorical.getManual().getShift());
                arrayList82.add(customCategorical.getManual().getScale());
                continue;
            }
            if (null != transformationType.getOutlier()) {
                customCategorical = transformationType.getOutlier();
                arrayList69.add(transformationOutputAttribute.getName());
                arrayList70.add(stringBuilder.toString());
                if (NULLS.equals(customCategorical.getReplaceWith())) {
                    arrayList72.add(NULLS);
                } else {
                    arrayList72.add(EDGES);
                }
                if (null != customCategorical.getStandardDeviation()) {
                    arrayList71.add("StandardDeviation");
                    arrayList73.add(customCategorical.getStandardDeviation().getMultiplesSigma());
                    arrayList74.add(null);
                    arrayList75.add(null);
                    arrayList76.add(null);
                    arrayList77.add(null);
                    continue;
                }
                if (null != customCategorical.getValue()) {
                    arrayList71.add("Value");
                    arrayList73.add(null);
                    arrayList74.add(customCategorical.getValue().getLowerValue());
                    arrayList75.add(customCategorical.getValue().getUpperValue());
                    arrayList76.add(null);
                    arrayList77.add(null);
                    continue;
                }
                arrayList71.add("Percent");
                arrayList73.add(null);
                arrayList74.add(null);
                arrayList75.add(null);
                arrayList76.add(customCategorical.getPercent().getLowerPercent());
                arrayList77.add(customCategorical.getPercent().getUpperPercent());
                continue;
            }
            if (null == transformationType.getCustomTransformation()) continue;
            customCategorical = transformationType.getCustomTransformation();
            arrayList83.add(transformationOutputAttribute.getName());
            arrayList84.add(stringBuilder.toString());
            arrayList85.add(customCategorical.getValue());
        }
        object62 = null;
        mapTransformedSource = null;
        try {
            object62 = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes((Connection)object62);
            transformationOutputAttribute = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_NAMES, (Connection)object62);
            stringCollection = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_IDS, (Connection)object62);
            stringBuilder = ArrayDescriptor.createDescriptor((String)ODMR_OBJECT_VALUES, (Connection)object62);
            mapTransformedSource = (OracleCallableStatement)object62.prepareCall(xformToSql);
            int n = 1;
            mapTransformedSource.registerOutParameter(n++, 12);
            mapTransformedSource.setString(n++, string3);
            if (string != null) {
                mapTransformedSource.setString(n++, string);
            } else {
                mapTransformedSource.setNull(n++, 12);
            }
            int n2 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getNumericalBins();
            int n3 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getCategoricalBins();
            int n4 = ((TransformationNodeType)transformationNode.getData()).getDataProfileSettings().getDateBins();
            mapTransformedSource.setInt(n++, n3);
            mapTransformedSource.setInt(n++, n2);
            mapTransformedSource.setInt(n++, n4);
            if (list != null && !list.isEmpty()) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)list.toArray(new String[list.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)list2.toArray(new String[list2.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
            }
            if (arrayList44.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList44.toArray(new String[arrayList44.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList45.toArray(new String[arrayList45.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList46.toArray(new Integer[arrayList46.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList47.toArray(new String[arrayList47.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList48.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList48.toArray(new String[arrayList48.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList49.toArray(new String[arrayList49.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList50.toArray(new Integer[arrayList50.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList51.toArray(new String[arrayList51.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList19.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList19.toArray(new String[arrayList19.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList20.toArray(new String[arrayList20.size()]));
                object3 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList21.toArray(new String[arrayList21.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList22.toArray(new Integer[arrayList22.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList23.toArray(new Integer[arrayList23.size()]));
                charSequence = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList24.toArray(new Integer[arrayList24.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList25.toArray(new Integer[arrayList25.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
                mapTransformedSource.setArray(n++, (Array)((Object)charSequence));
                mapTransformedSource.setArray(n++, comparable2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList26.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList26.toArray(new String[arrayList26.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList27.toArray(new String[arrayList27.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList28.toArray(new Integer[arrayList28.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList29.toArray(new Integer[arrayList29.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList30.toArray(new Integer[arrayList30.size()]));
                charSequence = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList31.toArray(new Integer[arrayList31.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
                mapTransformedSource.setArray(n++, (Array)((Object)charSequence));
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList32.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList32.toArray(new String[arrayList32.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList33.toArray(new String[arrayList33.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList34.toArray(new Integer[arrayList34.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList35.toArray(new Integer[arrayList35.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList36.toArray(new Integer[arrayList36.size()]));
                charSequence = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList37.toArray(new Integer[arrayList37.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
                mapTransformedSource.setArray(n++, (Array)((Object)charSequence));
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList38.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList38.toArray(new String[arrayList38.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList39.toArray(new String[arrayList39.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList40.toArray(new Integer[arrayList40.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList41.toArray(new Integer[arrayList41.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList42.toArray(new Integer[arrayList42.size()]));
                charSequence = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList43.toArray(new Integer[arrayList43.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
                mapTransformedSource.setArray(n++, (Array)((Object)charSequence));
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList9.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList9.toArray(new String[arrayList9.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList10.toArray(new String[arrayList10.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList11.toArray(new Integer[arrayList11.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList12.toArray(new String[arrayList12.size()]));
                object = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList13.toArray(new String[arrayList13.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList14.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList14.toArray(new String[arrayList14.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList15.toArray(new String[arrayList15.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList16.toArray(new Integer[arrayList16.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList17.toArray(new String[arrayList17.size()]));
                object = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList18.toArray(new String[arrayList18.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList4.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList4.toArray(new String[arrayList4.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList5.toArray(new String[arrayList5.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList6.toArray(new Integer[arrayList6.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList7.toArray(new String[arrayList7.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList8.toArray(new Double[arrayList8.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (object8.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)object8.toArray(new String[object8.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)object7.toArray(new String[object7.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList.toArray(new String[arrayList.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList2.toArray(new Integer[arrayList2.size()]));
                object = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList3.toArray(new String[arrayList3.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList52.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList52.toArray(new String[arrayList52.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList53.toArray(new String[arrayList53.size()]));
                object3 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList54.toArray(new String[arrayList54.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList55.toArray(new String[arrayList55.size()]));
                object = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList56.toArray(new String[arrayList56.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList57.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList57.toArray(new String[arrayList57.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList58.toArray(new String[arrayList58.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList59.toArray(new String[arrayList59.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList60.toArray(new Double[arrayList60.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList61.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList61.toArray(new String[arrayList61.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList62.toArray(new String[arrayList62.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList63.toArray(new String[arrayList63.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList64.toArray(new String[arrayList64.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList65.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList65.toArray(new String[arrayList65.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList66.toArray(new String[arrayList66.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList67.toArray(new String[arrayList67.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList68.toArray(new String[arrayList68.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            if (arrayList69.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList69.toArray(new String[arrayList69.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList70.toArray(new String[arrayList70.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList71.toArray(new String[arrayList71.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList72.toArray(new String[arrayList72.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList73.toArray(new Double[arrayList73.size()]));
                charSequence = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList74.toArray(new Double[arrayList74.size()]));
                comparable2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList75.toArray(new Double[arrayList75.size()]));
                comparable = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList76.toArray(new Double[arrayList76.size()]));
                stringBuffer = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList77.toArray(new Double[arrayList77.size()]));
                if (string2 != null) {
                    mapTransformedSource.setString(n++, string2);
                } else {
                    mapTransformedSource.setNull(n++, 12);
                }
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
                mapTransformedSource.setArray(n++, (Array)((Object)charSequence));
                mapTransformedSource.setArray(n++, comparable2);
                mapTransformedSource.setArray(n++, (Array)((Object)comparable));
                mapTransformedSource.setArray(n++, (Array)((Object)stringBuffer));
            } else {
                mapTransformedSource.setNull(n++, 12);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList78.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList78.toArray(new String[arrayList78.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList79.toArray(new String[arrayList79.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList80.toArray(new String[arrayList80.size()]));
                object2 = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList81.toArray(new Double[arrayList81.size()]));
                object = new ARRAY((ArrayDescriptor)stringCollection, (Connection)object62, (Object)arrayList82.toArray(new Double[arrayList82.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
                mapTransformedSource.setArray(n++, (Array)object2);
                mapTransformedSource.setArray(n++, (Array)object);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_IDS);
            }
            if (arrayList83.size() > 0) {
                object5 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList83.toArray(new String[arrayList83.size()]));
                object4 = new ARRAY((ArrayDescriptor)transformationOutputAttribute, (Connection)object62, (Object)arrayList84.toArray(new String[arrayList84.size()]));
                object3 = new ARRAY((ArrayDescriptor)stringBuilder, (Connection)object62, (Object)arrayList85.toArray(new String[arrayList85.size()]));
                mapTransformedSource.setArray(n++, (Array)object5);
                mapTransformedSource.setArray(n++, (Array)object4);
                mapTransformedSource.setArray(n++, (Array)object3);
            } else {
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_NAMES);
                mapTransformedSource.setNull(n++, 2003, ODMR_OBJECT_VALUES);
            }
            mapTransformedSource.executeQuery();
            object4 = object5 = mapTransformedSource.getString(1);
            return object4;
        }
        finally {
            if (mapTransformedSource != null) {
                mapTransformedSource.close();
            }
            if (object62 != null) {
                object62.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDistinctValuesFromDB(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = TransformationStatisticsState.getStackedSQL(this._transformationNode);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string3 = StringUtils.getReplacedString(sql_distincts, "<column_name>", string);
            string3 = StringUtils.getReplacedString(string3, "<table_name>", string2);
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areColumnsPresentInSampleTable(Context context, String string, List<String> list) {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = Connections.getUniqueConnection(context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            int n = 0;
            for (String string2 : list) {
                if (++n > 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
            }
            Object object = Connections.getUserAccountName(context);
            object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
            stringBuffer.append(" from " + (String)object + "." + string + " where ROWNUM < 2");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        if (this._refreshStatsTable == null && this._refreshSingleColumnStatsTable == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
            String string = Connections.getUserAccountName(this._context);
            String string2 = string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            if (null != this._refreshSingleColumnStatsTable) {
                try {
                    DatabaseMetadataUtils.dropTable(connection, string, this._refreshSingleColumnStatsTable);
                    this._refreshSingleColumnStatsTable = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null != this._refreshStatsTable) {
                DatabaseMetadataUtils.dropTable(connection, string, this._refreshStatsTable);
                this._refreshStatsTable = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.clearRefreshedResults();
            this.clearServerResults();
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    static {
        _listBuffer.append(ATTR);
        _listBuffer.append(_comma);
        _listBuffer.append(DATA_TYPE);
        _listBuffer.append(_comma);
        _listBuffer.append(NULL_PERCENT);
        _listBuffer.append(_comma);
        _listBuffer.append(DISTINCT_CNT);
        _listBuffer.append(_comma);
        _listBuffer.append(DISTINCT_PERCENT);
        _listBuffer.append(_comma);
        _listBuffer.append(MODE_VALUE);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG_DATE);
        _listBuffer.append(_comma);
        _listBuffer.append(AVG_TS_TZ);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_VAL);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_DATE);
        _listBuffer.append(_comma);
        _listBuffer.append(MEDIAN_TS_TZ);
        _listBuffer.append(_comma);
        _listBuffer.append(MIN);
        _listBuffer.append(_comma);
        _listBuffer.append(MAX);
        _listBuffer.append(_comma);
        _listBuffer.append(STD);
        _listBuffer.append(_comma);
        _listBuffer.append(VAR);
        _listBuffer.append(_comma);
        _listBuffer.append(SKEWNESS);
        _listBuffer.append(_comma);
        _listBuffer.append(KURTOSIS);
        _listBuffer.append(_comma);
        _listBuffer.append(ATTRIBUTE_VALUE);
        _listBuffer.append(_comma);
        _listBuffer.append(ATTRIBUTE_PERCENT);
        _where_clause = "<where_clause>";
        _where_clause_template = " where ATTR IN(";
        _attr_list_token = "<attribute_list>";
        _table_name_token = "<table_name>";
        _QUERY = "SELECT <attribute_list> from <table_name>, table (HISTOGRAMS) <where_clause>";
        LIST_OF_DISTINCT_VALUES = "LIST_OF_DISTINCT_VALUES";
        EQWIDTH = "EQWIDTH";
        QTILE = "QTILE";
        TOPN = "TOPN";
        UNBOUNDED = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_UNBOUNDED");
        NO_LOWER_BOUND = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_NO_LOWER_BOUND");
        xformToSql = "{? = call ODMR_UTIL.CLIENT_TRANSFORM(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
        sql_distincts = "SELECT DISTINCT <column_name> from (<table_name>)";
        queryDateTemplate_no_with = "  <stacked_sql_view>,    ALL_DATA_VIEW as (      select * from(        select \"Attribute Name\", \"Attribute Value\"        from         (select \"Attribute Name\", \"Attribute Value\"         FROM  (select <column> from (<table_name>))             UNPIVOT INCLUDE NULLS (               \"Attribute Value\"                FOR \"Attribute Name\" IN ( <column> ))          group by (\"Attribute Name\", \"Attribute Value\") ) ) ),    STATS_VIEW as (     select \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP) max_value,                                CAST(MIN(\"Attribute Value\") AS TIMESTAMP) min_value     from ALL_DATA_VIEW     group by (\"Attribute Name\") )     select        \"Attribute Name\" ATTRIBUTE_NAME, min_value, max_value from STATS_VIEW";
        queryDateTemplate = "WITH    ALL_DATA_VIEW as (      select * from(        select \"Attribute Name\", \"Attribute Value\"        from         (select \"Attribute Name\", \"Attribute Value\"         FROM  (select <column> from (<table_name>))             UNPIVOT INCLUDE NULLS (               \"Attribute Value\"                FOR \"Attribute Name\" IN ( <column> ))          group by (\"Attribute Name\", \"Attribute Value\") ) ) ),    STATS_VIEW as (     select \"Attribute Name\", CAST(MAX(\"Attribute Value\") AS TIMESTAMP) max_value,                                CAST(MIN(\"Attribute Value\") AS TIMESTAMP) min_value     from ALL_DATA_VIEW     group by (\"Attribute Name\") )     select        \"Attribute Name\" ATTRIBUTE_NAME, min_value, max_value from STATS_VIEW";
    }

    public static class AttributeHistogramArray {
        ArrayList<NameValuePair> attributeValuesBars = new ArrayList();

        boolean isEmpty() {
            return this.attributeValuesBars.isEmpty();
        }

        ArrayList<String> getBarTitles() {
            ArrayList<String> arrayList = new ArrayList<String>(this.attributeValuesBars.size());
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                arrayList.add(nameValuePair.getName());
            }
            return arrayList;
        }

        ArrayList<NameValuePair> getBarArray(String string) {
            ArrayList<NameValuePair> arrayList = null;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!string.equals(nameValuePair.getName())) continue;
                arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
            }
            return arrayList;
        }

        void addPoint(Object object, String string, Double d) {
            boolean bl = false;
            for (int i = 0; i < this.attributeValuesBars.size(); ++i) {
                NameValuePair nameValuePair = this.attributeValuesBars.get(i);
                if (!object.toString().equals(nameValuePair.getName())) continue;
                ArrayList<NameValuePair> arrayList = ConverterHelper.objectToNameValuePairList(nameValuePair.getValue());
                arrayList.add(new NameValuePair(string, d));
                bl = true;
            }
            if (!bl) {
                ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
                arrayList.add(new NameValuePair(string, d));
                this.attributeValuesBars.add(new NameValuePair(object.toString(), arrayList));
            }
        }
    }
}

