/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultRowSorter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshResult;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshStatsProgressRunnable;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationLoadGraphPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;

public class TransformationStatisticPanel
extends JPanel {
    private TransformationStatisticsState _state;
    private TransformationLoadGraphPanel _parent;
    private String srcColumnName;
    private String outColumnName;
    private boolean noSource = false;
    private String customOutputName;
    private static Preferences _p = Preferences.getPreferences();
    private DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)_p);
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jBtnRefresh;
    private GenericTable _jStatsTable = new GenericTable();
    private static String _statsistics_column_name = XformDialogsLrb.get("STATISTIC_TAB_COLUMN_STATISTICS");
    protected static int ROW_INDEX = 0;
    protected static int PERCENT_NULL = ROW_INDEX++;
    protected static int DISTINCT = ROW_INDEX++;
    protected static int MODE = ROW_INDEX++;
    protected static int AVG = ROW_INDEX++;
    protected static int MEDIAN = ROW_INDEX++;
    protected static int MIN = ROW_INDEX++;
    protected static int MAX = ROW_INDEX++;
    protected static int STD = ROW_INDEX++;
    protected static int VAR = ROW_INDEX++;
    protected static int SKEWNESS = ROW_INDEX++;
    protected static int KURTOSIS = ROW_INDEX++;
    protected static Map<Integer, String> _rowLabels = new HashMap<Integer, String>();

    public TransformationStatisticPanel(TransformationLoadGraphPanel transformationLoadGraphPanel, TransformationStatisticsState transformationStatisticsState, String string, String string2, boolean bl, String string3) {
        this._state = transformationStatisticsState;
        this.noSource = bl;
        this._parent = transformationLoadGraphPanel;
        this.srcColumnName = string;
        this.outColumnName = string2;
        this.customOutputName = string3;
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBtnRefresh = new JButton();
        this.jBtnRefresh.setText("Refresh Statistics");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, GroupLayout.Alignment.TRAILING, -1, 364, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(237, Short.MAX_VALUE).addComponent(this.jBtnRefresh).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jBtnRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -1, 239, Short.MAX_VALUE)));
    }

    public void initUI() {
        Object object;
        TransformationType transformationType;
        StatisticsTableModel statisticsTableModel = null;
        TransformationSourceAttribute transformationSourceAttribute = this._state.findTransformationSourceColumn(this.srcColumnName);
        statisticsTableModel = transformationSourceAttribute != null && this.outColumnName == null ? (this.noSource ? new OriginalStatisticsTableModel(this.customOutputName) : new OriginalStatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName))) : (null != (transformationType = (object = this._state.findTransformedColumn(this.outColumnName)).getTransformationElementType()).getCustomTransformation() ? new CustomStatisticsTableModel(this._state.getDataProfileStatisticsData(this.outColumnName)) : new StatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName), this._state.getDataProfileStatisticsData(this.outColumnName)));
        this.setupTableModel(statisticsTableModel);
        object = new JScrollPane((Component)this._jStatsTable);
        this.jAttributesComponent.setComponent((JComponent)object);
        this.jAttributesComponent.setLabel(new JLabel(XformDialogsLrb.get("STATISTIC_TAB_COLUMN_STATISTICS_TITLE")));
        this.updateRefresButtonState();
        if (this.isRefresheVisible()) {
            this.jBtnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RefreshResult refreshResult = TransformationStatisticPanel.this.refreshStatistics();
                        if (refreshResult.isException()) {
                            throw refreshResult.getException();
                        }
                        if (refreshResult == null) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                            return;
                        }
                        TransformationStatisticPanel.this._parent.updateGraph(refreshResult.getStatsData(), refreshResult.getGrafDataModel());
                        TransformationStatisticPanel.this.updateRefresButtonState();
                    }
                    catch (Exception exception) {
                        String string = exception.getLocalizedMessage();
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    }
                }
            });
        }
    }

    public RefreshResult refreshStatistics() throws Exception {
        RefreshStatsProgressRunnable refreshStatsProgressRunnable = new RefreshStatsProgressRunnable(this._state, this._parent, this.outColumnName);
        refreshStatsProgressRunnable.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        refreshStatsProgressRunnable.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        refreshStatsProgressRunnable.start(true);
        return refreshStatsProgressRunnable.getResults();
    }

    boolean isRefresheVisible() {
        return !this._parent.isAddEditDialog();
    }

    void updateRefresButtonState() {
        boolean bl = this.isRefresheVisible();
        this.jBtnRefresh.setVisible(bl);
        if (bl) {
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this.outColumnName));
        }
        this._parent.peerRefresButtonState(this);
    }

    void updateRefresButtonStateFromPeer() {
        boolean bl = this.isRefresheVisible();
        this.jBtnRefresh.setVisible(bl);
        if (bl) {
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this.outColumnName));
        }
    }

    public void setupTableModel(StatisticsTableModel statisticsTableModel) {
        Object object;
        assert (statisticsTableModel != null);
        this._jStatsTable.setModel((TableModel)((Object)statisticsTableModel));
        this._jStatsTable.setSorted(true);
        int n = this._jStatsTable.getColumnModel().getColumnCount();
        if (n == 2) {
            object = this._jStatsTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setCellRenderer(new CustomRenderer());
        } else if (n == 3) {
            object = this._jStatsTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setCellRenderer(new CustomRenderer());
            TableColumn tableColumn = this._jStatsTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new CustomRenderer());
        }
        object = new TableRowSorter<TableModel>(this._jStatsTable.getModel());
        this._jStatsTable.setRowSorter((RowSorter)object);
        if (n == 2) {
            ((DefaultRowSorter)object).setComparator(1, new StringComparator());
        }
        if (n == 3) {
            ((DefaultRowSorter)object).setComparator(2, new StringComparator());
        }
    }

    public void updateTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
        StatisticsTableModel statisticsTableModel = new StatisticsTableModel(this._state.getDataProfileStatisticsData(this.srcColumnName), dataProfileStatisticsData);
        this.setupTableModel(statisticsTableModel);
    }

    static {
        _rowLabels.put(PERCENT_NULL, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_PERCENT_NULL"));
        _rowLabels.put(DISTINCT, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_DISTINCT"));
        _rowLabels.put(MODE, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MODE"));
        _rowLabels.put(AVG, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_AVG"));
        _rowLabels.put(MEDIAN, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MEDIAN"));
        _rowLabels.put(MIN, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MIN"));
        _rowLabels.put(MAX, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MAX"));
        _rowLabels.put(STD, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_STD"));
        _rowLabels.put(VAR, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_VAR"));
        _rowLabels.put(SKEWNESS, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_SKEWNESS"));
        _rowLabels.put(KURTOSIS, TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_KURTOSIS"));
    }

    private class StatisticsTableModel
    extends GenericBaseTableModel {
        protected Vector<Vector<Object>> data = new Vector();
        protected DataProfileStatisticsData srcColumnStats;
        protected DataProfileStatisticsData newColumnStats;
        protected String[] _columnNames;

        StatisticsTableModel() {
        }

        StatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData, DataProfileStatisticsData dataProfileStatisticsData2) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.srcColumnName, TransformationStatisticPanel.this.outColumnName};
            this.srcColumnStats = dataProfileStatisticsData;
            this.newColumnStats = dataProfileStatisticsData2;
            this.setColumnIdentifiers(this._columnNames);
            this.buildData();
        }

        protected void buildData() {
            for (int i = 0; i < _rowLabels.size(); ++i) {
                Object object;
                String string;
                Vector<String> vector = new Vector<String>();
                String string2 = _rowLabels.get(i);
                vector.add(string2);
                if (this.srcColumnStats != null) {
                    string = null;
                    object = this.getValue(i, this.srcColumnStats);
                    string = object != null && object instanceof Double ? (i == PERCENT_NULL ? NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) : NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "") : (object != null ? object.toString() : "");
                    vector.add(string);
                }
                if (this.newColumnStats != null) {
                    string = null;
                    object = this.getValue(i, this.newColumnStats);
                    string = object != null && object instanceof Double ? (i == PERCENT_NULL ? NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) : NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "") : (object != null ? object.toString() : "");
                    vector.add(string);
                }
                this.data.add(vector);
            }
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 < this.getColumnCount()) {
                Vector<Object> vector = this.data.get(n);
                if (n2 >= vector.size()) {
                    return "";
                }
                object = vector.get(n2);
            }
            return object != null ? object : "";
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getRowCount() {
            return _rowLabels.size();
        }

        public TableModel getModel() {
            return this;
        }

        protected Object getValue(int n, DataProfileStatisticsData dataProfileStatisticsData) {
            if (n == PERCENT_NULL) {
                return dataProfileStatisticsData.getPercentNulls();
            }
            if (n == DISTINCT) {
                return dataProfileStatisticsData.getNumOfDistincts();
            }
            if (n == MODE) {
                return dataProfileStatisticsData.getMode();
            }
            if (n == AVG) {
                return dataProfileStatisticsData.getAvg();
            }
            if (n == MEDIAN) {
                return dataProfileStatisticsData.getMedian();
            }
            if (n == MIN) {
                return dataProfileStatisticsData.getMin();
            }
            if (n == MAX) {
                return dataProfileStatisticsData.getMax();
            }
            if (n == STD) {
                return dataProfileStatisticsData.getStd();
            }
            if (n == VAR) {
                return dataProfileStatisticsData.getVar();
            }
            if (n == SKEWNESS) {
                return dataProfileStatisticsData.getSkewness();
            }
            if (n == KURTOSIS) {
                return dataProfileStatisticsData.getKurtosis();
            }
            return "";
        }
    }

    private class OriginalStatisticsTableModel
    extends StatisticsTableModel {
        OriginalStatisticsTableModel(String string) {
            this._columnNames = new String[]{_statsistics_column_name, string};
            this.setColumnIdentifiers(this._columnNames);
            this.srcColumnStats = this.srcColumnStats;
            this.buildData();
        }

        OriginalStatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.srcColumnName};
            this.setColumnIdentifiers(this._columnNames);
            this.srcColumnStats = dataProfileStatisticsData;
            this.buildData();
        }

        public String getColumnName(int n) {
            return this._columnNames[n];
        }
    }

    private class CustomStatisticsTableModel
    extends StatisticsTableModel {
        CustomStatisticsTableModel(DataProfileStatisticsData dataProfileStatisticsData) {
            this._columnNames = new String[]{_statsistics_column_name, TransformationStatisticPanel.this.outColumnName};
            this.setColumnIdentifiers(this._columnNames);
            this.newColumnStats = dataProfileStatisticsData;
            this.buildData();
        }
    }

    public class CustomRenderer
    extends DefaultTableCellRenderer {
        FormatType formatType;

        public CustomRenderer(FormatType formatType) {
            this.formatType = formatType;
        }

        public CustomRenderer() {
            this.formatType = FormatType.NUMERICAL;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                String string = null;
                if (object instanceof Double) {
                    string = this.formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, TransformationStatisticPanel.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                } else if (object instanceof Integer) {
                    string = NumericFormat.format((Integer)object, true, 8) + "";
                } else if (object instanceof String) {
                    string = (String)object;
                }
                super.setValue(string);
            }
        }
    }

    private class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null || object2 == null) {
                if (object == object2) {
                    return 0;
                }
                if (object != null) {
                    return 1;
                }
                return -1;
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    public static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

