/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshResult;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshStatsProgressRunnable;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationLoadGraphPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class RefreshGraphJPanel
extends JPanel {
    private TransformationStatisticsState _state;
    private String _xformedAttribute;
    private TransformationLoadGraphPanel _parent;
    private JButton jBtnRefresh;
    private JPanel jHostPanel;

    public RefreshGraphJPanel(TransformationLoadGraphPanel transformationLoadGraphPanel, TransformationStatisticsState transformationStatisticsState, String string) {
        this._state = transformationStatisticsState;
        this._xformedAttribute = string;
        this._parent = transformationLoadGraphPanel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jBtnRefresh = new JButton();
        this.jHostPanel = new JPanel();
        this.jBtnRefresh.setText("Refresh Statistics");
        GroupLayout groupLayout = new GroupLayout(this.jHostPanel);
        this.jHostPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 380, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 249, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnRefresh, GroupLayout.Alignment.TRAILING).addComponent(this.jHostPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jBtnRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jHostPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        this.jBtnRefresh.setText(XformDialogsLrb.get("MAIN_TRANSFORMATION_DIALOG_REFRESH_STATS"));
    }

    boolean isRefresheVisible() {
        return !this._parent.isAddEditDialog();
    }

    void updateRefresButtonState() {
        boolean bl = this.isRefresheVisible();
        this.jBtnRefresh.setVisible(bl);
        if (bl) {
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this._xformedAttribute));
        }
        this._parent.peerRefresButtonState(this);
    }

    void updateRefresButtonStateFromPeer() {
        boolean bl = this.isRefresheVisible();
        this.jBtnRefresh.setVisible(bl);
        if (bl) {
            this.jBtnRefresh.setEnabled(this._state.needsRefresh(this._xformedAttribute));
        }
    }

    public void initUI() {
        this.updateRefresButtonState();
        if (this.isRefresheVisible()) {
            this.jBtnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RefreshResult refreshResult = RefreshGraphJPanel.this.refreshStatistics();
                        if (refreshResult.isException()) {
                            throw refreshResult.getException();
                        }
                        if (refreshResult == null) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                            return;
                        }
                        RefreshGraphJPanel.this._parent.updateGraph(refreshResult.getStatsData(), refreshResult.getGrafDataModel());
                        RefreshGraphJPanel.this.updateRefresButtonState();
                    }
                    catch (Exception exception) {
                        String string = exception.getLocalizedMessage();
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    }
                }
            });
        }
    }

    public RefreshResult refreshStatistics() throws Exception {
        RefreshStatsProgressRunnable refreshStatsProgressRunnable = new RefreshStatsProgressRunnable(this._state, this._parent, this._xformedAttribute);
        refreshStatsProgressRunnable.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        refreshStatsProgressRunnable.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        refreshStatsProgressRunnable.start(true);
        return refreshStatsProgressRunnable.getResults();
    }

    public JPanel getJHostPanel() {
        return this.jHostPanel;
    }
}

