/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.utils.CustomComparator;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;

public class ExtendedTransformationSettingsTableModel
extends TransformationSettingsTableModel {
    private static String[] _extended_columnNames = new String[]{TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_COLUMN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TYPE"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_SOURCE_COLUMN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TRANSFORM"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_OUTPUT"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_HISTOGRAM"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_PERCENT_NULL"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_DISTINCT"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MODE"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_AVG"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MEDIAN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MIN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_MAX"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_STD"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_VAR"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_SKEWNESS"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_KURTOSIS")};

    public ExtendedTransformationSettingsTableModel(TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector, List<DataProfileStatisticsData> list, String string, int n) {
        super(transformedAttributes, vector, list, string, n);
    }

    @Override
    protected String[] getColumnNames() {
        return _extended_columnNames;
    }

    @Override
    public String getColumnName(int n) {
        return _extended_columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        if (n2 <= OUTPUT) {
            return super.getValueAt(n, n2);
        }
        DataProfileStatisticsData dataProfileStatisticsData = this.getDataProfileStatisticsData(n);
        if (dataProfileStatisticsData == null) {
            return "";
        }
        Object object2 = null;
        if (n2 == PERCENT_NULL) {
            object2 = dataProfileStatisticsData.getPercentNulls();
        } else if (n2 == DISTINCT) {
            object2 = dataProfileStatisticsData.getNumOfDistincts();
        } else if (n2 == MODE) {
            object2 = dataProfileStatisticsData.getMode();
        } else if (n2 == AVG) {
            object2 = dataProfileStatisticsData.getAvg();
        } else if (n2 == MEDIAN) {
            object2 = dataProfileStatisticsData.getMedian();
        } else if (n2 == MIN) {
            object2 = dataProfileStatisticsData.getMin();
        } else if (n2 == MAX) {
            object2 = dataProfileStatisticsData.getMax();
        } else if (n2 == STD) {
            object2 = dataProfileStatisticsData.getStd();
        } else if (n2 == VAR) {
            object2 = dataProfileStatisticsData.getVar();
        } else if (n2 == SKEWNESS) {
            object2 = dataProfileStatisticsData.getSkewness();
        } else if (n2 == KURTOSIS) {
            object2 = dataProfileStatisticsData.getKurtosis();
        } else if (n2 == HISTOGRAM) {
            object2 = dataProfileStatisticsData.getGraphDataModel();
            if (object2 != null && object2 instanceof DefaultGraphDataModel) {
                object = (DefaultGraphDataModel)object2;
                if (((DefaultGraphDataModel)object).getGraphData() == null || ((DefaultGraphDataModel)object).getGraphData().length == 0) {
                    return "";
                }
                ((DefaultGraphDataModel)object).setComment(MessageFormat.format(DataProfileStatisticsLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), dataProfileStatisticsData.getName()));
            }
        } else assert (false) : "Out of bounds column when accessing statistics";
        if (object2 instanceof Date || object2 instanceof Timestamp) {
            object = null;
            if (object2 instanceof Timestamp) {
                object = TimeUtils.getShortSimpleDateFormatZone();
            } else if (object2 instanceof Date) {
                object = TimeUtils.getShortSimpleDateFormat();
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = ((SimpleDateFormat)object).format((Date)object2, stringBuffer, new FieldPosition(0));
            return stringBuffer2.toString();
        }
        if (object2 instanceof GregorianCalendar) {
            object = (GregorianCalendar)object2;
            SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZone();
            simpleDateFormat.setTimeZone(((GregorianCalendar)object).getTimeZone());
            Date date = ((Calendar)object).getTime();
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            StringBuffer stringBuffer3 = new StringBuffer(TimeUtils.removeGMT(stringBuffer.toString()));
            return stringBuffer3.toString();
        }
        return object2 != null ? object2 : "";
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        comparator = n == PERCENT_NULL ? NumberComparator.getComparator() : (n == DISTINCT ? NumberComparator.getComparator() : (n == MODE ? super.getColumnSortComparator(n) : (n == AVG ? CustomComparator.getComparator() : (n == MEDIAN ? CustomComparator.getComparator() : (n == MIN ? CustomComparator.getComparator() : (n == MAX ? CustomComparator.getComparator() : (n == STD ? NumberComparator.getComparator() : (n == VAR ? NumberComparator.getComparator() : (n == SKEWNESS ? NumberComparator.getComparator() : (n == KURTOSIS ? NumberComparator.getComparator() : super.getColumnSortComparator(n)))))))))));
        return comparator;
    }

    @Override
    public void setFailedStatus() {
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILED_TO_LOAD_TABLE_SUMMARY"));
        this.clearRows();
        this.addDataItem(dataProfileStatisticsData);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }
}

