/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelAbstract;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelNoStats;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelWithStats;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformationsAbtractDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AddEditTransformsDialogAbstract
extends EditTransformationsAbtractDialog<TransformationNode> {
    protected AddEditTransformsPanelAbstract content;
    protected TransformationNodeType _cachedTransformationNodeType;
    protected List<TransformationSourceAttribute> _selectedSourceColumns;
    protected TransformationStatisticsState state;
    protected boolean isPI = false;
    private static Preferences _p = Preferences.getPreferences();
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)_p);

    public AddEditTransformsDialogAbstract(TransformationNodeType transformationNodeType, TransformationStatisticsState transformationStatisticsState, List<TransformationSourceAttribute> list, boolean bl) {
        this._cachedTransformationNodeType = transformationNodeType;
        this.state = transformationStatisticsState;
        this.isPI = bl;
        this._selectedSourceColumns = list;
    }

    protected abstract List<AttributeType> getXformAttributes(AbstractDataNode var1);

    @Override
    protected JEWTDialog buildDialog(Context context, TransformationNode transformationNode, AbstractDataNode abstractDataNode) {
        List<AttributeType> list = this.getXformAttributes(abstractDataNode);
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        if (null == list || list.isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MSG"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            return null;
        }
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isLOBType(attributeType.getDataType())) continue;
            TransformationSourceAttribute transformationSourceAttribute = null;
            if (attributeType instanceof TransformationSourceAttribute) {
                transformationSourceAttribute = AttributeTypeHelper.cloneTransformationAttribute(attributeType);
            } else {
                transformationSourceAttribute = new TransformationSourceAttribute();
                AttributeTypeHelper.copyAttribute((AttributeType)transformationSourceAttribute, attributeType);
                transformationSourceAttribute.setIsOutput(false);
            }
            arrayList.add(transformationSourceAttribute);
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        this.content = null != this._cachedTransformationNodeType.getInputStatisticTable() && null != this._cachedTransformationNodeType.getInputStatisticTable().getName() ? new AddEditTransformsPanelWithStats(context, this._cachedTransformationNodeType, this.state, hashMap, arrayList, this._selectedSourceColumns, this.isPI) : new AddEditTransformsPanelNoStats(context, this.state, this._cachedTransformationNodeType, hashMap, arrayList, this._selectedSourceColumns);
        JEWTDialog jEWTDialog = super.buildDialog(context, this.content);
        if (this.content instanceof AddEditTransformsPanelWithStats) {
            jEWTDialog.setMinimumSize(455, 700);
        }
        return jEWTDialog;
    }

    @Override
    public MapTransformedSource getTransformedAttribute() {
        return this.content.getTransformedAttribute();
    }

    @Override
    public boolean isUpdateWhenFinished() {
        boolean bl = this.transformSettings.isUpdateWhenFinished();
        if (bl) {
            bl = this.state.hasInputStatisticTable();
        }
        return bl;
    }
}

