/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractAttributesTableModel
extends GenericBaseTableModel {
    public static final int FILTER_SOURCE_NAME = 0;
    public static final int FILTER_ORIGINAL_NAME = 1;
    public static final int FILTER_NEW_NAME = 2;
    protected ApplyTransformWizardModel _model;
    protected Map<String, String> _outSrcMap = new HashMap<String, String>();
    protected List<String> _srcColumns = new ArrayList<String>();
    protected List<String> _outColumns = new ArrayList<String>();
    static final int SOURCE_COLUMN_NAME = 0;

    protected abstract int getNewName();

    protected abstract Vector getColumnNames();

    protected abstract void populateColumns();

    protected abstract void replaceName(String var1, int var2);

    AbstractAttributesTableModel(ApplyTransformWizardModel applyTransformWizardModel) {
        this._model = applyTransformWizardModel;
        this.populateColumns();
        this.setRowCount(this._outColumns.size());
        this.setDataVector(this.fillDataVector(), this.getColumnNames());
        this.setColumnCount(this.getColumnNames().size());
    }

    AbstractAttributesTableModel(ApplyTransformWizardModel applyTransformWizardModel, String string, int n) throws Exception {
        this._model = applyTransformWizardModel;
        this.populateFilteredColumns(string, n);
        this.setRowCount(this._outColumns.size());
        this.setDataVector(this.fillDataVector(), this.getColumnNames());
        this.setColumnCount(this.getColumnNames().size());
    }

    List<String> getOutputColumns() {
        return this._outColumns;
    }

    Vector fillDataVector() {
        Vector vector = new Vector();
        for (String string : this._outColumns) {
            String string2 = this._outSrcMap.get(string);
            Vector<String> vector2 = new Vector<String>();
            vector2.add(string2);
            vector2.add(string);
            vector.add(vector2);
        }
        return vector;
    }

    public int getRowCount() {
        return this._outColumns != null ? this._outColumns.size() : 0;
    }

    public void clearRows() {
        this._outColumns.clear();
        this._srcColumns.clear();
        this._outSrcMap.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        if (this._outColumns.isEmpty()) {
            return "";
        }
        String string = this._outColumns.get(n);
        String string2 = null;
        if (n2 == 0) {
            string2 = this._outSrcMap.get(string);
        } else if (n2 == this.getNewName()) {
            string2 = string;
        } else assert (false) : "Out of bounds column when accessing items";
        return string2 != null ? string2 : "";
    }

    public void setValueAt(Object object, int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        if (n2 == this.getNewName()) {
            if (object == null || object.toString().isEmpty()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_INVALID_NAME"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return;
            }
            if (!this._model.isUniqueTransformationOutputName(object.toString())) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_DUPLICATE_NAME"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return;
            }
            this.replaceName(object.toString(), n);
        }
    }

    public String getInputColumnName(String string) {
        return this._outSrcMap.get(string);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public TableModel getModel() {
        return this;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == this.getNewName();
    }

    protected abstract void populateFilteredColumns(String var1, int var2) throws Exception;
}

