/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.text;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.OdmrNodeReference;
import oracle.dmt.dataminer.generated.server.OdmrNodeReferenceSet;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.text.BuildTextRowDetail;
import oracle.dmt.dataminer.workflow.dialog.text.TextDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.text.WorkflowFilterType;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;

public class SelectNodeTableModel
extends GenericBaseTableModel {
    private static String BUILD_TEXT_NODE_TYPE = "BuildText";
    private Vector<BuildTextRowDetail> _data = new Vector();
    private Vector<BuildTextRowDetail> _currentWorkflowdata = null;
    private Vector<BuildTextRowDetail> _allWorkflowdata = null;
    private BuildTextNodeRef _node;
    private Context _context;
    private static final int COLUMN_COUNT = 4;
    public static final int NODE_NAME = 0;
    public static final int PROJECT_NAME = 1;
    public static final int WORKFLOW_NAME = 2;
    public static final int STATUS = 3;
    private String[] _columnNames = new String[]{TextDialogLrb.get("SELECT_NODE_COLUMN_NODE_NAME"), TextDialogLrb.get("SELECT_NODE_COLUMN_PROJ_NAME"), TextDialogLrb.get("SELECT_NODE_COLUMN_WK_NAME"), TextDialogLrb.get("SELECT_NODE_COLUMN_NODE_STATUS")};

    public SelectNodeTableModel(Context context, BuildTextNodeRef buildTextNodeRef) {
        this._node = buildTextNodeRef;
        this._context = context;
        this.setColumnCount(4);
        this.setRowCount(this._data.size());
        this.setColumnIdentifiers(this._columnNames);
        this.initIcons();
    }

    private void initIcons() {
    }

    public void load(WorkflowFilterType workflowFilterType) throws Exception {
        this._data.clear();
        if (workflowFilterType == WorkflowFilterType.CURRENT_WORKFLOW) {
            this.loadCurrentWorkflowNodes();
        } else if (workflowFilterType == WorkflowFilterType.ALL_WORKFLOWS) {
            this.loadAllWorkflowNodes();
        }
        this.fireTableDataChanged();
    }

    public boolean isCurrrentWorkflow(Number number) {
        Workflow workflow = this.getWorkflow();
        return workflow.getId().longValue() == number.longValue();
    }

    private Workflow getWorkflow() {
        WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        return workflow;
    }

    private void loadCurrentWorkflowNodes() {
        if (this._currentWorkflowdata != null) {
            this._data.addAll(this._currentWorkflowdata);
        } else {
            this._currentWorkflowdata = new Vector();
            WorkflowProcess workflowProcess = this._node.getModel().getDocumentObject();
            List list = workflowProcess.getNodes().getBuildText();
            Workflow workflow = this.getWorkflow();
            WorkflowProject workflowProject = ProjectFolder.getWorkflowProject(this._context);
            for (BuildTextNodeType buildTextNodeType : list) {
                BuildTextRowDetail buildTextRowDetail = new BuildTextRowDetail();
                buildTextRowDetail.setProjectId(workflowProject.getId());
                buildTextRowDetail.setProjectName(workflowProject.getName());
                buildTextRowDetail.setWorkflowId(workflow.getId());
                buildTextRowDetail.setWorkflowName(workflow.getName());
                buildTextRowDetail.setNodeId(Integer.valueOf(buildTextNodeType.getId()));
                buildTextRowDetail.setNodeName(buildTextNodeType.getName());
                buildTextRowDetail.setStatus(buildTextNodeType.getStatus());
                buildTextRowDetail.setNode(buildTextNodeType);
                this._currentWorkflowdata.add(buildTextRowDetail);
            }
            this._data.addAll(this._currentWorkflowdata);
        }
    }

    public BuildTextNodeType getSelectedRowNodeObject(int n) {
        if (this._data.size() < n) {
            return null;
        }
        return this._data.get(n).getNode();
    }

    public BuildTextRowDetail getSelectedReferenceObject(int n) {
        if (this._data.size() < n) {
            return null;
        }
        return this._data.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllWorkflowNodes() throws Exception {
        Connection connection = null;
        if (this._allWorkflowdata != null) {
            this._data.addAll(this._allWorkflowdata);
        } else {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                connection = connectionFolder.getUniqueConnection();
                OdmrNodeReferenceSet[] odmrNodeReferenceSetArray = Workflow.getWorkflowNodesReferences(connection, BUILD_TEXT_NODE_TYPE);
                OdmrNodeReference[] odmrNodeReferenceArray = odmrNodeReferenceSetArray[0].getArray();
                for (int i = 0; i < odmrNodeReferenceArray.length; ++i) {
                    OdmrNodeReference odmrNodeReference = odmrNodeReferenceArray[i];
                    BuildTextRowDetail buildTextRowDetail = new BuildTextRowDetail();
                    if (this.getWorkflow().getId().longValue() == odmrNodeReference.getWorkflowId().longValue()) continue;
                    buildTextRowDetail.setProjectId(odmrNodeReference.getProjectId());
                    buildTextRowDetail.setProjectName(odmrNodeReference.getProjectName());
                    buildTextRowDetail.setWorkflowId(odmrNodeReference.getWorkflowId());
                    buildTextRowDetail.setWorkflowName(odmrNodeReference.getWorkflowName());
                    buildTextRowDetail.setNodeId(odmrNodeReference.getNodeId());
                    buildTextRowDetail.setNodeName(odmrNodeReference.getNodeName());
                    buildTextRowDetail.setStatus(NodeStatusType.fromValue((String)odmrNodeReference.getNodeStatus()));
                    this._data.add(buildTextRowDetail);
                }
                this._data.addAll(this._currentWorkflowdata);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildTextNodeType loadNodeFromServer(BuildTextRowDetail buildTextRowDetail, Context context) throws Exception {
        Connection connection = null;
        BuildTextNodeType buildTextNodeType = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            connection = connectionFolder.getUniqueConnection();
            Object object = Workflow.getWorkflowNodeContent(connection, BUILD_TEXT_NODE_TYPE, BigDecimal.valueOf(buildTextRowDetail.getProjectId().longValue()), BigDecimal.valueOf(buildTextRowDetail.getWorkflowId().longValue()), BigDecimal.valueOf(buildTextRowDetail.getNodeId().longValue()));
            if (object instanceof BuildTextNodeType) {
                buildTextNodeType = (BuildTextNodeType)object;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return buildTextNodeType;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        if (this.getRowCount() == 0) {
            return null;
        }
        BuildTextRowDetail buildTextRowDetail = this._data.get(n);
        String string = null;
        switch (n2) {
            case 1: {
                string = buildTextRowDetail.getProjectName();
                break;
            }
            case 2: {
                string = buildTextRowDetail.getWorkflowName();
                break;
            }
            case 0: {
                string = buildTextRowDetail.getNodeName();
                break;
            }
            case 3: {
                if (buildTextRowDetail.getStatus() != null) {
                    string = WorkflowUtils.getTranslatedNodeStatus(buildTextRowDetail.getStatus());
                    break;
                }
                string = null;
                break;
            }
            default: {
                assert (false) : "Out of bounds column when table";
                break;
            }
        }
        return string;
    }

    public BuildTextRowDetail getRowDetailAt(int n) {
        return this._data.get(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        BuildTextRowDetail buildTextRowDetail = this._data.get(n);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 1 && n2 != 2 && n2 != 0 && n2 != 3;
    }
}

