/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.nulls.NullIcon;

public class TestModelPickerPanel
extends AbstractDialogPanel {
    private List<TestModelType.Model> availModelsCache;
    private List<TestModelType.Model> selectedModelsCache;
    private TestModelPanel _parent;
    private MiningFunctionType _curMiningFunction = null;
    private AttributeType _curTarget = null;
    private boolean _dirty = false;
    private static final String UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
    private boolean _showSchema = false;
    private JLabel _jCaseIdLabel;
    private JLabel _jCaseIdValue;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionValue;
    private JLabel _jTargetLabel;
    private JLabel _jTargetTypeLabel;
    private JLabel _jTargetTypeValue;
    private JLabel _jTargetValue;
    private GenericTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private GenericTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private static Icon _validAttrIcon;
    private static Icon _invalidAttrIcon;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;

    public TestModelPickerPanel(Context context, TestModelPanel testModelPanel, TestModelType testModelType) {
        super(context, testModelPanel.getData());
        List<RefModelType> list;
        ModelProvider modelProvider;
        this._parent = testModelPanel;
        this.availModelsCache = new ArrayList<TestModelType.Model>();
        TestNode testNode = (TestNode)this._parent.getData();
        this._curTarget = testModelPanel.getTargetAttr();
        this._curMiningFunction = testModelPanel.getMiningFunction();
        List<AbstractNode> list2 = testNode.findTestModelNodes();
        Connection connection = null;
        String string = null;
        try {
            connection = Connections.getSharedConnection(context);
            string = Connections.getUserAccountName(this._context);
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._showSchema = false;
        block2: for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                String string2 = refModelType.getSchema();
                if (string2 == null || string2.compareTo(string) == 0) continue;
                this._showSchema = true;
                continue block2;
            }
        }
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                String string3;
                boolean bl = false;
                if (!refModelType.isUseForOutput()) continue;
                if (this._curMiningFunction == null) {
                    this._curMiningFunction = refModelType.getMiningFunction();
                    this._curTarget = modelProvider.getTargetAttribute();
                    bl = true;
                } else {
                    String string4;
                    string3 = this._curTarget != null ? this._curTarget.getName() : "";
                    String string5 = this._curTarget != null ? this._curTarget.getDataType() : "";
                    String string6 = modelProvider.getTargetAttribute() != null ? modelProvider.getTargetAttribute().getName() : "";
                    String string7 = string4 = modelProvider.getTargetAttribute() != null ? modelProvider.getTargetAttribute().getDataType() : "";
                    if (modelProvider.getMiningFunctionTypeSupported().equals((Object)this._curMiningFunction) && string6.equals(string3) && string4.equals(string5)) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                string3 = new TestModelType.Model();
                string3.setMiningAlgorithm(refModelType.getMiningAlgorithm());
                string3.setMiningFunction(refModelType.getMiningFunction());
                string3.setModelId(refModelType.getModelId());
                string3.setName(refModelType.getName());
                string3.setNodeId(refModelType.getNodeId());
                string3.setSchema(refModelType.getSchema());
                string3.setStatus(refModelType.getStatus());
                string3.setTestStatus(ModelStatusType.READY);
                this.availModelsCache.add((TestModelType.Model)string3);
            }
        }
        TestModelType testModelType2 = (TestModelType)MetaDataHelper.copyMetadataObject(testModelType);
        this.selectedModelsCache = testModelType2.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jMiningFunctionLabel = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jTargetLabel = new JLabel();
        this._jTargetValue = new JLabel();
        this._jTargetTypeLabel = new JLabel();
        this._jTargetTypeValue = new JLabel();
        this._jCaseIdLabel = new JLabel();
        this._jCaseIdValue = new JLabel();
        this.jAvailableLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new GenericTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jSelectedLabel = new JLabel();
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new GenericTable();
        this._jMiningFunctionLabel.setText("Function:");
        this._jMiningFunctionLabel.setName("_jMiningFunctionLabel");
        this._jMiningFunctionValue.setText("Classification");
        this._jMiningFunctionValue.setName("_jMiningFunctionValue");
        this._jTargetLabel.setText("Target:");
        this._jTargetLabel.setName("_jTargetLabel");
        this._jTargetValue.setText("AFFINITY_CARD");
        this._jTargetValue.setName("_jTargetValue");
        this._jTargetTypeLabel.setText("Target Type:");
        this._jTargetTypeLabel.setName("_jTargetTypeLabel");
        this._jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this._jTargetTypeValue.setName("_jTargetTypeValue");
        this._jCaseIdLabel.setText("Case Id:");
        this._jCaseIdLabel.setName("_jCaseIdLabel");
        this._jCaseIdValue.setText("CUST_ID");
        this._jCaseIdValue.setName("_jCaseIdValue");
        this.jAvailableLabel.setText("Available Models");
        this.jAvailableLabel.setName("jAvailableLabel");
        this.jAvailAttrsScrollPane.setName("jAvailAttrsScrollPane");
        this.jAvailAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{"CLAS_SVM_1", "BuildClassificationModels", "SupportVectorMachine"}}, new String[]{"Model", "Node", "Algorithm"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrs.setName("jAvailAttrs");
        this.jAvailAttrsScrollPane.setViewportView((Component)this.jAvailAttrs);
        this.jSelectBtn.setText(">");
        this.jSelectBtn.setName("jSelectBtn");
        this.jSelectAllBtn.setText(">>");
        this.jSelectAllBtn.setName("jSelectAllBtn");
        this.jRemoveBtn.setText("<");
        this.jRemoveBtn.setName("jRemoveBtn");
        this.jRemoveAllBtn.setText("<<");
        this.jRemoveAllBtn.setName("jRemoveAllBtn");
        this.jSelectedLabel.setText("Selected Models");
        this.jSelectedLabel.setName("jSelectedLabel");
        this.jSelectedAttrsScrollPane.setName("jSelectedAttrsScrollPane");
        this.jSelectedAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"Model", "Node", "Algorithm"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrs.setName("jSelectedAttrs");
        this.jSelectedAttrsScrollPane.setViewportView((Component)this.jSelectedAttrs);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jCaseIdLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jTargetLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jCaseIdValue, -2, 203, -2).addComponent(this._jTargetValue, -2, 203, -2).addComponent(this._jMiningFunctionValue, -2, 203, -2)).addGap(18, 18, 18).addComponent(this._jTargetTypeLabel, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetTypeValue, -2, 147, -2).addGap(313, 313, 313)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 366, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 366, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 374, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 374, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetLabel).addComponent(this._jTargetValue).addComponent(this._jTargetTypeLabel).addComponent(this._jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jCaseIdLabel).addComponent(this._jCaseIdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 281, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 281, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("TEST_MODEL_FUNCTION"), this._jMiningFunctionLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET"), this._jTargetLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET_TYPE"), this._jTargetTypeLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_CASE_ID"), this._jCaseIdLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_AVAIL_MODELS"), this.jAvailableLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_SELECT_MODELS"), this.jSelectedLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.initIcons();
    }

    private void initIcons() {
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        ImageIcon imageIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
        if (_validAttrIcon == null) {
            _validAttrIcon = new NullIcon(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }
        if (_invalidAttrIcon == null) {
            _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
        }
        Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
        _select = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
        _selectAll = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
        _remove = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
        _removeAll = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"test_select_models");
        TestNode testNode = (TestNode)this._parent.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._jMiningFunctionValue.setText(this._curMiningFunction != null ? this._curMiningFunction.value() : UNKNOWN);
        this._jTargetValue.setText(this._curTarget != null ? this._curTarget.getName() : UNKNOWN);
        this._jTargetTypeValue.setText(this._curTarget != null ? this._curTarget.getDataType() : UNKNOWN);
        this._jCaseIdLabel.setVisible(testNodeType.getTestModels().getMiningFunction() != null && testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this._jCaseIdValue.setVisible(testNodeType.getTestModels().getMiningFunction() != null && testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        String[] stringArray = new String[]{DialogsLrb.get("TEST_MODEL_NAME"), DialogsLrb.get("TEST_MODEL_NODE"), DialogsLrb.get("TEST_MODEL_ALGORITHM")};
        this.removeSelectedAttrs(this.availModelsCache, this.selectedModelsCache);
        ModelTableModel modelTableModel = new ModelTableModel(this.availModelsCache, stringArray);
        this.jAvailAttrs.setModel((TableModel)((Object)modelTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        ModelNameCellRenderer modelNameCellRenderer = new ModelNameCellRenderer(this.availModelsCache, _validAttrIcon, _invalidAttrIcon);
        tableColumn.setCellRenderer(modelNameCellRenderer);
        ModelTableModel modelTableModel2 = new ModelTableModel(this.selectedModelsCache, stringArray);
        this.jSelectedAttrs.setModel((TableModel)((Object)modelTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        modelNameCellRenderer = new ModelNameCellRenderer(this.selectedModelsCache, _validAttrIcon, _invalidAttrIcon);
        tableColumn.setCellRenderer(modelNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jAvailAttrs, TestModelPickerPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jAvailAttrs, TestModelPickerPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jSelectedAttrs, TestModelPickerPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jSelectedAttrs, TestModelPickerPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<TestModelType.Model> list = ((ModelTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((TestModelType.Model)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<TestModelType.Model> list2 = ((ModelTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((ModelTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((ModelTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (TestModelType.Model)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<TestModelType.Model> list, List<TestModelType.Model> list2) {
        HashMap<String, TestModelType.Model> hashMap = new HashMap<String, TestModelType.Model>();
        for (TestModelType.Model model : list2) {
            hashMap.put(model.getNodeId() + "." + model.getName(), model);
        }
        Iterator<TestModelType.Model> iterator = list.iterator();
        while (iterator.hasNext()) {
            TestModelType.Model model;
            model = iterator.next();
            TestModelType.Model model2 = (TestModelType.Model)hashMap.get(model.getNodeId() + "." + model.getName());
            if (model2 == null || !model2.getName().equals(model.getName())) continue;
            iterator.remove();
        }
    }

    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<TestModelType.Model> getSelectedModelsCache() {
        return this.selectedModelsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private class ModelNameCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;
        private List<TestModelType.Model> _cache;

        public ModelNameCellRenderer(List<TestModelType.Model> list, Icon icon, Icon icon2) {
            this._cache = list;
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TestModelType.Model model = this._cache.get(n);
            RefModelStatusType refModelStatusType = model.getStatus();
            if (refModelStatusType == RefModelStatusType.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    class ModelTableModel
    extends GenericBaseTableModel {
        private List<TestModelType.Model> _data;
        private final int TEST_MODEL_NAME = 0;
        private final int TEST_MODEL_NODE = 1;
        private final int TEST_MODEL_ALGORITHM = 2;
        private final int COLUMN_COUNT = 3;

        public ModelTableModel(List<TestModelType.Model> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            TestModelType.Model model = this._data.get(n);
            if (0 == n2) {
                string = TestModelPickerPanel.this._showSchema ? model.getSchema() + "." + model.getName() : model.getName();
            } else if (1 == n2) {
                string = ((TestNode)TestModelPickerPanel.this._parent.getData()).getModelNodeName(model.getNodeId());
            } else if (2 == n2) {
                string = model.getMiningAlgorithm().value();
            }
            return string;
        }

        public List<TestModelType.Model> getDataList() {
            return this._data;
        }
    }
}

