/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPickerDialog;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPickerPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.inspect.WorkflowTestNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.SwingWorker;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.jdeveloper.db.ConnectionException;

public class TestModelPanel
extends AbstractDialogPanel {
    private NiceTableWithToolbar _tableWithToolbar;
    private PropertyModel _propertyModel;
    private ModelTableModel _tableModels;
    private TestModelType _models;
    private List<? extends MiningResultType> _results;
    private MiningFunctionType _miningFunction;
    private AttributeType _targetAttr;
    private AttributeType _caseAttr;
    private static Icon _ready_icon;
    private static Icon _built_icon;
    private static NullIcon _nullIcon;
    private static Icon _error_icon;
    private static Icon _invalid_icon;
    private static Icon _viewIconEna;
    private static Icon _viewIconDis;
    private JButton _viewModelBtn;
    private JButton _viewTestBtn;
    private JButton _removeBtn;
    private JButton _addBtn;
    private AutoSpecType _autoSetting;
    private boolean _autoDirty;
    private boolean _targetDirty;
    private boolean _caseIdDirty;
    private boolean _modelsDirty;
    private boolean _loading = false;
    private boolean _showModelDetails = true;
    private String _ownerName = null;
    private HashMap<String, AttributeType> _caseIdLookupMap = new HashMap();
    private static final String TEST_NONE;
    private static final String UNKNOWN;
    private static String NOT_TESTED;
    private JCheckBox _jAutoSpecificationCheckBox;
    private JLabel _jCaseIdLabel;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionValue;
    private JLabel _jTargetLabel;
    private JLabel _jTargetTypeLabel;
    private JLabel _jTargetTypeValue;
    private JLabel _jTargetValue;
    private JComboBox jCaseIdComboBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ComponentWithTitlebar<JComponent> modelsToolbar;

    public TestModelPanel(PropertyModel propertyModel, boolean bl) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for test node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._showModelDetails = bl;
        this.setMinimumSize(new Dimension(200, 400));
        this.init((TestNode)this._data, propertyModel);
    }

    public TestModelPanel(JEWTDialog jEWTDialog, Context context, TestNode testNode, PropertyModel propertyModel) {
        super(context, testNode);
        assert (context != null) : "Context must not be null.";
        assert (testNode != null) : "test node must not be null.";
        assert (testNode instanceof TestNode) : "Must be an instance of test node.";
        this.init(testNode, propertyModel);
    }

    private void init(TestNode testNode, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._autoDirty = false;
        this._caseIdDirty = false;
        this._modelsDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        this._results = MetaDataHelper.getResultsCollection(testNode);
        this._autoSetting = this._models.getAutoSpec();
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        Connection connection = null;
        try {
            connection = Connections.getSharedConnection(this._context);
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public boolean isShowSchema() {
        boolean bl = false;
        for (TestModelType.Model model : this._models.getModel()) {
            String string = model.getSchema();
            if (string == null || string.compareTo(this._ownerName) == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        TestNode testNode = (TestNode)workflowNodeInspectorElement.getNode();
        if (testNode == null) {
            return;
        }
        this._propertyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = testNode;
        this._autoDirty = false;
        this._caseIdDirty = false;
        this._modelsDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        if (this._showModelDetails) {
            this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
            this._results = MetaDataHelper.getResultsCollection(testNode);
            this._autoSetting = this._models.getAutoSpec();
        }
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private TestNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            return (TestNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        if (this._targetDirty || this._caseIdDirty || this._autoDirty || this._modelsDirty) {
            TestNode testNode = (TestNode)this.getData();
            TestNodeType testNodeType = (TestNodeType)testNode.getData();
            if (this._propertyModel != null) {
                AttributeType attributeType;
                ComplexProperty complexProperty;
                ArrayList<Property> arrayList = new ArrayList<Property>();
                if (this._targetDirty) {
                    complexProperty = new ComplexProperty("TargetAttribute", this._targetAttr);
                    attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getTargetAttribute());
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.TARGET_ATTRIBUTE), null, complexProperty, null, null));
                }
                if (this._caseIdDirty) {
                    complexProperty = new ComplexProperty("CaseAttributes", this._caseAttr);
                    attributeType = new CaseAttributes();
                    for (AttributeType attributeType2 : testNodeType.getCaseAttributes().getAttribute()) {
                        attributeType.getAttribute().add((AttributeType)MetaDataHelper.copyMetadataObject(attributeType2));
                    }
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.CASE_ATTRIBUTES), null, complexProperty, null, null));
                }
                if (this._modelsDirty) {
                    complexProperty = new ComplexProperty("TestModels", this._models);
                    attributeType = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.TEST_MODELS), null, complexProperty, null, null));
                }
                if (this._autoDirty) {
                    complexProperty = new ComplexProperty("AutoSetting", this._autoSetting);
                    attributeType = testNodeType.getTestModels().getAutoSpec();
                    complexProperty.setOldData(attributeType);
                    arrayList.add(new Property(String.valueOf(TestNodePropertyModel.RowIndex.AUTO_SETTING), null, complexProperty, null, null));
                }
                ((WorkflowTestNodePropertyProxyModel)this._propertyModel).setValueAt(PropertyLrb.get("PI_TEST_NODE_EDIT_SETTING"), testNode, arrayList);
            } else {
                try {
                    CommandProcessor.getInstance().beginTrans(DialogsLrb.get("TEST_NODE_EDIT_TRANSACTION_NAME"));
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    if (this._targetDirty) {
                        arrayList.add(new Property("TargetAttribute", null, this._targetAttr, null, null));
                    }
                    if (this._caseIdDirty) {
                        arrayList.add(new Property("CaseAttributes", null, this._caseAttr, null, null));
                    }
                    if (this._modelsDirty) {
                        arrayList.add(new Property("TestModels", null, this._models, null, null));
                    }
                    if (this._autoDirty) {
                        arrayList.add(new Property("AutoSetting", null, this._autoSetting, null, null));
                    }
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
                    if (this._targetDirty || this._modelsDirty) {
                        testNode.validate(true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    CommandProcessor.getInstance().abortTrans();
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        }
    }

    public boolean doWork() {
        boolean bl = true;
        this.updateNode();
        return bl;
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("TEST_AUTO_SETTING"), this._jAutoSpecificationCheckBox);
        hashMap.put(DialogsLrb.get("TEST_MODEL_FUNCTION"), this._jMiningFunctionLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET"), this._jTargetLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET_TYPE"), this._jTargetTypeLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_CASE_ID"), this._jCaseIdLabel);
        UIResourceHelper.setComponentText(hashMap);
        this._jCaseIdLabel.setLabelFor(this.jCaseIdComboBox);
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        if (_ready_icon == null) {
            _ready_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_READY_ICON"));
        }
        if (_built_icon == null) {
            _built_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
        }
        if (_error_icon == null) {
            _error_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_ERROR_ICON"));
        }
        Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
        if (_invalid_icon == null) {
            _invalid_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        }
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(_built_icon.getIconWidth(), _built_icon.getIconHeight());
        }
        Class<WorkflowUtils> clazz3 = WorkflowUtils.class;
        _viewIconEna = UIResourceHelper.getImageIcon(clazz3, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_ENA"));
        _viewIconDis = UIResourceHelper.getImageIcon(clazz3, PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_VIEW_MODEL_DIS"));
    }

    @Override
    public void initUI() {
        List<AbstractNode> list;
        HelpUtils.setHelpID((JComponent)this, (String)"test_models");
        this._loading = true;
        TestNode testNode = (TestNode)this.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        AttributeType attributeType = null;
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0);
        }
        this._targetAttr = testNodeType.getTargetAttribute();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(TEST_NONE);
        List<AttributeType> list2 = testNode.findCaseIds();
        this._caseIdLookupMap.clear();
        for (AttributeType object2 : list2) {
            defaultComboBoxModel.addElement(object2.getName());
            this._caseIdLookupMap.put(object2.getName(), object2);
        }
        this.jCaseIdComboBox.setModel(defaultComboBoxModel);
        if (attributeType == null) {
            this.jCaseIdComboBox.setSelectedItem(TEST_NONE);
        } else {
            this.jCaseIdComboBox.setSelectedItem(attributeType.getName());
        }
        if (this._models.getMiningFunction() == null) {
            list = testNode.findTestModelNodes();
            if (list.size() > 0) {
                ModelProvider modelProvider = (ModelProvider)list.get(0);
                this._miningFunction = modelProvider.getMiningFunctionTypeSupported();
                this._targetAttr = modelProvider.getTargetAttribute();
            } else {
                this._miningFunction = null;
                this._targetAttr = null;
            }
        } else {
            this._miningFunction = this._models.getMiningFunction();
        }
        if (this._showModelDetails) {
            this._tableModels = new ModelTableModel(this, this._models);
            list = new ControlBar();
            this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
            this._addBtn.setEnabled(true);
            this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
            this._removeBtn.setEnabled(false);
            this._viewModelBtn = new JButton(_viewIconEna);
            this._viewModelBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
            this._viewModelBtn.setDisabledIcon(_viewIconDis);
            this._viewModelBtn.setEnabled(false);
            this._viewTestBtn = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this._viewTestBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_RESULTS_COMPARE"));
            this._viewTestBtn.setEnabled(false);
            list.add(this._addBtn);
            list.add(this._removeBtn);
            list.add(this._viewModelBtn);
            list.add(this._viewTestBtn);
            this._tableWithToolbar = new NiceTableWithToolbar(this.modelsToolbar, (ControlBar)list, ModelTableModel._columnNames, this._tableModels);
            this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("TEST_MODEL_TABLE_TITLE")));
            this._addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestModelPanel.this.processAdd();
                }
            });
            this._removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("TEST_MODEL_REMOVE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                        return;
                    }
                    TestModelPanel.this.processRemove();
                }
            });
            this._viewModelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestModelPanel.this.viewModel();
                }
            });
            this._viewTestBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection((TestNode)TestModelPanel.this._data);
                    if (list.isEmpty()) {
                        return;
                    }
                    TestModelPanel.this.viewCompare(list);
                }
            });
            this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    TestModelPanel.this.handleModelSelectionChanged();
                }
            });
            TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRendererModel());
            TableColumn tableColumn2 = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2);
            tableColumn2.setCellRenderer(new CustomCellRendererTest());
            this._tableWithToolbar.getNiceTable().setAutoResizeMode(0);
            this._tableWithToolbar.getNiceTable().setSelectionMode(2);
            this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
            this._tableWithToolbar.getNiceTable().setShowToolTips(true);
            this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
            this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
            int n = 0;
            for (int n2 : ModelTableModel._columnWidths) {
                this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
            }
        }
        this.enableControls();
        this._loading = false;
    }

    private void processAdd() {
        TestModelPickerPanel testModelPickerPanel;
        TestModelPickerDialog testModelPickerDialog = new TestModelPickerDialog();
        if (testModelPickerDialog.invoke(this.getContext(), this, this._models) && (testModelPickerPanel = testModelPickerDialog.getPanel()).isDirty()) {
            List<TestModelType.Model> list = testModelPickerPanel.getSelectedModelsCache();
            TestNode.removeModel(this._models, this._models.getModel());
            TestNode.addModels2(this._models, list);
            this._targetDirty = true;
            this._tableModels = new ModelTableModel(this, this._models);
            this._tableWithToolbar.resetNiceTableModel(this._tableModels);
            this._modelsDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
            this.enableControls();
        }
    }

    private void processRemove() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(n);
            arrayList.add(model);
        }
        TestNode.removeModel(this._models, arrayList);
        if (this._models.getModel().size() == 0) {
            this._targetDirty = true;
        }
        this._tableModels = new ModelTableModel(this, this._models);
        this._tableWithToolbar.resetNiceTableModel(this._tableModels);
        this._modelsDirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
        this.enableControls();
    }

    private void viewModel() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(n);
        if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(model);
            loadSVMModelViewer.start();
        } else {
            String string = model.getName();
            String string2 = this._data.getData().getName();
            WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
            EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
        }
    }

    public AttributeType getTargetAttr() {
        return this._targetAttr;
    }

    public MiningFunctionType getMiningFunction() {
        return this._miningFunction;
    }

    private void viewCompare(List<? extends MiningResultType> list) {
        Context context = this._context;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        try {
            Element[] elementArray = context.getSelection();
            WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
            TestNodeType testNodeType = (TestNodeType)workflowNodeInspectorElement.getNode().getData();
            TestCompareNode testCompareNode = null;
            if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                testCompareNode = WorkflowEditor.createClassTestCompareNode(context, workflowNode, testNodeType, list);
            } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                testCompareNode = WorkflowEditor.createRegressTestCompareNode(context, workflowNode, testNodeType, list);
            }
            if (testCompareNode == null) {
                MessageDialog.error((Component)this, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                return;
            }
            EditorUtil.openDefaultEditorInFrame((Node)testCompareNode);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private boolean compareEnabled() {
        boolean bl = false;
        for (MiningResultType miningResultType : this._results) {
            XMLGregorianCalendar xMLGregorianCalendar = miningResultType.getCreationDate();
            if (xMLGregorianCalendar == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void enableControls() {
        boolean bl = this._autoSetting.equals((Object)AutoSpecType.YES);
        this._jAutoSpecificationCheckBox.setSelected(bl);
        this._jAutoSpecificationCheckBox.setEnabled(this.isWritable());
        this._jCaseIdLabel.setVisible(this._models.getMiningFunction() != null && this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this.jCaseIdComboBox.setVisible(this._models.getMiningFunction() != null && this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this.jCaseIdComboBox.setEditable(this.isWritable() && this._models.getMiningFunction() != null && this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        if (this._showModelDetails) {
            int n = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
            this._addBtn.setEnabled(this.isWritable() && !bl);
            this._removeBtn.setEnabled(this.isWritable() && !bl && n > 0);
            boolean bl2 = false;
            if (n == 1) {
                int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
                TestModelType.Model model = (TestModelType.Model)this._models.getModel().get(nArray[0]);
                bl2 = model.getStatus() == RefModelStatusType.VALID;
            }
            this._viewModelBtn.setEnabled(this.isWritable() && bl2 && n == 1);
            this._viewTestBtn.setEnabled(this.isWritable() && this.compareEnabled());
            if (this._propertyModel != null) {
                this.jPanel1.setVisible(false);
            }
        } else {
            this.jPanel2.setVisible(false);
        }
        String string = "";
        if (this._miningFunction != null) {
            string = this._miningFunction == MiningFunctionType.CLASSIFICATION ? DialogsLrb.get("TEST_NODE_CLASSIFICATION_TYPE") : (this._miningFunction == MiningFunctionType.REGRESSION ? DialogsLrb.get("TEST_NODE_REGRESSSION_TYPE") : UNKNOWN);
        }
        this._jTargetValue.setText(this._targetAttr != null ? this._targetAttr.getName() : UNKNOWN);
        this._jTargetTypeValue.setText(this._targetAttr != null ? this._targetAttr.getDataType() : UNKNOWN);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._jMiningFunctionLabel = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jTargetLabel = new JLabel();
        this._jTargetValue = new JLabel();
        this._jTargetTypeLabel = new JLabel();
        this._jTargetTypeValue = new JLabel();
        this._jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this._jAutoSpecificationCheckBox = new JCheckBox();
        this.modelsToolbar = new ComponentWithTitlebar();
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this._jMiningFunctionLabel.setText("Function:");
        this._jMiningFunctionLabel.setName("_jMiningFunctionLabel");
        this._jMiningFunctionValue.setText("Classification");
        this._jMiningFunctionValue.setName("_jMiningFunctionValue");
        this._jTargetLabel.setText("Target:");
        this._jTargetLabel.setName("_jTargetLabel");
        this._jTargetValue.setText("AFFINITY_CARD");
        this._jTargetValue.setName("_jTargetValue");
        this._jTargetTypeLabel.setText("Target Type:");
        this._jTargetTypeLabel.setName("_jTargetTypeLabel");
        this._jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this._jTargetTypeValue.setName("_jTargetTypeValue");
        this._jCaseIdLabel.setText("Case Id:");
        this._jCaseIdLabel.setName("_jCaseIdLabel");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item56789012345678901234567890", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.setName("jCaseIdComboBox");
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jCaseIdLabel, GroupLayout.Alignment.LEADING).addComponent(this._jTargetLabel, GroupLayout.Alignment.LEADING).addComponent(this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValue, -2, 203, -2).addGap(31, 31, 31).addComponent(this._jTargetTypeLabel, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetTypeValue, -2, 147, -2)).addComponent(this._jMiningFunctionValue, -2, 203, -2).addComponent(this.jCaseIdComboBox, -2, 216, -2)).addContainerGap(41, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetLabel).addComponent(this._jTargetValue).addComponent(this._jTargetTypeLabel).addComponent(this._jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setOpaque(false);
        this._jAutoSpecificationCheckBox.setText("Automatic Specification");
        this._jAutoSpecificationCheckBox.setName("_jAutoSpecificationCheckBox");
        this._jAutoSpecificationCheckBox.setOpaque(false);
        this._jAutoSpecificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPanel.this._jAutoSpecificationCheckBoxActionPerformed(actionEvent);
            }
        });
        this.modelsToolbar.setAutoscrolls(true);
        this.modelsToolbar.setName("modelsToolbar");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jAutoSpecificationCheckBox).addContainerGap(464, Short.MAX_VALUE)).addComponent((Component)this.modelsToolbar, -1, 601, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jAutoSpecificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.modelsToolbar, -1, 257, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jCaseIdComboBox.getSelectedItem();
        if (string != TEST_NONE) {
            AttributeType attributeType = this._caseIdLookupMap.get(string);
            if (this._caseAttr == null || !this._caseAttr.equals(attributeType)) {
                this._caseAttr = attributeType;
                this._caseIdDirty = true;
                if (this._propertyModel != null) {
                    this.updateNode();
                }
            }
        } else if (this._caseAttr != null) {
            this._caseAttr = null;
            this._caseIdDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void _jAutoSpecificationCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this._jAutoSpecificationCheckBox.isSelected();
        if (bl) {
            this._autoSetting = AutoSpecType.YES;
            this._autoDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        } else {
            this._autoSetting = AutoSpecType.NO;
            this._autoDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    static {
        TEST_NONE = DialogsLrb.get("TEST_NONE");
        UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
        NOT_TESTED = BuildEditorLrb.get("BUILD_MODEL_NOT_TESTED");
    }

    private class CustomCellRendererTest
    extends DefaultTableCellRenderer {
        private CustomCellRendererTest() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = TestModelPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            RefModelType refModelType = (RefModelType)TestModelPanel.this._models.getModel().get(n3);
            ClassificationResultType classificationResultType = null;
            if (TestModelPanel.this._models.getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection((TestNode)TestModelPanel.this._data);
                for (ClassificationResultType classificationResultType2 : list) {
                    if (!classificationResultType2.getModelId().equals(refModelType.getModelId())) continue;
                    classificationResultType = classificationResultType2;
                    break;
                }
            } else if (TestModelPanel.this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection((TestNode)TestModelPanel.this._data);
                for (RegressionResultType regressionResultType : list) {
                    if (!regressionResultType.getModelId().equals(refModelType.getModelId())) continue;
                    classificationResultType = regressionResultType;
                    break;
                }
            }
            if (classificationResultType != null) {
                if (classificationResultType.getStatus() == ModelStatusType.COMPLETE) {
                    this.setIcon(_built_icon);
                } else if (classificationResultType.getStatus() == ModelStatusType.READY) {
                    this.setIcon(_ready_icon);
                } else if (classificationResultType.getStatus() == ModelStatusType.FAILURE) {
                    this.setIcon(_error_icon);
                } else {
                    this.setIcon(_invalid_icon);
                }
            } else {
                this.setIcon(_ready_icon);
            }
            return component;
        }
    }

    private class CustomCellRendererModel
    extends DefaultTableCellRenderer {
        private CustomCellRendererModel() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = TestModelPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            RefModelType refModelType = (RefModelType)TestModelPanel.this._models.getModel().get(n3);
            RefModelStatusType refModelStatusType = refModelType.getStatus();
            if (refModelStatusType == RefModelStatusType.VALID) {
                this.setIcon((Icon)_nullIcon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }

    static class ModelTableModel
    extends GenericBaseTableModel {
        static String[] _columnNames = new String[]{DialogsLrb.get("TEST_MODEL_NAME"), DialogsLrb.get("TEST_MODEL_NODE"), DialogsLrb.get("TEST_DATE_TESTED"), DialogsLrb.get("TEST_MODEL_ALGORITHM")};
        static int[] _columnWidths = new int[]{180, 80, 180, 150};
        public static final int TEST_MODEL_NAME = 0;
        public static final int TEST_MODEL_NODE = 1;
        public static final int TEST_DATE_TESTED = 2;
        public static final int TEST_MODEL_ALGORITHM = 3;
        public static final int COLUMN_COUNT = 4;
        private TestModelType _srcData;
        private TestModelPanel _parent;

        public ModelTableModel(TestModelPanel testModelPanel, TestModelType testModelType) {
            this._parent = testModelPanel;
            this._srcData = testModelType;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getModel().size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            TestModelType.Model model = (TestModelType.Model)this._srcData.getModel().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    if (this._parent.isShowSchema()) {
                        string = model.getSchema() + "." + model.getName();
                        break;
                    }
                    string = model.getName();
                    break;
                }
                case 1: {
                    string = ((TestNode)this._parent.getData()).getModelNodeName(model.getNodeId());
                    break;
                }
                case 2: {
                    string = NOT_TESTED;
                    MiningResultType miningResultType = ((TestNode)this._parent.getData()).getModelResult(model.getModelId());
                    if (miningResultType == null) break;
                    XMLGregorianCalendar xMLGregorianCalendar = miningResultType.getCreationDate();
                    string = TimeUtils.formatDate(xMLGregorianCalendar);
                    break;
                }
                case 3: {
                    string = MetaDataHelper.getAlgorithmName(model.getMiningAlgorithm());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        TestModelType.Model _modelType;
        boolean _isLinear = false;

        public LoadSVMModelViewer(TestModelType.Model model) {
            this._modelType = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(TestModelPanel.this._context);
                Model model = new Model();
                Context context = TestModelPanel.this._context;
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                String string = connectionFolder.getUserAccountName();
                Vector<MiningModelSettings> vector = model.getModelSetting(connection, string, this._modelType.getName());
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
                if (miningModelSettings != null) {
                    this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                exception.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this._isLinear;
        }

        public void finished() {
            if (this._success && this._ex == null) {
                Context context = TestModelPanel.this._context;
                BaseTreeNode baseTreeNode = null;
                String string = this._modelType.getName();
                if (string != null) {
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string2 = TestModelPanel.this._data.getData().getName();
                    baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), null, (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_GROUP_MODEL_MODEL_VIEWER_ERROR_MESG"));
            }
        }
    }
}

