/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowTestNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;

public class TargetPanel
extends AbstractDialogPanel {
    private PropertyModel _propertyModel;
    private TestModelType _models;
    private AttributeType _caseAttr;
    private boolean _caseIdDirty;
    private boolean _loading = false;
    private HashMap<String, AttributeType> _caseIdLookupMap = new HashMap();
    private static final String TEST_NONE = DialogsLrb.get("TEST_NONE");
    private static final String UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
    private JLabel _jCaseIdLabel;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionValue;
    private JLabel _jTargetLabel;
    private JLabel _jTargetTypeLabel;
    private JLabel _jTargetTypeValue;
    private JLabel _jTargetValue;
    private JComboBox jCaseIdComboBox;

    public TargetPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for test node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((TestNode)this._data, propertyModel);
    }

    private void init(TestNode testNode, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._caseIdDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        TestNode testNode = (TestNode)workflowNodeInspectorElement.getNode();
        if (testNode == null) {
            return;
        }
        this._propertyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = testNode;
        this._caseIdDirty = false;
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this._models = (TestModelType)MetaDataHelper.copyMetadataObject(testNodeType.getTestModels());
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            this._caseAttr = (AttributeType)MetaDataHelper.copyMetadataObject(testNodeType.getCaseAttributes().getAttribute().get(0));
        }
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private TestNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowTestNodePropertyProxyModel)) {
            return null;
        }
        WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
        Context context = workflowTestNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TestNodeType) {
            return (TestNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        if (this._caseIdDirty) {
            try {
                CommandProcessor.getInstance().beginTrans(DialogsLrb.get("TEST_NODE_EDIT_TRANSACTION_NAME"));
                TestNode testNode = (TestNode)this.getData();
                ArrayList<Property> arrayList = new ArrayList<Property>();
                if (this._caseIdDirty) {
                    arrayList.add(new Property("CaseAttributes", null, this._caseAttr, null, null));
                }
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                odmrSDMUndoFilter.prepareUndoPropertyList(testNode, this.getContext(), arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("TEST_MODEL_FUNCTION"), this._jMiningFunctionLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET"), this._jTargetLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_TARGET_TYPE"), this._jTargetTypeLabel);
        hashMap.put(DialogsLrb.get("TEST_MODEL_CASE_ID"), this._jCaseIdLabel);
        UIResourceHelper.setComponentText(hashMap);
        this._jCaseIdLabel.setLabelFor(this.jCaseIdComboBox);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"test_target");
        this._loading = true;
        TestNode testNode = (TestNode)this.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        AttributeType attributeType = null;
        if (testNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)testNodeType.getCaseAttributes().getAttribute().get(0);
        }
        AttributeType attributeType2 = testNodeType.getTargetAttribute();
        if (this._models.getMiningFunction() != null && this._models.getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
            this._jCaseIdLabel.setVisible(true);
            this.jCaseIdComboBox.setVisible(true);
            this.jCaseIdComboBox.setEditable(this.isWritable());
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(TEST_NONE);
            List<AttributeType> list = testNode.findCaseIds();
            this._caseIdLookupMap.clear();
            for (AttributeType attributeType3 : list) {
                defaultComboBoxModel.addElement(attributeType3.getName());
                this._caseIdLookupMap.put(attributeType3.getName(), attributeType3);
            }
            this.jCaseIdComboBox.setModel(defaultComboBoxModel);
            if (attributeType == null) {
                this.jCaseIdComboBox.setSelectedItem(TEST_NONE);
            } else {
                this.jCaseIdComboBox.setSelectedItem(attributeType.getName());
            }
        } else {
            this._jCaseIdLabel.setVisible(false);
            this.jCaseIdComboBox.setVisible(false);
        }
        if (this._models.getMiningFunction() == null) {
            this._jMiningFunctionValue.setText(UNKNOWN);
            this._jTargetValue.setText(UNKNOWN);
            this._jTargetTypeValue.setText(UNKNOWN);
        } else {
            this._jMiningFunctionValue.setText(this._models.getMiningFunction().value());
            this._jTargetValue.setText(attributeType2.getName());
            this._jTargetTypeValue.setText(attributeType2.getDataType());
        }
        this._loading = false;
    }

    private void initComponents() {
        this._jMiningFunctionLabel = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jTargetLabel = new JLabel();
        this._jTargetValue = new JLabel();
        this._jTargetTypeLabel = new JLabel();
        this._jTargetTypeValue = new JLabel();
        this._jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new JComboBox();
        this._jMiningFunctionLabel.setText("Function:");
        this._jMiningFunctionValue.setText("Classification");
        this._jTargetLabel.setText("Target:");
        this._jTargetValue.setText("AFFINITY_CARD");
        this._jTargetTypeLabel.setText("Data Type:");
        this._jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this._jCaseIdLabel.setText("Case Id:");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item56789012345678901234567890", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jTargetLabel).addComponent(this._jMiningFunctionLabel, -2, 54, -2).addComponent(this._jTargetTypeLabel, -2, 64, -2).addComponent(this._jCaseIdLabel)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMiningFunctionValue, -2, 203, -2).addComponent(this._jTargetValue, -2, 203, -2).addComponent(this._jTargetTypeValue, -2, 147, -2).addComponent(this.jCaseIdComboBox, -2, 216, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetLabel).addComponent(this._jTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetTypeLabel).addComponent(this._jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jCaseIdComboBox.getSelectedItem();
        if (string != TEST_NONE) {
            AttributeType attributeType = this._caseIdLookupMap.get(string);
            if (this._caseAttr == null || !this._caseAttr.equals(attributeType)) {
                this._caseAttr = attributeType;
                this._caseIdDirty = true;
                if (this._propertyModel != null) {
                    this.updateNode();
                }
            }
        } else if (this._caseAttr != null) {
            this._caseAttr = null;
            this._caseIdDirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }
}

